<?php

/*
 * $RCSfile: $
 *
 * SnapGalaxy4CPG - a plugin for Coppermine gallery to create photo prints, and print product gift items
 * Copyright (C) 2007 SnapGalaxy, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

/**
 * @version $Revision: $ $Date: $
 * @package SnapGalaxy4CPG
 * @author Bhavin Suthar <service@snapgalaxy.com> for SnapGalaxy, Inc. http://www.snapgalaxy.com/
 */

    require_once($snapgalaxyPluginHome.'/SnapGalaxy4CPG.conf.php');

    // Global variables needed.
    if(!$_SESSION['snapgalaxy']){
        $_SESSION['snapgalaxy'] = Array();
        $_SESSION['snapgalaxy']['cart'] = Array();
    }

    $_SESSION['snapgalaxy']['partnerId'] = $snapgalaxyPartnerId;
    $_SESSION['snapgalaxy']['postUrl'] = $snapgalaxyPostUrl;

    /**
     *  Function to create the div containers for the image cart, and the product view.
     */
    function snapgalaxyCartAndViewDivElements(){
        $html="<div id=\"snapgalaxy-hidden-divs\">";
        $html.="  <div id=\"snapgalaxy-cartview\">";
        $html.="    <div id=\"snapgalaxy-carthead\"><div class=\"snapgalaxy-left\">Currently In Your Cart</div><div class=\"snapgalaxy-right\"><a href=\"javascript:snapgalaxyCloseViewDivs('snapgalaxy-cartview');\">Hide Cart</a></div><div class=\"snapgalaxy-clear\"></div></div>";
        $html.="    <div id=\"snapgalaxy-cartarea\"></div>";
        $html.="    <div id=\"snapgalaxy-cartfoot\"><div class=\"snapgalaxy-right\"><a href=\"javascript:snapgalaxyCheckout();\">Checkout</a></div><div class=\"snapgalaxy-clear\"></div></div>";
        $html.="</div>";

        // Now that the cart has been build we will build the item view.
        $html.="    <div id=\"snapgalaxy-itemview\">";
        $html.="    <div id=\"snapgalaxy-itemhead\"><div class=\"snapgalaxy-left\">Gift Item Preview</div><div class=\"snapgalaxy-right\"><a href=\"javascript:snapgalaxyCloseViewDivs('snapgalaxy-itemview');\">Hide Gift Item Preview</a></div><div class=\"snapgalaxy-clear\"></div></div>";
        $html.="  </div>";
        $html.="</div>";

        return  $html;
    } // end: function snapgalaxyCartAndViewDivElements()

    function snapgalaxyCSSandJavascriptIncludes(){
        global $CONFIG;

        $html = '<link rel="stylesheet" href="'.$CONFIG['site_url'].'plugins/SnapGalaxy4CPG/includes/SnapGalaxyAPI.css" type="text/css" />'."\n";
        $html .= '<script language="javascript"> var snapgalaxyPartnerId="'.$_SESSION['snapgalaxy']['partnerId'].'"; snapgalaxyPostUrl="'.$_SESSION['snapgalaxy']['postUrl'].'"; snapgalaxySiteUrl="'.$CONFIG['site_url'].'"; </script>';
        $html .= '<script src="'.$CONFIG['site_url'].'plugins/SnapGalaxy4CPG/includes/SnapGalaxyAPIControls.js" language="javascript"></script>';
        return $html;
    } // end: function snapgalaxyCartAndViewDivElements()

    function snapgalaxyViewAddRemoveButtons($thumb,$tWidth,$tHeight,$raw,$rWidth,$rHeight,$inCartStatus){
        $html='<div align="center"><div style="width: 20%;">';
        if(array_key_exists($raw,$_SESSION['snapgalaxy']['cart'])){
            $html.="<a class=\"snapgalaxyButtonAdd\" name=\"".$raw."\" href=\"#\" onclick=\"snapgalaxyProcessImageInCart('".$thumb."','".$tWidth."','".$tHeight."','".$raw."','".$rWidth."','".$rHeight."',this.firstChild.data); return false;\">- Cart</a>";
        }else{
            $html.="<a class=\"snapgalaxyButtonAdd\" name=\"".$raw."\" href=\"#\" onclick=\"snapgalaxyProcessImageInCart('".$thumb."','".$tWidth."','".$tHeight."','".$raw."','".$rWidth."','".$rHeight."',this.firstChild.data); return false;\">+ Cart</a>";
        }
 //       $html.="<a class=\"snapgalaxyButtonView\" href=\"#\" onclick=\"snapgalaxyOpenViewImageOnItem('".$thumb."'); return false;\">View On...</a>";
        $html.='<div class="clear"></div>';
        $html.='</div></div>';
        return $html;
    } // end: function snapgalaxyViewAddRemoveButtons($thumb,$tWidth,$tHeight,$raw,$rWidth,$rHeight)


?>
