<?php
/**************************************************
  Coppermine 1.4.x Plugin - Smart Catlist
  *************************************************
  Copyright (c) 2009 mil1616 
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.
  **************************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// Add an install action
$thisplugin->add_action('plugin_install','smart_catlist_install');

// Add a configure action
//$thisplugin->add_action('plugin_configure','smart_catlist_configure');

// Add an uninstall action
$thisplugin->add_action('plugin_uninstall','smart_catlist_uninstall');

// Add an cleanup action
$thisplugin->add_action('plugin_cleanup','smart_catlist_cleanup');

// Add a filter for the gallery header
$thisplugin->add_filter('plugin_block','smart_catlist');


// the base of this function is the theme_display_cat_list function located in include/themes.inc.php
// but a little different, line 65.
function smart_catlist() {
	
    global $thisplugin;
	global $CONFIG, $matches, $cat, $lang_catmgr_php;
	
	// need some methods located in custom.php
	require('plugins/smart_catlist/include/custom.php');
	

	
	$breadcrumb = '';
    $cat_data = array();
    $statistics = '';	
	
	
	
	
	if (isset($cat)) {
		get_meta_album_set($cat,$META_ALBUM_SET);
    } else {
        get_meta_album_set(0,$META_ALBUM_SET);
    }

	
    get_smartcat_list($breadcrumb, $cat_data, $statistics);
	//originally: get_cat_list($breadcrumb, $cat_data, $statistics);
	
	
	
	if($matches[1] != 'catlist')
	{
         return $matches;
    }

	if ($breadcrumb != '' || count($cat_data) > 0){
	
	// the called method is different than the original method
	theme_display_smartcat_list($breadcrumb, $cat_data, $statistics);
	
	}
    if (isset($cat) && $cat == USER_GAL_CAT) 
		{
	
        list_users();
		
		}
	}


// Install function
// create a new field "visibility" at the end of the category table in the database, default value = 0 (= visible)
function smart_catlist_install() {

	global $CONFIG;
	
	// add a field in the table for the visibility parameter 
	if (!isset($CONFIG['smartcat_enable'])){
		$query = "ALTER TABLE {$CONFIG['TABLE_CATEGORIES']} ADD `visibility` INT NOT NULL DEFAULT '0'";
		$result = cpg_db_query($query);
	
		$query="INSERT INTO ".$CONFIG['TABLE_CONFIG']." VALUES ('smartcat_enable', '1');";
		$result = cpg_db_query($query);
	}
	
	$ftr = "catmgr.php";
	$ftc = "plugins/smart_catlist/catmgrcustomized.php";
	$ftb = "catmgrbak.php";

	
	//rename catmgr.php in catmgrbak.php
	rename($ftr, $ftb);
	//copy the customized catmgr.php in catmgr.php
	copy($ftc, $ftr);
	
    return true;

}

// uninstall function that drop the fields created when uninstalling
function smart_catlist_uninstall(){


	
	// drop the created field
	global $CONFIG;
	
	if (!isset($_POST['drop'])) return 1;
	
	if ($_POST['drop']) {
		$query = "ALTER TABLE {$CONFIG['TABLE_CATEGORIES']} DROP `visibility` ";
		$result = cpg_db_query($query);
		cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name='smartcat_enable';");
	}
	
	//rename the original catmgr.php in catmrg.php
	copy("catmgrbak.php", "catmgr.php");
	//delete the backup of catmgr.php
	unlink('catmgrbak.php');
	
	return true;

}

// Uninstall (ask admin about dropping table)
function smart_catlist_cleanup($action) 
{

	global $CONFIG;
	
	if (file_exists("plugins/smart_catlist/lang/{$CONFIG['lang']}.php")) {
  require "plugins/smart_catlist/lang/{$CONFIG['lang']}.php";
} else require 'plugins/smart_catlist/lang/english.php';
	
	
	// global $lang_smart_catlist;



    if ($action===1) {
        echo <<< EOT
    <form action="{$_SERVER['REQUEST_URI']}" method="post">
        <p>
            {$lang_smart_catlist['uninstall_title']}
        </p>
        <div style="margin:25;">
        <table border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td><input type="radio" name="drop" value="1" /></td>
                <td>Yes</td>
            </tr>
            <tr>
                <td><input type="radio" name="drop" checked="checked" value="0" /></td>
                <td>No</td>
            </tr>
        </table>
        </div>
        <span>
           <input type="submit" name="submit" value="{$lang_smart_catlist['button_submit']}" /> &nbsp;&nbsp;&nbsp;
            <input type="button" name="cancel" onClick="window.location='pluginmgr.php';" value="{$lang_smart_catlist['button_cancel']}" />
        </span>
    </form>
EOT;
    }
}

	
?>