<?php
/**************************************************
  Coppermine Plugin - Search Album
  *************************************************
  Copyright (c) 2005 Paul Van Rompay
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  *************************************************/

global $CONFIG, $lang_meta_album_names, $lang_yes, $lang_no;
global $lang_plugin_searchalbum, $lang_plugin_searchalbum_config;
require('include/init.inc.php');

if (!GALLERY_ADMIN_MODE) cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);

require('plugins/search_album/include/init.inc.php');

if (count($_POST) > 0) {
	if (isset($_POST['update_config'])) {

		$htmlchars = array('&lt;' => '<', '&gt;' => '>', '&amp;' => '&', '&quot;' => "\'", '&#39;' => "\'", '&#039;' => "\'");

		$template_stats = str_replace('\\','',$_POST['template_stats']);
		$template_stats = get_magic_quotes_gpc() ? $template_stats : addslashes($template_stats);
		$template_stats = strtr($template_stats, $htmlchars);

		$showemptyresults = $_POST['searchonlyalbum'] ? '1' : $_POST['showemptyresults'];

		$date_format = str_replace('\\','',$_POST['stats_date_format']);
		$date_format = get_magic_quotes_gpc() ? $date_format : addslashes($date_format);
		$date_format = strtr($date_format, $htmlchars);

		$sql1 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '{$showemptyresults}' WHERE name = 'plugin_searchalbum_showempty'";
		$sql2 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '{$_POST['showcatname']}' WHERE name = 'plugin_searchalbum_showcatname'";
		$sql3 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '{$_POST['showalbstats']}' WHERE name = 'plugin_searchalbum_showalbstats'";
		$sql4 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '{$template_stats}' WHERE name = 'plugin_searchalbum_templatestats'";
		$sql5 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '{$date_format}' WHERE name = 'plugin_searchalbum_statsdatefmt'";
		$sql6 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '{$_POST['searchonlyalbum']}' WHERE name = 'plugin_searchalbum_onlyalbum'";
		cpg_db_query($sql1);
		cpg_db_query($sql2);
		cpg_db_query($sql3);
		cpg_db_query($sql4);
		cpg_db_query($sql5);
		cpg_db_query($sql6);
		if ($CONFIG['log_mode'] == CPG_LOG_ALL) {
			log_write('CONFIG UPDATE SQL: '.$sql1.";\n".$sql2.";\n".$sql3.";\n".$sql4.";\n".$sql5.";\n".$sql6
				.'TIME: '.date("F j, Y, g:i a")."\n"
				.'USER: '.$USER_DATA['user_name'],
				CPG_DATABASE_LOG
				);
		}
	}
        pageheader($lang_plugin_searchalbum['display_name']);

	if ($_POST['searchonlyalbum']) {
		$install_message .= "<br />\n<strong>".$lang_plugin_searchalbum_config['searchonlymsg']."</strong><br />\n".'<p align="left"><pre>'
		.'// ---------------------------------------------------------------------------------------'."\n"
		.'// BEGIN BLOCK - added for plugin "Search Album"'."\n"
		.'//               may be left here even if plugin is uninstalled'."\n"
		.'// ---------------------------------------------------------------------------------------'."\n"
		.'if ($CONFIG[\'plugin_searchalbum_onlyalbum\']) {'."\n"
		."\n"
		.'	function theme_no_img_to_display($album_name)'."\n"
		.'	{'."\n"
		.'	    if ((!$_POST[\'search\'] && !$_GET[\'search\']) || (($_POST[\'plugin_search_album\']'."\n"
		.'		|| $_GET[\'plugin_search_album\']) && !defined(\'PLUGIN_SEARCH_ALBUM_OUTPUT\'))) {'."\n"
		.'		global $lang_errors, $template_no_img_to_display;'."\n"
		."\n"
		.'		static $template = \'\';'."\n"
		.'		static $spacer;'."\n"
		."\n"
		.'		if ((!$template)) {'."\n"
		.'			$template = $template_no_img_to_display;'."\n"
		.'			$spacer = template_extract_block($template, \'spacer\');'."\n"
		.'		}'."\n"
		."\n"
		.'		$params = array(\'{TEXT}\' => $lang_errors[\'no_img_to_display\']);'."\n"
		.'		starttable(\'100%\', $album_name);'."\n"
		.'		echo template_eval($template, $params);'."\n"
		.'		endtable();'."\n"
		."\n"
		.'		define(\'PLUGIN_SEARCH_ALBUM_OUTPUT\',true);'."\n"
		.'	     } '."\n"
		.'	}'."\n"
		.'}'."\n"
		.'// ---------------------------------------------------------------------------------------'."\n"
		.'</pre></p>'."<br />\n<strong>".$lang_plugin_searchalbum_config['searchonlymsg2']."</strong><br />\n"
		.($_POST['showemptyresults'] ? '' : '<br /><strong>'.$lang_plugin_searchalbum_config['searchonlymsg3']."</strong><br />\n")
		."<br />\n";

		starttable('80%', $lang_plugin_searchalbum['display_name'], 3);
		echo '<tr><td>'."\n";
		echo $install_message;
		echo '</td></tr>'."\n";
		endtable();
	}
        msg_box($lang_plugin_searchalbum['display_name'], $lang_plugin_searchalbum['page_success'], $lang_continue, 'index.php');
	pagefooter();
        exit;
}

pageheader($lang_plugin_searchalbum['display_name']);
starttable('100%');
echo <<< EOT
	<tr>
	<td class="tableh1" width="90%"><b>{$lang_plugin_searchalbum['display_name']}</b> 
		- <a href="pluginmgr.php" class="admin_menu">Plugin Manager</a>
	</td>
	</tr>
	<tr><td class="tableb">
	<form action="{$_SERVER['REQUEST_URI']}" method="post">
	<br />
EOT;

if ($CONFIG['plugin_searchalbum_showempty']) {
	$showempty_yes_selected = 'checked';
	$showempty_no_selected = '';
} else {
	$showempty_yes_selected = '';
	$showempty_no_selected = 'checked';
}

if ($CONFIG['plugin_searchalbum_showcatname']) {
	$showcatname_yes_selected = 'checked';
	$showcatname_no_selected = '';
} else {
	$showcatname_yes_selected = '';
	$showcatname_no_selected = 'checked';
}

if ($CONFIG['plugin_searchalbum_showalbstats']) {
	$showalbstats_yes_selected = 'checked';
	$showalbstats_no_selected = '';
} else {
	$showalbstats_yes_selected = '';
	$showalbstats_no_selected = 'checked';
}

$template_stats = $CONFIG['plugin_searchalbum_templatestats'];
$stats_date_format = $CONFIG['plugin_searchalbum_statsdatefmt'];

if ($CONFIG['plugin_searchalbum_onlyalbum']) {
	$searchonlyalbum_yes_selected = 'checked';
	$searchonlyalbum_no_selected = '';
} else {
	$searchonlyalbum_yes_selected = '';
	$searchonlyalbum_no_selected = 'checked';
}

echo <<< EOT
		<form action="{$_SERVER['REQUEST_URI']}" method="post">

		<strong>{$lang_plugin_searchalbum_config['emptyresults']}</strong>:
		<input type="radio" name="showemptyresults" value="1" $showempty_yes_selected>$lang_yes
			&nbsp;&nbsp;
		<input type="radio" name="showemptyresults" value="0" $showempty_no_selected>$lang_no
		<br />

		<strong>{$lang_plugin_searchalbum_config['searchonly']}</strong>:
		<input type="radio" name="searchonlyalbum" value="1" $searchonlyalbum_yes_selected>$lang_yes
			&nbsp;&nbsp;
		<input type="radio" name="searchonlyalbum" value="0" $searchonlyalbum_no_selected>$lang_no
		<br />
		<br />

		{$lang_plugin_searchalbum_config['lastalb_note']}<br />
		<strong>{$lang_plugin_searchalbum_config['showcatname']}</strong>:
		<input type="radio" name="showcatname" value="1" $showcatname_yes_selected>$lang_yes
			&nbsp;&nbsp;
		<input type="radio" name="showcatname" value="0" $showcatname_no_selected>$lang_no
		<br />

		<strong>{$lang_plugin_searchalbum_config['showalbstats']}</strong>: 
		<input type="radio" name="showalbstats" value="1" $showalbstats_yes_selected>$lang_yes
			&nbsp;&nbsp;
		<input type="radio" name="showalbstats" value="0" $showalbstats_no_selected>$lang_no
		<br />

		<nobr>- {$lang_plugin_searchalbum_config['stats_template']}: 
			<input type="text" class="textinput" maxlength="100" size="50" name="template_stats" value="$template_stats"/></nobr>
		<br />
		<nobr>- {$lang_plugin_searchalbum_config['stats_dateformat']}: 
			<input type="text" class="textinput" maxlength="40" size="50" name="stats_date_format" value="$stats_date_format"/></nobr><br />
		{$lang_plugin_searchalbum_config['stats_note']}<br />

		<br />
		<input type="submit" value="{$lang_plugin_searchalbum_config['button_done']}" name="update_config"/>
		</form>
EOT;

echo '</td></tr>'."\n";
endtable();
pagefooter();
ob_end_flush();
?>
