<?php
/**************************************************
  Coppermine Plugin - Popups Control
  *************************************************
  Copyright (c) 2006 Paul Van Rompay
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
***************************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// ------------------------------------------------------------------------------------------------
// Configuration Option - BEGIN
// ------------------------------------------------------------------------------------------------

   define('POPCON_EVERY', 3);	// every X clicks, a popup window is shown (with X defined here)

   // For popup window links, scroll down to $a_link array and set URLs as desired.

// ------------------------------------------------------------------------------------------------
// Configuration Option - END
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Add filters
// ------------------------------------------------------------------------------------------------
$thisplugin->add_filter('page_html','popcon_processpopups');

// ------------------------------------------------------------------------------------------------
// Filter page_html to add popups to displayimage.php
// ------------------------------------------------------------------------------------------------
function popcon_processpopups($html) {
	if (defined('DISPLAYIMAGE_PHP') && !GALLERY_ADMIN_MODE) {

		session_start();

		$a_link[0] = "window.open('http://www.domain0.com/');";
		$a_link[1] = "window.open('http://www.domain1.com/');";
		$a_link[2] = "window.open('http://www.domain2.com/');";
		$a_link[3] = "window.open('http://www.domain3.com/');";
		$a_link[4] = "window.open('http://www.domain4.com/');";
		$a_link[5] = "window.open('http://www.domain5.com/');";

		if(!isset($_SESSION['c_count']) || !is_numeric($_SESSION['c_count']) || $_SESSION['c_count']>(count($a_link)-1)){
			$_SESSION['c_count'] = 0;
		}
		if(!isset($_SESSION['c_cpg']) || !is_numeric($_SESSION['c_cpg'])){
			$_SESSION['c_cpg'] = 0;
		}
		if(!isset($_SESSION['c_link']) or $_SESSION['c_link']==""){
			$_SESSION['c_link'] = $a_link[0];
			$_SESSION['c_count'] = 0;
		}
		if(++$_SESSION['c_cpg'] == POPCON_EVERY) {
			$_SESSION['c_link'] = $a_link[$_SESSION['c_count']];
			$_SESSION['c_cpg'] = 0;
			$_SESSION['c_count']++;
			$popupscript = "<script language=\"JavaScript\">{$_SESSION['c_link']}</script>";
			$html = preg_replace('/<\/head>/',$popupscript.'</head>',$html);
		}
	}
	return $html;
}

// ------------------------------------------------------------------------------------------------
// End of plugin code
// ------------------------------------------------------------------------------------------------

?>
