<?php
 /** 
 * BrainFeeder for CPG
 * Version 1.0
 * written  by Hallvard Natvik <hallvard@natvik.com>
 * Send me a mail if you use it
 * 
 * This is free software made available to you without any guarantees or obligations
 * You can use this sofware anyway you like.
 *------------------------------------------------------------
 *  
 * This file, rss.php, should be installed in your main coppermine folder or directory (same place as Coppermine's index.php)
 * Realtime mode: The feed is generated on-the-fly when the RSS aggregator client contacts this script. Only one feed can be generated.
 * Batch mode: The feeds are generated by a cron job or by manually running this script. All batch feeds are generated.
 * When operating in Batch mode, you save server resources. You should give the URL to the output XML-file to your subscribers, 
 * not the URL to this script to achieve this. The XML file will be written to the coppermine directory if no path is given in the
 * configuration screen. Make sure that this script has writing rights to the directory.
 * 
 * By using "...?feed=<feed name>" you can actually run a Batch feed in Realtime
 * 
 * Start-up syntax: 
 * host.com/rss.php -> runs all batch feeds (ie. generating rss files) ($run_type 0)
 * host.com/rss.php?feed=news -> generates the feed named 'news' to the browser (realtime $run_type 1)
 * host.com/rss.php?fid=1 -> generates feed number one to the browser (realtime $run_type 2) 
 */
 
 
 define ('IN_COPPERMINE', TRUE);
 define ('GENERATOR', "BrainFeeder for Coppermine 1.0 by Hallvard Natvik");
 require_once('include/init.inc.php');
 require_once ('plugins/brainfeeder/init.inc.php'); 
 require_once ('plugins/brainfeeder/brainfeeder.php'); 
 
 $feed_name="";
 $feed_id=0;
 $run_type =0;
 $where ="WHERE feed_mode ='Batch'";
 $feed_mode = TRUE;
 $channel_image = FALSE;
 $rss_filename ="";
 
 if (isset($_GET['feed'])) {
     $feed_name=$_GET['feed'];
     $where = "WHERE feed_name='".$feed_name."'";
     $feed_mode = FALSE;
     $run_type= 1;
 } elseif (isset($_GET['fid'])) {
     $fid=$_GET['fid'];
     $where = "WHERE fid=".$fid;
     $feed_mode = FALSE;
     $run_type= 2;
 }
 
 //logg("runtype: ".$run_type);
 
$query = "SELECT * FROM ".$CONFIG['TABLE_brainfeeder']." ".$where;
//logg("\n1:".$query);
$result = cpg_db_query($query);
$rows = cpg_db_fetch_rowset($result);

$pic_fields = "pid, pic.aid, concat(filepath, filename) as file, 
                    concat(filepath,'".$CONFIG['thumb_pfx'] ."', filename) as thumb, 
                    concat(filepath,'".$CONFIG['normal_pfx'] ."', filename) as normal, 
                    filesize, pic.title as ptitle, caption, owner_name, keywords";
    $alb_fields = "alb.title as atitle, description, visibility, category";
    $base_query = "SELECT ".$pic_fields.", ".$alb_fields." 
                    FROM ".$CONFIG['TABLE_PICTURES']." pic, ".$CONFIG['TABLE_ALBUMS']." alb 
                    WHERE alb.aid = pic.aid and approved ='YES' \n";
    $restr_visibility = " AND visibility = 0 ";

foreach ($rows as $row)  {
    if (isset($row['logo_keyw']) && strlen(trim($row['logo_keyw'])) >0) {
        $logo_row=get_by_keyword($row['logo_keyw'],1);
        $thumb_url = $CONFIG['ecards_more_pic_target'].$CONFIG['fullpath'].$logo_row[0]['thumb'];
    }
    if (isset($row['feed_incl_restr']) && $row['feed_incl_restr']=="No" ) $base_query .= $restr_visibility;
    switch ($row['feed_type']) {
        case "Last public":
            $pic_array = get_last_public_pics($row['items_to_include']);
            break;
        case "Keyword":
            $pic_array = get_by_keyword($row['feed_parameter'], $row['items_to_include']);
            break;
        case "Album";
            $pic_array = get_by_aid($row['feed_parameter'], $row['items_to_include']);
            break;
        case "Category";
            $pic_array = get_by_catid($row['feed_parameter'], $row['items_to_include']);
            break;
        case "Hits";
            $pic_array = get_by_hits($row['items_to_include']);
            break;
        case "Rating";
            $pic_array = get_by_rating($row['items_to_include']);
            break;
    }
//logg("\nfeedmode: ".$feed_mode)   ;
    $rss_channel = new feed_genarator($feed_mode,"2.0",$CONFIG['charset']);
    $rss_channel->set_permalink(FALSE);
    
    //$rss_channel->debug=TRUE;
    $channel = array (
        'title' =>$row['feed_title'],
        'link' =>$row['feed_link'],
        'description' =>$row['feed_description'],
        'copyright' =>$row['feed_copyright'],
        'language' =>'en-us',
        'ttl' =>720,
        'category'=> $row['feed_keywords'],
        'generator' =>GENERATOR,
        'managingEditor' =>$CONFIG['gallery_admin_email'],
        'webMaster' =>$CONFIG['gallery_admin_email'],
        'pubDate' =>date(DATE_RFC822),
        'lastBuildDate' =>date(DATE_RFC822)
        );
    
//    logg(str_replace(",","\n",json_encode($channel)));

    $channel_image = array (
        'url' =>$thumb_url,
        'link' =>$row['feed_link'],
        'title'=> $row['feed_title'],
        'description'=> "",
        'widht'=>$CONFIG['thumb_width']
        //'height'=>58
        );
//    logg(str_replace(",","\n",json_encode($channel_image)));

    $rss_channel->build_channel($channel);
    $rss_channel->set_channel_image($channel_image);
    //logg ("\n\nChannel: ");
//    logg(str_replace(",","\n",json_encode($rss_channel->channel)));  

    foreach ($pic_array as $pic) {
        //print_r ($pic);
        if (strlen(trim($pic['title']))<1) {
            $pic['title']=$row['item_def_title'];
        }
        if (strlen($pic['ptitle'])>2) {
            $ptitle = $pic['ptitle'];
        } else {
            $ptitle = $row['item_def_title'];
        }
        $item = array(
        'title'=> $ptitle,
        'author'=>$pic['owner_name'],
        'ttl'=>$pic['feed_refresh'],
        'link'=>$CONFIG['ecards_more_pic_target']."displayimage.php?pos=-".$pic['pid'],
        'guid'=>$CONFIG['ecards_more_pic_target']."displayimage.php?pos=-".$pic['pid'],
        'description'=>make_pic_descr($pic,$row['item_comments'],$row['item_cms'])
        );
        if ($row['feed_enclosure']!="No") {
            $pic_url=make_pic_url($pic,$row['feed_enclosure']);
            $item['enclosure'] =$pic_url;
            //logg("\npicurl: ".$pic_url);
        }
        if ($row['feed_source']=="Yes") $item['source'] =$CONFIG['ecards_more_pic_target'];
        if ($row['feed_category_opt']=="Yes") {
         $item['category']=$pic['keywords'];
        }
        $rss_channel->add_items($item);
    }
    $rss_filename = $row['file_name'];
    $rss_channel->createFeed();
}

function get_last_public_pics($number=10) {
    global $base_query;
    $query = $base_query." and visibility = 0 ORDER BY ctime desc LIMIT $number";
    //logg("\n2:".$query);
    $result = cpg_db_query($query); 
    return cpg_db_fetch_rowset($result);
}

function get_by_keyword($keyword, $number=10) {
    global $base_query;
    $query = $base_query." and keywords LIKE '%$keyword%' ORDER BY ctime desc LIMIT $number";
    //logg("\n3:".$query);
    $result = cpg_db_query($query); 
    return cpg_db_fetch_rowset($result);
}

function get_by_aid($aid, $number=10) {
    global $base_query;
    $query = $base_query." and pic.aid=$aid ORDER BY ctime desc LIMIT $number";
    //logg("\n4:".$query);
    $result = cpg_db_query($query); 
    return cpg_db_fetch_rowset($result);
}

function get_by_catid($catid, $number=10) {
    global $CONFIG;
    global $base_query;
    $query = $base_query." and (category=$catid OR category in (SELECT cid from ".$CONFIG['TABLE_CATEGORIES']." WHERE parent=".$catid. " ))
            ORDER BY ctime desc LIMIT $number";
    //logg("\n5:".$query);
    $result = cpg_db_query($query); 
    return cpg_db_fetch_rowset($result);
}

function get_by_hits($number=10) {
    global $CONFIG;
    global $base_query;
    $query = $base_query." ORDER BY hits desc LIMIT $number";
    //logg("\n5:".$query);
    $result = cpg_db_query($query); 
    return cpg_db_fetch_rowset($result);
}

function get_by_rating($number=10) {
    global $CONFIG;
    global $base_query;
    $query = $base_query." ORDER BY pic_rating desc LIMIT $number";
    //logg("\n5:".$query);
    $result = cpg_db_query($query); 
    return cpg_db_fetch_rowset($result);
}

function make_pic_descr($pic, $comments="No",$cms="No"){
    global $CONFIG;
    $txt = "";
    $ret = "<table><tr><td>";
    $pic_url = make_pic_url($pic,"Thumb");
    $ret .= "<img src=\"".$pic_url."\" width=\"".$CONFIG['thumb_width']."\" alt=\"RSS image\" /></td>";
    if ($cms =="Yes" && isset($CONFIG['TABLE_CMS'])){
        $cmsquery = "SELECT content FROM ".$CONFIG['TABLE_CMS']." WHERE type = 2 and conid= ".$pic['pid'];
        $result = cpg_db_query($cmsquery); 
        $txt = cpg_db_fetch_row($result);
        $txt = html_entity_decode($txt['content']);
    }
    
    $ret .= "<td valign=\"top\">".$pic['caption']."<br />".$txt."</td></tr>";
    if ($comments=="Yes") {
        $coms = get_pic_comments($pic['pid']);
        if (count($coms)>0) {
            foreach ($coms as $com) {
                $ret .= "</tr><td>&nbsp</td><td><p>".$com['msg_author'].": ".$com['msg_body']."</td></tr>";
            }
        }
    }
    $ret .= "</table>";
    return $ret;
}

function logg ($txt) {
    $hndl=fopen("queries.txt","a");
    fwrite($hndl,$txt);
    fclose($hndl);
}

function make_pic_url($pic, $size) {
    global $CONFIG;
    switch ($size) {
        case "Thumb": 
            $filename = $pic['thumb'];
            break;
        case "Normal":
            $filename = $pic['normal'];
            break;
        case "Original":
            $filename = $pic['file'];
            break;
        default:
            $filename = $pic['normal'];
            break;
    }
    $path_arr = explode("/",$CONFIG['fullpath'].$filename);
    $c = count($path_arr);
    $i=0;
    $pathstr ="";
    for ($i=0;$i<$c;$i++) {
       $pathstr .= str_replace("+"," ",urlencode($path_arr[$i]))."/";
    }
    $pathstr = substr($pathstr,0,-1); //remove trailing "/"
    return $CONFIG['ecards_more_pic_target'].$pathstr; //.$filename;

}

function get_pic_comments ($pid) {
    global $CONFIG;
    $comment_query = "SELECT msg_author, msg_date, msg_body FROM ".$CONFIG['TABLE_COMMENTS']." WHERE pid=".$pid." LIMIT 5";
    logg($comment_query);
    $result = cpg_db_query($comment_query);
    $rows = cpg_db_fetch_rowset($result);
    return $rows;
}

?>
