#**************************************************
#  CPG PMS Plugin for Coppermine Photo Gallery
#  *************************************************
#  Copyright (c) 2006 Thomas Lange <stramm@gmx.net>
#  *************************************************
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#  *************************************************
#  Coppermine version: 1.4.13
#  CPG PMS version: 1.1
#  $Revision: 1.0 $
#  $Author: stramm $
#***************************************************


#
# Table structure for table `CPG_pms`
#

CREATE TABLE IF NOT EXISTS CPG_pms (
					id INT(10) NOT NULL AUTO_INCREMENT,
					owner int(10) NOT NULL DEFAULT '0',
					subject VARCHAR(120) NOT NULL DEFAULT '',
					message TEXT,
					sender VARCHAR(120) NOT NULL DEFAULT '',
					sender_id int(10) NOT NULL DEFAULT '0',
					posted INT(10) NOT NULL DEFAULT '0',
					sender_ip VARCHAR(120),
					smileys TINYINT DEFAULT '1',
					status TINYINT DEFAULT '0',
					showed TINYINT DEFAULT '0',
					replied TINYINT DEFAULT '0',
					PRIMARY KEY (id)
					) TYPE=MyISAM;


#
# Modification of user table
#

ALTER TABLE CPG_users ADD user_pmsmail tinyint(4) NOT NULL DEFAULT 1;


#
# Additions to config table
#

INSERT INTO CPG_config (name, value) values ('pms_enabled', '1');
INSERT INTO CPG_config (name, value) values ('pms_messages', '200');
INSERT INTO CPG_config (name, value) values ('pms_enable_email', '1');
INSERT INTO CPG_config (name, value) values ('pms_make_links', '1');
INSERT INTO CPG_config (name, value) values ('pms_date_format', 'l dS of F Y ');
INSERT INTO CPG_config (name, value) values ('pms_time_format', 'h:i:s');
INSERT INTO CPG_config (name, value) values ('pms_smilies', '1');
INSERT INTO CPG_config (name, value) values ('pms_post_flood', '30');
INSERT INTO CPG_config (name, value) values ('pms_message_bbcode', '1');
INSERT INTO CPG_config (name, value) values ('pms_message_img_tag', '1');
INSERT INTO CPG_config (name, value) values ('display_pms_status', '1');
INSERT INTO CPG_config (name, value) values ('enable_loginform', '1');
#INSERT INTO CPG_config (name, value) values ('display_buddy_status', '1');
#INSERT INTO CPG_config (name, value) values ('enable_custom_thumbs', '1');
#INSERT INTO CPG_config (name, value) values ('enable_thumb_watermark', '1');