<?php

/**
* @desc ^^ evt start from here !
*/

class HTMLelement {
    function hidden($name, $value) {
		return "<input type=\"hidden\" name=\"$name\" value=\"$value\" />\n";		
	}
	function radio($name, $value, $text) {		
		return "<input type=\"radio\" name=\"$name\" value=\"$value\" /> $text\n";	
	}
	function text_input($name, $value="") {
		return "<input class=\"textinput\" type=\"text\" name=\"$name\" style=\"width: 100%\" value=\"$value\" />\n";	
	}
	function textarea($name, $value="", $rows="8") {
		return "<textarea class=\"textinput\" id=\"$name\" name=\"$name\" style=\"width: 100%;\" rows=\"$rows\">$value</textarea>\n";
	}
	function simple_select($name, $value_array, $default='', $is_100=true) {
		global $CONFIG;
		$html = "";
		if ($is_100)
			$html .= "<select name=\"$name\" class=\"listbox\" style=\"width: 100%;\">\n";
		else 
			$html .= "<select name=\"$name\" class=\"listbox\">\n";
		foreach ($value_array as $key => $title) {
			if ($key == $default)
				$html .= "<option value=\"$key\" selected=\"selected\">$title</option>\n";
			else
				$html .= "<option value=\"$key\">$title</option>\n";
		}
		$html .= "</select>\n";
		return $html;	
	}	
	function check_box($name, $checked=false) {
		if ($checked)
			return "<input type=\"checkbox\" name=\"$name\" checked>\n";
		else
			return "<input type=\"checkbox\" name=\"$name\">\n";
	}	
	function apply_bold($text) {		
		return "<b>".$text."</b>";	
	}
	function apply_span($text, $class="") {
		if ($class != "")
			return "<span class=\"$class\">".$text."</span>\n";
		else
			return "<span>".$text."</span>\n";	
	}
	function board_title($board_id, $board_name) {
	    return "<span class=\"catlink\"><b>".HTMLelement::board_link($board_id, $board_name)."</b></span>";
	}              
	function profile_link($user_id, $user_name) {
		$user_name = trim($user_name);
		if ($user_id != 0)
    		return "<a href=\"profile.php?uid=$user_id\">$user_name</a>\n";
    	else
    		return $user_name;
	}	
	function cat_link($cat_id, $cat_name) {
		return "<a href=\"forum.php?cat=$cat_id\">$cat_name</a>\n";	
	}			                                                                      	
	function board_link($board_id, $board_name) {
		return "<a href=\"forum.php?board=$board_id\">$board_name</a>\n";	
	}
	function topic_link($topic_id, $topic_name,$extras=array()) {
		if ($extras)
			return "<a href=\"forum.php?topic=$topic_id&amp;$extras\">$topic_name</a>\n";
		else
			return "<a href=\"forum.php?topic=$topic_id\">$topic_name</a>\n";
	}
	function msg_link($msg_id, $msg_name) {		
		return "<a href=\"forum.php?msg=$msg_id\">$msg_name</a>\n";	
	}
	function image($image_link, $size = 1) {		
		global $CONFIG;
		$image_info = getimagesize($image_link); 		
		$image_info[0] = round($image_info[0] * $size);
		$image_info[1] = round($image_info[1] * $size);
		if ((int)$image_info[0] == 0) $image_info[0] = $CONFIG['thumb_width'] * $size;
		if ((int)$image_info[1] == 0) $image_info[1] = $CONFIG['thumb_width'] * $size;
				
		return "<img border=\"0\" src=\"$image_link\" width=\"{$image_info[0]}\" height=\"{$image_info[1]}\">\n";		
	}	
	function link($link, $text, $class="") {
		if ($class)
			return "<a class=\"$class\" href=\"$link\">$text</a>\n";
		else
			return "<a href=\"$link\">$text</a>\n";
	}	
	function spacer($height=10)	{
		echo "<img src=\"images/spacer.gif\" height=\"$height\" width=\"100%\" alt=\"\" />\n";	
	}
	function indent($level, $indent="<span style=\"color: red;\">|=></span>") {
		$html = "";
		for ($i=0;$i<($level-1);$i++) {			
			$html .= $indent;	
		}
		if ($html) $html .= "&nbsp;";
		return $html;	
	}
	function simple_form($name, $action) {
		return "<form name=\"$name\" action=\"$action\" method=\"post\"></form>\n";
	}
	
	function nagavitor($id, $type) {
		global $CONFIG;
		global $lang_fr_index;
		global $template_fr_nagavitor;	
		$nagavitor_array = array();
		// topic ?
		if ($type == "topic" || $type == "msg.post") {
			$topic_data = cpgdb_fetch_row("SELECT board_id, topic_id, last_msg_id, first_msg_id FROM `{$CONFIG['TABLE_FR_TOPICS']}` WHERE topic_id='$id' LIMIT 1;");
			$subject = cpgdb_fetch_var("SELECT subject FROM `{$CONFIG['TABLE_FR_MESSAGES']}` WHERE msg_id='{$topic_data['first_msg_id']}' LIMIT 1;");
			$nagavitor_array[] = $lang_fr_index['topic'] ." ". HTMLelement::topic_link($topic_data['topic_id'], "<span style=\"color:red\"><i>".$subject."</i></span>");
			$board_id = $topic_data['board_id']; 
		} elseif ($type == "board" || $type == "topic.post") {
			$board_id = $id;
		} elseif ($type == "cat") {		
			$cat_name = cpgdb_fetch_var("SELECT name FROM `{$CONFIG['TABLE_FR_CATEGORIES']}` WHERE cat_id='$id' LIMIT 1;");
			$nagavitor_array[] = HTMLelement::cat_link($id, "<span style=\"color:red\"><i>".$cat_name."</i></span>");
		// smt here
		}
		if ($type == "topic" || $type == "board" || $type == "msg.post" || $type == "topic.post") {
			// board		
			$board_data = cpgdb_fetch_row("SELECT cat_id, board_id, name, child_level, parent_id FROM `{$CONFIG['TABLE_FR_BOARDS']}` WHERE board_id = '$board_id' LIMIT 1;");		
			$cat_id = $board_data['cat_id'];
			if (count($nagavitor_array) == 0)
				$nagavitor_array[] = HTMLelement::board_link($board_data['board_id'], "<span style=\"color:red\"><i>".$board_data['name']."</i></span>");
			else
				$nagavitor_array[] = HTMLelement::board_link($board_data['board_id'], $board_data['name']);
			do {
			$board_data = cpgdb_fetch_row("SELECT cat_id, board_id, name, child_level, parent_id FROM `{$CONFIG['TABLE_FR_BOARDS']}` WHERE board_id = '{$board_data['parent_id']}' LIMIT 1;");
			if ($board_data['board_id']) $nagavitor_array[] = HTMLelement::board_link($board_data['board_id'], $board_data['name']);				
			if (!$board_data['parent_id']) break;                                                                   
		} while ($board_data['child_level']>1);
			// category
			$category_data = cpgdb_fetch_row("SELECT cat_id, name FROM `{$CONFIG['TABLE_FR_CATEGORIES']}` WHERE cat_id = '$cat_id' LIMIT 1;");
			$cat_link = HTMLelement::cat_link($category_data['cat_id'], $category_data['name']);
		}
		// home
		if (count($nagavitor_array) != 0)	
			$home_link = HTMLelement::link("forum.php", HTMLelement::apply_bold($lang_fr_index['home']));
		else 
			$home_link = HTMLelement::link("forum.php", "<span style=\"color:red\"><i>".HTMLelement::apply_bold($lang_fr_index['home'])."</i></span>");
		// global home						
		$global_home_link = HTMLelement::link("index.php", HTMLelement::apply_bold($lang_fr_index['index']));
		$nagavitor_array = array_reverse($nagavitor_array);
		if (!isset($cat_link))
			$nagavitor_array = array_merge(array($global_home_link, $home_link), $nagavitor_array);
		else
			$nagavitor_array = array_merge(array($global_home_link, $home_link, $cat_link), $nagavitor_array);
		$nagavitor = HTMLelement::apply_span(implode(" > ", $nagavitor_array), "catlink"); 		
		HTMLelement::spacer();
		starttable();
		$vars = array('{NAGAVITOR}'=>$nagavitor);
		echo template_eval($template_fr_nagavitor, $vars);
		endtable();	
		HTMLelement::spacer();
	}

	function get_last_post_text($msg_id) {
		global $CONFIG;
		global $last_msg_date_fmt;
		global $lang_fr_index;
		if ($msg_id == 0 || $msg_id == "") return "";
		$current_msg_data = cpgdb_fetch_row("SELECT msg_id, topic_id, subject, poster_id, poster_name, poster_time, body FROM `{$CONFIG['TABLE_FR_MESSAGES']}` WHERE msg_id='$msg_id';");
		$user_link   = HTMLelement::profile_link($current_msg_data['poster_id'], $current_msg_data['poster_name']);
		$topic_link  = HTMLelement::topic_link($current_msg_data['topic_id'], $current_msg_data['subject']);		
		// ???
		$topic_count = cpgdb_fetch_var("SELECT count(*) as count FROM `{$CONFIG['TABLE_FR_MESSAGES']}` WHERE topic_id='{$current_msg_data['topic_id']}';");			
		$topic_total_page = ceil($topic_count/$CONFIG['fr_msg_per_page']);
		$post_extra = "start=".($topic_total_page-1)*$CONFIG['fr_msg_per_page'];
		$post_extra .= "#".$msg_id;
		// ???
		$msg_link    = HTMLelement::topic_link($current_msg_data['topic_id'], substr($current_msg_data['body'], 0, 15), $post_extra);
		$msg_date    = localised_date($current_msg_data['poster_time'], $last_msg_date_fmt);		
		return sprintf($lang_fr_index['last_post'], $user_link, $topic_link, $msg_link, $msg_date);
	}

	function get_last_message($board_id) {
		global $CONFIG;
		$topic_array = cpgdb_fetch_rowset("SELECT topic_id FROM `{$CONFIG['TABLE_FR_TOPICS']}` WHERE board_id='$board';");	
		$topic_list_array = array();
		foreach ($topic_array as $topic) {
			$topic_list_array[] = $topic['topic_id'];			
		}		
		$topic_list = "(".implode(",", $topic_list_array).")";
		$last_message_data = cpgdb_fetch_row("SELECT * FROM `{$CONFIG['TABLE_FR_MESSAGE']}` WHERE topic_id IN $topic_list ORDER BY poster_time DESC LIMIT 1;");
	}

	function get_child_board($board_id, $child_level) {
		global $CONFIG;
		global $lang_fr_index;
		// child board
		$child_level++;
		$parent_board_id = $board_id;
		$child_array = cpgdb_fetch_rowset("SELECT board_id, name FROM `{$CONFIG['TABLE_FR_BOARDS']}` WHERE parent_id = '$parent_board_id' AND child_level='$child_level' ORDER BY board_order ASC;");
		foreach ($child_array as $key => $child) {
			$child_array[$key] = HTMLelement::board_link($child['board_id'], $child['name']);					
		}				
		if (count($child_array) != 0) {
			$child_boards =	$lang_fr_index['child_boards'].implode(", ", $child_array);					
		} else {
			return "";
		} 						
		return $child_boards;
	}

	function page($total, $start, $limit, $pattern) {
		global $CONFIG;
		$html = "";
		if ($total != 0) {
			$number_of_page = ceil($total / $limit);		
			$current_page   = ceil($start / $limit) + 1;
			if ($current_page == 0) $current_page = 1;
			for ($i=1;$i<=$number_of_page;$i++) {
				$current_start = ($i-1)*$limit;
				if ($current_page == $i)
					$html .= "[<b>$i</b>]" . "&nbsp;&nbsp;";
				else
					$html .= "<a href=\"$pattern&start=$current_start\">$i</a>" . "&nbsp;&nbsp;";
			}
			return $html;
		} else return "";
	}
	
	function icon_select($form_name, $name, $default="icon1") {
		global $CONFIG;
		$message_icon_array = cpgdb_fetch_rowset("SELECT title, filename FROM `{$CONFIG['TABLE_FR_MESSAGE_ICONS']}` ORDER BY icon_id ASC;");
		$html .= "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n";
		$html .= "<tr>\n";
		$count = 0;
		foreach ($message_icon_array as $message_icon) {
			$count++;
			if ($default == $message_icon['filename'])
				$html .= "<td><input type=\"radio\" name=\"$name\" value=\"{$message_icon['filename']}\" checked=\"checked\">&nbsp;<img src=\"adaptor/images/default/post/{$message_icon['filename']}.gif\" title=\"{$message_icon['title']}\" alt=\"\" />\n";
			else
				$html .= "<td><input type=\"radio\" name=\"$name\" value=\"{$message_icon['filename']}\">&nbsp;<img src=\"adaptor/images/default/post/{$message_icon['filename']}.gif\" title=\"{$message_icon['title']}\" alt=\"\" /></td>\n";
			if ($count % 16 == 0 && $count != 1) $html .= "</tr><tr>\n"; 		
		}           		
		$html .= "</tr>\n";
		$html .= "</table>\n";
		return $html;	
    }

	function redirect_box($cat_id) {
		global $CONFIG;
		$html = "<select class=\"listbox\" name=\"jumpto\" onchange=\"if (this.options[this.selectedIndex].value) window.location.href=this.options[this.selectedIndex].value;\">\n";
		$html .= "<option value=\"\">Please select a destination:</option>\n";
		$html .= "<option value=\"\" disabled=\"disabled\">-----------------------------</option>\n";
		// cat
		$cat_array = cpgdb_fetch_rowset("SELECT cat_id, name FROM `{$CONFIG['TABLE_FR_CATEGORIES']}`");		
		foreach ($cat_array as $cat) {
			if ($cat_id == $cat['cat_id'])                                 
				$html .= "<option value=\"forum.php?cat={$cat['cat_id']}\" selected=\"selected\">{$cat['name']}</option>\n";
			else	
				$html .= "<option value=\"forum.php?cat={$cat['cat_id']}\">{$cat['name']}</option>\n";
			$html .= "<option value=\"\" disabled=\"disabled\">-----------------------------</option>\n";	
			$board_array = array();
			get_board_list2($cat['cat_id'], 0, $board_array);			
			foreach ($board_array as $board) { 					
				$html .= "<option value=\"forum.php?board={$board['board_id']}\">".HTMLelement::indent($board['child_level']+1).$board['name']."</option>\n";	
			}		
			if (count($board_array) > 0) $html .= "<option value=\"\" disabled=\"disabled\">-----------------------------</option>\n";
		}	
		$html .= "</select>\n";
		return $html;
	}
	
}
?>