<?php
/**************************************************
  Coppermine Plugin - Delete Control
  *************************************************
  Copyright (c) 2005 Paul Van Rompay
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
***************************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// ------------------------------------------------------------------------------------------------
// Add filters - process search album and add to search results page
// ------------------------------------------------------------------------------------------------
$thisplugin->add_filter('page_html','delcon_filterpage');

// ------------------------------------------------------------------------------------------------
// Add actions
// ------------------------------------------------------------------------------------------------
$thisplugin->add_action('page_start','delcon_restrictaccess');

// ------------------------------------------------------------------------------------------------
// Filter page_html to remove delete buttons
// ------------------------------------------------------------------------------------------------
function delcon_filterpage($html) {
	if (defined('DISPLAYIMAGE_PHP') && !GALLERY_ADMIN_MODE) {
		$html = preg_replace('/<a href="delete\.php.*?<\/a>/','',$html);
	}
	if (defined('INDEX_PHP') && !GALLERY_ADMIN_MODE) {
		$html = preg_replace('/(?U)<td.*\s*<a href="delete\.php(?s).*<\/a>.*<\/td>/','',$html);
	}
	if (defined('EDITPICS_PHP') && !GALLERY_ADMIN_MODE) {
		$html = preg_replace('/(?U)<td.*\s*<span.*\s*.*(?s)name="deleteAll".*<\/td>/','',$html);
		$html = preg_replace('/(?U)<td.*(?s)name="delete\d+".*<\/td>/','',$html);
	}
	if (defined('ALBMGR_PHP') && !GALLERY_ADMIN_MODE) {
		$html = preg_replace('/(?U)<td.*\s*(?s)javascript:Album_Delete().*<\/td>/','<td width="80">&nbsp;</td>',$html);
	}
	return $html;
}

// ------------------------------------------------------------------------------------------------
// Restrict access to delete.php script
// ------------------------------------------------------------------------------------------------
function delcon_restrictaccess() {
	global $lang_errors, $lang_error;
	if (defined('DELETE_PHP') && !GALLERY_ADMIN_MODE) {
		$try_to_delete = false;
		$what = isset($_GET['what']) ? $_GET['what'] : $_POST['what'];
		if (($what != 'albmgr') || (($what == 'albmgr') && $_POST['delete_album'])) {
			$try_to_delete = true;
		}
		if ($try_to_delete) {
			load_template();
			pageheader($lang_error);
			cpg_die(ERROR, $lang_errors['perm_denied'], __FILE__, __LINE__);
		}
	}
	if (defined('EDITPICS_PHP') && !GALLERY_ADMIN_MODE) {
		$try_to_delete = false;
	        $pid_array = $_POST['pid'];
	        foreach($pid_array as $pid){
        	        $pid = (int)$pid;
			if (isset($_POST['delete'.$pid])) $try_to_delete = true;
		}
		if ($try_to_delete) {
			load_template();
			pageheader($lang_error);
			cpg_die(ERROR, $lang_errors['perm_denied'], __FILE__, __LINE__);
		}
	}
}

// ------------------------------------------------------------------------------------------------
// End of plugin code
// ------------------------------------------------------------------------------------------------

?>
