<?php
/**************************************************
  Backup Plugin for Coppermine Photo Gallery
/**********************************************
  based on the XT Dump script with the agreement of the author
  Modified by Frantz for Backup plugin
  2007/01/20
**********************************************
Functions for the plugin
**********************************************/
if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...'); }
function  ListFiles($sDir, $bRemoveExt = false)
{

  $aGlob = array();

  if ($fd = @opendir($sDir))
  {
    $sPattern = '^'.$sPattern.'$';
    while($sFile = readdir($fd))
    {
      if (!is_dir($sDir.'/'.$sFile) && ($sFile != '.') && ($sFile != '..'))
      {
        if ($bRemoveExt)
          $aGlob[] = substr($sFile, 0, strpos($sFile, '.'));
        else
          $aGlob[] = $sFile;
      }
    }
  }
  sort($aGlob);
  return $aGlob;
}

function        PrintArray($a)
{
        echo '<pre>';
        print_r($a);
        echo '</pre>';
}

function        PrintError($txt)
{
        global        $sHEADER, $sFOOTER, $lang_plugin_backup, $lang_plugin_backup;
pageheader($lang_plugin_backup['display_name']);
starttable('100%', 'Backup plugin - '.$lang_plugin_backup['version'].'    '.'<a href="pluginmgr.php" class="admin_menu">Plugin Manager</a>',1);
        echo <<<EOF
        <tr><td align="center">
        <br /><b>{$lang_plugin_backup['error']}</b><br/><br/>
        <b>{$txt}<br /></b>
        <br />
        <br />
        </td></tr>
EOF;
endtable();
pagefooter();
        exit;
}

function MicrotimeFloat()
{
    list($usec, $sec) = explode(" ", microtime());
    return ((float)$usec + (float)$sec);
}

function CheckConfig()
{
        global        $CONFIG;

        if (!file_exists('lang/'.$CONFIG['lang'].'.inc.php'))
                return ('Configuration Error: Invalid Language.');
        return (false);
}


function        CheckConnect($sDBhost = '', $sDBbase = '', $sDBuser = '', $sDBpass = '')
{
        global        $lang_plugin_backup;

        if (!($iSQL = @mysql_connect($sDBhost, $sDBuser, $sDBpass)))
        {
                PrintError($lang_plugin_backup['ERROR_CONNEXION_FAILED']);
        }
        if (!mysql_select_db($sDBbase, $iSQL))
        {
                @mysql_close($iSQL);
                PrintError($lang_plugin_backup['ERROR_DB_NOT_EXISTS']);
        }
        return ($iSQL);
}


function        GetTotalNumRows($aTables, $sDBhost = '', $sDBbase = '', $sDBuser = '', $sDBpass = '')
{
        /*$iSQL = mysql_connect($sDBhost, $sDBuser, $sDBpass);
        if (!$iSQL)
        {
                PrintError($lang_plugin_backup['ERROR_CONNEXION_FAILED']);
                return -1;
        }
        if (!mysql_select_db($sDBbase, $iSQL))
        {
                PrintError($lang_plugin_backup['ERROR_DB_NOT_EXISTS']);
                @mysql_close($iSQL);
                return -1;
        }*/
        $Total = 0;
        foreach ($aTables as $sTable)
        {
                $req = mysql_query("SELECT COUNT(*) as Num FROM ".$sTable);
                $data = mysql_fetch_assoc($req);
                $Total += intval($data['Num']);
        }
        return ($Total);
}

//function        PhpMinimumVersion ($sVersionCheck )
//{
//        $aMinVersion = explode(".", $sVersionCheck);
//        $aCurVersion = explode(".", phpversion());
//
//        if (($aCurVersion[0] < $aMinVersion[0])
//                || (($aCurVersion[0] == $aMinVersion[0]) && ($aCurVersion[1] < $aMinVersion[1]))
//                || (($aCurVersion[0] == $aMinVersion[0]) && ($aCurVersion[1] == $aMinVersion[1]) && ($aCurVersion[2][0] < $aMinVersion[2][0])))
//                {
//                  return (false);
//          }
//        else
//                {
//                  return (true);
//          }
//}

function        PrintJS($iTableCount)
{
        return <<<EOF
                <script type="text/javascript">
                <!--
                function checkall()
                {
                        var i = 0;

                        while (i < {$iTableCount})
                        {
                                a = 'tbls[' + i + ']';
                                document.frmConnex.elements[a].checked = true;
                                i++;
                        }
                        document.getElementById('selc1').checked = true;
                        document.getElementById('selc2').checked = true;
                }

                function decheckall()
                {
                        var i = 0;

                        while (i < {$iTableCount})
                        {
                                a = 'tbls[' + i + ']';
                                document.frmConnex.elements[a].checked = false;
                                i++;
                        }
                        document.getElementById('selc1').checked = false;
                        document.getElementById('selc2').checked = false;
                }
                -->
                </script>
EOF;
}

function        NextPageForm($aParams, $sButtonTxt)
{
        global        $lang_plugin_backup;
/*
        unset($aParams['dbhost']);
        unset($aParams['dbbase']);
        unset($aParams['dbuser']);
        unset($aParams['dbpass']);
*/
        $sForm = '<form id="frmNextPage" name="frmNextPage" method="post" action="">';
        foreach ($aParams as $key => $value)
        {
                if (!is_array($value))
                {
                        $sForm .= '<input type="hidden" name="'.$key.'" value="'.htmlentities($value).'" \>'."\n";
                }
                else
                {
                        foreach($value as $k => $v)
                        {
                                $sForm .= '<input type="hidden" name="'.$key.'['.$k.']" value="'.htmlentities($v).'" />'."\n";
                        }
                }
        }
        $sForm .= '<input type="submit" value=" '.$sButtonTxt.' " \>'."\n";
        $sForm .= '</form>'."\n";
        return  ($sForm);
}

function        ProgressUpdate($sText, $iPercent = '')
{
        $sText = htmlentities(str_replace('"', '\'', $sText));
        if ($iPercent != '')
        {
                $iPercent = ceil($iPercent);
                $sProgressBarUpdate = 'UpdateBar('.$iPercent.');';
        }
        else
        {
                $sProgressBarUpdate = '';
        }

        echo <<<EOF
<script type="text/javascript">
<!--
MyGetById('txtProgress').value = "{$sText}";
{$sProgressBarUpdate}
//-->
</script>

EOF;
        flush();
}

function        FormatSize($iSize)
{
        if ($iSize >= 1073741824)
                $sFormat = round($iSize / 1073741824 * 100) / 100 . " GB";
        elseif ($iSize >= 1048576)
                $sFormat = round($iSize / 1048576 * 100) / 100 . " MB";
        elseif ($iSize >= 1024)
                $sFormat = round($iSize / 1024 * 100) / 100 . " KB";
        else
                $sFormat = $iSize . " octets";
        if ($iSize == 0)
                $sFormat="-";
        return $sFormat;
}
?>