<?php
/**************************************************
  Backup Plugin for Coppermine Photo Gallery
/**********************************************
  based on the XT Dump script with the agreement of the author
  Modified by Frantz for Backup plugin
  2007/01/20
**********************************************/
if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...'); }
if (isset($_POST['LastTable']))
{
        header('Cache-Control: no-cache');
        header('Pragma: no-cache');
}
require('include/init.inc.php');

// Include the plugin's language file
// Submit your lang file for this plugin on the coppermine forums
// Plugin will try to use the configured language if it is available.
if (file_exists("./plugins/backup/lang/{$CONFIG['lang']}.php")) {
        require "./plugins/backup/lang/{$CONFIG['lang']}.php";
}
else {
        require "./plugins/backup/lang/english.php";
}


$XTCONFIG = array (
// Default database settings (can be empty)
'dbhost' => $CONFIG['dbserver'],
'dbbase' => $CONFIG['dbname'],
'dbuser' => $CONFIG['dbuser'],
'dbpass' => $CONFIG['dbpass'],
// Timeout limit before redirect
'timeout' => (ini_get('max_execution_time') - 2),
'cookiename' => 'XtDumpLang',
);
$XTDUMP_VERSION = '1 RC2';
$PLUGIN_VERSION = '2.3'; // Curent plugin version
include ('./plugins/backup/include/functions.inc.php');
if (!GALLERY_ADMIN_MODE) {
  cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);
}
if($lang_text_dir=='ltr') {
        $align="left";
        $direction="ltr";
}else {
        $align="right";
        $direction="rtl";
}
define('MAX_EXECUTION_TIME', $XTCONFIG['timeout']);

$iStartTime = MicrotimeFloat();


$aPages = array(
'dump' => './plugins/backup/dump_start.php',
'dodump' => './plugins/backup/dump.php',
'restore' => './plugins/backup/restore_start.php',
'dorestore' => './plugins/backup/restore.php',
'delete' => './plugins/backup/gest.php',
'gest' => './plugins/backup/gest.php'
);

// Display the header of this plugin
pageheader($lang_plugin_backup['display_name'], '<link rel="stylesheet" href="plugins/backup/backup.css" type="text/css" />'."\n");
print '<a name="backup"></a>';
print '<form action="'.$_SERVER['PHP_SELF'].'?file=backup/backup" method="post" id="frmConnex" name="frmConnex">';
starttable('100%', $lang_plugin_backup['display_name'] . ' - v'.$PLUGIN_VERSION,1);
print <<< EOT
<tr>
  <td class="tableh2">
    <span id="backup_plugin_menu">
    <a href="{$_SERVER['PHP_SELF']}?file=backup/backup&amp;act=dump#backup" class="admin_menu">{$lang_plugin_backup['menu_backup']}</a>
    <a href="{$_SERVER['PHP_SELF']}?file=backup/backup&amp;act=restore#backup" class="admin_menu">{$lang_plugin_backup['menu_restore']}</a>
    <a href="{$_SERVER['PHP_SELF']}?file=backup/backup&amp;act=gest#backup" class="admin_menu">{$lang_plugin_backup['menu_files']}</a>
    &nbsp;&middot;&nbsp;</span>
    <a href="pluginmgr.php" class="admin_menu">{$lang_plugin_backup['plugin_manager']}</a>
    <a href="http://coppermine-gallery.net/forum/index.php?topic=40439.0" rel="external" class="admin_menu external">{$lang_plugin_backup['announcement_thread']}</a>
    &middot;&nbsp;{$lang_plugin_backup['based_on']} <a href="http://www.dreaxteam.net/" rel="external" class="external">XT Dump</a>
  </td>
</tr>
EOT;

if (!isset($_REQUEST['act']) || !array_key_exists($_REQUEST['act'], $aPages)) {
        include('./plugins/backup/start.php');
} else {
        include($aPages[$_REQUEST['act']]);
}

// Display the footer of this plugin
endtable();
print '<br />';
print '</form>';
pagefooter();
?>