<?php
/**************************************************
  Coppermine Plugin - Stats, Hits
  *************************************************
  Copyright (c) 2006 Paul Van Rompay
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  *************************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// ------------------------------------------------------------------------------------------------
// Add an install & configure & uninstall actions
// ------------------------------------------------------------------------------------------------
$thisplugin->add_action('plugin_install','stats_hits_install');
$thisplugin->add_action('plugin_configure','stats_hits_configure');
$thisplugin->add_action('plugin_uninstall','stats_hits_uninstall');

// ------------------------------------------------------------------------------------------------
// Add actions
// ------------------------------------------------------------------------------------------------
$thisplugin->add_action('page_start','stats_hits_page_start');

// ------------------------------------------------------------------------------------------------
// Install Plugin
// ------------------------------------------------------------------------------------------------
function stats_hits_install() {
  global $CONFIG, $lang_plugin_stats_hits, $lang_plugin_stats_hits_config;
  require ('plugins/stats_hits/include/init.inc.php');
  
  if ($_POST['submit']==$lang_plugin_stats_hits_config['button_install']) {
    return true;
  } else {
    return 1;
  }
}

// ------------------------------------------------------------------------------------------------
// Configure Plugin
// ------------------------------------------------------------------------------------------------
function stats_hits_configure() {
  global $CONFIG, $lang_plugin_stats_hits, $lang_plugin_stats_hits_config;
  require ('plugins/stats_hits/include/init.inc.php');

  echo <<< EOT
    <h2>{$lang_plugin_stats_hits['install_done']}</h2>
    {$lang_plugin_stats_hits['install_note']}<br />
    <br />
    <form action="{$_SERVER['REQUEST_URI']}" method="post">
    <input type="submit" value="{$lang_plugin_stats_hits_config['button_install']}" name="submit"/>
    </form>
EOT;
}

// ------------------------------------------------------------------------------------------------
// Uninstall plugin
// ------------------------------------------------------------------------------------------------
function stats_hits_uninstall() {
  global $CONFIG;
  return true;
}

// ------------------------------------------------------------------------------------------------
// Add config button
// ------------------------------------------------------------------------------------------------
function stats_hits_add_config_button($href,$title,$target,$link)
{
  global $template_gallery_admin_menu;

  $new_template = $template_gallery_admin_menu;
  $button = template_extract_block($new_template,'documentation');
  $params = array(
      '{DOCUMENTATION_HREF}' => $href,
      '{DOCUMENTATION_TITLE}' => $title,
      'target="cpg_documentation"' => $target,
      '{DOCUMENTATION_LNK}' => $link,
   );
   $new_button="<!-- BEGIN $link -->".template_eval($button,$params)."<!-- END $link -->\n";
   template_extract_block($template_gallery_admin_menu,'documentation',"<!-- BEGIN documentation -->" . $button . "<!-- END documentation -->\n" . $new_button);
}

// ------------------------------------------------------------------------------------------------
// Add admin button to start of each page & restrict access if displayimage.php
// ------------------------------------------------------------------------------------------------
function stats_hits_page_start()
{
  global $CONFIG, $lang_plugin_stats_hits, $lang_plugin_stats_hits_config;
  global $lang_errors, $lang_error;
  require ('plugins/stats_hits/include/init.inc.php');

  if (GALLERY_ADMIN_MODE) {
    stats_hits_add_config_button('index.php?file=stats_hits/stats',$lang_plugin_stats_hits['config_title'],'',$lang_plugin_stats_hits['config_button']);
  }
}

// ------------------------------------------------------------------------------------------------
// End of plugin code
// ------------------------------------------------------------------------------------------------

?>
