<?php
/**************************************************
  Coppermine Plugin - Link Append
  *************************************************
  Copyright (c) 2009 Jeff Bailey
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
***************************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

$thisplugin->add_action('plugin_install','link_append_install');
$thisplugin->add_action('plugin_configure','link_append_configure');
$thisplugin->add_filter('template_html','link_append_include');
$thisplugin->add_action('plugin_uninstall','link_append_uninstall');
$thisplugin->add_action('plugin_cleanup','link_append_cleanup');

function link_append_include($html) {
$sql="SELECT id FROM `cpg_link_append` WHERE 1";
$resultq1 = cpg_db_query($sql);
while($r = mysql_fetch_array($resultq1)) {
$did = ($r["id"]);
}
$aid = 'galltop';
$include_js = <<<EOT
<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1/jquery.min.js"></script>
<script type="text/javascript">
	$(function (){
		$("#$did a").each(function(){
			var CLink = $(this).attr("href");
			var NLink = CLink + '#$aid';
			$(this).attr("href", NLink);
		});
	});
</script>
EOT;

$include_anchor = "<a id=\"$aid\" />";

	$html = str_ireplace('</head>', $include_js . '</head>', $html);
	$html = str_ireplace("<div id=\"$did\">", "<div id=\"$did\">" . $include_anchor , $html);

	return $html;
}

// Install the plugin
function link_append_install() {
global $CONFIG, $thisplugin, $divid;
    if (!$_POST['submit']) {
        return 1;  // configure function has not been called yet, so return error code '1'
    } elseif ($_POST['submit'] == 'All Done!') {
        require ('include/sql_parse.php');
        $db_update = 'plugins/link_append/sql/basic.sql';
        $sql_query = fread(fopen($db_update, 'r'), filesize($db_update));
        $sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);
        $sql_query = remove_remarks($sql_query);
        $sql_query = split_sql_file($sql_query, ';');
        foreach($sql_query as $q) { 
            cpg_db_query($q);
        }
        $divid = addslashes($_POST['divsub']);
        $sql="INSERT INTO `cpg_link_append` (id) VALUES ('".$divid."')";
        cpg_db_query($sql);
        return true; // configure function has been called, so install the plugin
    } elseif ($_POST['submit'] == 'Cancel')  {
        header("Location: pluginmgr.php\n\n");  // go back to plugin manager without installing the plugin
        exit(0);
    }
}


// Configure function: displays the configuration form
function link_append_configure($action_code) {
    global $thisplugin;
    if ($action_code === 1) {
        echo <<< EOT
        <h3>Configure the setup of <strong>{$thisplugin->name}</strong>!<br />
        You must Edit your template.html first!<br />
        Place a div with an id around your gallery!<br />
		<strong>Must</strong> be formed like &#60;div id="someid"&#62;</h3>
        <form action="{$_SERVER['REQUEST_URI']}" method="post">
        <table>
        <tr>
        <td>Div ID:</td>
        <td><input type="text" name="divsub" /></td>
        <td>Input the ID of Coppermines containing div tag</td>
        </tr>
        <tr>
        <td></td>
        <td></td>
        <td><input type="submit" name="submit" value="All Done!" /><input type="submit" name="submit" value="Cancel" /></td>
        </tr>
        </table>
        </form>
EOT;
    }
}

// Uninstall (ask admin about dropping table)
function link_append_uninstall()
{
	global $CONFIG, $thisplugin;
	if (!isset($_POST['drop'])) return 1;
	if ($_POST['drop']) {
		cpg_db_query("DROP TABLE IF EXISTS cpg_link_append");
   	}
	return true;
}

// Ask if admin wants to drop the table
function link_append_cleanup($action) 
{
    if ($action===1) {
        echo <<< EOT
    <form action="{$_SERVER['REQUEST_URI']}" method="post">
        <p>
            Remove the table that was used to store settings?
        </p>
        <div style="margin:25;">
        <table border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td><input type="radio" name="drop" value="1" /></td>
                <td>Yes</td>
            </tr>
            <tr>
                <td><input type="radio" name="drop" checked="checked" value="0" /></td>
                <td>No</td>
            </tr>
        </table>
        </div>
        <span>
           <input type="submit" name="submit" value="Submit" />
            <input type="button" name="cancel" onClick="window.location='pluginmgr.php';" value="Cancel" />
        </span>
    </form>
EOT;
    }
}
?>