<?php
/*
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://etienne.sf.free.fr/wiki/doku.php?id=jupload_coppermine_download_gb
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */



/**
 * This page manages the upload http request. Its aim is to:
 * - Add the uploaded files into the database
 * - Calculate the thumb and normal picture.
 * - return a status to the applet, by writting one simple line. This return is:
 *     SUCCESS               (if everything is Ok)
 *     ERROR: Error message  (if some problem occurs)
 */

if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { die('Not in Jupload...');}

define('JUPLOAD_PHP_in_upload_picture', true);

$JUPLOAD_CONFIG['debug'] = 'true';
$return = "Unknow return status";
echo ("[DEBUG] upload_picture.php: Entering upload_picture.php\n");

//We don't want the cpg_die to be called. Instead, we want just the error in the script ouptut.
//see jupload_cpg_die for more informations
$callCpgDie = false;

require('plugins/jupload/include/j_picmgmt.inc.php');
echo ("[DEBUG] upload_picture.php: j_picmgmt.inc.php included\n");

//The response in the HTTP body may be read by the applet and displayed to the user. It isn't HTML
//This is especially right for error codes. I force them to UTF-8:
header("Content-Type: text/plain; charset=UTF-8"); 

/*
 * For debug only. Take care: by uncommenting this, you may give information to users on your system.
echo("[DEBUG] USER_ID: " . (USER_ID ? 'true' : 'false')  . "\n");
echo("[DEBUG] USER_IS_ADMIN: " . (USER_IS_ADMIN ? 'true' : 'false') . "\n");
echo("[DEBUG] GALLERY_ADMIN_MODE: " . (GALLERY_ADMIN_MODE ? 'true' : 'false')  . "\n");
echo("[DEBUG] USER_ADMIN_MODE: " . (USER_ADMIN_MODE ? 'true' : 'false')  . "\n");
echo("[DEBUG] USER_CAN_UPLOAD_PICTURES: " . (USER_CAN_UPLOAD_PICTURES ? 'true' : 'false')  . "\n");
echo("[DEBUG] USER_CAN_CREATE_ALBUMS: " . (USER_CAN_CREATE_ALBUMS ? 'true' : 'false')  . "\n");
echo("[DEBUG] CAN_UPLOAD_PICTURES: " . (CAN_UPLOAD_PICTURES ? 'true' : 'false')  . "\n");
echo("[DEBUG] CAN_CREATE_ALBUMS: " . (CAN_CREATE_ALBUMS ? 'true' : 'false')  . "\n");
echo("[DEBUG] alwaysVisible" . $JUPLOAD_CONFIG['alwaysVisible'] . "\n");
echo("[DEBUG] jupload_may_see_jupload_link: $jupload_may_see_jupload_link\n");
echo("[DEBUG] jupload_user_may_use_jupload: $jupload_user_may_use_jupload\n");
foreach ($USER as $key => $value) {
	echo("[DEBUG] USER['$key']=$value\n");
}
foreach ($USER_DATA as $key => $value) {
	echo("[DEBUG] USER_DATA['$key']=$value\n");
}
*/

//If the user may not upload pictures, there is no reason for him to go on this page.
//USER_CAN_CREATE_ALBUMS: seems to indicate that the user may have its personnal gallery (at least for the admin)
if (!USER_CAN_UPLOAD_PICTURES && !USER_CAN_CREATE_ALBUMS) {
	$msg = str_replace('$1', 'login.php?referer=plugins/jupload/jupload.php', $lang_jupload_php['perm_denied']);
	//Let's send a proprer error message, so that the applet can read it.	
	die("ERROR: $msg\n");
}

//If JUpload has to manage its own user's session, and we're here: the user may upload picture.
//Let's save the current one, for the next call to the server.
//echo ("[DEBUG] upload_picture.php: Before saveJuploadInternalSessionIfConfiguredTo\n");
//saveJuploadInternalSessionIfConfiguredTo(5, false);
//echo ("[DEBUG] upload_picture.php: After saveJuploadInternalSessionIfConfiguredTo\n");


//####################################################################################################
//#################################  MAIN CODE BLOC  #################################################
//####################################################################################################


//Note: 
// When in chunk mode, Coppermine controls the size of the last chunk, and not the size of the whole uploaded
//file, that may have been split into several chunk.

//If the maxFileSize is defined in the Jupload configuration, it overrides the Coppermine configuration
if ($JUPLOAD_CONFIG['maxNonTransformedPictureSize'] > 0) {
	$CONFIG['max_upl_size'] = $JUPLOAD_CONFIG['maxNonTransformedPictureSize'];
}

//Let's read the _FILES array. What to do, depend on the script parameters: is the file sent in one piece, 
//or in several chunks.
echo ("[DEBUG] upload_picture.php: Before handle_uploaded_files\n");
handle_uploaded_files('userpicture');
echo ("[DEBUG] upload_picture.php: After handle_uploaded_files\n");


if (count($escrow_array) > 1) {
	echo ("ERROR: too many files uploaded (" . count($escrow_array) . ")\n");
} else if (count($escrow_array) == 0) {
	//What's up doc ?
	$error_reason = '';
	if (count($file_failure_array) > 0) {
		//Ok, we have some news of the error in this array
		$error_reason = '(' . $file_failure_array[0]['failure_ordinal']
			. ', ' . $file_failure_array[0]['file_name']
			. ', ' . $file_failure_array[0]['error_code']
			. ' )';
	}
	echo ('ERROR: no file uploaded (' . $error_reason . ")\n");
} else if (!$chunkedUpload  ||  ($chunkedUpload && $jufinal)) {
	//Ok, one file has been uploaded. So, we are in one of these two cases:
	//a) Non-chunk upload (that is: standard upload)
	//b) Chunk upload (that is: the file is sent by pieces), and we just received the last chunk.


	//Let's read the given parameters.	
    $title = addslashes($_POST['title']);
    $caption = addslashes($_POST['caption']);
    $keywords = addslashes($_POST['keywords']);
    $user1 = addslashes($_POST['user1']);
    $user2 = addslashes($_POST['user2']);
    $user3 = addslashes($_POST['user3']);
    $user4 = addslashes($_POST['user4']);
    // Capture movie or audio width and height if sent.
    $movie_wd = isset($_POST['movie_wd']) ? (int)$_POST['movie_wd'] : 320;
    $movie_ht = isset($_POST['movie_ht']) ? (int)$_POST['movie_ht'] : 240;

	echo ("[DEBUG] upload_picture.php: Before jupload_add_physical_file\n");
	$file_placement = jupload_add_physical_file(
		$album, 
		$escrow_array[0]['actual_name'], $escrow_array[0]['temporary_name'],
		$title, $caption, $keywords, $user1, $user2, $user3, $user4, $category, $raw_ip, $hdr_ip, $movie_wd, $movie_ht);
	echo ("[DEBUG] upload_picture.php: After jupload_add_physical_file\n");

	//If we received an error, we transmit it, and return.	
	if (substr($file_placement, 0, 7) == 'ERROR: ') {
		echo(strip_tags($file_placement) . "1\n");
	} else if ($ERROR != ''){
		echo("[DEBUG] file_placement: $file_placement\r\n");
		echo("[DEBUG] php_errormsg: $php_errormsg\r\n");
		echo("\r\nERROR: " . strip_tags($ERROR) . "2\r\n");
	} else if ($file_placement == 'no1' || $file_placement == 'no2') {
		echo("\r\nERROR: " . strip_tags($lang_upload_php['no_place']) . " 3 (file_placement: $file_placement)\r\n");
	} else if ($file_placement == 'yes') {
		if ($PIC_NEED_APPROVAL) {
			echo("\r\nSUCCESS\r\nWARNING: " . $lang_jupload_php['need_approval'] . "\r\n");
		} else {
			echo("\r\nSUCCESS\r\n");
		}
		//Send a mail, if needed.
		echo ("[DEBUG] upload_picture.php: After jupload_add_physical_file\n");
		after_upload();
		echo ("[DEBUG] upload_picture.php: Before after_upload\n");
	} else {
		echo("\r\nWARNING: Unknown placement status (file_placement=$file_placement)\r\n");
	}
} else {
	//If we come here, we are in chunk mode, but we didn't receive the last one.
	echo("Chunk $jupart received\r\nSUCCESS\r\n");
}

//Some tries, to validate the CR, LF and CRLF management in the applet.

echo("End of upload_picture.php\n");
