/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.filedata.helper;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.DefaultFileData;
import wjhk.jupload2.filedata.PictureFileData;
import wjhk.jupload2.filedata.helper.ImageReaderWriterHelper;
import wjhk.jupload2.policies.PictureUploadPolicy;

public class ImageHelper
implements ImageObserver {
    private Boolean hasToTransformPicture = null;
    private PictureFileData pictureFileData;
    private int quarterRotation;
    private int maxWidth;
    private int maxHeight;
    private int nbPixelsTotal = -1;
    private int nbPixelsRead = 0;
    private int scaledNonRotatedWidth = -1;
    private int scaledNonRotatedHeight = -1;
    private int progressBarBaseValue = 0;
    private double scale = 1.0;
    private int scaledRotatedWidth = -1;
    private int scaledRotatedHeight = -1;
    PictureUploadPolicy uploadPolicy;

    public ImageHelper(PictureUploadPolicy uploadPolicy, PictureFileData pictureFileData, int targetMaxWidth, int targetMaxHeight, int quarterRotation) throws JUploadIOException {
        this.uploadPolicy = uploadPolicy;
        this.pictureFileData = pictureFileData;
        this.maxWidth = targetMaxWidth;
        this.maxHeight = targetMaxHeight;
        this.quarterRotation = quarterRotation;
        this.initScale();
    }

    private void initScale() throws JUploadIOException {
        double theta = Math.toRadians(90 * this.quarterRotation);
        int nonScaledRotatedWidth = this.pictureFileData.getOriginalWidth();
        int nonScaledRotatedHeight = this.pictureFileData.getOriginalHeight();
        if (this.quarterRotation % 2 != 0) {
            nonScaledRotatedWidth = this.pictureFileData.getOriginalHeight();
            nonScaledRotatedHeight = this.pictureFileData.getOriginalWidth();
        }
        double scaleWidth = this.maxWidth < 0 ? 1.0 : (double)this.maxWidth / (double)nonScaledRotatedWidth;
        double scaleHeight = this.maxHeight < 0 ? 1.0 : (double)this.maxHeight / (double)nonScaledRotatedHeight;
        this.scale = Math.min(scaleWidth, scaleHeight);
        if (this.scale < 1.0 && (this.maxWidth > 0 && this.maxWidth < (int)(this.scale * Math.cos(theta) * (double)nonScaledRotatedWidth) || this.maxHeight > 0 && this.maxHeight < (int)(this.scale * Math.cos(theta) * (double)nonScaledRotatedHeight))) {
            scaleWidth = this.maxWidth < 0 ? 1.0 : ((double)this.maxWidth - 1.0) / (double)nonScaledRotatedWidth;
            scaleHeight = this.maxHeight < 0 ? 1.0 : ((double)this.maxHeight - 1.0) / (double)nonScaledRotatedHeight;
            this.scale = Math.min(scaleWidth, scaleHeight);
        }
        this.scaledRotatedWidth = nonScaledRotatedWidth;
        this.scaledRotatedHeight = nonScaledRotatedHeight;
        if (this.scale < 1.0) {
            this.scaledRotatedWidth = (int)((double)this.scaledRotatedWidth * this.scale);
            this.scaledRotatedHeight = (int)((double)this.scaledRotatedHeight * this.scale);
        }
        this.uploadPolicy.displayDebug("Resizing factor (scale): " + this.scale, 30);
        if (this.scaledRotatedWidth > this.maxWidth) {
            this.uploadPolicy.displayDebug("Correcting rounded width: " + this.scaledRotatedWidth + " to " + this.maxWidth, 50);
            this.scaledRotatedWidth = this.maxWidth;
        }
        if (this.scaledRotatedHeight > this.maxHeight) {
            this.uploadPolicy.displayDebug("Correcting rounded height: " + this.scaledRotatedHeight + " to " + this.maxHeight, 50);
            this.scaledRotatedHeight = this.maxHeight;
        }
        if (this.quarterRotation % 2 == 0) {
            this.scaledNonRotatedWidth = this.scaledRotatedWidth;
            this.scaledNonRotatedHeight = this.scaledRotatedHeight;
        } else {
            this.scaledNonRotatedWidth = this.scaledRotatedHeight;
            this.scaledNonRotatedHeight = this.scaledRotatedWidth;
        }
    }

    public boolean hasToTransformPicture() throws JUploadException {
        if (DefaultFileData.getExtension(this.pictureFileData.getFile()).equalsIgnoreCase("gif")) {
            ImageReaderWriterHelper irwh = new ImageReaderWriterHelper(this.uploadPolicy, this.pictureFileData);
            int nbImages = irwh.getNumImages(true);
            irwh.dispose();
            irwh = null;
            if (nbImages > 1) {
                this.hasToTransformPicture = Boolean.FALSE;
                this.uploadPolicy.displayWarn("No transformation for gif picture file, that contain several pictures. (see JUpload documentation for details)");
            }
        }
        if (this.hasToTransformPicture == null) {
            if (this.hasToTransformPicture == null && !this.uploadPolicy.getPictureTransmitMetadata()) {
                this.hasToTransformPicture = Boolean.TRUE;
            }
            if (this.hasToTransformPicture == null && this.quarterRotation != 0) {
                this.uploadPolicy.displayDebug(this.pictureFileData.getFileName() + " : hasToTransformPicture = true (quarterRotation != 0)", 10);
                this.hasToTransformPicture = Boolean.TRUE;
            }
            if (this.hasToTransformPicture == null && this.uploadPolicy.getTargetPictureFormat() != null) {
                String target = this.uploadPolicy.getTargetPictureFormat().toLowerCase();
                String ext = this.pictureFileData.getFileExtension().toLowerCase();
                if (target.equals("jpg")) {
                    target = "jpeg";
                }
                if (ext.equals("jpg")) {
                    ext = "jpeg";
                }
                if (!target.equals(ext)) {
                    this.uploadPolicy.displayDebug(this.pictureFileData.getFileName() + " : hasToTransformPicture = true (targetPictureFormat)", 10);
                    this.hasToTransformPicture = Boolean.TRUE;
                }
            }
            if (this.hasToTransformPicture == null && this.scale < 1.0) {
                this.uploadPolicy.displayDebug(this.pictureFileData.getFileName() + " : hasToTransformPicture = true (scale < 1)", 10);
                this.hasToTransformPicture = Boolean.TRUE;
            }
            if (this.hasToTransformPicture == null) {
                this.uploadPolicy.displayDebug(this.pictureFileData.getFileName() + " : hasToTransformPicture = false", 10);
                this.hasToTransformPicture = Boolean.FALSE;
            }
        }
        return this.hasToTransformPicture;
    }

    public BufferedImage getBufferedImage(boolean highquality, BufferedImage sourceBufferedImage) throws JUploadException {
        long msGetBufferedImage = System.currentTimeMillis();
        double theta = Math.toRadians(90 * this.quarterRotation);
        BufferedImage returnedBufferedImage = null;
        this.uploadPolicy.displayDebug("getBufferedImage: start", 10);
        try {
            AffineTransform transform = new AffineTransform();
            if (this.quarterRotation != 0) {
                double translationX = 0.0;
                double translationY = 0.0;
                this.uploadPolicy.displayDebug("getBufferedImage: quarter: " + this.quarterRotation, 50);
                switch (this.quarterRotation) {
                    case 1: {
                        translationX = 0.0;
                        translationY = -this.scaledRotatedWidth;
                        break;
                    }
                    case 2: {
                        translationX = -this.scaledRotatedWidth;
                        translationY = -this.scaledRotatedHeight;
                        break;
                    }
                    case 3: {
                        translationX = -this.scaledRotatedHeight;
                        translationY = 0.0;
                        break;
                    }
                    default: {
                        this.uploadPolicy.displayWarn("Invalid quarterRotation : " + this.quarterRotation);
                        this.quarterRotation = 0;
                        theta = 0.0;
                    }
                }
                transform.rotate(theta);
                transform.translate(translationX, translationY);
            }
            if (this.scale < 1.0) {
                if (highquality) {
                    this.uploadPolicy.displayDebug("getBufferedImage: Resizing picture(using high quality picture)", 30);
                    Image img = sourceBufferedImage.getScaledInstance(this.scaledNonRotatedWidth, this.scaledNonRotatedHeight, 16);
                    int localImageType = sourceBufferedImage.getType();
                    if (localImageType == 0) {
                        localImageType = 4;
                    }
                    BufferedImage tempBufferedImage = new BufferedImage(this.scaledNonRotatedWidth, this.scaledNonRotatedHeight, localImageType);
                    this.nbPixelsTotal = this.scaledNonRotatedWidth * this.scaledNonRotatedHeight;
                    this.nbPixelsRead = 0;
                    this.uploadPolicy.displayDebug("getBufferedImage: Before drawImage", 50);
                    tempBufferedImage.getGraphics().drawImage(img, 0, 0, this);
                    this.uploadPolicy.displayDebug("getBufferedImage: After drawImage", 50);
                    tempBufferedImage.flush();
                    img.flush();
                    img = null;
                    this.pictureFileData.freeMemory("ImageHelper.getBufferedImage()");
                    sourceBufferedImage = tempBufferedImage;
                    tempBufferedImage = null;
                } else {
                    this.uploadPolicy.displayDebug("getBufferedImage: Resizing picture(using standard quality picture)", 50);
                    transform.scale(this.scale, this.scale);
                }
            }
            this.uploadPolicy.displayDebug("getBufferedImage: Picture is now rescaled", 50);
            if (transform.isIdentity()) {
                returnedBufferedImage = sourceBufferedImage;
            } else {
                AffineTransformOp affineTransformOp = null;
                affineTransformOp = new AffineTransformOp(transform, 1);
                returnedBufferedImage = affineTransformOp.createCompatibleDestImage(sourceBufferedImage, null);
                this.uploadPolicy.displayDebug("getBufferedImage: returnedBufferedImage.getColorModel(): " + sourceBufferedImage.getColorModel().toString(), 50);
                this.uploadPolicy.displayDebug("getBufferedImage: returnedBufferedImage.getColorModel(): " + sourceBufferedImage.getColorModel().toString(), 50);
                affineTransformOp.filter(sourceBufferedImage, returnedBufferedImage);
                affineTransformOp = null;
                returnedBufferedImage.flush();
            }
        }
        catch (Exception e) {
            throw new JUploadException(e.getClass().getName() + " (" + this.getClass().getName() + ".getBufferedImage()) : " + e.getMessage());
        }
        if (returnedBufferedImage != null && this.uploadPolicy.getDebugLevel() >= 50) {
            this.uploadPolicy.displayDebug("getBufferedImage: " + returnedBufferedImage, 50);
            this.uploadPolicy.displayDebug("getBufferedImage: MinX=" + returnedBufferedImage.getMinX(), 50);
            this.uploadPolicy.displayDebug("getBufferedImage: MinY=" + returnedBufferedImage.getMinY(), 50);
        }
        this.uploadPolicy.displayDebug("getBufferedImage: was " + (System.currentTimeMillis() - msGetBufferedImage) + " ms long", 50);
        this.pictureFileData.freeMemory("ImageHelper.getBufferedImage()");
        return returnedBufferedImage;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 1) == 1) {
            this.progressBarBaseValue = this.uploadPolicy.getApplet().getUploadPanel().getPreparationProgressBar().getValue();
            this.uploadPolicy.displayDebug("  imageUpdate (start of), progressBar geValue: " + this.progressBarBaseValue, 50);
            int max = this.uploadPolicy.getApplet().getUploadPanel().getPreparationProgressBar().getMaximum();
            this.uploadPolicy.displayDebug("  imageUpdate (start of), progressBar maximum: " + max, 50);
        } else if ((infoflags & 8) == 8) {
            this.nbPixelsRead += width * height;
            int percentage = (int)((long)this.nbPixelsRead * 100L / (long)this.nbPixelsTotal);
            this.uploadPolicy.getApplet().getUploadPanel().getPreparationProgressBar().setValue(this.progressBarBaseValue + percentage);
            this.uploadPolicy.getApplet().getUploadPanel().getPreparationProgressBar().repaint(100L);
        } else if ((infoflags & 0x20) == 32) {
            this.uploadPolicy.displayDebug("  imageUpdate, total number of pixels: " + this.nbPixelsRead + " read", 50);
        }
        return true;
    }
}

