<?php
require_once('plugins/framework/initialize.php');
load_helper(array('table','form','html'));
load_library('User');
$database = Database::getInstance();
$action = isset($_GET['action']) ? $_GET['action'] : 'index';
$func_name = 'this_'.$action;
if (function_exists($func_name)) {
    $func_name();
}
function this_index() {    
    global $CONFIG;
    global $lang_guessgame_php;
    global $database;
    pageheader($lang_guessgame_php['pluginmgr']);    
    // search panel
    echo table::open();
    echo form::open('index.php', 'search', 'get');
    echo form::hidden('file', 'guessgame/admin');
    echo table::td($lang_guessgame_php['search'], 2);
    echo table::tds(array(
        array('class'=>'tableb', 'width'=>'30%', 'text'=>$lang_guessgame_php['search_title']),
        array('class'=>'tableb', 'width'=>'70%', 'text'=>form::text('search', $_GET['search'])),
    ));
    echo table::tds(array(
        array('class'=>'tableb', 'width'=>'30%', 'text'=>$lang_guessgame_php['ipp']),
        array('class'=>'tableb', 'width'=>'70%', 'text'=>form::select('ipp', array(10=>10,20=>20,30=>30,40=>40,50=>50,), $_GET['ipp'])),
    ));
    echo table::tds(array(
        array('class'=>'tablef', 'colspan'=>'2', 'text'=>form::submit($lang_guessgame_php['search'], 'submit')),
    ));
    echo form::close();
    echo table::close();
    $paging = array();
    $paging['page'] = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    if ($paging['page'] == 0) $paging['page'] = 1;    
    $paging['limit'] = isset($_GET['ipp']) ? (int)$_GET['ipp'] : 10;    
    $database->select('count(*) as count');
    $query = $database->get($CONFIG['TABLE_PREFIX'].'point');
    $row = $query->row();    
    $paging['total'] = $row->count;
    if (isset($_GET['search']) && $_GET['search']) {
        $search = trim($_GET['search']);
        $database->where('award_id', $search);
        $database->orwhere('award_name', $search);
    }
    // paging
    $paging['start'] = ($paging['page']-1)*$_GET['ipp'];    
    $paging['pattern'] = 'index.php?file=guessgame/admin&search='.$search.'&ipp='.$_GET['ipp'];    
    $database->limit($paging['limit'], $paging['start']);
    $database->orderby('id desc');
    $query = $database->get($CONFIG['TABLE_PREFIX'].'point');
    $items = $query->result();
    echo html::spacer();
    $username = get_username($search);    
    if (is_numeric($search) && $search && $username != 'Anonymous' && $username) {
        echo table::open();
        echo table::td(html::anchor('index.php?file=guessgame/admin&action=point&id='.$search,'Click here to add/remove point of this user'), 1, 'tableb');
        echo table::close();
        echo html::spacer();
    }
    echo table::open();
    echo table::td('Search Result', 5);
    echo table::tds(array(
        array('class'=>'tableh2', 'width'=>'20%', 'text'=>$lang_guessgame_php['image']),
        array('class'=>'tableh2', 'width'=>'30%', 'text'=>$lang_guessgame_php['user']),
        array('class'=>'tableh2', 'width'=>'30%', 'text'=>$lang_guessgame_php['point']),
        array('class'=>'tableh2', 'width'=>'10%', 'text'=>$lang_guessgame_php['modify']),
        array('class'=>'tableh2', 'width'=>'10%', 'text'=>$lang_guessgame_php['delete']),
    ));
    if (count($items) == 0) echo table::td('no result', 5, 'tableb');       
    foreach ($items as $row) {
        echo table::tds(array(
            array('class'=>'tableb', 'text'=>
                ($row->pid ?
                    html::anchor('displayimage.php?pos=-'.$row->pid, 'Image')
                    :
                    $lang_guessgame_php['admin_act']
                )
            ),
            array('class'=>'tableb', 'text'=>html::anchor('profile.php?uid='.$row->award_id,$row->award_name)),
            array('class'=>'tableb', 'text'=>$row->point),
            array('class'=>'tableb', 'text'=>html::anchor('index.php?file=guessgame/admin&action=modify&id='.$row->id,$lang_guessgame_php['modify'])),
            array('class'=>'tableb', 'text'=>html::anchor('index.php?file=guessgame/admin&action=dodelete&id='.$row->id,$lang_guessgame_php['delete'])),
        ));
    }
    echo table::close();
    if (count($items) > 0) {
        echo table::open();
        echo table::td($lang_guessgame_php['page'].html::paging($paging),1,'tableb');
        echo table::close();    
    }
    pagefooter();
}
function this_modify() {
    global $CONFIG;    
    global $lang_guessgame_php;
    global $database;
    $id = isset($_GET['id']) ? (int)$_GET['id'] : 0;    
    $database->select('point');
    $database->where('id', $id);
    $query = $database->get($CONFIG['TABLE_PREFIX'].'point');
    $row = $query->row();
    pageheader($lang_guessgame_php['pluginmgr']);
    echo table::open(); 
    echo form::open('index.php?file=guessgame/admin&action=domodify&id='.$id);
    echo table::td('Edit', 2);
    echo table::tds(array(
        array('class'=>'tableb', 'width'=>'30%', 'text'=>$lang_guessgame_php['point']),
        array('class'=>'tableb', 'width'=>'70%', 'text'=>form::text('point', $row->point)),        
    ));
    echo table::tds(array(
        array('class'=>'tablef', 'colspan'=>2, 'text'=>form::submit($lang_guessgame_php['edit'], 'submit')),
    ));
    echo form::close();
    echo table::close();
    pagefooter();    
}
function this_domodify() {
    global $CONFIG;
    global $database;
    $id = isset($_GET['id']) ? (int)$_GET['id'] : 0;   
    $database->select('award_id,point');
    $database->where('id', $id);
    $query = $database->get($CONFIG['TABLE_PREFIX'].'point');
    $row = $query->row();
    $change = (int)$_POST['point'] - $row->point;
    $data = array('point'=>(int)$_POST['point']);
    $database->update($CONFIG['TABLE_PREFIX'].'point', $data, "id=$id");    
    $user = User::getInstance();                      
    $user_data = $user->get_user_data($row->award_id);
    $data = array('user_point'=>$user_data['user_point']+$change);
    $user->set_user_data($row->award_id, $data);
    header('Location: index.php?file=guessgame/admin');
}
function this_dodelete() {
    global $CONFIG;
    global $database;    
    $id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
    $database->select('award_id, point');
    $database->where('id', $id);
    $query = $database->get($CONFIG['TABLE_PREFIX'].'point');
    $row = $query->row();
    if ($row->point > 0) {
        $update = 'user_point-'.$row->point;
    } else {
        $point = abs($row->point);
        $update = 'user_point+'.$point;
    }
    $user = User::getInstance();
    $data = array('user_point' => $update);
    $user->set_user_data($row->award_id, $data);
    $database->delete($CONFIG['TABLE_PREFIX'].'point', "id=$id");
    header('Location: index.php?file=guessgame/admin');
}
function this_point() {
    global $CONFIG;
    global $lang_guessgame_php;    
    $id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
    $user = User::getInstance();
    $user_data = $user->get_user_data($id);
    pageheader($lang_guessgame_php['pluginmgr']);
    echo table::open();                          
    echo form::open('index.php?file=guessgame/admin&action=dopoint&id='.$id);
    echo table::td('Edit User Point', 2);
    echo table::tds(array(
        array('class'=>'tableb', 'width'=>'30%', 'text'=>'User'),
        array('class'=>'tableb', 'width'=>'70%', 'text'=>html::anchor('profile.php?uid='.$user_data['user_id'], $user_data['user_name'])),        
    ));
    echo table::tds(array(
        array('class'=>'tableb', 'width'=>'30%', 'text'=>$lang_guessgame_php['point']),
        array('class'=>'tableb', 'width'=>'70%', 'text'=>
            form::select('what', array('+'=>'+','-'=>'-'), '+', false).            
            form::text('point', 0, false)
        ),        
    ));
    echo table::tds(array(
        array('class'=>'tablef', 'colspan'=>'2', 'text'=>form::submit($lang_guessgame_php['apply'], 'submit')),
    ));
    echo form::close();
    echo table::close();
    pagefooter();  
}
function this_dopoint() {
    global $CONFIG; 
    global $database;
    $id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
    $data = array(
        'award_id' => $id,
        'award_name' => get_username($id),
        'is_admin' => 'YES',
        'is_admin' => 'YES',
        'point' => $_POST['what'].((int)$_POST['point']),
    );    
    $database->insert($CONFIG['TABLE_PREFIX'].'point', $data);
    $user = User::getInstance();
    $user_data = $user->get_user_data($id);
    if ($_POST['what'] == '-') 
        $user_point -= $user_data['user_point'] - (int)$_POST['point'];
    else 
        $user_point = $user_data['user_point'] + (int)$_POST['point'];
    $data = array('user_point'=>$user_point);
    $user->set_user_data($id, $data);
    header('Location: index.php?file=guessgame/admin');
}
function this_correct() {
    global $CONFIG;
    global $database;
    $user = User::getInstance();
    $user->query("UPDATE {$CONFIG['TABLE_USERS']} SET user_point=0");    
    $database->select('award_id, point');
    $query = $database->get($CONFIG['TABLE_PREFIX'].'point');    
    foreach ($query->result() as $row) {
        if ($row->point > 0) {
            $update = 'user_point+'.$row->point;
        } else {
            $point = abs($row->point);
            $update = 'user_point-'.$point;   
        }        
        $data = array('user_point'=>$update);
        print_r($data);
        $user->set_user_data($row->award_id, $data);
    }
}