<?php

// all HTML element come form here

class HTMLelement {	
	// use in many case so I put it here 	
	function preview_cart($cart_data) {
		global $CONFIG;			
		global $currency_symbol;
		global $lang_cm_cart;
		$tpl_preview_cart = cpgTemplate::get('blog_preview_cart');
	    $cart_header      = cpgTemplate::extract($tpl_preview_cart, 'cart_header');
	    $cart_element     = cpgTemplate::extract($tpl_preview_cart, 'cart_element');
	    $cart_footer      = cpgTemplate::extract($tpl_preview_cart, 'cart_footer');	    
		// cart header
		echo cpgTemplate::set($cart_header, array(
			'{LANG_THUMB}'        => $lang_cm_cart['thumb'],	
			'{LANG_NAME}'         => $lang_cm_cart['item_name'],
			'{LANG_PRICE_OPTION}' => $lang_cm_cart['price_n_option'],  
			'{LANG_PRICE_EACH}'   => $lang_cm_cart['price_each'], 
			'{LANG_QTY}'          => $lang_cm_cart['qty'],
			'{LANG_PRICE_ALL}'    => $lang_cm_cart['price_all'],
		));
		// cart element
		$total = 0;	
		foreach ($cart_data as $item_pos => $item_data) {
			$CURRENT_PIC_DATA = cpgTool::get_pic_data($item_data['pid']);
			$price_each = cpgTool::price_each($item_data);  			
			$total += $price_each * $item_data['qty'];	
			echo cpgTemplate::set($cart_element, array(
				'{THUMB}'		=>	HTMLelement::image(get_pic_url($CURRENT_PIC_DATA, "thumb")),
				'{NAME}'        =>	HTMLelement::item_name($CURRENT_PIC_DATA),
				'{PRICE}'       =>	HTMLelement::item_price_list($item_data['price']),
				'{OPTION}'  	=>	HTMLelement::item_option_list($item_data['option']),
				'{PRICE_EACH}'  =>	$currency_symbol[$CONFIG['cpgmart_currency']] ." ".cpgTool::price_format($price_each),
				'{QTY}'         =>	$item_data['qty'],
				'{PRICE_ALL}'	=>	$currency_symbol[$CONFIG['cpgmart_currency']] ." ".cpgTool::price_format($price_each * $item_data['qty']),						
			));
		}
		// cart footer
		echo cpgTemplate::set($cart_footer, array(
			'{LANG_PRICE_TOTAL}'	=>	$lang_cm_cart['price_total'],
			'{PRICE_TOTAL}'			=>	$currency_symbol[$CONFIG['cpgmart_currency']] ." ".cpgTool::price_format($total),		
		));
	}
	function message($title, $text)	{
		global $CONFIG;		
		$message = cpgTemplate::get('element_message');
		starttable($CONFIG['picture_table_width'], $title);
		if (!is_array($text))
			echo cpgTemplate::set($message, array('{MESSAGE}'=>$text));
		else {
			foreach ($text as $item) {
				echo cpgTemplate::set($message, array('{MESSAGE}'=>$item));					
			}
		}
		endtable();
	} 
	function hidden($name, $value) {
		return "<input type=\"hidden\" name=\"$name\" value=\"$value\" />\n";		
	}
	function radio($name, $value="") {
		switch ($value) {
			case 1:
				return "<input type=\"radio\" name=\"$name\" value=\"1\" checked=\"checked\"> Y<input type=\"radio\" name=\"$name\" value=\"0\" /> N\n";	
				break;
			case 0:
				return "<input type=\"radio\" name=\"$name\" value=\"1\"> Y<input type=\"radio\" name=\"$name\" value=\"0\" checked=\"checked\" /> N\n";	
				break;
			default:	
				return "<input type=\"radio\" name=\"$name\" value=\"1\"> Y<input type=\"radio\" name=\"$name\" value=\"0\" /> N\n";	
		}
	}
	function qty_input($name, $value="") {
		return "<input class=\"textinput\" type=\"text\" name=\"$name\" size=\"3\" value=\"$value\" />\n";			
	}
	function text_input($name, $value="") {
		return "<input class=\"textinput\" type=\"text\" name=\"$name\" style=\"width: 100%\" value=\"$value\" />\n";	
	}
	function simple_select($name, $value_array, $default='') {
		global $CONFIG;
		$html = "";
		$html .= "<select name=\"$name\" class=\"listbox\" style=\"width: 100%;\">\n";
		foreach ($value_array as $key => $title) {
			if ($key == $default)
				$html .= "<option value=\"$key\" selected=\"selected\">$title</option>\n";
			else
				$html .= "<option value=\"$key\">$title</option>\n";
		}
		$html .= "</select>\n";
		return $html;
	}
	function advance_select($name, $value_array, $default='') {
		global $CONFIG;
		global $currency_symbol;
		$html = "";
		$html .= "<select name=\"$name\" class=\"listbox\" style=\"width: 100%;\">\n";
		foreach ($value_array as $id => $data) {
			// different in currency ?
			// format
			$data[0] = cpgTool::price_format(cpgTool::to_config_currency($data[0], $data[2]));
			if ($id == $default)
				$html .= "<option value=\"$id\" selected=\"selected\">{$currency_symbol[$CONFIG['cpgmart_currency']]} {$data[0]} ({$data[1]})</option>\n";
			else
				$html .= "<option value=\"$id\">{$currency_symbol[$CONFIG['cpgmart_currency']]} {$data[0]} ({$data[1]})</option>\n";
		}
		$html .= "</select>\n";
		return $html;
	}
	function multiple_select($name, $value_array, $default=array(), $size=5) {
		global $CONFIG;
		$html = "";	
		$html .= "<select name=\"{$name}[]\" class=\"listbox\" multiple=\"multiple\" size=\"$size\" style=\"width: 100%;\">\n"; 
		foreach ($value_array as $value => $title) {
			if (in_array($value, $default)) 
				$html .= "<option value=\"$value\" selected=\"selected\">$title</option>\n";
			else 	
				$html .= "<option value=\"$value\">$title</option>\n";			
		}		
		$html .= "</select>\n";
		return $html;
	}	
	function check_box($name) {
		return "<input type=\"checkbox\" name=\"$name\">\n";	
	}	
	function price_list($id, $default="", $extra="") {
		global $CONFIG;
		global $currency_symbol;
		$id = (int)$id;                                                		
		$price_set = cpgDB::fetchRow("SELECT * FROM `{$CONFIG['TABLE_CM_PRICESET']}` WHERE pid = '$id' LIMIT 1;");
		$price_array = cpgTool::decode_data($price_set['price_array']);
		foreach ($price_array as $price_id) { 
			$price_data = cpgDB::fetchRow("SELECT pid, title, value, currency FROM `{$CONFIG['TABLE_CM_PRICE']}` WHERE pid = '{$price_id}' LIMIT 1;");								
			$price_combine[$price_data['pid']] =  array($price_data['value'], $price_data['title'], $price_data['currency']);			
		}
		return self::advance_select('price'.$extra, $price_combine, $default);
	}
	function option_list($id, $default_array=array(), $extra="") {
		global $CONFIG;
		global $currency_symbol; 
		$id = (int)$id;
		$html = "";
		$option_set = cpgDB::fetchRow("SELECT * FROM `{$CONFIG['TABLE_CM_OPTIONSET']}` WHERE oid = '$id' LIMIT 1;");
		$option_array = cpgTool::decode_data($option_set['option_array']);			
		$html .= "<table class=\"maintable\" width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"0\">\n";		
		foreach($option_array as $option_id) {
			$option_data = cpgDB::fetchRow("SELECT title, title_array, value_array, currency FROM `{$CONFIG['TABLE_CM_OPTION']}` WHERE oid = '$option_id' LIMIT 1;");
			$option_data['title_array']	= cpgTool::decode_data($option_data['title_array']);
			$option_data['value_array']	= cpgTool::decode_data($option_data['value_array']);			
			foreach ($option_data['title_array'] as $title_key => $title_value) {
				$option_combine[] = array($option_data['value_array'][$title_key],$option_data['title_array'][$title_key], $option_data['currency']);			
			}
			$html .= "<tr>\n<td class=\"tableh1\" valign=\"middle\" style=\"text-align: right;\">{$option_data['title']}&nbsp;</td>\n<td class=\"tableb\">".self::advance_select("option_".$option_id.$extra, $option_combine, $default_array[$option_id])."</td>\n</tr>\n";  						
		}					
		$html .= "</table>\n";
		return $html;
	}
	function plain_price_list($price_id_array) {
		global $CONFIG;
		global $currency_symbol;
		if (!is_array($price_id_array)) $price_id_array = cpgTool::decode_data($price_id_array);
		$html = "";
		$html .= "<table class=\"maintable\" width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"0\">\n";
		foreach ($price_id_array as $price_id) {
			$price_data = cpgDB::fetchRow("SELECT title, value, currency FROM `{$CONFIG['TABLE_CM_PRICE']}` WHERE pid='$price_id';");
			$html .= "<tr>\n<td class=\"tableh1\" valign=\"middle\" width=\"20%\">{$price_data['title']}&nbsp;</td>\n<td class=\"tableb\" width=\"70%\">{$price_data['value']}</td>\n<td class=\"tableb\" width=\"10%\">{$currency_symbol[$price_data['currency']]}</td>\n</tr>\n"; 					
		}		
		$html .= "</table>\n";
		return $html;
	}
	function plain_option_list($option_id_array) {
		global $CONFIG;
		global $currency_symbol;
		if (!is_array($option_id_array)) $option_id_array = cpgTool::decode_data($option_id_array);
		$html = "";
		$html .= "<table class=\"maintable\" width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"0\">\n";
		foreach ($option_id_array as $option_id) {
			$option_data = cpgDB::fetchRow("SELECT title, title_array, value_array, currency FROM `{$CONFIG['TABLE_CM_OPTION']}` WHERE oid='$option_id';");	
			$option_data['title_array'] = cpgTool::decode_data($option_data['title_array']);
			$option_data['value_array'] = cpgTool::decode_data($option_data['value_array']);
			$combine_array = array_combine($option_data['title_array'], $option_data['value_array']);
			$sub_html = self::plain_option($combine_array);
			$html .= "<tr>\n<td class=\"tableh1\" valign=\"middle\" width=\"30%\" align=\"center\">{$option_data['title']}&nbsp;</td>\n<td class=\"tableb\" width=\"60%\">$sub_html</td>\n<td class=\"tableb\" width=\"10%\" align=\"center\">{$currency_symbol[$option_data['currency']]}</td>\n</tr>\n";						
		}
		$html .= "</table>\n";
		return $html;
	}
	function plain_option($combine_array) {
		$sub_html = "<table class=\"maintable\" width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"0\">\n";		
		foreach ($combine_array as $title => $value) {
			$value = cpgTool::price_format($value);
			$sub_html .= "<tr>\n<td class=\"tableh1\" width=\"40%\">$title</td>\n<td class=\"tableb\" width=\"60%\">$value</td>\n</tr>\n";
		}		
		$sub_html .= "</table>\n";
		return $sub_html;
	}
	function price_list_title($id) {
		global $CONFIG;  
		$id = (int)$id;		
		return cpgDB::fetchVar("SELECT title FROM `{$CONFIG['TABLE_CM_PRICESET']}` WHERE pid = '$id' LIMIT 1;");
	}		
	function option_list_title($id) {
		global $CONFIG;  		
		$id = (int)$id;		
		return cpgDB::fetchVar("SELECT title FROM `{$CONFIG['TABLE_CM_OPTIONSET']}` WHERE oid = '$id' LIMIT 1;");
	}
	function item_price_list($item_price) {
		global $CONFIG;
		global $currency_symbol;
		$html = "";
		$html .= "<table class=\"maintable\" width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"0\">\n";				
		$price_data = cpgDB::fetchRow("SELECT title, value, currency  FROM `{$CONFIG['TABLE_CM_PRICE']}` WHERE pid = '$item_price' LIMIT 1;");			
		//$price_data['value'] =
		$price_data['value'] = cpgTool::price_format(cpgTool::to_config_currency($price_data['value'], $price_data['currency'])); 
		$html .= "<tr>\n<td class=\"tableh1\" width=\"30%\">{$price_data['title']}</td>\n<td class=\"tableb\" width=\"70%\">{$currency_symbol[$CONFIG['cpgmart_currency']]} {$price_data['value']}</td>\n</tr>\n";		
		$html .= "</table>\n";
		return $html;		
	}		
	function item_option_list($item_option) {
		global $CONFIG;
		global $currency_symbol;
		$html = "";
		$html .= "<table class=\"maintable\" width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"0\">\n";		
		foreach ($item_option as $option_id => $option_value) {			
			$option_data = cpgDB::fetchRow("SELECT title, title_array, value_array, currency FROM `{$CONFIG['TABLE_CM_OPTION']}` WHERE oid = '$option_id' LIMIT 1;");
			$option_data['title_array'] = cpgTool::decode_data($option_data['title_array']);
			$option_data['value_array'] = cpgTool::decode_data($option_data['value_array']);
			foreach ($option_data['title_array'] as $title_key => $title_value) {
				$option_combine[] = array($option_data['value_array'][$title_key], $option_data['title_array'][$title_key]);
				$option_combine[$option_value][0] = cpgTool::price_format(cpgTool::to_config_currency($option_combine[$option_value][0], $option_data['currency']));
			}			
			$html .= "<tr>\n<td class=\"tableh1\" width=\"30%\">{$option_data['title']}</td>\n<td class=\"tableb\" width=\"40%\">{$option_combine[$option_value][1]}</td>\n<td class=\"tableb\" width=\"30%\">{$currency_symbol[$CONFIG['cpgmart_currency']]} {$option_combine[$option_value][0]}</td>\n</tr>\n";
		}			  
		$html .= "</table>\n";
		return $html;
	}
	function price_set_list($name, $default="") {
		global $CONFIG;		
		$price_set_array = cpgDB::fetchRowset("SELECT * FROM `{$CONFIG['TABLE_CM_PRICESET']}`;");
		$value_array = array();
		foreach ($price_set_array as $price_set) {
			$value_array[$price_set['pid']] = $price_set['title'];
		}			
		return self::simple_select($name, $value_array, $default);
	}
	function option_set_list($name, $default="") {
		global $CONFIG;
		$option_set_array = cpgDB::fetchRowset("SELECT * FROM `{$CONFIG['TABLE_CM_OPTIONSET']}`;");
		$value_array = array();
		foreach ($option_set_array as $option_set) {
			$value_array[$option_set['oid']] = $option_set['title'];
		}			
		return self::simple_select($name, $value_array, $default);
	}
	function apply_simple_text($template, $text) {
		return cpgTemplate::set($template, array('{TEXT}'=>$text));
	}
	function simple_text($colspan="1", $class="tableb", $is_center=false) {
		if ($is_center)	{
			return "<tr><td class=\"$class\" colspan=\"$colspan\" align=\"center\">{TEXT}</td></tr>";
		} else {
			return "<tr><td class=\"$class\" colspan=\"$colspan\">{TEXT}</td></tr>";			
		}
	}
	function spacer($height=10)	{
		echo "<img src=\"images/spacer.gif\" height=\"$height\" width=\"100%\">\n";	
	}
	function image($image_link, $size = 0.75) {		
		global $CONFIG;
		$image_info = getimagesize($image_link); 		
		$image_info[0] = round($image_info[0] * $size);
		$image_info[1] = round($image_info[1] * $size);
		if ((int)$image_info[0] == 0) $image_info[0] = $CONFIG['thumb_width'] * $size;
		if ((int)$image_info[1] == 0) $image_info[1] = $CONFIG['thumb_width'] * $size;
				
		return "<img class=\"image\" src=\"$image_link\" width=\"{$image_info[0]}\" height=\"{$image_info[1]}\">";		
	}	
	function link($link, $text, $class="") {
		if ($class)
			return "<a class=\"$class\" href=\"$link\">$text</a>";
		else
			return "<a href=\"$link\">$text</a>";
	}
	function item_name($CURRENT_PIC_DATA) {		
		return $CURRENT_PIC_DATA['pid']."|".$CURRENT_PIC_DATA['filename'];			
	}
}   

?>