<?php
// coppermine default
if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');
if (!defined('CORE_PLUGIN')) define('CORE_PLUGIN', true); // 15x
if (!defined('DS')) define('DS', DIRECTORY_SEPARATOR);
// load my codebase helper
if (!function_exists('codebase_query')) include('forum'.DS.'helpers'.DS.'codebase_helper.php');
// install - uninstall stuff
$thisplugin->add_action('plugin_install',   'codebase_install');
$thisplugin->add_action('plugin_configure', 'codebase_configure');
$thisplugin->add_action('plugin_uninstall', 'codebase_uninstall');
$thisplugin->add_action('plugin_cleanup',   'codebase_cleanup');
// start
$thisplugin->add_action('page_start', 'forum_start');
function forum_start() {
	global $CONFIG;
	include('forum'.DS.'languages'.DS.'english'.DS.'codebase.php');
	codebase_admin_button('forum.php?c=admin', $lang['fr_mgr'], '', $lang['fr_mgr']);
	codebase_sys_user_button('forum.php', $lang['fr'], '', $lang['fr']);
}
// inject addon css & javascript to DOM
$thisplugin->add_filter('gallery_header', 'forum_gallery_header');
function forum_gallery_header() {
	global $CONFIG;
	global $template_header;
    $html = '<script type="text/javascript" src="'.$CONFIG['site_url'].'forum/html/js/scripts.js"></script>'.PHP_EOL;
    $html .= '<script type="text/javascript" src="'.$CONFIG['site_url'].'forum/html/js/jquery.js"></script>'.PHP_EOL;
    $forum_css_file = 'forum/templates/'.$CONFIG['theme'].'/style.css';
    if (file_exists($forum_css_file)) {
        $html .= '<link rel="stylesheet" href="'.$CONFIG['site_url'].$forum_css_file.'" type="text/css" />'.PHP_EOL;
	}
    $template_header = str_replace('</head>', $html.'</head>', $template_header);
}