<?php
	
function codebase_query($title, $sql_file) {
	global $CONFIG;	
	if (!function_exists('remove_comments')) {
		include('include'.DS.'sql_parse.php');  	
	}
	$sql_query = fread(fopen($sql_file, 'r'), filesize($sql_file));
	$sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);
   	$sql_query = remove_remarks($sql_query);
   	$sql_query = split_sql_file($sql_query, ';'); 			
   	echo <<<EOT
        <table class="maintable" width="100%" border="0" cellspacing="1" cellpadding="0">
        	<tr><td class="tableh1" colspan="2"><b>{$title}</b></td></tr>
EOT;
	foreach($sql_query as $q) {
		echo "<tr><td class='tableb' style='color: black;'>{$q}</td>";
		if (mysql_query($q)) {
       		echo "<td class='tableb' style='color: green;'><b>OK</b></td></tr>";
       	} else {
       		echo "<td class='tableb' style='color: red;'><b>Already Done</b></td></tr>";
       	}
	}
	echo '</table>';
}
	
function codebase_install() {
	$superCage = Inspekt::makeSuperCage();
   	if ($superCage->post->keyExists('submit')) {
       	return true;
   	} else {
       	return 1;
   	}
}

function codebase_configure($stop = TRUE) {
	global $errors, $CONFIG;
	global $lang_common;
    $superCage = Inspekt::makeSuperCage();
    $plugin_name = $superCage->get->getRaw('p');
    $install_sql_file = 'plugins'.DS.$plugin_name.DS.'sql'.DS.'install.sql';
    $update_sql_file  = 'plugins'.DS.$plugin_name.DS.'sql'.DS.'update.sql';
    codebase_query('Performing database updates', $install_sql_file);
    codebase_query('Performing database updates', $update_sql_file);
    if ($stop) {
    	echo <<< EOT
       	<form action="{$superCage->server->getEscaped('REQUEST_URI')}" method="post">
       		<input class="button" type="submit" name="submit" value="{$lang_common['go']}" name="submit" />
        </form>
EOT;
	}
}

function codebase_uninstall() {
	global $CONFIG;
	$superCage = Inspekt::makeSuperCage();	
   	if (!$superCage->post->keyExists('drop')) {
   		return 1;
	}   	
   	if ($superCage->post->getInt('drop') == 0) {   		
   		return true;
	} else {
		$plugin_id = $superCage->get->getInt('p');
   		$result = cpg_db_query("SELECT path FROM `{$CONFIG['TABLE_PREFIX']}plugins` WHERE plugin_id='{$plugin_id}';");
   		$row = cpg_db_fetch_row($result);    
   		$plugin_name = $row['path'];
   		$uninstall_sql_file = 'plugins'.DS.$plugin_name.DS.'sql'.DS.'uninstall.sql';
		codebase_query('Drop the database', $uninstall_sql_file);
		return true;
	}
}

function codebase_cleanup($action) {
	global $lang_common;	
	$superCage = Inspekt::makeSuperCage();
   	if ($action === 1) {
       	echo <<< EOT
		<form action="{$superCage->server->getEscaped('REQUEST_URI')}" method="post">
    	<table class="maintable" width="100%" border="0" cellspacing="1" cellpadding="0">
    		<tr><td class="tableh1"><b>Do you want to drop the plugin's current database ?</b></td></tr>
    	    <tr><td class="tableb">
    	    	<table border="0" cellspacing="0" cellpadding="0">
    	        	<tr>
                		<td>
                			<input type="radio" name="drop" id="drop_yes" value="1" />
                			<label for="drop_yes" class="clickable_option">{$lang_common['yes']}</label>
                		</td>
            		</tr>
            		<tr>
                		<td>
			        		<input type="radio" name="drop" id="drop_no" checked="checked" value="0" />
			        		<label for="drop_no" class="clickable_option">{$lang_common['no']}</label>
                		</td>                		
            		</tr>    	
    			</table>
    		</td></tr>
    		<tr>
    			<td class="tableb">
    				<input class="button" type="submit" name="submit" value="{$lang_common['go']}" />
            		<input class="button" type="button" name="cancel" onClick="window.location='pluginmgr.php';" value="cancel" />
    			</td>
    		</tr>
    	</table>
    	</form>
EOT;
	}
}	

function codebase_admin_button($href, $title, $target, $link, $before = 'documentation') {
	global $template_gallery_admin_menu;
	$new_emplate = $template_gallery_admin_menu;
	$button = template_extract_block($new_emplate, $before);
	$uc_before = strtoupper($before);
	$params = array(
   		"{{$uc_before}_HREF}"    => $href,
   		"{{$uc_before}_TITLE}"   => $title,
   		"target=\"cpg_$before\"" => $target,
   		"{{$uc_before}_LNK}"     => $link,
	);
	$new_button="<!-- BEGIN $link -->".template_eval($button, $params)."<!-- END $link -->\n";	
	template_extract_block($template_gallery_admin_menu, $before, "<!-- BEGIN $before -->" . $button . "<!-- END $before -->\n" . $new_button);	
}

function codebase_sub_user_button($href, $title, $target, $link, $before = 'custom_link') {
	global $template_sub_menu;	
	$new_template = $template_sub_menu;
   	$button = template_extract_block($new_template, $before);
   	switch ($before) {
   		case 'custom_link':	
   			$uc_before = 'CUSTOM_LNK';
   			break;
  		case 'album_list':
   			$uc_before = 'ALB_LIST';
   			break;  			
   		case 'favpics':
   			$uc_before = 'FAV';
   			break;
   		default:
   	    	$uc_before = strtoupper($before);    	
	}
   	$params = array(      
  		"{{$uc_before}_LNK}"   => $link,
   		"{{$uc_before}_TITLE}" => $title,      
   		"{{$uc_before}_TGT}"   => $href,
	);
   	$new_button="<!-- BEGIN $link -->".template_eval($button, $params)."<!-- END $link -->\n";
   	template_extract_block($template_sub_menu, $before, "<!-- BEGIN $before -->" . $button . "<!-- END $before -->\n" . $new_button);
}

function codebase_sys_user_button($href, $title, $target, $link, $before = 'home') {
	global $template_sys_menu;	
	$new_template = $template_sys_menu;
   	$button = template_extract_block($new_template, $before);
   	switch ($before) {
   		case 'my_gallery':	
   			$uc_before = 'MY_GAL';
   			break;
   		case 'allow_memberlist':
   			$uc_before = 'MEMBERLIST';
   			break;
   		case 'upload_approval':
   		    $uc_before = 'UPL_APP';
   			break;
   		case 'enter_admin_mode':
   			$uc_before = 'ADM_MODE';
   			break;
   		case 'leave_admin_mode':
   			$uc_before = 'ADM_MODE';
   			break;
   		case 'leave_admin_mode':
   		    $uc_before = 'USR_MODE';
   			break;
   		case 'upload_pic':
   			$uc_before = 'UPL_PIC';
  			break;
  		case 'my_profile':
  			$uc_before = 'MY_PROF';
   		default:
   	    	$uc_before = strtoupper($before);    	
	}
   	$params = array(      
  		"{{$uc_before}_LNK}"   => $link,
   		"{{$uc_before}_TITLE}" => $title,      
  		"{{$uc_before}_TGT}"   => $href,
	);
   	$new_button="<!-- BEGIN $link -->".template_eval($button, $params)."<!-- END $link -->\n";
   	template_extract_block($template_sys_menu, $before, "<!-- BEGIN $before -->" . $button . "<!-- END $before -->\n" . $new_button);
}

function codebase_redirect($link, $type='js') {
	switch ($type) {
		case 'php':
		    header("Location: $link");
			break;
		case 'js':
			echo "<script language=\"javascript\" type=\"text/javascript\">window.location='$link';</script>";
			break;	
		default:
        	echo "<html><head><meta http-equive=\"refresh\" content=\"0; URL=$link\"></head></html>";
	}
}


