<?php

/**
* @desc view a board
*/

function board($board_id) {
	global $CONFIG;
	global $lang_fr_board, $lang_fr_index;
	global $template_fr_board;
	global $last_msg_date_fmt;	
	// var
	$start = isset($_GET['start']) ? (int)$_GET['start'] : 0;
	$limit = $CONFIG['fr_topic_per_page'];
	// template		
	$template_child_board_view  		= template_extract_block($template_fr_board, "child_board_view");
	$template_child_board_view_no_child = template_extract_block($template_fr_board, "child_board_view_no_child");
	$template_menu 			    		= template_extract_block($template_fr_board, "menu");
	$template_topic_title 				= template_extract_block($template_fr_board, "topic_title");
	$template_topic_view 				= template_extract_block($template_fr_board, "topic_view");
	$template_no_topic 					= template_extract_block($template_fr_board, "no_topic");
	$template_board_footer 				= template_extract_block($template_fr_board, "board_footer");
	$template_sticky_topic_view 		= str_replace('tableb', 'tablef', $template_topic_view);
	// begin	
	$current_board_data = cpgdb_fetch_row("SELECT * FROM `{$CONFIG['TABLE_FR_BOARDS']}` WHERE board_id='$board_id';");
	HTMLelement::nagavitor($board_id, "board"); 		
	$child_board_array = cpgdb_fetch_rowset("SELECT * FROM `{$CONFIG['TABLE_FR_BOARDS']}` WHERE parent_id='$board_id';");
	if (count($child_board_array) != 0) {
		starttable($CONFIG['picture_table_width'], HTMLelement::apply_bold($lang_fr_board['child_board']), 4);
		// on || off ?		
		foreach ($child_board_array as $child_board) {
			$child_board_lst = HTMLelement::get_child_board($child_board['board_id'], $child_board['child_level']);
			$vars = array(
				'{ICON}'			=> HTMLelement::image("adaptor/images/default/icon_board.gif"),
				'{TITLE}'			=> HTMLelement::board_title($child_board['board_id'], $child_board['name']).$child_board['description'],	
				'{STATS}'           => $child_board['posts'].$lang_fr_index['posts']."<br />".$child_board['topics'].$lang_fr_index['topics'],				    				    
				'{LAST_POST}'       => HTMLelement::get_last_post_text($child_board['last_msg_id']),
				'{CHILD_BOARDS}'    => $child_board_lst,	
			);
			if ($child_board_lst == "")
				echo template_eval($template_child_board_view_no_child, $vars);
			else
				echo template_eval($template_child_board_view, $vars);
		}							
		endtable();
		HTMLelement::spacer();
	}
	// topic + page + button
	$topic_count = cpgdb_fetch_var("SELECT count(*) FROM `{$CONFIG['TABLE_FR_TOPICS']}` WHERE board_id='$board_id';");
	$vars = array(
		'{LANG_NEW_TOPIC}'	=> $lang_fr_board['new_topic'],
		'{BOARD_ID}'        => $board_id,
		'{PAGE}' 			=> $lang_fr_board['page'].HTMLelement::page($topic_count, $start, $limit, "forum.php?board=$board_id"),
	);
	if ($topic_count == 0) $vars['{PAGE}'] = "";
	$menu_html = template_eval($template_menu, $vars);
	starttable();
	echo $menu_html;
	endtable();
	// sticky
	$sticky_topic_array = cpgdb_fetch_rowset("SELECT * FROM `{$CONFIG['TABLE_FR_TOPICS']}` WHERE board_id='$board_id' AND is_sticky='1' ORDER BY topic_id DESC;");
	$topic_array = cpgdb_fetch_rowset("SELECT * FROM `{$CONFIG['TABLE_FR_TOPICS']}` WHERE board_id='$board_id' AND is_sticky='0' ORDER BY last_msg_id DESC LIMIT $start, $limit;");	
	// topic list	
	starttable($CONFIG['picture_table_width']);	
	$vars = array(
		'{LANG_SUBJECT}'	 => $lang_fr_board['subject'],
	    '{LANG_STARTED_BY}'  => $lang_fr_board['started_by'],
	    '{LANG_REPLIES}'  	 => $lang_fr_board['repiles'],
	    '{LANG_VIEWS}'  	 => $lang_fr_board['views'],
	    '{LANG_LAST_POST}'   => $lang_fr_board['last_post'],
	);
	echo template_eval($template_topic_title, $vars);	
	if (count($topic_array)+count($sticky_topic_array) == 0) {
	 	// do smt here because there is no topic
	 	$vars = array('{TEXT}'=>$lang_fr_board['no_topic']);
	 	echo template_eval($template_no_topic, $vars);
	}
	display_topic($template_sticky_topic_view, $sticky_topic_array);
	display_topic($template_topic_view, $topic_array);
	endtable();
	// page + button again
	starttable();
	echo $menu_html;
	endtable();
	HTMLelement::nagavitor($board_id, "board");
	starttable();	
	$vars = array(	
		'{LANG_NO_NEW_MSG_TOPIC}' 	=> $lang_fr_board['no_new_msg_topic'],
		'{LANG_NEW_MSG_TOPIC}'		=> $lang_fr_board['new_msg_topic'],	
		'{LANG_HOT_TOPIC}'			=> sprintf($lang_fr_board['hot_topic'], $CONFIG['fr_hot_topic_msg']),
    	'{LANG_RO_TOPIC}'			=> $lang_fr_board['ro_topic'],
		'{LANG_SK_TOPIC}'           => $lang_fr_board['sk_topic'],
		'{LANG_JUMP_TO}'    		=> $lang_fr_index['jump_to'],
		'{LANG_GO}'         		=> $lang_fr_index['go'],
		'{JUMP_TO}' 				=> HTMLelement::redirect_box($current_board_data['cat_id']),
	);	
	echo template_eval($template_board_footer, $vars);
	endtable();
}

function display_topic($template_topic_view, $topic_array) {
	global $CONFIG;
	foreach ($topic_array as $topic) {
		// first msg data
		$first_msg_data = cpgdb_fetch_row("SELECT * FROM `{$CONFIG['TABLE_FR_MESSAGES']}` WHERE msg_id='{$topic['first_msg_id']}';");
		$last_msg_data = cpgdb_fetch_row("SELECT * FROM `{$CONFIG['TABLE_FR_MESSAGES']}` WHERE msg_id='{$topic['last_msg_id']}';");
		// hot topic ?
		$number_of_msg = cpgdb_fetch_var("SELECT count(*) FROM `{$CONFIG['TABLE_FR_MESSAGES']}` WHERE topic_id='{$topic['topic_id']}';");
		if ($topic['locked']) {
			$subject = HTMLelement::image("adaptor/images/default/icon_topic_readonly.gif");			
		} else if ($topic['is_sticky']) {
			$subject = HTMLelement::image("adaptor/images/default/icon_topic_reply.gif");				
			
		} else if ($number_of_msg >= $CONFIG['fr_hot_topic_msg']) {
			$subject = HTMLelement::image("adaptor/images/default/icon_topic_hot.gif");
		} else {
			$subject = HTMLelement::image("adaptor/images/default/icon_topic_new.gif");
			//$subject = HTMLelement::image("adaptor/images/default/icon_topic.gif");
		}		
		$vars = array(
	    	'{STATUS}'		=> $subject,  		    		    	
	    	'{ICON}'  	    => HTMLelement::image("adaptor/images/default/post/".$first_msg_data['icon'].".gif"),
	    	'{SUBJECT}'  	=> HTMLelement::topic_link($topic['topic_id'] ,$first_msg_data['subject']),
	    	'{START_BY}'  	=> HTMLelement::profile_link($first_msg_data['poster_id'], $first_msg_data['poster_name']),
	    	'{REPLIES}'  	=> $topic['replies'],
	    	'{VIEWS}'  	    => $topic['views'],
	    	'{LAST_POST}'   => HTMLelement::get_last_post_text($topic['last_msg_id']),	    		    	
		);
		if (GALLERY_ADMIN_MODE) {
			$vars['{REMOVE_LNK}']	= "forum.php?topic=" . $topic['topic_id'] . "&amp;action=remove";
			$vars['{REMOVE_TITLE}'] = $lang_fr_board['remove_topic'];
			$vars['{REMOVE_IMG}']   = "images/delete.gif";			
		}
		echo template_eval($template_topic_view, $vars);	
	}	
}
 
?>