<?php
/**
* @desc database functions
*/

function cpgdb_run_query($query_string) {
	return cpg_db_query($query_string);
}

function cpgdb_insert_id() {
	$insert_id = mysql_insert_id();	
	if ($insert_id == 0) {
		// try another way			
	}
	return $insert_id;
}

function cpgdb_fetch_var($query_string) {
	$query_result = cpg_db_query($query_string);
	$row = cpg_db_fetch_row($query_result);		
	mysql_free_result($query_result);
	return $row[0];
}

function cpgdb_fetch_row($query_string) {
	$query_result = cpg_db_query($query_string);
	$row = cpg_db_fetch_row($query_result);		
	mysql_free_result($query_result);
	return $row;
}

function cpgdb_fetch_rowset($query_string) {
	$query_result = cpg_db_query($query_string);
	$rowset = cpg_db_fetch_rowset($query_result);		
	mysql_free_result($query_result);
	return $rowset;		
}

/**
* @desc forum functions
*  
*/

function update_board_stats($board_id) {
	global $CONFIG;	
	// topic count
	$topic_count = cpgdb_fetch_var("SELECT COUNT(*) as count FROM `{$CONFIG['TABLE_FR_TOPICS']}` WHERE board_id='$board_id';");
	// post count
	$post_count = cpgdb_fetch_var("SELECT SUM(replies) as count FROM `{$CONFIG['TABLE_FR_TOPICS']}` WHERE board_id='$board_id';");
	// last_msg_id, updated_msg_id
	$last_topic_data = cpgdb_fetch_row("SELECT last_msg_id FROM `{$CONFIG['TABLE_FR_TOPICS']}` WHERE board_id='$board_id' ORDER BY last_msg_id DESC LIMIT 1;");
	// update
	cpg_db_query("UPDATE `{$CONFIG['TABLE_FR_BOARDS']}` SET topics='{$topic_count}', posts='{$post_count}', last_msg_id='{$last_topic_data['last_msg_id']}', updated_msg_id='{$last_topic_data['last_msg_id']}' WHERE board_id='$board_id';");	
}

function update_topic_stats($topic_id) {
	global $CONFIG;
	// message count
	$message_count = cpgdb_fetch_var("SELECT COUNT(*) as count FROM `{$CONFIG['TABLE_FR_MESSAGES']}` WHERE topic_id='$topic_id';");	
	// first & last data
	$first_data = cpgdb_fetch_row("SELECT msg_id, poster_id FROM `{$CONFIG['TABLE_FR_MESSAGES']}` WHERE topic_id='$topic_id' ORDER BY msg_id ASC LIMIT 1;");
	$last_data = cpgdb_fetch_row("SELECT msg_id, poster_id FROM `{$CONFIG['TABLE_FR_MESSAGES']}` WHERE topic_id='$topic_id' ORDER BY msg_id DESC LIMIT 1;");
	// update
	cpg_db_query("UPDATE `{$CONFIG['TABLE_FR_TOPICS']}` SET replies='$message_count', first_msg_id='{$first_data['msg_id']}', last_msg_id='{$last_data['msg_id']}', started_member_id='{$first_data['poster_id']}', updated_member_id='{$last_data['poster_id']}' WHERE topic_id='$topic_id';");	
}

/**
* @desc tool functions
*/                   

function cpg_redirect($link, $text="", $type="js", $time=3) {
	switch ($type) {
		case "html":	
		    echo "<html><head><meta http-equive=\"refresh\" content=\"{$time}; URL={$link}\"></head></html>";
			break;
		case "php":
		    header("Location: {$link}");
			break;
		case "js":
			echo "<script language=\"javascript\" type=\"text/javascript\">
			<!--
			window.location.href=\"{$link}\";
			//-->
			</script>";			
			break;	
	}
}
 
function str_cutter($string, $length) {
	return substr($string, 0, $length);	
}

function get_board_list2($cat_id, $parent_id, &$board_array) {
	global $CONFIG;	
    if ($parent_id == 0) {
    	$board_lst_array = cpgdb_fetch_rowset("SELECT board_id, name, child_level FROM `{$CONFIG['TABLE_FR_BOARDS']}` WHERE cat_id='$cat_id' AND child_level='1' ORDER BY board_order ASC;");
	} else {
		$board_lst_array = cpgdb_fetch_rowset("SELECT board_id, name, child_level FROM `{$CONFIG['TABLE_FR_BOARDS']}` WHERE cat_id='$cat_id' AND parent_id='$parent_id' ORDER BY board_order ASC;");	
	}
	foreach ($board_lst_array as $board_lst) {
		$board_array[] = $board_lst;
		get_board_list2($cat_id, $board_lst['board_id'], $board_array);
	}
}

function check_cat($cat_id) {	
	global $CONFIG;
	global $lang_fr_errors;
	$count = cpgdb_fetch_var("SELECT COUNT(*) FROM `{$CONFIG['TABLE_FR_CATEGORIES']}` WHERE cat_id='$cat_id';");
	if ($count != 1) cpg_die(ERROR, $lang_fr_errors['wrong_cat'], __FILE__, __LINE__);
}

function check_board($board_id) {
	global $CONFIG;
    global $lang_fr_errors;
	$count = cpgdb_fetch_var("SELECT COUNT(*) FROM `{$CONFIG['TABLE_FR_BOARDS']}` WHERE board_id='$board_id';");
	if ($count != 1) cpg_die(ERROR, $lang_fr_errors['wrong_board'], __FILE__, __LINE__);
}

function check_topic($topic_id) {
	global $CONFIG;
    global $lang_fr_errors;
	$count = cpgdb_fetch_var("SELECT COUNT(*) FROM `{$CONFIG['TABLE_FR_TOPICS']}` WHERE topic_id='$topic_id';");
	if ($count != 1) cpg_die(ERROR, $lang_fr_errors['wrong_topic'], __FILE__, __LINE__);
}

function check_msg($msg_id) {
	global $CONFIG;
    global $lang_fr_errors;
	$count = cpgdb_fetch_var("SELECT COUNT(*) FROM `{$CONFIG['TABLE_FR_MESSAGES']}` WHERE msg_id='$msg_id';");
	if ($count != 1) cpg_die(ERROR, $lang_fr_errors['wrong_msg'], __FILE__, __LINE__);
}

function error_display($errors) {
	if (!is_array($errors)) $errors = array($errors);
	$html = "<ul>\n";
	foreach ($errors as $error) {
		$html .= "<li>".$error."\n";		
	}
	$html .= "</ul>\n";
	cpg_die(ERROR, $html, __FILE__, __LINE__);
}

function load_badword_list() {
	global $CONFIG;	
	global $badword_list;	
}

function get_avatar_image($user_id) {
	global $CONFIG;
	// check if stramm avatar active
	if (isset($CONFIG['enable_avatar'])) {
		if ($CONFIG['enable_avatar'] != 0) {
			if ($user_id) {
			 	$query = "SELECT avatar_url FROM `{$CONFIG['TABLE_USERS']}` WHERE user_id='$user_id';";
			 	$result = cpg_db_query($query);
			 	if (mysql_num_rows($result) > 0) {
			 		$row = cpg_db_fetch_row($result);
			 		if ($row['avatar_url']) return "<img src=\"{$row['avatar_url']}\" border=\"0\" alt=\"\" />";		 		
				}
			}
		}
	}	
	if ($user_id) return "<img src=\"adaptor/images/default_avatar.png\" border=\"0\" alt=\"\" />"; else return "";	
}

function text_word_warp($text) {
	global $CONFIG;	
	if ($CONFIG['fr_max_word_length'] == 0)	return $text; 
	$text_array = explode(' ', $text);
	$new_text = "";	
	foreach ($text_array as $v) {
		// bbcode checking		
		if (is_bbcode($v, "img") || is_bbcode($v, "url") || is_bbcode($v, "b") || is_bbcode($v, "i") || is_bbcode($v, "email") || is_bbcode($v, "color")) {		
			$new_text .= " ".$v;
		} else if (strlen($v) > $CONFIG['fr_max_word_length']) {
			$word_gaps = ceil(strlen($v)/$CONFIG['fr_max_word_length']);				
			$new_word = "";
			for ($i=0;$i<$word_gaps;$i++) {
				if (($i+1)*$CONFIG['fr_max_word_length'] > (strlen($v)-1))
				    $new_word .= " ".substr($v, $i*$CONFIG['fr_max_word_length'], (strlen($v)-$i*$CONFIG['fr_max_word_length']));
				else
			   		$new_word .= " ".substr($v, $i*$CONFIG['fr_max_word_length'], $CONFIG['fr_max_word_length']);
			}
			$new_text .= " ".$new_word;				
		} else 
			$new_text .= " ".$v;
	}
	$text = trim($new_text);
	return $text;
}

function is_bbcode($string, $code_name) {
	$start_code = "[".$code_name;
	$end_code = "[/".$code_name."]";
	if ((strpos($string, $start_code) !== false) && (strpos($string, $start_code) !== false)) return true; else return false;
}

function check_double_post() {
	global $CONFIG;
	global $raw_ip, $hdr_ip;
	global $lang_fr_errors;
	if ($CONFIG['fr_gap_time'] == 0 || GALLERY_ADMIN_MODE) return true;
	$post_time = time();	
	$allow_time = $post_time-$CONFIG['fr_gap_time'];
	$CONFIG['debug_mode'] = 2;
	$query = "SELECT * FROM `{$CONFIG['TABLE_FR_MESSAGES']}` WHERE poster_id='".USER_ID."' AND poster_time>$allow_time;";
	$result = cpg_db_query($query);
	if (mysql_num_rows($result) != 0) {
		cpg_die(ERROR, sprintf($lang_fr_errors['double_post'], $CONFIG['fr_gap_time'] ), __FILE__, __LINE__);
	}
}

function check_feature($name) {
	global $CONFIG;
	switch ($name) {
		case "avatar":
		    if (isset($CONFIG['enable_avatar']) && $CONFIG['enable_avatar'] != 0) return true; else return false;
			break;
		case "PM":	
			break;
		case "captcha":	
			break;	
	    default:
	    	return false;	
	}
}

function auto_update_sql() {
    global $CONFIG;
    global $cpgforum_version;
    if (!isset($CONFIG['fr_version'])) {
    	cpg_db_query("INSERT INTO `{$CONFIG['TABLE_CONFIG']}` (name, value) VALUES ('fr_version', '0.0.0');");
    	$CONFIG['fr_version'] = '0.0.0';
	}
    if ($cpgforum_version != $CONFIG['fr_version']) {
    	require ('include/sql_parse.php');
    	$sql_file = "plugins/adaptor/sql/update.sql"; 	
		$sql_query = fread(fopen($sql_file, 'r'), filesize($sql_file));
		$sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);
    	$sql_query = remove_remarks($sql_query);
    	$sql_query = split_sql_file($sql_query, ';');    
		foreach($sql_query as $q) {		
			mysql_query($q);
        }
        cpg_db_query("UPDATE `{$CONFIG['TABLE_CONFIG']}` SET value='$cpgforum_version' WHERE name='fr_version';");
	}
}	

?>