<?php
/**************************************************
  Coppermine Plugin - Full-Size Photos Access
  *************************************************
  Copyright (c) 2006 Paul Van Rompay
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  *************************************************/

global $CONFIG, $lang_main_menu;
global $lang_plugin_controlfullsize, $lang_plugin_controlfullsize_config;
require('include/init.inc.php');

if (!GALLERY_ADMIN_MODE) cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);

require('plugins/control_fullsize/include/init.inc.php');

if (count($_POST) > 0) {
  if (isset($_POST['update_config'])) {

    $group_list = isset($_POST['group_list']) ? $_POST['group_list'] : '';
    $groups_thumbnail = '';
    $groups_intermediate = '';
    $groups_fullsize = '';
    foreach ($group_list as $group) {
      $group_permission = isset($_POST['permission-'.$group]) ? $_POST['permission-'.$group] : '';
      switch ($group_permission) {
        case 0 : 
          $groups_thumbnail .= ($groups_thumbnail ? ',' : '') . $group;
          break;
        case 1 :
          $groups_intermediate .= ($groups_intermediate ? ',' : '') . $group;
          break;
        case 2 :
          $groups_fullsize .= ($groups_fullsize ? ',' : '') . $group;
          break;
      }
    }
    $displaynotice = ($_POST['displaynotice'] ? '1' : '0');
    $noticetooltip = ($_POST['noticetooltip'] ? '1' : '0');
    $noticepopup = ($_POST['noticepopup'] ? '1' : '0');
    $displaynotice_th = ($_POST['displaynotice_th'] ? '1' : '0');
    $noticetooltip_th = ($_POST['noticetooltip_th'] ? '1' : '0');
    $noticepopup_th = ($_POST['noticepopup_th'] ? '1' : '0');
    $controleverything = ($_POST['controleverything'] ? '1' : '0');

    $sql1 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '$groups_thumbnail' WHERE name = 'plugin_controlfullsize_groups_thumb'";
    $sql2 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '$groups_intermediate' WHERE name = 'plugin_controlfullsize_groups_inter'";
    $sql3 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '$groups_fullsize' WHERE name = 'plugin_controlfullsize_groups_full'";
    $sql4 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '{$_POST['requsercomment']}' WHERE name = 'plugin_controlfullsize_requsercomment'";
    $sql5 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '{$_POST['conditionoperator']}' WHERE name = 'plugin_controlfullsize_conditionoperator'";
    $sql6 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '$displaynotice' WHERE name = 'plugin_controlfullsize_displaynotice'";
    $sql7 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '{$_POST['noticemessage']}' WHERE name = 'plugin_controlfullsize_noticemessage'";
    $sql8 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '{$_POST['noticemessanon']}' WHERE name = 'plugin_controlfullsize_noticemessanon'";
    $sql9 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '$noticetooltip' WHERE name = 'plugin_controlfullsize_noticetooltip'";
    $sql10 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '$noticepopup' WHERE name = 'plugin_controlfullsize_noticepopup'";
    $sql11 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '$displaynotice_th' WHERE name = 'plugin_controlfullsize_displaynotice_th'";
    $sql12 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '{$_POST['noticemessage_th']}' WHERE name = 'plugin_controlfullsize_noticemessage_th'";
    $sql13 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '{$_POST['noticemessanon_th']}' WHERE name = 'plugin_controlfullsize_noticemessanon_th'";
    $sql14 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '$noticetooltip_th' WHERE name = 'plugin_controlfullsize_noticetooltip_th'";
    $sql15 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '$noticepopup_th' WHERE name = 'plugin_controlfullsize_noticepopup_th'";
    $sql16 = "UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '$controleverything' WHERE name = 'plugin_controlfullsize_controleverything'";
    cpg_db_query($sql1);
    cpg_db_query($sql2);
    cpg_db_query($sql3);
    cpg_db_query($sql4);
    cpg_db_query($sql5);
    cpg_db_query($sql6);
    cpg_db_query($sql7);
    cpg_db_query($sql8);
    cpg_db_query($sql9);
    cpg_db_query($sql10);
    cpg_db_query($sql11);
    cpg_db_query($sql12);
    cpg_db_query($sql13);
    cpg_db_query($sql14);
    cpg_db_query($sql15);
    cpg_db_query($sql16);
    if ($CONFIG['log_mode'] == CPG_LOG_ALL) {
      log_write('CONFIG UPDATE SQL: '.$sql1.";\n".$sql2.";\n".$sql3.";\n".$sql4.";\n".$sql5.";\n".$sql6.";\n".$sql7.";\n".$sql8.";\n".$sql9.";\n".$sql10.";\n".$sql11.";\n".$sql12.";\n".$sql13.";\n".$sql14.";\n".$sql15.";\n".$sql16.
        'TIME: '.date("F j, Y, g:i a")."\n".
        'USER: '.$USER_DATA['user_name'],
        CPG_DATABASE_LOG
        );
    }
  }
  pageheader($lang_plugin_controlfullsize['display_name']);
  msg_box($lang_plugin_controlfullsize['display_name'], $lang_plugin_controlfullsize['page_success'], $lang_continue, 'index.php');
  pagefooter();
  exit;
}

pageheader($lang_plugin_controlfullsize['display_name']);
starttable('100%', $lang_plugin_controlfullsize['display_name'].' - <a href="pluginmgr.php" class="admin_menu">Plugin Manager</a>', 3);
echo '<tr><td>'."\n";

// default parameters
$groups_thumbnail = '';
$groups_intermediate = '';
$groups_fullsize = '';
$requsercomment = 0;
$conditionoperator = "AND";
$displaynotice = 0;
$noticetooltip = 1;
$noticepopup = 0;
$noticemessage = $lang_plugin_controlfullsize_config['noticemessage_default'];
$noticemessanon = $lang_plugin_controlfullsize_config['noticemessage_default_anon'];
$displaynotice_th = 0;
$noticetooltip_th = 1;
$noticepopup_th = 0;
$noticemessag_th = $lang_plugin_controlfullsize_config['noticemessage_default_th'];
$noticemessanon_th = $lang_plugin_controlfullsize_config['noticemessage_default_anon_th'];

// pull in current values
$result = cpg_db_query("SELECT name, value FROM {$CONFIG['TABLE_CONFIG']} where name REGEXP '^plugin_controlfullsize_'");
$params = cpg_db_fetch_rowset($result);
mysql_free_result($result);
foreach($params as $param) {
  if($param['name'] == 'plugin_controlfullsize_groups_thumb') { $groups_thumbnail = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_groups_inter') { $groups_intermediate = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_groups_full') { $groups_fullsize = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_requsercomment') { $requsercomment = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_conditionoperator') { $conditionoperator = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_displaynotice') { $displaynotice = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_noticemessage') { $noticemessage = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_noticemessanon') { $noticemessanon = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_noticetooltip') { $noticetooltip = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_noticepopup') { $noticepopup = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_displaynotice_th') { $displaynotice_th = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_noticemessage_th') { $noticemessage_th = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_noticemessanon_th') { $noticemessanon_th = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_noticetooltip_th') { $noticetooltip_th = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_noticepopup_th') { $noticepopup_th = $param['value']; }
  elseif($param['name'] == 'plugin_controlfullsize_controleverything') { $controleverything = $param['value']; }
}
$sql = "SELECT group_id, group_name FROM {$CONFIG['TABLE_USERGROUPS']} ORDER BY group_name";
$result = cpg_db_query($sql);
$group_list = cpg_db_fetch_rowset($result);
mysql_free_result($result);
$group_cb = '';
foreach($group_list as $group) {
  if ($group['group_id'] != 4) {
    if ($group['group_id'] == 1) { 
      $group['group_name'] .= ' - '.$lang_main_menu['usr_mode_lnk'];
    }
    $selected_thumbnail = strpos(',,'.$groups_thumbnail.',' , ','.$group['group_id'].',') ? 'checked="checked"' : '';
    $selected_intermediate = strpos(',,'.$groups_intermediate.',' , ','.$group['group_id'].',') ? 'checked="checked"' : '';
    $selected_fullsize = strpos(',,'.$groups_fullsize.',' , ','.$group['group_id'].',') ? 'checked="checked"' : '';
    if (!$selected_intermediate && !$selected_fullsize) {
      $selected_thumbnail = 'checked="checked"';
    }
    $group_cb .= '<input type="hidden" name="group_list[]" value="' . $group['group_id'] .'" />'
      . '<input name="permission-' . $group['group_id'] . '" type="radio" value="0" ' . $selected_thumbnail . ' />'
      . $lang_plugin_controlfullsize_config['select_thumbnail'] . ' --- '
      . '<input name="permission-' . $group['group_id'] . '" type="radio" value="1" ' . $selected_intermediate . ' />'
      . $lang_plugin_controlfullsize_config['select_intermediate'] . ' --- '
      . '<input name="permission-' . $group['group_id'] . '" type="radio" value="2" ' . $selected_fullsize . ' />'
      . $lang_plugin_controlfullsize_config['select_fullsize'] . ' ---> '
      . $lang_plugin_controlfullsize_config['select_group'] .': '. $group['group_name'] . "<br />\n";
  }
}
$op_and_selected = '';
$op_or_selected = '';
if ($conditionoperator == 'AND') { $op_and_selected = "selected"; }
if ($conditionoperator == 'OR') { $op_or_selected = "selected"; }
$requser_yes_selected = '';
$requser_no_selected = '';
if ($requsercomment == '0') { $requser_no_selected = "selected"; }
if ($requsercomment == '1') { $requser_yes_selected = "selected"; }
$displaynotice_selected = ($displaynotice == '1') ? 'checked' : '';
$noticetooltip_selected = ($noticetooltip == '1') ? 'checked' : '';
$noticepopup_selected = ($noticepopup == '1') ? 'checked' : '';
$displaynotice_th_selected = ($displaynotice_th == '1') ? 'checked' : '';
$noticetooltip_th_selected = ($noticetooltip_th == '1') ? 'checked' : '';
$noticepopup_th_selected = ($noticepopup_th == '1') ? 'checked' : '';
$control_extent_all_selected = '';
$control_extent_imageonly_selected = '';
if ($controleverything == '0') { $control_extent_imageonly_selected = "selected"; }
if ($controleverything == '1') { $control_extent_all_selected = "selected"; }
echo <<< EOT
  <form action="{$_SERVER['REQUEST_URI']}" method="post">
  {$lang_plugin_controlfullsize_config['control_extent']} -->
  <select name="controleverything"><option value="1" $control_extent_all_selected>{$lang_plugin_controlfullsize_config['control_extent_choice_all']}</option>
    <option value="0" $control_extent_imageonly_selected>{$lang_plugin_controlfullsize_config['control_extent_choice_imageonly']}</option></select><br />
  {$lang_plugin_controlfullsize_config['control_note']}<br />
  <br />
  {$lang_plugin_controlfullsize_config['select_groups']}:<br />
  $group_cb<br />
  {$lang_plugin_controlfullsize_config['select_note1']}<br />
  {$lang_plugin_controlfullsize_config['select_note2']}<br />
  <br />
  <select name="conditionoperator"><option value="AND" $op_and_selected>{$lang_plugin_controlfullsize_config['op_and']}</option>
    <option value="OR" $op_or_selected>{$lang_plugin_controlfullsize_config['op_or']}</option></select>
  {$lang_plugin_controlfullsize_config['require_user']} -->
  <select name="requsercomment"><option value="1" $requser_yes_selected>{$lang_plugin_controlfullsize_config['choice_yes']}</option>
    <option value="0" $requser_no_selected>{$lang_plugin_controlfullsize_config['choice_no']}</option</select><br />
  <br />
  <input type="checkbox" value="1" name="displaynotice" $displaynotice_selected> {$lang_plugin_controlfullsize_config['display_notice']} : <br />
  &nbsp; &nbsp; &nbsp; {$lang_plugin_controlfullsize_config['notice_loggedin']}: <input type="text" name="noticemessage" value="$noticemessage" size="80"><br />
  &nbsp; &nbsp; &nbsp; {$lang_plugin_controlfullsize_config['notice_anon']}: <input type="text" name="noticemessanon" value="$noticemessanon" size="80"><br />
  &nbsp; &nbsp; &nbsp; {$lang_plugin_controlfullsize_config['notice_choose']}: <input type="checkbox" value="1" name="noticetooltip" $noticetooltip_selected> {$lang_plugin_controlfullsize_config['notice_tooltip']} ---  
  <input type="checkbox" value="1" name="noticepopup" $noticepopup_selected> {$lang_plugin_controlfullsize_config['notice_popup']}<br />
  <br />
  <input type="checkbox" value="1" name="displaynotice_th" $displaynotice_th_selected> {$lang_plugin_controlfullsize_config['display_notice_th']} : <br />
  &nbsp; &nbsp; &nbsp; {$lang_plugin_controlfullsize_config['notice_loggedin']}: <input type="text" name="noticemessage_th" value="$noticemessage_th" size="80"><br />
  &nbsp; &nbsp; &nbsp; {$lang_plugin_controlfullsize_config['notice_anon']}: <input type="text" name="noticemessanon_th" value="$noticemessanon_th" size="80"><br />
  &nbsp; &nbsp; &nbsp; {$lang_plugin_controlfullsize_config['noticemessage_note_th']}<br />  
  &nbsp; &nbsp; &nbsp; {$lang_plugin_controlfullsize_config['notice_choose']}: <input type="checkbox" value="1" name="noticetooltip_th" $noticetooltip_th_selected> {$lang_plugin_controlfullsize_config['notice_tooltip']} ---  
  <input type="checkbox" value="1" name="noticepopup_th" $noticepopup_th_selected> {$lang_plugin_controlfullsize_config['notice_popup']}<br />
  <br />
  <input type="submit" value="{$lang_plugin_controlfullsize_config['button_done']}" name="update_config"/>
  </form>
EOT;

echo '</td></tr>'."\n";
endtable();
pagefooter();
ob_end_flush();
?>
