<?php
/**************************************************
  Backup Plugin for Coppermine Photo Gallery
/**********************************************
  based on the XT Dump script with the agreement of the author
  Modified by Frantz for Backup plugin
  2007/01/20
**********************************************/

if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...'); }
if (!GALLERY_ADMIN_MODE) {
  cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);
}

// Added by GauGau:
// Make sure that the dump folder is writtable
  $testFileError = '';
  $testFile = './plugins/backup/dumps/testFile'.date("YmdHis").'.txt';
  $dumpFolderURL = $CONFIG['ecards_more_pic_target']. 'plugins/backup/dumps/';
  // 1. Create a test file
    $handle = @fopen($testFile, 'w');
    if ($handle == FALSE) {
        $testFileError .= '<li>' . $lang_plugin_backup['error_file_creation'] . '</li>' . "\n";
        $testFileCreate = 0;
    } else {
        $testFileCreate = 1;
    }
    @fclose($handle);
  if ($testFileCreate == 1) {
    // 2. Check if the test file exists
      if (file_exists($testFile) == FALSE) {
          $testFileError .= '<li>' . $lang_plugin_backup['error_file_read'] . '</li>' . "\n";
      }
    // 3. Delete the test file
      $deleteTestFile = @unlink($testFile);
      if ($deleteTestFile == FALSE && $testFileCreate == 1) {
          $testFileError .= '<li>' . $lang_plugin_backup['error_file_delete'] . '</li>' . "\n";
      } else {
          $testFileDelete = 1;
      }
    // 4. Check if the delete has been successfull
      if (file_exists($testFile) == TRUE && $testFileDelete == 1) {
          $testFileError .= '<li>' . sprintf($lang_plugin_backup['error_file_exists'], $testFile) . '</li>' . "\n";
      }
  }
  // 5. Output error message
    if ($testFileError != '') {
        $testFileError = '<tr><td class="tableh2"><ul>' . $testFileError . '</ul>'.sprintf($lang_plugin_backup['error_writable'], $dumpFolderURL).'</td></tr>';
        print $testFileError;
    }



$aTables = mysql_list_tables ($XTCONFIG['dbbase']);
$iTablesCount = mysql_num_rows ($aTables);
$sJScript = PrintJS($iTablesCount);
$sDefaultFileName = 'dump_' .
                    $XTCONFIG['dbbase'] . '_'.
                    date('Y') . '-'.
                    date('m') . '-'.
                    date('d') . '_'.
                    date('H') . '-'.
                    date('i') . '-'.
                    date('s');


if (extension_loaded('zlib'))
{
        $sZlib = '<input type="checkbox" name="zlib" value="1" id="zlib" />';
}
else
{
        $sZlib = '<input type="checkbox" name="zlib" disabled="disabled" value="0" id="zlib"/>';
}
echo <<<EOF

{$sJScript}

<!--<form action="" method="post" name="dbtables">-->
<tr>
  <td class="tableh1">
        <input type="hidden" name="act" value="dodump">
        <input type="hidden" name="dbhost" value="{$XTCONFIG['dbhost']}">
        <input type="hidden" name="dbbase" value="{$XTCONFIG['dbbase']}">
        <input type="hidden" name="dbuser" value="{$XTCONFIG['dbuser']}">
        <input type="hidden" name="dbpass" value="{$XTCONFIG['dbpass']}">
        <input type="hidden" name="LastTable" value="-1">
        <input type="hidden" name="LastRow" value="-1">
        {$lang_plugin_backup['SELECT_MAKE_SELECTION']}</td>
</tr>
<tr>
        <td class="tableh2">
          <input type="checkbox" name="selc1" id="selc1" alt="Select All" onclick="if (document.frmConnex.selc1.checked==true){checkall();}else{decheckall();}" />
          <label for="selc1">{$lang_plugin_backup['SELECT_TABLE_NAME']}</label> ({$lang_plugin_backup['coppermine_tables_are_preselected']})
        </td>
</tr>

EOF;

$i = 0;
$loop_counter = 0;
while ($i < $iTablesCount)
{
        if ($loop_counter == 0) {
            $row_style_class = 'tableb';
        } else {
            $row_style_class = 'tableb tableb_alternate';
        }
        $loop_counter++;
        if ($loop_counter > 1) {
            $loop_counter = 0;
        }
        $sTmp = mysql_tablename ($aTables, $i);
        // determine if the prefix matches the gallery's prefix
        if (substr($sTmp, 0, strlen($CONFIG['TABLE_PREFIX'])) == $CONFIG['TABLE_PREFIX']) {
            $checked = ' checked="checked"';
        } else {
            $checked = '';
        }
        // output the rows
        echo <<<EOF
                <tr>
                        <td class="{$row_style_class}">
                          <input type="checkbox" id="tbls[{$i}]" name="tbls[{$i}]" value="{$sTmp}" {$checked} /><label for="tbls[{$i}]" class="clickable_option">{$sTmp}</label>
                        </td>
                <tr>

EOF;
        $i++;
}

echo <<< EOF
        <td class="tablef">
          <input type="checkbox" name="selc2" id="selc2" alt="Select All" onclick="if (document.frmConnex.selc2.checked==true){checkall();}else{decheckall();}" />
          <label for="selc2">{$lang_plugin_backup['SELECT_TABLE_NAME']}</label>
        </td>
EOF;


echo <<<EOF

        <tr>
          <td class="tableh1">
            {$lang_plugin_backup['OPTIONS_LEGEND']}
          </td>
        </tr>
        <tr>
          <td class="tableb">
            <input type="checkbox" name="SaveStruct" id="SaveStruct" checked="checked" value="1" id="SaveStruct"/>
            <label for="SaveStruct" class="clickable_option">{$lang_plugin_backup['SELECT_STRUCT']}</label>
          </td>
        </tr>
        <tr>
          <td class="tableb tableb_alternate">
            <input type="checkbox" name="SaveData" id="SaveData" checked="checked" value="1" id="SaveData"/>
            <label for="SaveData" class="clickable_option">{$lang_plugin_backup['SELECT_DATA']}</label>
          </td>
        </tr>
        <tr>
          <td class="tableb">
            <input type="checkbox" name="ChkDropTable" id="ChkDropTable" checked="checked" value="1" id="ChkDropTable"/>
            <label="ChkDropTable" class="clickable_option">{$lang_plugin_backup['SELECT_ADD_DROPTABLE']}</label>
          </td>
        </tr>
        <tr>
          <td class="tableb tableb_alternate">
            <input type="checkbox" name="ChckIfNotExists" id="ChckIfNotExists" checked="checked" value="1" id="ChckIfNotExists"/>
            <label for="ChckIfNotExists" class="clickable_option">{$lang_plugin_backup['SELECT_ADD_IFEXISTS']}</label>
          </td>
        </tr>
        <tr>
          <td class="tableb">
            {$sZlib}
            <label for="zlib" class="clickable_option">{$lang_plugin_backup['SELECT_GZIP']}</label>
          </td>
        </tr>
        <tr>
          <td class="tablef">
            {$lang_plugin_backup['SELECT_FILENAME']}
            <input type="text" name="FileName" size="60" value="{$sDefaultFileName}" id="FileName" class="textinput" />
          </td>
        </tr>
        <tr>
        <td class="tablef">
          <input type="submit" value="{$lang_plugin_backup['SELECT_SUBMIT']}" class="button" />
        </td>
        </tr>

<!--</form>-->

EOF;

?>