<?php
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2008 Dev Team
  v1.1 originally written by Gregory DEMAR

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3
  as published by the Free Software Foundation.

  ********************************************
  Coppermine version: 1.4.x
  $HeadURL$
  $Revision$
  $LastChangedBy$
  $Date$
**********************************************/
/*********************************************
  Coppermine Plugin - Automove
  ********************************************
  Copyright (c) 2009 eenemeenemuu
**********************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

$thisplugin->add_action('plugin_install','automove_install');
$thisplugin->add_action('plugin_configure','automove_configure');
$thisplugin->add_action('plugin_uninstall','automove_uninstall');
$thisplugin->add_action('page_start','automove_start');



function automove_configure() {
    global $CONFIG;
    $albumlist = cpg_db_query("SELECT aid, title FROM {$CONFIG['TABLE_ALBUMS']} ORDER BY aid ASC");
    while ($row = mysql_fetch_array($albumlist,MYSQL_ASSOC)) {
        if ($row['aid'] == $CONFIG['plugin_automove_album_to_move']) {
            $selected = "selected=\"selected\"";
        } else {
            $selected = "";
        }
        $albums .= "<option value=\"{$row['aid']}\" $selected>{$row['title']}</option>\n";
    }

    echo <<<EOT
        <form name="cpgform" id="cpgform" action="{$_SERVER['REQUEST_URI']}" method="post">
            Please choose the album where the poor rated pictures should be moved to. Please use the plugin configuration page after installation to set the needed votes and rating points. <br />
            <select name="album_to_move" class="button">
                <option>-- Please choose album --</option>
                $albums
            </select> <br />
            <input name="save" type="submit" class="button" value="Save" />
            | Back to <a href="pluginmgr.php">plugin manager</a>
        </form>
EOT;
}


function automove_install() {
    if (!is_numeric($_POST['album_to_move'])) {
        return 1;
    }

    global $CONFIG;
    if (cpg_db_query("INSERT INTO {$CONFIG['TABLE_CONFIG']} (name,value) VALUES ('plugin_automove_voting_time','24'), ('plugin_automove_last_check','".time()."'), ('plugin_automove_min_votes','0'), ('plugin_automove_min_rating','0'), ('plugin_automove_min_hits','0'), ('plugin_automove_album_to_move','{$_POST['album_to_move']}')")) {
        return TRUE;
    } else {
        return FALSE;
    }
}


function automove_uninstall() {
    global $CONFIG;
    if (cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name LIKE 'plugin_automove_%'")) {
        return TRUE;
    } else {
        return FALSE;
    }
}


function automove_start() {
    global $CONFIG, $PHP_SELF;
    $time = time();
    if ($PHP_SELF != "pluginmgr.php" && $_GET['file'] != "automove/admin") {
        if ($CONFIG['plugin_automove_last_check'] < $time - 300) { // don't check on every page load - reduce cpu load
            cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '$time' WHERE name = 'plugin_automove_last_check'");
            $voting_time = $time - 3600 * $CONFIG['plugin_automove_voting_time'];
            $pic_rating = $CONFIG['plugin_automove_min_rating'] * 2000;
            $picturelist = cpg_db_query("SELECT pid, ctime, votes, pic_rating FROM {$CONFIG['TABLE_PICTURES']} WHERE aid != {$CONFIG['plugin_automove_album_to_move']} AND ctime < $voting_time AND (votes < {$CONFIG['plugin_automove_min_votes']} OR pic_rating < $pic_rating OR hits < {$CONFIG['plugin_automove_min_hits']})");
            while ($row = mysql_fetch_array($picturelist, MYSQL_ASSOC)) {
                 cpg_db_query("UPDATE {$CONFIG['TABLE_PICTURES']} SET aid = {$CONFIG['plugin_automove_album_to_move']} WHERE pid = {$row['pid']}");
            }
        }
    }
}

?>
