<?php
/*
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://forum.coppermine-gallery.net/index.php/board,100.0.html
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */



/**
 * This page manages the upload http request. Its aim is to:
 * - Add the uploaded files into the database
 * - Calculate the thumb and normal picture.
 * - return a status to the applet, by writting one simple line. This return is:
 *     SUCCESS               (if everything is Ok)
 *     ERROR: Error message  (if some problem occurs)
 */

if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { die('Not in Jupload...');}

define('JUPLOAD_PHP_in_upload_picture', true);

$JUPLOAD_CONFIG['debug'] = 'true';
$return = "Unknow return status";
echo ("[DEBUG] upload_picture.php: Entering upload_picture.php\n");

//We don't want the cpg_die to be called. Instead, we want just the error in the script ouptut.
//see jupload_cpg_die for more informations.
$callCpgDie = false;

/*
 * Let's include the relevant files.
 */
logDebug("[upload_picture.php] Before includes");
if (JUPLOAD_CPG_VERSION == JUPLOAD_CPG_1_4) {
	logDebug("[upload_picture.php] Using include files for Coppermine 1.4");
	require_once('plugins/jupload/include1.4/j_picmgmt.inc.php');
	logDebug("[upload_picture.php] After include of j_picmgmt.inc.php");
	require_once('plugins/jupload/include1.4/j_upload_management.inc.php');
} else {
	logDebug("[upload_picture.php] Using include files for Coppermine 1.5");
	require_once('plugins/jupload/include1.5/j_picmgmt.inc.php');
	logDebug("[upload_picture.php] After include of j_picmgmt.inc.php");
	require_once('plugins/jupload/include1.5/j_upload_management.inc.php');
}
logDebug("[upload_picture.php] After include of j_upload_management.inc.php");



//The response in the HTTP body may be read by the applet and displayed to the user. It isn't HTML
//This is especially right for error codes. I force them to UTF-8:
header("Content-Type: text/plain; charset=UTF-8"); 

//If the user may not upload pictures, there is no reason for him to go on this page.
//USER_CAN_CREATE_ALBUMS: seems to indicate that the user may have its personnal gallery (at least for the admin)
if (!USER_CAN_UPLOAD_PICTURES && !USER_CAN_CREATE_ALBUMS) {
	$msg = str_replace('$1', 'login.php?referer=plugins/jupload/jupload.php', $lang_jupload_php['perm_denied']);
	//Let's send a proprer error message, so that the applet can read it.	
	die("ERROR: $msg\n");
}

//If JUpload has to manage its own user's session, and we're here: the user may upload picture.
//Let's save the current one, for the next call to the server.
//echo ("[DEBUG] upload_picture.php: Before saveJuploadInternalSessionIfConfiguredTo\n");
//saveJuploadInternalSessionIfConfiguredTo(5, false);
//echo ("[DEBUG] upload_picture.php: After saveJuploadInternalSessionIfConfiguredTo\n");
logDebug("jupload.php: Using Coppermine USER_DATA");
if ($USER_DATA['user_id']) {
	logDebug("jupload.php: The connected user is " . $USER_DATA['user_id'] . ': ' . $USER_DATA['user_name']);
} else {
	logDebug("jupload.php: No user has been found !");
}



//####################################################################################################
//#################################  MAIN CODE BLOC  #################################################
//####################################################################################################


//Note: 
// When in chunk mode, Coppermine controls the size of the last chunk, and not the size of the whole uploaded
//file, that may have been split into several chunk.

//If the maxFileSize is defined in the Jupload configuration, it overrides the Coppermine configuration
if ($JUPLOAD_CONFIG['maxNonTransformedPictureSize'] > 0) {
	$CONFIG['max_upl_size'] = $JUPLOAD_CONFIG['maxNonTransformedPictureSize'];
}

//Let's read the _FILES array. What to do, depend on the script parameters: is the file sent in one piece, 
//or in several chunks.
logDebug ("upload_picture.php: Before handle_uploaded_files");
handle_uploaded_files('userpicture');
logDebug ("upload_picture.php: After handle_uploaded_files");


//Some tries, to validate the CR, LF and CRLF management in the applet.

echo("End of upload_picture.php\n");
