<?php
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2008 Dev Team
  v1.1 originally written by Gregory DEMAR

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3
  as published by the Free Software Foundation.
  
  ********************************************
  Coppermine version: 1.4.21
  $HeadURL: https://coppermine.svn.sourceforge.net/svnroot/coppermine/trunk/cpg1.4.x/themes/classic/theme.php $
  $Revision: 4392 $
  $Author: gaugau $
  $Date: 2009-03-24 16:55:00 +0100 (Mo, 24 Mar 2009) $
**********************************************/

//define('THEME_IS_XHTML10_TRANSITIONAL',1);
define('THEME_HAS_FILM_STRIP_GRAPHIC', 1); 
define('THEME_HAS_MENU_ICONS', 16);
defined('THEME_HAS_VANITY_GRAPHICS');
define('THEME_IS_XHTML10_TRANSITIONAL',1);

// These parameters overide what the user inputs in the Configuration setup to prevent the theme from breaking.
$CONFIG['max_film_strip_items'] = 5; //overrides the number of thumbnails.
$CONFIG['thumbcols'] = 4; //overrides the number of columns for thumbnails.
$CONFIG['main_table_width'] = '100%'; //overrides the Width of the main table (pixels or %).
$CONFIG['picture_table_width'] = '100%'; //overrides the Width of the table for file display (pixels or %).
$CONFIG['album_list_cols'] = 2; // sets "Number of columns for the album list = 2"
$CONFIG['first_level'] = 1; //sets "Show first level album thumbnails in categories = no".

// HTML template for template sys_menu spacer
$template_sys_menu_spacer ="&raquo;";

if (!isset($template_sub_menu)) { //{THEMES}
/******************************************************************************
** Section <<<$template_sub_menu>>> - START
******************************************************************************/
// HTML template for sub_menu
$template_sub_menu = <<<EOT

<div id="tabs" style="margin-top: 0px;">
   <ul>
<!-- BEGIN custom_link -->
     <li class="activetab"><a href="{CUSTOM_LNK_TGT}" title="{CUSTOM_LNK_TITLE}"><span>{CUSTOM_LNK_LNK}</span></a></li>
<!-- END custom_link -->
<!-- BEGIN album_list -->
     <li class="activetab"><a href="{ALB_LIST_TGT}" title="{ALB_LIST_TITLE}"><span>{ALB_LIST_LNK}</span></a></li>
<!-- END album_list -->
	<li><a href="{LASTUP_TGT}"><span>{LASTUP_LNK}</span></a></li>
	<li><a href="{LASTCOM_TGT}"><span>{LASTCOM_LNK}</span></a></li>
	<li><a href="{TOPN_TGT}"><span>{TOPN_LNK}</span></a></li>
	<li><a href="{TOPRATED_TGT}"><span>{TOPRATED_LNK}</span></a></li>
	<li><a href="{FAV_TGT}"><span>{FAV_LNK}</span></a></li>
	<li><a href="{SEARCH_TGT}"><span>{SEARCH_LNK}</span></a></li>
   </ul>
</div>

EOT;
/******************************************************************************
** Section <<<$template_sub_menu>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_gallery_admin_menu)) { //{THEMES}
/******************************************************************************
** Section <<<$template_gallery_admin_menu>>> - START
******************************************************************************/
// HTML template for gallery admin menu
$template_gallery_admin_menu = <<<EOT

<div class="forabg" style="margin-right: 1px;">
  <div class="inner"> <span class="corners-top"><span></span></span>
	<ul class="topiclist">
	  <li class="header">
		<dl class="icon">
          <dt style="width: 100%;">{ADMIN_LNK}</dt>
        </dl>
      </li>
    </ul>
	<ul class="topiclist forums">
	<li class="row bg1">
		<dl class="icon">
          <dd style="width: 100%;">
		 
           <div class="admin_menu_wrapper">
			<!-- BEGIN admin_approval -->
				<a href="editpics.php?mode=upload_approval" title="{UPL_APP_TITLE}"><span class="admin_float">{UPL_APP_ICO}{UPL_APP_LNK}</span></a>
			<!-- END admin_approval -->
			<!-- BEGIN config -->
				<a href="admin.php" title="{ADMIN_TITLE}"><span class="admin_float">{ADMIN_ICO}{ADMIN_LNK}</span></a>
			<!-- END config -->
			<!-- BEGIN catmgr -->
				<a href="catmgr.php" title="{CATEGORIES_TITLE}"><span class="admin_float">{CATEGORIES_ICO}{CATEGORIES_LNK}</span></a>
			<!-- END catmgr -->
			<!-- BEGIN albmgr -->
				<a href="albmgr.php{CATL}" title="{ALBUMS_TITLE}"><span class="admin_float">{ALBUMS_ICO}{ALBUMS_LNK}</span></a>
			<!-- END albmgr -->
			<!-- BEGIN picmgr -->
				<a href="picmgr.php" title="{PICTURES_TITLE}"><span class="admin_float">{PICTURES_ICO}{PICTURES_LNK}</span></a>
			<!-- end picmgr -->
			<!-- BEGIN groupmgr -->
				<a href="groupmgr.php" title="{GROUPS_TITLE}"><span class="admin_float">{GROUPS_ICO}{GROUPS_LNK}</span></a>
			<!-- END groupmgr -->
			<!-- BEGIN usermgr -->
				<a href="usermgr.php" title="{USERS_TITLE}"><span class="admin_float">{USERS_ICO}{USERS_LNK}</span></a>
			<!-- END usermgr -->
			<!-- BEGIN banmgr -->
				<a href="banning.php" title="{BAN_TITLE}"><span class="admin_float">{BAN_ICO}{BAN_LNK}</span></a>
			<!-- END banmgr -->
			<!-- BEGIN admin_profile -->
				<a href="profile.php?op=edit_profile" title="{MY_PROF_TITLE}"><span class="admin_float">{MY_PROF_ICO}{MY_PROF_LNK}</span></a>
			<!-- END admin_profile -->
			<!-- BEGIN review_comments -->
				<a href="reviewcom.php" title="{COMMENTS_TITLE}"><span class="admin_float">{COMMENTS_ICO}{COMMENTS_LNK}</span></a>
			<!-- END review_comments -->
			<!-- BEGIN log_ecards -->
				<a href="db_ecard.php" title="{DB_ECARD_TITLE}"><span class="admin_float">{DB_ECARD_ICO}{DB_ECARD_LNK}</span></a>
			<!-- END log_ecards -->
			<!-- BEGIN batch_add -->
				<a href="searchnew.php" title="{SEARCHNEW_TITLE}"><span class="admin_float">{SEARCHNEW_ICO}{SEARCHNEW_LNK}</span></a>
			<!-- END batch_add -->
			<!-- BEGIN admin_tools -->
				<a href="util.php?t={TIME_STAMP}#admin_tools" title="{UTIL_TITLE}"><span class="admin_float">{UTIL_ICO}{UTIL_LNK}</span></a>
			<!-- END admin_tools -->
			<!-- BEGIN keyword_manager -->
				<a href="keywordmgr.php" title="{KEYWORDMGR_TITLE}"><span class="admin_float">{KEYWORDMGR_ICO}{KEYWORDMGR_LNK}</span></a>
			<!-- END keyword_manager -->
			<!-- BEGIN exif_manager -->
				<a href="exifmgr.php" title="{EXIFMGR_TITLE}"><span class="admin_float">{EXIFMGR_ICO}{EXIFMGR_LNK}</span></a>
			<!-- END exif_manager -->
			<!-- BEGIN plugin_manager -->
				<a href="pluginmgr.php" title="{PLUGINMGR_TITLE}"><span class="admin_float">{PLUGINMGR_ICO}{PLUGINMGR_LNK}</span></a>
			<!-- END plugin_manager -->
			<!-- BEGIN bridge_manager -->
				<a href="bridgemgr.php" title="{BRIDGEMGR_TITLE}"><span class="admin_float">{BRIDGEMGR_ICO}{BRIDGEMGR_LNK}</span></a>
			<!-- END bridge_manager -->
			<!-- BEGIN view_log_files -->
				<a href="viewlog.php" title="{VIEW_LOG_FILES_TITLE}"><span class="admin_float">{VIEW_LOG_FILES_ICO}{VIEW_LOG_FILES_LNK}</span></a>
			<!-- END view_log_files -->
			<!-- BEGIN overall_stats -->
				<a href="stat_details.php?type=hits&amp;sort=sdate&amp;dir=&amp;sdate=1&amp;ip=1&amp;search_phrase=0&amp;referer=0&amp;browser=1&amp;os=1&amp;mode=fullscreen&amp;page=1&amp;amount=50" title="{OVERALL_STATS_TITLE}"><span class="admin_float">{OVERALL_STATS_ICO}{OVERALL_STATS_LNK}</span></a>
			<!-- END overall_stats -->
			<!-- BEGIN check_versions -->
				<a href="versioncheck.php" title="{CHECK_VERSIONS_TITLE}"><span class="admin_float">{CHECK_VERSIONS_ICO}{CHECK_VERSIONS_LNK}</span></a>
			<!-- END check_versions -->
			<!-- BEGIN update_database -->
				<a href="update.php" title="{UPDATE_DATABASE_TITLE}"><span class="admin_float">{UPDATE_DATABASE_ICO}{UPDATE_DATABASE_LNK}</span></a>
			<!-- END update_database -->
			<!-- BEGIN export -->
			    <a href="export.php" title="{EXPORT_TITLE}"><span class="admin_float">{EXPORT_ICO}{EXPORT_LNK}</span></a>
			<!-- END export -->
			<!-- BEGIN php_info -->
				<a href="phpinfo.php" title="{PHPINFO_TITLE}"><span class="admin_float">{PHPINFO_ICO}{PHPINFO_LNK}</span></a>
			<!-- END php_info -->
			<!-- BEGIN show_news -->
				<a href="mode.php?what=news&amp;referer=$REFERER" title="{SHOWNEWS_TITLE}"><span class="admin_float">{SHOWNEWS_ICO}{SHOWNEWS_LNK}</span></a>
			<!-- END show_news -->
			<!-- BEGIN documentation -->
				<a href="{DOCUMENTATION_HREF}" title="{DOCUMENTATION_TITLE}"><span class="admin_float">{DOCUMENTATION_ICO}{DOCUMENTATION_LNK}</span></a>
			<!-- END documentation -->
		 
		  </dd>
        </dl>
      </li>
    </ul>
    <span class="corners-bottom"><span></span></span> </div>
</div>

EOT;
/******************************************************************************
** Section <<<$template_gallery_admin_menu>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_user_admin_menu)) { //{THEMES}
/******************************************************************************
** Section <<<$template_user_admin_menu>>> - START
******************************************************************************/
// HTML template for user admin menu
$template_user_admin_menu = <<<EOT

<div class="forabg" style="margin-right: 1px;">
  <div class="inner"> <span class="corners-top"><span></span></span>
	<ul class="topiclist">
	  <li class="header">
		<dl class="icon">
          <dt style="width: 100%;">{ALBMGR_LNK}</dt>
        </dl>
      </li>
    </ul>
	<ul class="topiclist forums">
	<li class="row bg1">
		<dl class="icon">
          <dd style="width: 100%;">
		 
                <div align="center">
                <table cellpadding="0" cellspacing="1">
                        <tr>
                                <td class="admin_menu"><a href="albmgr.php" title="{ALBMGR_TITLE}">{ALBUMS_ICO}{ALBMGR_LNK}</a></td>
                                <td class="admin_menu"><a href="modifyalb.php" title="{MODIFYALB_TITLE}">{MODIFYALB_ICO}{MODIFYALB_LNK}</a></td>
                                <td class="admin_menu"><a href="profile.php?op=edit_profile" title="{MY_PROF_TITLE}">{MY_PROF_ICO}{MY_PROF_LNK}</a></td>
                                <td class="admin_menu"><a href="picmgr.php" title="{PICTURES_TITLE}">{PICTURES_ICO}{PICTURES_LNK}</a></td>
                        </tr>
                </table>
                </div>
		 
		  </dd>
        </dl>
      </li>
    </ul>
    <span class="corners-bottom"><span></span></span> </div>
</div>

EOT;
/******************************************************************************
** Section <<<$template_user_admin_menu>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_thumb_view_title_row)) { //{THEMES}
/******************************************************************************
** Section <<<$template_thumb_view_title_row>>> - START
******************************************************************************/
// HTML template for title row of the thumbnail view (album title + sort options)
$template_thumb_view_title_row = <<<EOT

	  <table width="100%" cellpadding="0" cellspacing="0">
	  <tr>
			  <td width="100%" class="statlink"><h4>{ALBUM_NAME}</h2></td>
			  <td><img src="images/spacer.gif" width="1" alt="" /></td>
			  <td class="sortorder_cell" id="sortorder_cell">
				  <!-- Use JavaScript to display the sorting options only to humans, but hide them from search engines to avoid double-content indexing (js/thumbnails.js) -->
			  </td>
	  </tr>
	  </table>

EOT;
/******************************************************************************
** Section <<<$template_thumb_view_title_row>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_thumbnail_view)) { //{THEMES}
/******************************************************************************
** Section <<<$template_thumbnail_view>>> - START
******************************************************************************/
// HTML template for thumbnails display
$template_thumbnail_view = <<<EOT

<!-- BEGIN header -->
        <tr>
<!-- END header -->
<!-- BEGIN thumb_cell -->
        <td valign="top" class="thumbnails" width ="{CELL_WIDTH}" align="center">
		
<div class="forabg" style="margin-right: 1px;">
  <div class="inner"> <span class="corners-top"><span></span></span>
	<ul class="topiclist">
	  <li class="header">
		<dl class="icon">
          <dt style="width: 100%;">&nbsp;</dt>
        </dl>
      </li>
    </ul>
	<ul class="topiclist forums">
	<li class="row bg1">
		<dl class="icon">
          <dd style="width: 100%;">
		
                <table width="100%" cellpadding="0" cellspacing="0">
                        <tr>
                                <td align="center">
                                        <a href="{LINK_TGT}">{THUMB}<br /></a>
                                        {CAPTION}
                                        {ADMIN_MENU}
                                </td>
                        </tr>
                </table>
           
		  </dd>
        </dl>
      </li>
    </ul>
    <span class="corners-bottom"><span></span></span> </div>
</div>

       </td>
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
                <td valign="top" class="thumbnails" align="center">&nbsp;</td>
<!-- END empty_cell -->
<!-- BEGIN row_separator -->
        </tr>
        <tr>
<!-- END row_separator -->
<!-- BEGIN footer -->
        </tr>
<!-- END footer -->
<!-- BEGIN tabs -->
        <tr>
                <td colspan="{THUMB_COLS}" style="padding: 0px;">
                        <table width="100%" cellspacing="0" cellpadding="0">
                                <tr>
                                       {TABS}
                                </tr>
                        </table>
                </td>
        </tr>
<!-- END tabs -->
<!-- BEGIN spacer -->
        <img src="images/spacer.gif" width="1" height="7" border="" alt="" /><br />
<!-- END spacer -->

EOT;
/******************************************************************************
** Section <<<$template_thumbnail_view>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_image_rating)) { //{THEMES}
/******************************************************************************
** Section <<<$template_image_rating>>> - START
******************************************************************************/
// HTML template for the image rating box
$template_image_rating = <<<EOT

<div class="forabg" style="margin-right: 1px;">
  <div class="inner"> <span class="corners-top"><span></span></span>
	<ul class="topiclist">
	  <li class="header">
		<dl class="icon">
          <dt style="width: 100%;"><b>{TITLE}</b> {VOTES}</dt>
        </dl>
      </li>
    </ul>
	<ul class="topiclist forums">
	<li class="row bg1">
		<dl class="icon">
          <dd style="width: 100%;">

			<table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable">
					<tr  id="rating_stars">
						<td class="tableb" id="star_rating" ></td>
					</tr>
				<noscript>
					<tr>
					  <td class="tableb" colspan="6" align="center">{JS_WARNING}</td>
					</tr>
					</noscript>
			</table>
          
		  </dd>
        </dl>
      </li>
    </ul>
    <span class="corners-bottom"><span></span></span> </div>
</div>

EOT;
/******************************************************************************
** Section <<<$template_image_rating>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_image_comments)) { //{THEMES}
/******************************************************************************
** Section <<<$template_image_comments>>> - START
******************************************************************************/
// HTML template for the display of comments
$template_image_comments = <<<EOT

<div class="forabg" style="margin-right: 1px;">
  <div class="inner"> <span class="corners-top"><span></span></span>
	<ul class="topiclist">
	  <li class="header">
		<dl class="icon">
          <dt style="width: 100%;">{ADD_YOUR_COMMENT}</dt>
        </dl>
      </li>
    </ul>
	<ul class="topiclist forums">
	<li class="row bg1">
		<dl class="icon">
          <dd style="width: 100%;">
          
<table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable" border="0">

        <tr>
                <td>
                        <table width="100%" cellpadding="0" cellspacing="0">
                           <tr>
                                <td class="tableh2" nowrap="nowrap">
                                        <strong>{MSG_AUTHOR_LNK}</strong><a name="comment{MSG_ID}"></a>&nbsp;
<!-- BEGIN ipinfo -->
                                                                                 ({IP})
<!-- END ipinfo -->

</td>


                                <td class="tableh2" align="right" width="100%">
<!-- BEGIN report_comment_button -->
     <a href="report_file.php?pid={PID}&amp;msg_id={MSG_ID}&amp;what=comment" title="{REPORT_COMMENT_TITLE}">{REPORT_COMMENT_ICON}</a>
<!-- END report_comment_button -->
<!-- BEGIN pending approval -->
                                        {PENDING_APPROVAL}
<!-- END pending approval -->
<!-- BEGIN buttons -->
                                        <script type="text/javascript">
                                          document.write('<a href="javascript:;" onclick="blocking(\'cbody{MSG_ID}\',\'\', \'block\'); blocking(\'cedit{MSG_ID}\',\'\', \'block\'); return false;" title="{EDIT_TITLE}">{EDIT_ICON}</a>');
                                        </script>
                                        <a href="delete.php?msg_id={MSG_ID}&amp;what=comment" onclick="return confirm('{CONFIRM_DELETE}');" title="{DELETE_TITLE}">{DELETE_ICON}</a>
<!-- END buttons -->
                                </td>
                                <td class="tableh2" align="right" nowrap="nowrap">
                                        <span class="comment_date">[{MSG_DATE}]</span>
                                </td></tr>
                        </table>
                </td>
        </tr>
        <tr>
                <td class="tableb tableb_alternate">
                        <div id="cbody{MSG_ID}" style="display:block">
                                {MSG_BODY}
                        </div>
                        <div id="cedit{MSG_ID}" style="display:none">
<!-- BEGIN edit_box_smilies -->
                                <form name="f{MSG_ID}" id="f{MSG_ID}" method="post" action="db_input.php">
                                    <table width="100%" cellpadding="0" cellspacing="0">
                                        <tr>
                                            <td valign="top">
                                                <!--<input type="text" name="msg_author" value="{MSG_AUTHOR}" class="textinput" size="25" />-->
                                                <input type="hidden" name="event" value="comment_update" />
                                                <input type="hidden" name="msg_id" value="{MSG_ID}" />
                                                </td>
                                                </tr>
                                                <tr>
                                                <td width="80%">
                                                        <textarea cols="40" rows="2" class="textinput" name="msg_body" onselect="storeCaret_f{MSG_ID}(this);" onclick="storeCaret_f{MSG_ID}(this);" onkeyup="storeCaret_f{MSG_ID}(this);" style="width: 100%;">{MSG_BODY_RAW}</textarea>
                                                </td>
                                                <td class="tableb tableb_alternate">
                                                </td>
                                                <td>
                                                        <input type="submit" class="button" name="submit" value="{OK}" />
                                                </td>
                                                </form>
                                        </tr>
                                        <tr>
                                                <td colspan="3">
                                                    <img src="images/spacer.gif" width="1" height="2" border="0" alt="" />
                                                    <br />
                                                </td>
                                        </tr>
                                </table>
                                {SMILIES}
<!-- END edit_box_smilies -->
<!-- BEGIN edit_box_no_smilies -->
                                <table width="100%" cellpadding="0" cellspacing="0">
                                        <tr>
                                                <form name="f{MSG_ID}" id="f{MSG_ID}" method="POST" action="db_input.php">
                                                <input type="hidden" name="event" value="comment_update" />
                                                <input type="hidden" name="msg_id" value="{MSG_ID}" />
                                                <td>
                                                <!--<input type="text" name="msg_author" value="{MSG_AUTHOR}" class="textinput" size="25" />-->
                                                </td>
                                        </tr>
                                        <tr>
                                                <td width="100%">
                                                        <textarea cols="40" rows="2" class="textinput" name="msg_body" style="width: 100%;">{MSG_BODY_RAW}</textarea>
                                                </td>
                                                <td class="tableb tableb_alternate">
                                                </td>
                                                <td>
                                                        <input type="submit" class="button" name="submit" value="{OK}" />
                                                </td>
                                                </form>
                                        </tr>
                                        <tr>
                                                <td colspan="3"><img src="images/spacer.gif" width="1" height="2" border="0" alt="" /><br /></td>
                                        </tr>
                                </table>
<!-- END edit_box_no_smilies -->
                        </div>
                </td>
        </tr>
</table>
          
		  </dd>
        </dl>
      </li>
    </ul>
    <span class="corners-bottom"><span></span></span> </div>
</div>

EOT;
/******************************************************************************
** Section <<<$template_image_comments>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_add_your_comment)) { //{THEMES}
/******************************************************************************
** Section <<<$template_add_your_comment>>> - START
******************************************************************************/
$template_add_your_comment = <<<EOT

<div class="forabg" style="margin-right: 1px;">
  <div class="inner"> <span class="corners-top"><span></span></span>
	<ul class="topiclist">
	  <li class="header">
		<dl class="icon">
          <dt style="width: 100%;">{ADD_YOUR_COMMENT}</dt>
        </dl>
      </li>
    </ul>
	<ul class="topiclist forums">
	<li class="row bg1">
		<dl class="icon">
          <dd style="width: 100%;">
          
        <form method="post" name="post" id="post" action="db_input.php">
                <table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable">
                    <tr>
                        <td width="100%" class="tableh2">{ADD_YOUR_COMMENT}{HELP_ICON}</td>
                    </tr>
                    <tr>
                        <td colspan="1">
                        <table width="100%" cellpadding="0" cellspacing="0">

<!-- BEGIN user_name_input -->
                                                        <tr>
                               <td class="tableb tableb_alternate">
                                        {NAME}
                                </td>
                                <td class="tableb tableb_alternate">
                                        <input type="text" class="textinput" name="msg_author" size="10" maxlength="20" value="{USER_NAME}" />
                                </td>
<!-- END user_name_input -->
<!-- BEGIN input_box_smilies -->
                                <td class="tableb tableb_alternate">
                                {COMMENT}
                                                                </td>
                                <td width="100%" class="tableb tableb_alternate">
                                <input type="text" class="textinput" id="message" name="msg_body" onselect="storeCaret_post(this);" onclick="storeCaret_post(this);" onkeyup="storeCaret_post(this);" maxlength="{MAX_COM_LENGTH}" style="width: 100%;" />
                                                                </td>
<!-- END input_box_smilies -->
<!-- BEGIN input_box_no_smilies -->
                                <td class="tableb tableb_alternate">
                                {COMMENT}
                                                                </td>
                                <td width="100%" class="tableb tableb_alternate">
                                <input type="text" class="textinput" id="message" name="msg_body"  maxlength="{MAX_COM_LENGTH}" style="width: 100%;" />
                                </td>
<!-- END input_box_no_smilies -->
<!-- BEGIN submit -->
                                <td class="tableb tableb_alternate">
                                <input type="hidden" name="event" value="comment" />
                                <input type="hidden" name="pid" value="{PIC_ID}" />
                                <input type="submit" class="button" name="submit" value="{OK}" onclick="return notDefaultUsername(this.form, '{DEFAULT_USERNAME}', '{DEFAULT_USERNAME_MESSAGE}');" />
                                </td>
<!-- END submit -->
                                                        </tr>
<!-- BEGIN comment_captcha -->
                                                        <tr>
                                <td class="tableb tableb_alternate" colspan="2">
                                  {CONFIRM}
                                </td>
                                <td class="tableb tableb_alternate" colspan="2">
                                  <input type="text" name="confirmCode" size="5" maxlength="5" class="textinput" />
                                  <img src="captcha.php" align="middle" border="0" alt="" />
                                </td>
                                                        </tr>
<!-- END comment_captcha -->
                        </table>
                </td>
        </tr>
<!-- BEGIN smilies -->
        <tr>
                <td width="100%" class="tableb tableb_alternate">
                        {SMILIES}
                </td>
        </tr>
<!-- END smilies -->
<!-- BEGIN login_to_comment -->
        <tr>
                                <td class="tableb tableb_alternate" colspan="2">
                                  {LOGIN_TO_COMMENT}
                                </td>
        </tr>
<!-- END login_to_comment -->
                </table>
          
		  </dd>
        </dl>
      </li>
    </ul>
    <span class="corners-bottom"><span></span></span> </div>
</div>

        </form>
        
EOT;
/******************************************************************************
** Section <<<$template_add_your_comment>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_display_media)) { //{THEMES}
/******************************************************************************
** Section <<<$template_display_media>>> - START
******************************************************************************/
// HTML template for intermediate image display
$template_display_media = <<<EOT

<td align="center" valign="top" height="{CELL_HEIGHT}" style="padding: 0px;">
				
<div class="forabg" style="margin-right: 1px;">
  <div class="inner"> <span class="corners-top"><span></span></span>
	<ul class="topiclist">
	  <li class="header">
		<dl class="icon">
          <dt style="width: 100%;">&nbsp;</dt>
        </dl>
      </li>
    </ul>
	<ul class="topiclist forums">
	<li class="row bg1">
		<dl class="icon">
          <dd style="width: 100%;">
		
        <table cellspacing="2" cellpadding="0" class="imageborder">
        <tr>
                <td align="center" class="display_media" nowrap="nowrap">
                        <table cellspacing="2" cellpadding="0" >
                                <tr>
                                        <td align="center" style="{SLIDESHOW_STYLE}">
                                                {IMAGE}
                                        </td>
                                </tr>
                        </table>
                </td>
            </tr>
            <tr>
                <td>
                <table width="100%" cellspacing="2" cellpadding="0" class="tableb tableb_alternate">
                                <tr>
                                        <td align="center">
                                                {ADMIN_MENU}
                                        </td>
                                </tr>
                </table>


<!-- BEGIN img_desc -->
                        <table cellpadding="0" cellspacing="0" class="tableb tableb_alternate" width="100%">
<!-- BEGIN title -->
                                <tr>
                                        <td class="tableb tableb_alternate"><h1 class="pic_title">
                                                {TITLE}
                                        </h1></td>
                                </tr>
<!-- END title -->
<!-- BEGIN caption -->
                                <tr>
                                        <td class="tableb tableb_alternate"><h2 class="pic_caption">
                                                {CAPTION}
                                        </h2></td>
                                </tr>
<!-- END caption -->
                        </table>
<!-- END img_desc -->
                </td>
        </tr>
        </table>
          
		  </dd>
        </dl>
      </li>
    </ul>
    <span class="corners-bottom"><span></span></span> </div>
</div>
		
</td>

EOT;
/******************************************************************************
** Section <<<$template_display_media>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_film_strip)) { //{THEMES}
/******************************************************************************
** Section <<<$template_film_strip>>> - START
******************************************************************************/
// HTML template for filmstrip display
$template_film_strip = <<<EOT

<tr><td>
				
	<table width="100%" cellspacing="0" cellpadding="0">			
		<tr>
          <td valign="top" class="filmstrip_background" style="background-image: url({TILE1});"><img src="{TILE1}" alt="" border="0" /></td>
		<td>
         	<div id="film" style="{SET_WIDTH}"><table class="tape"><tr><td>{THUMB_STRIP}</td></tr></table></div>
		</td> 
         <td valign="top" class="filmstrip_background" style="background-image: url({TILE2});"><img src="{TILE2}" alt="" border="0" /></td>
        </tr>
	</table>
		
</td></tr>
<!-- BEGIN thumb_cell -->
			<table width="100%" cellspacing="0" cellpadding="0">
			<tr>
                <td class="thumb">
                  <a href="{LINK_TGT}" class="thumbLink" style="{ONE_WIDTH}">{THUMB}</a>
                </td>
			</tr>
			</table>
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
                <td valign="top" align="center">&nbsp;</td>
<!-- END empty_cell -->

EOT;
/******************************************************************************
** Section <<<$template_film_strip>>> - END
******************************************************************************/
} //{THEMES}

if (!function_exists('theme_display_film_strip')) {  //{THEMES}
/******************************************************************************
** Section <<<theme_display_film_strip>>> - START
******************************************************************************/
// Function to display the film strip
function theme_display_film_strip(&$thumb_list, $nbThumb, $album_name, $aid, $cat, $pos, $sort_options, $mode = 'thumb', $date='', $filmstrip_prev_pos, $filmstrip_next_pos,$max_block_items,$thumb_width)
{
    global $CONFIG, $THEME_DIR;
    global $template_film_strip, $lang_film_strip;

    static $template = '';
    static $thumb_cell = '';
    static $empty_cell = '';
    static $spacer = '';

    if ((!$template)) {
        $template = $template_film_strip;
        $thumb_cell = template_extract_block($template, 'thumb_cell');
        $empty_cell = template_extract_block($template, 'empty_cell');
    }

    $cat_link = is_numeric($aid) ? '' : '&cat=' . $cat;

    $thumbcols = $CONFIG['thumbcols'];
    $cell_width = ceil(100 / $CONFIG['max_film_strip_items']) . '%';

    $i = 0;
    $thumb_strip = '';
    foreach($thumb_list as $thumb) {
        $i++;
        if ($mode == 'thumb') {
            $params = array('{CELL_WIDTH}' => $cell_width,
                '{LINK_TGT}' => "displayimage.php?album=$aid$cat_link&pos={$thumb['pos']}",
                '{THUMB}' => $thumb['image'],
                '{CAPTION}' => '',
                '{ADMIN_MENU}' => ''
                );
        } else {
            $params = array('{CELL_WIDTH}' => $cell_width,
                '{LINK_TGT}' => "index.php?cat={$thumb['cat']}",
                '{THUMB}' => $thumb['image'],
                '{CAPTION}' => '',
                '{ADMIN_MENU}' => ''
                );
        }
        $thumb_strip .= template_eval($thumb_cell, $params);
    }

    if (defined('THEME_HAS_FILM_STRIP_GRAPHICS')) {
        $tile1 = $THEME_DIR . 'images/tile1.gif';
        $tile2 = $THEME_DIR . 'images/tile2.gif';
    } elseif (defined('THEME_HAS_FILM_STRIP_GRAPHIC')) {
        $tile1=$tile2=$THEME_DIR . 'images/tile.gif';
    } else {
        $tile1=$tile2= 'images/tile.gif';
    }

    $params = array('{THUMB_STRIP}' => $thumb_strip,
        '{COLS}' => $i,
        '{TILE1}' => $tile1,
        '{TILE2}' => $tile2,
        );

    ob_start();
    starttable('');
      echo template_eval($template, $params);
    endtable();
    $film_strip = ob_get_contents();
    ob_end_clean();

    return $film_strip;
}
/******************************************************************************
** Section <<<theme_display_film_strip>>> - END
******************************************************************************/
}  //{THEMES}

if (!function_exists('theme_display_image')) {  //{THEMES}
/******************************************************************************
** Section <<<theme_display_image>>> - START
******************************************************************************/
function theme_display_image($nav_menu, $picture, $votes, $pic_info, $comments, $film_strip)
{
    global $HTTP_COOKIE_VARS, $CONFIG;

    starttable();
	    echo $nav_menu;
    endtable();
	
    starttable();
    if ($CONFIG['display_film_strip'] == 1) {
		echo "<tr><td align='center' width='200' class='tableb' valign='middle'><!-- gb before film_strip -->";
	        echo $film_strip;
		echo "</td><!-- gb after film_strip -->";
    }
		echo "<td class='tableb' valign='middle'><!-- gb before picture -->";
    		echo $picture;
		echo "</td></tr><!-- gb after picture -->";
    endtable();

    echo $votes;

    $picinfo = isset($_COOKIE['picinfo']) ? $_COOKIE['picinfo'] : ($CONFIG['display_pic_info'] ? 'block' : 'none');
    echo "<div id=\"picinfo\" style=\"display: $picinfo;\">\n";
    starttable();
    echo $pic_info;
    endtable();
    echo "</div>\n";

    echo "<div id=\"comments\">\n";
        echo $comments;
        echo "</div>\n";

}
/******************************************************************************
** Section <<<theme_display_image>>> - END
******************************************************************************/
}  //{THEMES}

if (!function_exists('starttable')) {  //{THEMES}
/******************************************************************************
** Section <<<starttable>>> - START
******************************************************************************/
// Function to start a 'standard' table
function starttable($width = '-1', $title = '', $title_colspan = '1')
{
    global $CONFIG;

    if ($width == '-1') $width = $CONFIG['picture_table_width'];
    if ($width == '100%') $width = $CONFIG['main_table_width'];
    echo <<<EOT

<!-- Start standard table -->
<div class="forabg" style="margin-right: 1px;">
  <div class="inner"> <span class="corners-top"><span></span></span>
	<ul class="topiclist">
	  <li class="header">
		<dl class="icon">
          <dt style="width: 100%;">
		
EOT;
    if ($title) {
        echo <<<EOT
		<span>$title</span>
EOT;
    }

	echo <<<EOT
		
		  </dt>
        </dl>
      </li>
    </ul>
	<ul class="topiclist forums">
	<li class="row bg1">
		<dl class="icon">
          <dd style="width: 100%;">
          
<table align="center" width="$width" cellspacing="1" cellpadding="0">
  <tr>
    <td valign="top">

EOT;
}
/******************************************************************************
** Section <<<starttable>>> - END
******************************************************************************/
}  //{THEMES}

if (!function_exists('endtable')) {  //{THEMES}
/******************************************************************************
** Section <<<endtable>>> - START
******************************************************************************/
function endtable()
{
    echo <<<EOT
    </td>
  </tr>
</table>
		 
		  </dd>
        </dl>
      </li>
    </ul>
    <span class="corners-bottom"><span></span></span> </div>
</div>
<!-- End standard table -->

EOT;
}
/******************************************************************************
** Section <<<endtable>>> - END
******************************************************************************/
}  //{THEMES}

if (!isset($template_cat_list)) { //{THEMES}
/******************************************************************************
** Section <<<$template_cat_list>>> - START
******************************************************************************/
// HTML template for the category list
$template_cat_list = <<<EOT

<!-- BEGIN header -->
        <tr>
                <td class="tableh1" width="80%" align="left">{CATEGORY}</td>
                <td class="tableh1" width="10%" align="center">{ALBUMS}</td>
                <td class="tableh1" width="10%" align="center">{PICTURES}</td>
        </tr>
<!-- END header -->
<!-- BEGIN catrow_noalb -->
        <tr>
                <td class="catrow_noalb" colspan="3"><table border="0"><tr><td align="left">{CAT_THUMB}</td><td align="left"><span class="catlink">{CAT_TITLE}</span>{CAT_DESC}</td></tr></table></td>
        </tr>
<!-- END catrow_noalb -->
<!-- BEGIN catrow -->
        <tr>
                <td class="catrow" align="left"><table border="0"><tr><td>{CAT_THUMB}</td><td><span class="catlink">{CAT_TITLE}</span>{CAT_DESC}</td></tr></table></td>
                <td class="catrow" align="center">{ALB_COUNT}</td>
                <td class="catrow" align="center">{PIC_COUNT}</td>
        </tr>
        <tr>
            <td class="tableb tableb_alternate" colspan="3">{CAT_ALBUMS}</td>
        </tr>
<!-- END catrow -->
<!-- BEGIN footer -->
        <tr>
                <td colspan="3" class="tableh1" align="center"><span class="statlink">{STATISTICS}</span></td>
        </tr>
<!-- END footer -->
<!-- BEGIN spacer -->
        <img src="images/spacer.gif" width="1" height="7" border="" alt="" /><br />
<!-- END spacer -->

EOT;
/******************************************************************************
** Section <<<$template_cat_list>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_image_comments)) { //{THEMES}
/******************************************************************************
** Section <<<$template_image_comments>>> - START
******************************************************************************/
// HTML template for the display of comments
$template_image_comments = <<<EOT
<table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable" border="0">

        <tr>
                <td>
                        <table width="100%" cellpadding="0" cellspacing="0">
                           <tr>
                                <td class="tableh2" nowrap="nowrap">
                                        <strong>{MSG_AUTHOR_LNK}</strong><a name="comment{MSG_ID}"></a>&nbsp;
<!-- BEGIN ipinfo -->
                                                                                 ({IP})
<!-- END ipinfo -->

</td>


                                <td class="tableh2" align="right" width="100%">
<!-- BEGIN report_comment_button -->
     <a href="report_file.php?pid={PID}&amp;msg_id={MSG_ID}&amp;what=comment" title="{REPORT_COMMENT_TITLE}">{REPORT_COMMENT_ICON}</a>
<!-- END report_comment_button -->
<!-- BEGIN pending approval -->
                                        {PENDING_APPROVAL}
<!-- END pending approval -->
<!-- BEGIN buttons -->
                                        <script type="text/javascript">
                                          document.write('<a href="javascript:;" onclick="blocking(\'cbody{MSG_ID}\',\'\', \'block\'); blocking(\'cedit{MSG_ID}\',\'\', \'block\'); return false;" title="{EDIT_TITLE}">{EDIT_ICON}</a>');
                                        </script>
                                        <a href="delete.php?msg_id={MSG_ID}&amp;what=comment" onclick="return confirm('{CONFIRM_DELETE}');" title="{DELETE_TITLE}">{DELETE_ICON}</a>
<!-- END buttons -->
                                </td>
                                <td class="tableh2" align="right" nowrap="nowrap">
                                        <span class="comment_date">[{MSG_DATE}]</span>
                                </td></tr>
                        </table>
                </td>
        </tr>
        <tr>
                <td class="tableb tableb_alternate">
                        <div id="cbody{MSG_ID}" style="display:block">
                                {MSG_BODY}
                        </div>
                        <div id="cedit{MSG_ID}" style="display:none">
<!-- BEGIN edit_box_smilies -->
                                <form name="f{MSG_ID}" id="f{MSG_ID}" method="post" action="db_input.php">
                                    <table width="100%" cellpadding="0" cellspacing="0">
                                        <tr>
                                            <td valign="top">
                                                <!--<input type="text" name="msg_author" value="{MSG_AUTHOR}" class="textinput" size="25" />-->
                                                <input type="hidden" name="event" value="comment_update" />
                                                <input type="hidden" name="msg_id" value="{MSG_ID}" />
                                                </td>
                                                </tr>
                                                <tr>
                                                <td width="80%">
                                                        <textarea cols="40" rows="2" class="textinput" name="msg_body" onselect="storeCaret_f{MSG_ID}(this);" onclick="storeCaret_f{MSG_ID}(this);" onkeyup="storeCaret_f{MSG_ID}(this);" style="width: 100%;">{MSG_BODY_RAW}</textarea>
                                                </td>
                                                <td class="tableb tableb_alternate">
                                                </td>
                                                <td>
                                                        <input type="submit" class="button" name="submit" value="{OK}" />
                                                </td>
                                                </form>
                                        </tr>
                                        <tr>
                                                <td colspan="3">
                                                    <img src="images/spacer.gif" width="1" height="2" border="0" alt="" />
                                                    <br />
                                                </td>
                                        </tr>
                                </table>
                                {SMILIES}
<!-- END edit_box_smilies -->
<!-- BEGIN edit_box_no_smilies -->
                                <table width="100%" cellpadding="0" cellspacing="0">
                                        <tr>
                                                <form name="f{MSG_ID}" id="f{MSG_ID}" method="POST" action="db_input.php">
                                                <input type="hidden" name="event" value="comment_update" />
                                                <input type="hidden" name="msg_id" value="{MSG_ID}" />
                                                <td>
                                                <!--<input type="text" name="msg_author" value="{MSG_AUTHOR}" class="textinput" size="25" />-->
                                                </td>
                                        </tr>
                                        <tr>
                                                <td width="100%">
                                                        <textarea cols="40" rows="2" class="textinput" name="msg_body" style="width: 100%;">{MSG_BODY_RAW}</textarea>
                                                </td>
                                                <td class="tableb tableb_alternate">
                                                </td>
                                                <td>
                                                        <input type="submit" class="button" name="submit" value="{OK}" />
                                                </td>
                                                </form>
                                        </tr>
                                        <tr>
                                                <td colspan="3"><img src="images/spacer.gif" width="1" height="2" border="0" alt="" /><br /></td>
                                        </tr>
                                </table>
<!-- END edit_box_no_smilies -->
                        </div>
                </td>
        </tr>
</table>
EOT;
/******************************************************************************
** Section <<<$template_image_comments>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_add_your_comment)) { //{THEMES}
/******************************************************************************
** Section <<<$template_add_your_comment>>> - START
******************************************************************************/
$template_add_your_comment = <<<EOT
        <form method="post" name="post" id="post" action="db_input.php">
                <table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable">
                        <tr>
                                        <td width="100%" class="tableh2">{ADD_YOUR_COMMENT}{HELP_ICON}</td>
                        </tr>
                        <tr>
                <td colspan="1">
                        <table width="100%" cellpadding="0" cellspacing="0">

<!-- BEGIN user_name_input -->
                                                        <tr>
                               <td class="tableb tableb_alternate">
                                        {NAME}
                                </td>
                                <td class="tableb tableb_alternate">
                                        <input type="text" class="textinput" name="msg_author" size="10" maxlength="20" value="{USER_NAME}" />
                                </td>
<!-- END user_name_input -->
<!-- BEGIN input_box_smilies -->
                                <td class="tableb tableb_alternate">
                                {COMMENT}
                                                                </td>
                                <td width="100%" class="tableb tableb_alternate">
                                <input type="text" class="textinput" id="message" name="msg_body" onselect="storeCaret_post(this);" onclick="storeCaret_post(this);" onkeyup="storeCaret_post(this);" maxlength="{MAX_COM_LENGTH}" style="width: 100%;" />
                                                                </td>
<!-- END input_box_smilies -->
<!-- BEGIN input_box_no_smilies -->
                                <td class="tableb tableb_alternate">
                                {COMMENT}
                                                                </td>
                                <td width="100%" class="tableb tableb_alternate">
                                <input type="text" class="textinput" id="message" name="msg_body"  maxlength="{MAX_COM_LENGTH}" style="width: 100%;" />
                                </td>
<!-- END input_box_no_smilies -->
<!-- BEGIN submit -->
                                <td class="tableb tableb_alternate">
                                <input type="hidden" name="event" value="comment" />
                                <input type="hidden" name="pid" value="{PIC_ID}" />
                                <input type="submit" class="button" name="submit" value="{OK}" onclick="return notDefaultUsername(this.form, '{DEFAULT_USERNAME}', '{DEFAULT_USERNAME_MESSAGE}');" />
                                </td>
<!-- END submit -->
                                                        </tr>
<!-- BEGIN comment_captcha -->
                                                        <tr>
                                <td class="tableb tableb_alternate" colspan="2">
                                  {CONFIRM}
                                </td>
                                <td class="tableb tableb_alternate" colspan="2">
                                  <input type="text" name="confirmCode" size="5" maxlength="5" class="textinput" />
                                  <img src="captcha.php" align="middle" border="0" alt="" />
                                </td>
                                                        </tr>
<!-- END comment_captcha -->
                        </table>
                </td>
        </tr>
<!-- BEGIN smilies -->
        <tr>
                <td width="100%" class="tableb tableb_alternate">
                        {SMILIES}
                </td>
        </tr>
<!-- END smilies -->
<!-- BEGIN login_to_comment -->
        <tr>
                                <td class="tableb tableb_alternate" colspan="2">
                                  {LOGIN_TO_COMMENT}
                                </td>
        </tr>
<!-- END login_to_comment -->
                </table>
        </form>
EOT;
/******************************************************************************
** Section <<<$template_add_your_comment>>> - END
******************************************************************************/
} //{THEMES}

if (!function_exists('theme_style_credits')) {  //{THEMES}
/******************************************************************************
** Section <<<theme_credits>>> - START
******************************************************************************/

/******************************************************************************
// Function for the credits-section
In previous versions of Coppermine the "Powered by Coppermine" used to be
obfuscated to make it hard for non-coders to remove the tag. The reason behind
this was an additional license add-on that disallowed users to change the line.
The dev team has reviewed this policy for cpg1.5.x and decided that end users
ARE allowed to change or remove the line in legal terms.
HOWEVER: We have a forum policy for the support board instead: support will
only be given for galleries that show the "Powered by Coppermine" tag
unobfuscated.
Before removing the credits, please consider this as well:
Coppermine is free software, the dev team ASKS you to keep the footer intact.
We're convinced that you should give credit where credit is due. So please think
twice before you decide to remove the tag.
******************************************************************************/
function theme_style_credits() {
    $return = <<< EOT

<span class="footer" style="padding-top:10px;display:block;visibility:visible; font-family: Verdana,Arial,sans-serif;">Theme based on <a href="http://www.phpbb.com/" title="&copy; phpBB Group" rel="external">prosilver</a> &copy; phpBB Group</span>

EOT;
    return $return;
}
/******************************************************************************
** Section <<<theme_credits>>> - END
******************************************************************************/
}  //{THEMES}

if (!function_exists('pagefooter')) {  //{THEMES}
/******************************************************************************
** Section <<<pagefooter>>> - START
******************************************************************************/
// Function for writing a pagefooter
function pagefooter()
{
    //global $HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_SERVER_VARS;
    global $USER, $USER_DATA, $CONFIG, $time_start, $query_stats, $queries;
    global $template_footer;

    $custom_footer = cpg_get_custom_include($CONFIG['custom_footer_path']);

    if ($CONFIG['debug_mode']==1 || ($CONFIG['debug_mode']==2 && GALLERY_ADMIN_MODE)) {
        cpg_debug_output();
    }

    $template_vars = array(
        '{GAL_NAME}' => $CONFIG['gallery_name'],
        '{GAL_DESCRIPTION}' => $CONFIG['gallery_description'],
        '{SYS_MENU}' => theme_main_menu('sys_menu'),
        '{SUB_MENU}' => theme_main_menu('sub_menu'),
        '{ADMIN_MENU}' => theme_admin_mode_menu(),
        '{CUSTOM_HEADER}' => $custom_header,
        '{JAVASCRIPT}' => theme_javascript_head(),
        '{CUSTOM_FOOTER}' => $custom_footer,
        '{VANITY}' => (defined('THEME_IS_XHTML10_TRANSITIONAL')) ? theme_vanity() : '',
        '{CREDITS}' => theme_credits(),
        '{THEME_CREDITS}' => theme_style_credits(),
    );

    echo template_eval($template_footer, $template_vars);
}
/******************************************************************************
** Section <<<pagefooter>>> - END
******************************************************************************/
}  //{THEMES}

?>