<?php
/**
 * CoppermineFetch :: cfimageget
 *
 * This is a support library to help grab an image from a coppermine database and display them on normal
 * HTML page by coming back as an image.  It also contains the object used by any extentions of cfimageget
 *
 * Usage:  Call this file from an img tag and it will return graphic data to you
 *
 * cfimageget.php - will return random from anywhere in the gallery
 * cfimageget.php?category=1 - will return random image from category 1
 * cfimageget.php?album=1 - will return a random image from album 1
 * cfimageget.php?album=1 - will return a random image from album 1
 *
 * Other options to add on
 * size=[thumb|int|large]
 * cmd=[last|random]
*
 * @version $Revision: 1.12 $
 * The presedence is album over category, so if you add in both - you get whatever album is looking for
 */


require_once "cpmfetch_dao.php";

// CHANGE THIS TO TRUE IF PEOPLE ARE ALLOWED QUERIES THROUGH HERE
$ALLOW_DIRECT_ACCESS = true;

if ($ALLOW_DIRECT_ACCESS && substr($_SERVER['SCRIPT_FILENAME'],-14) == "cfimageget.php") {

// This one you need to adjust unless your galler is at http://www.youname.com/photos
// If you installed right to the root of your web site, just use a /
        $urltocpm = "/galerie";

// If no cmd= is submitted, it will do this:
        $default_command = "random";

// This would allow for non-public photos to be shown if set to FALSE
        $do_not_show_private = true;

// Change these only if you know what you are doing... its determines how your photos are named
        $thumbnailprefix='thumb_';
        $intermedprefix='normal_';
        $fullsizeprefix='';

        $cpmfetch = new cfimageget($urltocpm);

// $cpmfetch->setAllowedTypes(array(".jpg",".gif",".png",".bmp"));

// Dont touch these.  Really.         Honestly.  Really.
        $cpmfetch->setThumbnailPrefix($thumbnailprefix);
        $cpmfetch->setInterPrefix($intermedprefix);
        $cpmfetch->setFullPrefix($fullsizeprefix);
        $cpmfetch->setPrivacyFlagOn($do_not_show_private);

// THIS PART IS CODE... IF YOU DID NOT KNOW THAT, DO NOT TOUCH ANYTHING BELOW (VOIDS WARRENTY)
        if (array_key_exists("cmd",$_GET)) {
                switch ($_GET['cmd']) {
                        case ('random'):
                        case ('last'):
                                $cmd_parameter = $_GET['cmd'];
                        break;
                        default:
                                $cmd_parameter = $default_command;
                                break;
                }
        } else {
                $cmd_parameter = $default_command;
        }

        if (array_key_exists("album", $_GET)) {
                $cpmfetch->setAlbumSelection($_GET['album']);
        }

        if (array_key_exists("category", $_GET)) {
                $cpmfetch->setCategorySelection($_GET['category']);
        }

        if (array_key_exists("size", $_GET)) {

                switch ($_GET['size']) {
                        case ('thumb'):
                                $cpmfetch->setDefaultPrefix($thumbnailprefix);
                                break;
                        case ('int'):
                                $cpmfetch->setDefaultPrefix($intermedprefix);
                                break;
                        case ('large'):
                                $cpmfetch->setDefaultPrefix($fullsizeprefix);
                                break;
                        default:
                                $ERROR = true;
                                $ERROR_NO = 2;
                }
        } // end size if

        switch ($cmd_parameter) {
                case('random'):
                                $resultset = $cpmfetch->getRandom();
                                break;
                case('last'):
                                $resultset = $cpmfetch->getLastAdded();
                                break;
                default:
                                //$ERROR = true;
                                //$ERROR_NO = 4;
                                break;
        }
} // END DIRECT RUN


class cfimageget {

        var $cpm;
        var $urltocpm;
        var $filepathtocpm;

        var $sourceString = "";
        var $albumSelection = "";
        var $categorySelection = "";

        var $debugMode = false;

   var $thumbnailprefix='thumb_';
        var $intermedprefix='normal_';
        var $fullsizeprefix='';
        var $defaultsize = "thumb_";

        var $allowedtypes = array('.jpg','.gif','.png');

        function cfimageget ($urltocpm_ = "") {

                if ($urltocpm_ != "") {

                if (substr($urltocpm_,-1) != '/') $urltocpm_ .= '/';

                        $this->urltocpm = $urltocpm_;
                        $this->filepathtocpm = $_SERVER['DOCUMENT_ROOT'] . $urltocpm_;

                        if (file_exists($this->filepathtocpm . '/include/config.inc.php')) {
                                include $this->filepathtocpm . '/include/config.inc.php';

                                $this->cpm = new cpm_dao($CONFIG['dbname'], $CONFIG['dbserver'],
                                                                        $CONFIG['dbuser'], $CONFIG['dbpass'], $CONFIG['TABLE_PREFIX'], $this->urltocpm);

                                $this->cpm->setPhotoPrefix($this->thumbnailprefix, $this->intermedprefix, $this->fullsizeprefix);
                                $this->setAllowedTypes($this->allowedtypes);
                        }
                        else {
                                print "ERROR: Path to Coppermine incorrect. (" . $this->filepathtocpm .'/include/config.inc.php'  .  ")";
                                // $this = "";  // Removed to support PHP5
                        }
                }
        } // end cfimageget


        function getLastAdded() {
                $resultset = $this->cpm->getLastAddedMediaFrom($this->getSourceString(),1);
                $this->_dumpPhoto($resultset);
        }

        function getRandom( ) {
                $resultset = $this->cpm->getRandomImageFrom($this->getSourceString(),1);
                $this->_dumpPhoto($resultset);
        }

        function OverridePathToCoppermine($newpath_) {
                $this->cpm->OverridePathToCoppermine($newpath_);
        }

        function OverrideUrlToCoppermine($newpath_) {
                $this->cpm->OverrideUrlToCoppermine($newpath_);
        }

        function setThumbnailPrefix($string) {
           $this->thumbnailprefix='thumb_';
                $this->cpm->setPhotoPrefix($this->thumbnailprefix, $this->intermedprefix, $this->fullsizeprefix);
        }

        function setInterPrefix($string) {
          $this->intermedprefix='n_';
          $this->cpm->setPhotoPrefix($this->thumbnailprefix, $this->intermedprefix, $this->fullsizeprefix);
        }

        function setFullPrefix($string) {
                $this->fullsizeprefix='';
                $this->cpm->setPhotoPrefix($this->thumbnailprefix, $this->intermedprefix, $this->fullsizeprefix);
        }

        function setDefaultPrefix($string) {
                $this->defaultsize =$string;
        }

   function setPrivacyFlagOn($bool) {
                $this->cpm->setPrivateLockOn($bool);
        }

        function setAlbumSelection($source) {
                $this->albumSelection = $source;
        }

        function setCategorySelection($source) {
                $this->categorySelection = $source;
        }

        function getSourceString( ) {
                $fullString = "";

                if ($this->albumSelection == "" && $this->categorySelection == "") {
                        $fullString = $this->sourceString;
                } elseif ( $this->albumSelection != "" && $this->categorySelection == "") {
                        $fullString = "album=" . $this->albumSelection;
                } elseif ( $this->categorySelection != "" && $this->albumSelection == "") {
                        $fullString = "cat=" . $this->categorySelection;
                } else {
                        $fullString = "cat=" . $this->categorySelection . ":album=" . $this->albumSelection;
                }

                return ($fullString);
        }


        function setSourceString($sources) {
                $this->sourceString = $sources;
        }

        function setAllowedTypes($filterarray) {
           $this->allowedTypes = $filterarray;
                $this->cpm->setFilter($filterarray);
        }

        function setDebugMode($bool) {
           $this->debugMode = true;
                $this->cpm->setDebugMode($bool);
        }

        function _dumpPhoto($resultset ) {
                        if (count($resultset)==0) {
                                $ERROR = true;
                                $ERROR_NO = 5;
                                $filenametoshow = './problem.gif';
                        } else {
                                $row = array_shift($resultset);
                                $filenametoshow = $_SERVER['DOCUMENT_ROOT'];
                                $filenametoshow .= $this->cpm->getImageToUse($row['pFilepath'],$row['pFilename'],$this->defaultsize);
                        }

                        switch (strtolower(substr($row[1],strrpos($row[1],'.')))) {
                                case '.jpeg':
                                case '.jpg':
                                case '.jpe':
                                        $contenttype = 'image/jpeg';
                                        break;
                                case '.gif':
                                        $contenttype = 'image/gif';
                                        break;
                                case '.png':
                                        $contenttype = 'image/png';
                                        break;
                                case '.tiff';
                                case '.tif';
                                        $contenttype = 'image/tiff';
                                        break;
                                case '.bmp'        ;
                                        $contenttype - 'application/x-MS-bmp';
                                        break;
                                default:
                                        $contenttype = 'image/jpeg';
                }

                header ("Cache-Control: must-revalidate, post-check=0, pre-check=0");
           header ("Content-Type: $contenttype");

                if ($file = fopen($filenametoshow, 'rb')) {
                   while(!feof($file) and (connection_status()==0)) {
                            print(fread($file, 1024*8));
                            flush();
                   }

                        $status = (connection_status()==0);
                           fclose($file);
                }

        }

}  //End of class

?>