/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2019 Coppermine Dev Team
  v1.0 originally written by Gregory Demar

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3
  as published by the Free Software Foundation.
  
  ********************************************
  Coppermine version: 1.5.48
  $HeadURL: https://svn.code.sf.net/p/coppermine/code/trunk/cpg1.5.x/docs/es/script.js $
  $Revision: 8884 $
**********************************************/

var linebreak = '\n';

$(function() {
    $("#toc_overall").treeview({
        collapsed: true,
        animated: "medium",
        control:"#sidetreecontrol"
    });
    $(".cpg_zebra tr:even").addClass("tableb");
    $(".cpg_zebra tr:odd").addClass("tableb_alternate");
});

function cpgDocToc() {
  if (getUrlParameters('hide_nav') == 1) {
    $('#toc').replaceWith('');
    return;
  }
var doc_toc = '';
doc_toc += '<div id="toc_collapsed" class="en">\n';
doc_toc += '<h6><a href="toc.htm" class="en">Tabla de contenidos</a></h6>\n';
doc_toc += 'Pasa el ratón por encima para expandir\n';
doc_toc += '<div align="center" class="en"><img src="../../images/icons/downdown.png" border="0" width="10" height="10" alt="" /></div>\n';
doc_toc += '</div>\n';
doc_toc += '<div id="toc_expanded" style="display:none;">\n';
doc_toc += '<h6>Tabla de contenidos (<a href="../index.htm">Selección de idioma</a>)</h6>\n';
doc_toc += '<ul id="tree">\n';
doc_toc += '  <li><a href="index.htm" class="us_es">Documentación de Coppermine</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="index.htm#about" class="es">Sobre Coppermine</a></li>\n';
doc_toc += '      <li><a href="index.htm#about_documentation" class="es">Acerca de la documentación</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="index.htm#about_documentation_conventions" class="es">Convenciones de la documentación</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="index.htm?expand_all=1#features" class="es">Características</a></li>\n';
doc_toc += '      <li><a href="quickstart.htm#about" class="en">Guía rápida</a></li>\n';
doc_toc += '      <li><a href="toc.htm" class="en">Tabla de contenidos</a></li>\n';
doc_toc += '      <li><a href="requirements.htm" class="en">Requisitos mínimos</a>\n';
doc_toc += '        <ul class="en">\n';
doc_toc += '          <li><a href="requirements.htm#what_minimum" class="en">Requisitos mínimos del servidor</a>\n';
doc_toc += '            <ul class="en">\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_webserver" class="en">Servidor Web</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_php" class="en">Soporte de PHP</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_mysql" class="en">Base de datos mySQL</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_image_library" class="en">Librería gráfica</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="requirements.htm#what_minimum_self-hosting" class="en">Actuar de servidor Web &amp; Servidor Web</a></li>\n';
doc_toc += '          <li><a href="requirements.htm#personal" class="en">Requisitos para el servidor personal</a></li>\n';
doc_toc += '          <li><a href="requirements.htm#requirements_faq" class="en">FAQ de los requisitos</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="testing.htm" class="en">Pruebas (versiones alfa/beta)</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="testing.htm#testing_support" class="en">No hay soporte para versiones alfa o beta</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_areas" class="en">Áreas que merecen atención</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_feature_list" class="en">Funcionalidades</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_report" class="en">El formato del informe</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_availability" class="en">Disponibilidad</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="languages.htm" class="en">Idiomas</a>\n';
doc_toc += '        <ul class="en">\n';
doc_toc += '          <li><a href="languages.htm#how" class="en">Cómo funcionan los idiomas en Coppermine</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="languages.htm#how_remove_language">Quitar un idioma en particular</a></li>\n';
doc_toc += '              <li><a href="languages.htm#how_language_fallback">El inglés como idioma por defecto (Language fallback)</a></li>\n';
doc_toc += '              <li><a href="languages.htm#how_scope">Ámbito de la internacionalización</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="languages.htm#language_manager">El gestor de idiomas</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="languages.htm#language_manager_controls">Controles</a></li>\n';
doc_toc += '              <li><a href="languages.htm#language_manager_columns">Columnas</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_default">Por defecto</a></li>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_name">Nombre del idioma</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_name_english">English</a>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_name_native">Native</a>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_name_custom">Custom</a>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_flag">Flag</a></li>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_file">Language file</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_file_available">Available</a>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_file_complete">Complete</a>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_file">Enabled</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="translation.htm" class="en">Guía de traducción</a>\n';
doc_toc += '            <ul class="en">\n';
doc_toc += '              <li><a href="translation.htm#translation_translators_wanted" class="en">¡Se necesitan traductores!</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_why_translate" class="en">¿Por qué traducir?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_which_languages" class="en">De qué idiomas se necesitan traducciones?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_who" class="en">¿Quién puede traducir?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_char_encoding" class="en">Juegos de caracteres</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_editors" class="en">Editores &amp; herramientas</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_full_translation" class="en">Sólo ficheros completos</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_step_by_step" class="en">Paso a paso</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_special_issues" class="en">Aspectos especiales</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_versions" class="en">Versiones de los idiomas</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_work_in_progress" class="en">Trabajo continuado</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_initial_translation" class="en">Traducciones básicas para empezar</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_older_language_files" class="en">Uso de ficheros de idioma antiguos</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_documentation" class="en">Traducir la documentación</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="translation.htm#translation_documentation_steps" class="en">Pasoa para traducir los documentos a tu idioma</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_not_exist" class="en">Asegúrate de que la traducción no existe ya</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_structure" class="en">Crea la estructura</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_copy_core" class="en">Copia los ficheros tal cual están</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_start_translating" class="en">Empieza a traducir</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_attention" class="en">Áreas en las que poner atención</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_toc" class="en">Cuidado con la tabla de contenidos</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_zip" class="en">Empaqueta y comprime tu traducción</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="translation.htm#translation_links" class="en">Para saber más</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="credits.htm" class="en">Créditos</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="credits.htm#developers" class="en">Equipo de Coppermine</a></li>\n';
doc_toc += '          <li><a href="credits.htm#contributors" class="en">Contribuciones</a></li>\n';
doc_toc += '          <li><a href="credits.htm#translators" class="en">Traductores</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="credits.htm#translators_language_file" class="en">Ficheros de idioma</a></li>\n';
doc_toc += '              <li><a href="credits.htm#translators_documentation" class="en">Documentación</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="credits.htm#codebase" class="en">Uso de código libre</a></li>\n';
doc_toc += '          <li><a href="credits.htm#acknowledgements" class="en">Reconocimientos</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="credits.htm#acknowledgements_thanks" class="en">Many Thanks</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="copyrights.htm" class="en">Licencia &amp; derechos de autor</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_copyright" class="en">Derechos de autor</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_license" class="en">Licencia</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyrights_previous_versions" class="en">Versiones anteriores</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_additional" class="en">Términos añadidos a la licencia</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="copyrights.htm#copyright_additional_preservation" class="en">Conservación de las atribuciones de autoría</a></li>\n';
doc_toc += '              <li><a href="copyrights.htm#copyright_additional_marking" class="en">Diferenciación de versiones modificadas</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_freedom" class="en">Libertad</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="known_issues.htm" class="en">Problemas conocidos</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="install.htm" class="us_es">Instalación y configuración</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="install.htm#how" class="es">Cómo instalar Coppermine</a></li>\n';
doc_toc += '      <li><a href="install.htm#what" class="es">Qué hace el instalador</a></li>\n';
doc_toc += '      <li><a href="install.htm#install_related" class="es">Información relacionada</a></li>\n';
doc_toc += '      <li><a href="install.htm#install_server_config" class="es">Configuración del servidor</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="install.htm#install_server_config_register_globals" class="es">register_globals</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="install_permissions.htm" class="en">Permisos</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="install_permissions.htm#permissions_webserver" class="en">Permisos en diferentes tipos de servidores Web</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="install_permissions.htm#chmod" class="en">Apache sobre Unix/Linux (CHMOD)</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_basics" class="en">Basicos</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_groups" class="en">Grupos en Linux</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_daemon" class="en">El servicio del Webserver</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_binary_arithmetics" class="en">Aritmética binaria</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_benefit" class="en">¿Para qué vale esto?</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_ftp" class="en">Aplicación FTP</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_website_control_panel" class="en">Panel de control del sitio Web</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_shell_access" class="en">Acceso por shell</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="install_permissions.htm#apache_windows" class="en">Apache sobre Windows</a></li>\n';
doc_toc += '              <li><a href="install_permissions.htm#iis" class="en">IIS en Windows</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="install_permissions.htm#support" class="en">Preguntar a soporte sobre problemas de permisos</a></li>\n';
doc_toc += '          <li><a href="install_permissions.htm#permissions_folders" class="en">Permisos de los directorios</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="install_screen.htm#install_screen_start" class="en">La pantalla de instalación</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="install_screen.htm#install_screen_classic" class="en">La pantalla clásica de instalación</a></li>\n';
doc_toc += '          <li><a href="install_screen.htm#install_screen_wizard" class="en">El asistente de instalación</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="auto-installers.htm" class="en">Auto-Instaladores</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="auto-installers.htm#definition" class="en">What are auto-installers?</a></li>\n';
doc_toc += '          <li><a href="auto-installers.htm#sad_story" class="en">The sad story</a></li>\n';
doc_toc += '          <li><a href="auto-installers.htm#" class="en">Why not use auto-installers</a></li>\n';
doc_toc += '          <li><a href="auto-installers.htm#no_support" class="en">No support</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="install_faq.htm" class="en">FAQ de la installación</a></li>\n';
doc_toc += '      <li><a href="uninstall.htm" class="en">Desinstalar</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="upgrading.htm" class="us_es">Actualizar la versión</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_why" class="es">¿Por qué actualizar?</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="upgrading.htm#upgrade_why_reasons" class="es">Motivos para sacar paquetes de actualización</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#upgrade_why_changelog" class="es">Log de cambios (Changelog)</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_any" class="es">Pasos necesarios para subir la versión de Coppermine (para cualquier versión)</a></li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_particular" class="es">Acciones adicionales para algunas versiones</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="upgrading.htm#upgrade_10" class="es">Actualizar desde las versiones cpg1.0,1.1,1.2.x or 1.3.x a cpg1.5.x</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#upgrade_14" class="es">Actualizar desde cpg1.4.x a cpg1.5.x</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_plugins" class="es">Plugins</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_custom_theme" class="es">Tempas pessonalizados</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_language_files" class="es">Ficheros de idioma</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_password_encryption" class="es">Cifrado de la contraseña</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_faq" class="es">Mostrar las preguntas frecuentes</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_outdated_files" class="es">Ficheros obsoletos</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_safe_mode" class="es">Modo seguro</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          <li><a href="upgrading.htm#upgrade_15" class="es">Actualizar desde versiones cpg1.5.x to a la más reciente</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#updater" class="es">El script de actualización</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_what_it_does" class="es">Qué hace</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_purpose" class="es">Propósito</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_authorization" class="es">Permisos de ejecución</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_when" class="es">¿Cuándo hay que ejecutar la actualización?</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#versioncheck" class="en">Herramienta de comprobación de versiones</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_description_start" class="en">Qué hace</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_first_run" class="en">Primera ejecución</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_options_start" class="en">Opciones</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_display_output" class="en">Salida</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_only_show_potential_errors" class="en">Mostrar sólo los posibles errores</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_hide_images" class="en">Ocultar imágenes</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_no_modification_check" class="en">No comprobar los ficheros modificados</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_no_connect_online_repository" class="en">No conectar al repositorio online</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_comparison_start" class="en">Salida de la comprobación</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_path" class="en">Ruta</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_missing" class="en">Falta</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_permissions" class="en">Permisos</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_version" class="en">Versión</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_revision" class="en">Revisión</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_modified" class="en">Modificado</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_comment" class="en">Comentario</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_repository_link" class="en">Enlace al repositorio</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_problems" class="en">Qué podría fallar al usar versioncheck</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_expect" class="en">Falsas expectativas</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_faq" class="en">FAQ del cambio de versión</a></li>\n';
doc_toc += '      <li><a href="upgrading.htm#downgrading" class="en">Volver desde cpg1.5.x a una versión anterior</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="start.htm" class="en">En marcha</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="start.htm#getting_concepts" class="en">Conceptos básicos</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_initial_configuration" class="en">Configuración inicial</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_structure" class="en">Estructura de categoría/álbum/archivo</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_resizing" class="en">Imágenes reescaladas</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_thumbnails" class="en">Miniaturas</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_intermediate" class="en">Intermedias</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_original" class="en">Originales</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_recommended" class="en">Configuraciones de reescalado recomendadas</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_nofullsize" class="en">Sin ventanas emergentes con la imagen a tamaño completo</a></li>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_nointermediate" class="en">Con ventanas emergentes de tamaño completo con máximo ahorro de espacio</a></li>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_regular" class="en">Configuración &quot;normal&quot; con uso de espacio moderado</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="start.htm#getting_admin_account" class="en">Tu cuenta de administración</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_check_uploads" class="en">Comprobar las cargas</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_consider_bridging" class="en">Considera enlazar (bridging)</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_interaction" class="en">¿Qué permites a los visitantes?</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_design" class="en">Cambia el diseño de tu galería</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_typical" class="en">Configuraciones típicas</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="start.htm#getting_typical_monolithic" class="en">Un usuario carga, los demás no interaccionan (galería monolítica)</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_typical_single_uploader_community" class="en">Un usuario carga, los demás actúan también</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_typical_multiple_uploader_closed" class="en">Varios/muchos cargan, pero no se permiten usuarios nuevos (grupo cerrado)</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="faq.htm" class="en">Preguntas frecuentes</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="faq.htm#faq_setup" class="en">Puesta en funcionamiento / Configuración</a></li>\n';
doc_toc += '      <li><a href="faq.htm#hacks" class="en">Añadidos / Modificaciones / Hacks</a></li>\n';
doc_toc += '      <li><a href="faq.htm#support_board" class="en">Foro de soporte de Coppermine (Coppermine Support board)</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="theme.htm" class="en">Temas</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="theme.htm#theme_builtin" class="en">Temas incluidos en Coppermine</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_curve">Curve</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_eyeball">Eyeball</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_hardwired">Hardwired</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_rainy_day">Rainy Day</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_sample">Sample</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_waterdrop">Waterdrop</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme.htm#theme_upgrading" class="en">Actualizando tu tema personalizado</a>\n';
doc_toc += '      <ul>\n';
doc_toc += '        <li><a href="theme_upgrade_14x-15x.htm" class="en">Conversión de temas de cpg1.4.x a cpg1.5.x</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '            <li><a href="theme_upgrade_14x-15x.htm#theme_convert_style" class="en">Edita style.css</a></li>\n';
doc_toc += '            <li><a href="theme_upgrade_14x-15x.htm#theme_convert_template" class="en">Edita template.html</a></li>\n';
doc_toc += '            <li><a href="theme_upgrade_14x-15x.htm#theme_convert_theme" class="en">Edita theme.php</a></li>\n';
doc_toc += '            <li><a href="theme_upgrade_14x-15x.htm#theme_convert_validation" class="en">Metodología de validación</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '        </li>\n';
doc_toc += '      </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme.htm#theme_files" class="en">Contenido de un tema</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_template.htm#theme_template_html" class="en">Editar template.html</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_token" class="en">Tokens del modelo</a></li>\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_important" class="en">Importante</a></li>\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_token_list" class="en">Lista de tokens en template.html</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_style_css.htm#theme_style_css" class="en">Editar style.css</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_tools" class="en">Herramientas</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_style_css.htm#theme_style_css_tools_webdev" class="en">Uso de Web Developer Toolbar</a></li>\n';
doc_toc += '                  <li><a href="theme_style_css.htm#theme_style_css_tools_editor" class="en">Editor</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_list" class="en">Lista de las clases en style.css</a></li>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_overall" class="en">Hojas de estilo adicional</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_theme_php.htm#theme_create_theme_php" class="en">Editar theme.php</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_types" class="en">Tipos de entradas</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm" class="en">El tema sample - un modelo del que copiar</a></li>\n'; //Jmatute: pendiente
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_method" class="en">Método</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_scope" class="en">Alcance</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_list" class="en">Lista de entradas in theme.php</a></li>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples" class="en">Ejemplos de temas</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="theme_examples.htm#theme_examples_content" class="en">Contenido adicional</a>\n';
doc_toc += '                        <ul>\n';
doc_toc += '                          <li><a href="theme_examples.htm#theme_examples_content_thumbnail" class="en">Contenido adicional en la página de miniaturas</a>\n';
doc_toc += '                            <ul>\n';
doc_toc += '                              <li><a href="theme_examples.htm#theme_examples_content_thumbnail_extra_row" class="en">Fila extra entre dos filas de miniaturas</a></li>\n';
doc_toc += '                              <li><a href="theme_examples.htm#theme_examples_content_thumbnail_cell" class="en">Celda extra en cada página de miniaturas</a></li>\n';
doc_toc += '                            </ul>\n';
doc_toc += '                          </li>\n';
doc_toc += '                          <li><a href="theme_examples.htm#theme_examples_content_displayimage" class="en">Contenido adicional en la página de imágenes intermedias</a>\n';
doc_toc += '                            <ul>\n';
doc_toc += '                              <li><a href="theme_examples.htm#theme_examples_content_displayimage_image" class="en">Directly next to the intermediate image</a></li>\n'; //Jmatute: pendiente
doc_toc += '                              <li><a href="theme_examples.htm#theme_examples_content_displayimage_filmstrip" class="en">Directly next to the film strip</a></li>\n'; //Jmatute: pendiente
doc_toc += '                            </ul>\n';
doc_toc += '                          </li>\n';
doc_toc += '                          <li><a href="theme_examples.htm#theme_examples_content_fullsize" class="en">Contenido adicional en la ventana emergente de tamaño completo</a></li>\n';
doc_toc += '                        </ul>\n';
doc_toc += '                      </li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_summary" class="en">Resumen</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme.htm#theme_engine" class="en">How the theme engine works</a></li>\n';
doc_toc += '      <li><a href="theme_user-contributions.htm#theme_user-contributions" class="en">Temas creados por los usuarios (contribuciones)</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_preview" class="en">Vista previa de temas creados por los usuarios</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_download" class="en">Descargar estos temas</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_install" class="en">Instalarlos</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_copyrights" class="en">Derechos de autor</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_support" class="en">Pedir soporte de estos temas</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_contributing" class="en">Contribuir con tu tema</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_create.htm#theme_create" class="en">Crear el tema personalizado</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_rename" class="en">Renombralo primero</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_tipps" class="en">Trucos, pistas y todo eso</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_wysiwyg" class="en">Uso de editores WYSIWYG</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_colors" class="en">Cambiar colores</a></li>\n';
doc_toc += '          <li><a href="theme_create_matching_page_tutorial.htm#theme_matching" class="en">Crear un tema Coppermine que combine con el diseño general de tu sitio</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_intro">Introducción</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pre-requisites">Prerequisitos</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pre-requisites_tools">Herramientas</a></li>\n';
doc_toc += '                  <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pre-requisites_skills">Conocimientos</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_examples" class="en">Ejamplo</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pick_similar" class="en">Escoge un tema similar a lo que quieres</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_start" class="en">Empieza a editar tu tema</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_placeholder_replace" class="en">Reemplaza el contenido del ejemplo con etiquetas placeholder </a></li>\n'; //JLM: pendiente
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_style" class="en">Adapta el estilo</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_test1" class="en">Primera prueba</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_template.htm#theme_template_html" class="en">Editar template.html</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_template.htm#theme_template_token" class="en">Tokens del modelo</a></li>\n';
doc_toc += '              <li><a href="theme_template.htm#theme_template_important" class="en">Importante</a></li>\n';
doc_toc += '              <li><a href="theme_template.htm#theme_template_token_list" class="en">Lista de tokens en template.html</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_theme_php.htm#theme_php" class="en">Editar theme.php</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_types" class="en">Tipos de entradas</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_sample" class="en">El tema sample - un modelo del que copiar</a></li>\n'; //Jmatute: pendiente
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_method" class="en">Método</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_scope" class="en">Alcance</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_list" class="en">Lista de entradas en theme.php</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_style_css.htm#theme_style_css" class="en">Editar style.css</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_tools" class="en">Herramientas</a></li>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_list" class="en">Lista de las clases en style.css</a></li>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_overall" class="en">Hojas de estilo adicional</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_examples.htm#theme_examples" class="en">Ejemplos de temas</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_examples.htm#theme_examples_summary" class="en">Resumen</a></li>\n';
doc_toc += '          <li><a href="theme_examples.htm#theme_examples_content" class="en">Añadir contenido</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_examples.htm#theme_examples_content_thumbnail" class="en">Contenido extra en la página de miniaturas</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_thumbnail_extra_row" class="en">Fila extra entre dos de miniaturas</a></li>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_thumbnail_cell" class="en">Celda extra en cada página de miniaturas</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_examples.htm#theme_examples_content_displayimage" class="en">Contenido extra en las vistas intermedias (displayimage.php)</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_displayimage_image" class="en">"Siguiente" directo a la imagen intermedia</a></li>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_displayimage_filmstrip" class="en">"Siguiente" directo a la tira de imágenes (film strip)</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_examples.htm#theme_examples_content_fullsize" class="en">Contenido extra en la ventana emergente de tamaño completo</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_copyright.htm" class="en">Descarga de responsabilidad de los derechos de autor (Copyright-disclaimer) en el pie de página</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_copyright.htm#theme_copyright_fair_use" class="en">Uso correcto</a>\n';
doc_toc += '          <li><a href="theme_copyright.htm#theme_copyright_unfair_use" class="en">Juego sucio</a>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="php-content.htm" class="en">Contenido dinámico (PHP-driven)</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_anycontent" class="en">Usando anycontent.php</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_header_footer" class="en">Cabeceras y pies de páginas personalizados</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_theme" class="en">Contenido dinámico dependiente del tema (theme.php)</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_core" class="en">Modificando los ficheros básicos (core files)</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_graphics.htm" class="en">Recursos gráficos de los temas</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_menu_icons" class="en">Iconos de menú</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_nav_bar" class="en">Barra de navegación de imágenes</a></li>\n'; //Jmatute: pendiente de comprobar
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_rating" class="en">Valoración de imágenes</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_film_strip" class="en">Gráficos para la tira de película</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_progress" class="en">Imagen de progreso de la carga (loader)</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="administration.htm" class="en">Administración</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="admin_menu.htm" class="en">Entradas del menú</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_user_mode" class="en">Mostrar / ocultar controles de administración</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#upload_approval" class="en">Aprobación de cargas</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#config" class="en">Configuración</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#categories" class="en">Categorías</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#albums" class="en">Álbums</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#sort_my_pictures" class="en">Ordenar mis imágenes</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#groups" class="en">Grupos</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#users" class="en">Usuarios</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#ban" class="en">Expulsar usuarios</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#my_profile" class="en">Mi perfil</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#review_comments" class="en">Revisar comentarios</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#ecard_log" class="en">Mostrar postales</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#batch_add" class="en">Añadir ficheros por lotes (Batch)</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_tools" class="en">Herramientas de administración (Reescalar imágenes)</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#keyword_manager" class="en">Gestor de palabras clave</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#plugin_manager" class="en">Gestor de plugins</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#bridge_manager" class="en">Gestor de enlaces / integración (bridges)</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#view_log" class="en">Ficheros de registro (logs)</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#stats" class="en">Estadísticas generales</a></li>\n'; //Jmatute: pendiente de preguntar en el foro
doc_toc += '          <li><a href="admin_menu.htm#versioncheck" class="en">Comprobación de versiones</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#update_database" class="en">Actualizar la base de datos</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#export" class="en">Exportar</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#phpinfo" class="en">phpinfo</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#show_news" class="en">Mostrar novedades</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#documentation" class="en">Documentación</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_mode_regular_users" class="en">Modo de administración para usuarios normales</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#user_menu_items" class="en">Entradas de administración en el manú para usuarios regulares</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="banning.htm#banning" class="en">Expulsiones</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="banning.htm#banning_whats_new" class="en">¿Qué hay de nuevo?</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_scope" class="en">Alcance</a></li>\n';
doc_toc += '          <li><a href="banning.htm#bannig_how_it_works" class="en">¿Cómo funciona?</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_by_ip_address_no_good" class="en">Por qué no se recomienda expulsar una IP</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_page" class="en">Controlses de página</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_bridged" class="en">No usar cuando esté integrado</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_todo" class="en">Pendiente</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="configuration.htm" class="us_es">Configuración</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="configuration.htm#admin_general" class="es">Configuración general</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_language" class="en">Idioma y conjunto de caracteres</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_theme" class="en">Temas (aspecto)</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_album_list" class="en">Lista de álbumes</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_thumbnail_view" class="en">Vista de miniaturas</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_image_comment" class="en">Vista de imágenes</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_comment_start" class="en">Comentarios</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_contact_start" class="en">Formulario de contacto</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_thumb_start" class="en">Miniaturas</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_picture_thumbnail" class="en">Archivos</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_watermarking" class="en">Marcas de agua</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_registration" class="en">Registro</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_user" class="en">Usuarios</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_custom" class="en">Campos personalizados para perfiles de usuarios</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_custom_image" class="en">Campos extra para descripción de imágenes</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_cookie" class="en">Cookies</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_email" class="en">Correo</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_logging" class="en">Registro de sucesos y estadísticas</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_misc" class="en">Mantenimiento</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_reset_entire_config" class="en">Restaurar valores de fábrica</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="groups.htm" class="en">Grupos</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="groups.htm#group_cp" class="en">El panel de control de grupos</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_names" class="en">Nombres</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_types" class="en">Tipos</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_quota" class="en">Cuota de disco</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_permissions" class="en">Permisos del grupo (Valorar/Postales/Comentarios)</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_public" class="en">Subida en álbumes públicos</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_personal" class="en">Galerías personales</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_upload_method" class="en">Método de subida</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_assigned" class="en">Assigned albums</a></li>\n'; //Jmatute: pendiente
doc_toc += '          <li><a href="groups.htm#group_cp_create" class="en">Crear de grupos personalizados</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_delete" class="en">Borrar de grupos personalizados</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_sync" class="en">Lanzar sincronización (sólo para galerías enlazadas, bridged)</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_more_than_one_group" class="en">Pertenecer a más de un grupo</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="users.htm" class="en">Usuarios</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="users.htm#user_cp" class="en">Panel de control de usuarios</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="users.htm#user_cp_page" class="en">Controles de la página</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_search" class="en">Buscar usuarios</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_new" class="en">Crear usuarios nuevos</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_edit" class="en">Editar usuarios</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_group" class="en">Pertenecer a grupos</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="users.htm#lost_password" class="en">Contraseña perdida</a>\n'; //JLM: pendiente
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="users.htm#lost_password_cpg_user_account" class="en">Contraseña del usuario en Coppermine</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="users.htm#lost_password_cpg_user_account_standalone" class="en">Coppermine autónomo</a></li>\n';
doc_toc += '                  <li><a href="users.htm#lost_password_cpg_user_account_bridged" class="en">Coppermine enlazado con otra aplicación</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="users.htm#lost_password_cpg_user_account" class="en">Contraseña en mySQL</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="categories.htm" class="en">Categorías</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="categories.htm#cat_cp" class="en">Panel de control de categorías</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="categories.htm#cat_cp_page_controls" class="en">Controles de la página</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_sort" class="en">Apartado superior &quot;Ordenar categorías alfabéticamente&quot;</a></li>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_categories" class="en">Middle box &quot;Gestionar categoría&quot;</a></li>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_create" class="en">Apartado inferior&quot;Actualizar/crear categoría&quot;</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="categories.htm#cat_user_galleries" class="en">La categoría especial &quot;Galerías de usuario&quot;</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="albums.htm" class="en">Álbumes</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="albums.htm#albmgr" class="en">El gestor de álbumes</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_create" class="en">Crear álbumes</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_rename" class="en">Renombrar álbumes</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_order" class="en">Cambiar el orden del álbum</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_delete" class="en">Borrar álbumes</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="albums.htm#modif_alb_pics" class="en">Modificar álbumes/archivos</a></li>\n';
doc_toc += '          <li><a href="albums.htm#album_prop" class="en">Propiedades del álbum</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="albums.htm#album_prop_reset_start" class="en">Volver a las opciones por defecto</a></li>\n'; //Jmatute: pendiente
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="albums.htm#album_admin_user" class="en">Administradores vs. usuarios</a></li>\n';
doc_toc += '          <li><a href="albums.htm#album_faq" class="en">FAQ del álbum</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="files.htm" class="en">Archivo</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="files.htm#edit_pics" class="en">Editar archivos</a></li>\n';
doc_toc += '          <li><a href="files.htm#edit_vids" class="en">Editar videos</a></li>\n';
doc_toc += '          <li><a href="files.htm#cust_thmb" class="en">Miniaturas personalizadas</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_order" class="en">Orden de las miniaturas</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_types" class="en">Tipos de miniaturas</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_upload" class="en">Cargar miniaturas personalizadas</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_how" class="en">Cómo funciona</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_how_naming" class="en">Nomenclatura</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_why" class="en">¿Porqué Coppermine no puede crear miniaturas para mis vídeos?</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_step" class="en">Instrucciones: paso a paso</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_faq" class="en">FAQ de miniaturas personalizadas</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="keywords.htm" class="en">Palabras clave</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="keywords.htm#keywords_assign" class="en">Asignación de palabras clave</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="keywords.htm#keywords_assign_separator" class="en">Separador o delimitador de palabras clave</a></li>\n';
doc_toc += '              <li><a href="keywords.htm#keywords_assign_edit" class="en">Editar/añadir palabras clave</a></li>\n';
doc_toc += '              <li><a href="keywords.htm#keywords_manager" class="en">Gestor de palabras clave</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="keywords.htm#keywords_album" class="en">Palabras clave del álbum</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bbcode.htm" class="en">bbCode</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_purpose" class="en">Propósito</a></li>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_available" class="en">Etiquetas bbCode disponibles</a></li>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_dangers" class="en">Peligros</a></li>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_control" class="en">Más control</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="exif.htm" class="en">Datos Exif</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="exif.htm#exif_what" class="en">Qué es EXIF</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_makers" class="en">Different flavors</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_how_it_works" class="en">How it works</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_image_libraries" class="en">No exif support on the server</a></li>\n'; //Jmatute: pendiente
doc_toc += '          <li><a href="exif.htm#exif_limitations" class="en">Limitaciones</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_manager" class="en">Gestor de datos EXIF</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="plugins.htm" class="en">Plugins</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_definition" class="en">¿Qué es un plugin?</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_api" class="en">El API de los plugin </a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_obtain" class="en">¿Dónde conseguir plugins?</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_bundled" class="en">Plugins incluidos en Coppermine</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_link_target" class="en">Link Target (link_target)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_onlinestats" class="en">Who is online? (onlinestats)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_opensearch" class="en">OpenSearch (opensearch)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_sample" class="en">Sample Plugin (sample)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_usergal_alphatabs" class="en">User Gallery Alphabetic Tabbing (usergal_alphatabs)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_visiblehookpoints" class="en">Visible HookPoints (visiblehookpoints)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_sef_url" class="en">SEF_URLS plugin</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_manager" class="en">El gestor de plugins</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_upload" class="en">Subir un plugin</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_install" class="en">Instalar un plugin</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_configuration" class="en">Configurar de un plugin</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_uninstall" class="en">Desinstalar un plugin</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_writing" class="en">Escribir plugins</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="performance.htm#perf_tips" class="en">Rendimiento</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="performance.htm#perf_config" class="en">Ajustes de configuración</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="performance.htm#perf_config_general" class="en">General</a></li>\n';
doc_toc += '              <li><a href="performance.htm#perf_config_spikes" class="en">Spiking</a></li>\n';  //Jmatute: pendiente
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="performance.htm#perf_server" class="en">Ajustes en el servidor</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="performance.htm#perf_config_spikes" class="en">Ajustes en PHP</a></li>\n';
doc_toc += '              <li><a href="performance.htm#perf_server_mysql" class="en">Ajustes en MySQL</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="performance.htm#perf_tools" class="en">Herramientas de terceros</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="performance.htm#perf_yslow" class="en">YSlow</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n'; 
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="admin-tools.htm#admin_tools" class="en">Herramientas administrativas</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="admin-tools.htm#admin_tools_options" class="en">Herramientas disponibles</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_rebuild" class="en">Actualizar miniaturas y/o reescalar imágenes</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_filename_filetitle" class="en">Nombre de fichero &rarr; título del fichero</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_titles" class="en">Borrar los títulos</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_original" class="en">Borrar las imágeness de tamaño original</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_intermediate" class="en">Borrar las imágenes intermedias</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_older_files" class="en">Borrar archivos más antiguos que un número de días</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_comments" class="en">Borrar los comentarios huérfanos</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_original_backup" class="en">Borrar originales de las imágeness con marca de agua</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_reload_dimensions" class="en">Recargar la información de dimensiones y tamaño</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_reset_views" class="en">Poner a cero los contadores de visitas</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_keyword_convert" class="en">Convertir el separador de palabras clave</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="admin-tools.htm#admin_tools_usage" class="en">Uso</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="errors.htm#errors" class="en">Errores</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="errors.htm#errors_types" class="en">Error types</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_soft" class="en">Errores leves</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_hard" class="en">Errores graves</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_unhandled" class="en">Errores no controlados</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="errors.htm#errors_fatal" class="en">Error fatal</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_config" class="en">Activar la depuración en la configuración</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_manual" class="en">Activar la depuración manualmente</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_off" class="en">Desactivar la depuración</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="errors.htm#errors_messages" class="en">Mensajes habituales de error</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_messages_database" class="en">Mensajes relativos a la base de datos</a></li>\n';
doc_toc += '              <li><a href="errors.htm#commonPHPerrors" class="en">Errores PHP habituales</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_messages_upload" class="en">Mensajes de error relativos a las cargas (subidas)</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_messages_webserver">Códigos de respuesta del servidor web</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="export.htm#backup_export" class="en">Copias de seguridad</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="export.htm#backup_file" class="en">Copia de seguridad de ficheros</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="export.htm#backup_file_complete" class="en">Completa</a></li>\n';
doc_toc += '              <li><a href="export.htm#backup_file_partial" class="en">Parcial</a></li>\n';
doc_toc += '              <li><a href="export.htm#backup_file_incremental" class="en">Incremental</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="export.htm#backup_database" class="en">Copia de seguridad de la base de datos</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="export.htm#backup_database_what" class="en">¿Qué hay que copiar?</a></li>\n';
doc_toc += '              <li><a href="export.htm#backup_database_tools" class="en">Herramientas</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="export.htm#backup_database_tools_phpmyadmin" class="en">phpMyAdmin</a></li>\n';
doc_toc += '                  <li><a href="export.htm#backup_database_tools_mysqldumper" class="en">mySqlDumper</a></li>\n';
doc_toc += '                  <li><a href="export.htm#backup_database_tools_shell_mysqldump" class="en">mysqldump</a></li>\n';
doc_toc += '                  <li><a href="export.htm#backup_database_tools_shell_mysqlhotcopy" class="en">mysqlhotcopy</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="export.htm#backup_database_after" class="en">Después de hacer la copia de seguridad de la base de datos</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="export.htm#moving" class="en">Mover tu galería</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="export.htm#moving_folder" class="en">Mover en tu servidor Web</a></li>\n';
doc_toc += '              <li><a href="export.htm#moving_server" class="en">Mover de un servidor Web a otro</a></li>\n';
doc_toc += '              <li><a href="export.htm#moving_disadvantages" class="en">Desventajas de renombrar</a></li>\n';
doc_toc += '              <li><a href="export.htm#moving_config_url" class="en">Cambiar la URL de Coppermine en la configuración</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="watermarking.htm#watermark" class="en">Marcas de agua</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="watermarking.htm#watermark_alternatives" class="en">Alternativas</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_no_right_click" class="en">Quitar el menú contextual</a></li>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_registered_only" class="en">Mostrar el contenido más valioso sólo a los usuarios registrados</a></li>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_overlay" class="en">Display on overlay</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="watermarking.htm#watermark_client_sided" class="en">Marcas de agua desde la máquina cliente</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="uploading.htm" class="en">Subir ficheros</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="uploading_batch-add.htm#batch_add_pics" class="en">Subir ficheros por FTP / Añadir ficheros por lotes</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_pics_what" class="en">Qué hace el &quot;Añadir ficheros por lotes&quot;</a></li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_pics_how" class="en">How batch-add works</a></li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_common_mistakes" class="en">Errores habituales</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_doesnt_work" class="en">&quot;Añadir ficheros por lotes&quot; no funciona como se espera</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_broken_files" class="en">Los ficheros parecen estar rotos o corruptos</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_rename" class="en">No renombres</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_delete" class="en">No borres</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_sort" class="en">Ordenación</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_sort_capitalization" class="en">Las mayúsculas importan</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_sort_numbers" class="en">Las máquinas tratan a los números de forma diferente</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="uploading_http.htm#upload_http" class="en">Cargar (subir) por HTTP</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="uploading_http.htm#upload_http_interface" class="en">Interfases de carga</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="uploading_http.htm#upload_http_interface_flash" class="en">Basado en Flash, múltiples ficheros</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="uploading_http.htm#upload_http_interface_flash_usage" class="en">Uso</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="uploading_http.htm#upload_http_interface_html" class="en">Basado en HTML, un solo fichero cada vez</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="uploading_http.htm#upload_http_interface_html_usage" class="en">Uso</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="uploading_xp-publisher.htm#xp" class="en">Asistente de publicación de Windows XP</a>\n'; //JLM: pendiente de preguntar
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_requirements" class="en">Requisitos</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_setup" class="en">Configuración</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_upload" class="en">Subir imágenes</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_upload" class="en">Estructura de ficheros</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_remove" class="en">Quitar/desinstalar</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upload_troubleshooting.htm#upload_trouble" class="en">Solución de problemas en las cargas</a>\n';
doc_toc += '         <ul>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_permission" class="en">Permisos</a></li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_enable_settings" class="en">Activar las opciones para la resolución de problemas</a></li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_support" class="en">Pedir ayuda en problemas de subidas</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_support_step-by-step" class="en">Guía paso a paso para pedir soporte</a>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_support_example" class="en">Ejemplo de solicitud de soporte</a>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_error_messages" class="en">Mensajes de error</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorCantMovePic" class="en"></a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorImpossibleToMove" class="en">Imposible mover x a y</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorFailedToOpenDir" class="en">fallo al abrir directorio: no existe el  fichero o el directorio</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#httpPostVars" class="en">Variable no definida: HTTP_POST_VARS</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorNoAlbumExisting" class="en">Lo siento, pero no hay ningún álbum al que puedas subir ficheros</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorAllowedMemorySize" class="en">Se ha gastado toda la memoria permitida</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorExecDisabled" class="en">Exec() está desactivado</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#ErrorNotAGdExtension" class="en">No es una extensión GD válida</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#imagemagick127" class="en">Error al ejecutar ImageMagick - valor devuelto 127</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#no_gd_support" class="en">El PHP que se ejecuta en tu servidor no soporta la biblioteca gráfica GD</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#no_file_uploaded" class="en">¡No se subió ningún fichero! Si has seleccionado uno para cargar verifica que el servidor permite subidas</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#destination_not_writable" class="en">El directorio destino x no permite escritura por este script</a></li>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_server-sided_restrictions" class="en">Restricciones del servidor</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_server-sided_restrictions_php_ini" class="en">El ficerho de configuración php.ini</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_server-sided_restrictions_check" class="en">Puntos para verificar</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_methods" class="en">Mecanismos y métodos de subida</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_memory_usage" class="en">Uso de memoria durante el reescalado</a></li>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '         </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="comments.htm" class="en">Comentarios</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="comments.htm#comments_allow" class="en">Permitir comentarios</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_options" class="en">Opciones</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_options_spam" class="en">Problemas de spam</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_captcha" class="en">Asistente visual (Captcha)</a></li>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_approval" class="en">Aprobación</a></li>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_akismet" class="en">Akismet</a></li>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_resume" class="en">Resumen</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="comments.htm#comments_review" class="en">Revisar comentarios</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_individual" class="en">Comentarios individuales</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="bridging.htm" class="en">Enlace/Integración con otras aplicaciones (Bridging)</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_purpose" class="en">Qué hace el enlace</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_start" class="en">Archivos disponibles para el enlace</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_prerequisites_start" class="en">Prerrequistos</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_cookie_start" class="en">Autenticación por cookie</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_standalone_start" class="en">Primero la versión autónoma</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_users_start" class="en">Usuarios, grupos y archivos cargados por los usuarios que se pierden al integrar</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_backup_start" class="en">Copia de seguridad</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_steps_start" class="en">Pasos de la integración</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_start" class="en">Uso del gestor de enlaces</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_app_start" class="en">Escoge la aplicación con la que integrar Coppermine</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_path_start" class="en">Ruta(s) usadas por la aplicación integrada</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_full_forum_url" class="en">URL de la aplicación integrada</a></li>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_relative_path_of_forum_from_webroot" class="en">Ruta absoluta de la aplicación integrada</a></li>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_relative_path_to_config_file" class="en">Ruta relativa al fichero de configuración de la aplicación integrada</a></li>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_cookie_prefix" class="en">Prefijo de la cookie</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_specific_start" class="en">Configuración específica de la aplicación integrada</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_specific_groups" class="en">¿Usar los grupos personalizados en la aplicación integrada?</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_enable_start" class="en">Activar/Desactivar la integración</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bridging.htm#bridge_manager_recover_start" class="en">Recuperar desde una integración fallida</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_steps_sync_start" class="en">Sincronizar los grupos de la aplicación integrada con los de Coppermine</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_support_start" class="en">Soporte de la integración</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_config_options_start" class="en">Algunas opciones de configuración están deshabilitadas</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_files_start" class="en">Archivos de la integración</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_file_creating_start" class="en">Crear un archivo personalizado de la integración</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_philosophy_start" class="en">Filosofía de la integración</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_individual_bridge_issues_start" class="en">A tener en cuenta:</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_phpbb3" class="en">phpBB3</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_punbb115" class="en">PunBB1.1.5</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_punbb12" class="en">PunBB1.2</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_xmb" class="en">XMB</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_subdomain" class="en">Subdomain issues</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_subdomain_file_system" class="en">File system</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_subdomain_cookie" class="en">Cookies</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_subdomain_www" class="en">www-subdomain</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="dev.htm" class="en">Documentación para los desarrolladores</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="dev_files.htm" class="en">Adding/renaming/removing files</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_scope" class="en">Scope</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_naming" class="en">Naming conventions</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_adding" class="en">Adding files</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_files.htm#dev_files_adding_language" class="en">Language files</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_renaming" class="en">Renaming files</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_deleting" class="en">Deleting files</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_coding.htm" class="en">Coding guidelines</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_scope" class="en">Scope</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_indentation" class="en">Indentation</a></li>\n';
doc_toc += '          <li><a href="dev_coding_encoding" class="en">Encoding</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_general" class="en">General guidelines</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_php" class="en">PHP code</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_formatting" class="en">Formatting</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_control_structures" class="en">Control Structures</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_function_calls" class="en">Function Calls</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_function_definitions" class="en">Function Definitions</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_php_tags" class="en">PHP Code Tags</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_nesting" class="en">Nesting of HTML in PHP</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_linebreaks" class="en">Line breaks</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_naming_conventions" class="en">Naming Conventions</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_database" class="en">Database queries</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_documentation" class="en">Documentation</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_html_output" class="en">HTML output</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_images" class="en">Image-tags in HTML output</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_dev_coding_html_output_links" class="en">Links in HTML output</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_form" class="en">Form elements in HTML output</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_deprecated" class="en">Deprecated tags</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_prefered_tags" class="en">Prefered tags</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_credits" class="en">Credits for coding guidelines</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_usability" class="en">Usability</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_usability_forms" class="en">Forms</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_config.htm" class="en">Config options</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_add_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_history" class="en">History</a></li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_new_features" class="en">New features</a></li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_step_by_step" class="en">Step by Step</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_basiq_sql" class="en">Basic.sql</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_update_sql" class="en">Update.sql</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_array" class="en">Admin.inc.php</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_language_file" class="en">Language file</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_documentation" class="en">Documentation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_todo" class="en">To Do</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_database.htm" class="en">Database schema</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="dev_database.htm#db_config_file" class="en">Configuration file</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_reference within_code" class="en">Database reference within coppermine code</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_albums" class="en">cpg15x_albums</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_banned" class="en">cpg15x_banned</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_bridge" class="en">cpg15x_bridge</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_categories" class="en">cpg15x_categories</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_categorymap" class="en">cpg15x_categorymap</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_comments" class="en">cpg15x_comments</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_config" class="en">cpg15x_config</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_dict" class="en">cpg15x_dict</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_ecards" class="en">cpg15x_ecards</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_exif" class="en">cpg15x_exif</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_favpics" class="en">cpg15x_favpics</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_filetypes" class="en">cpg15x_filetypes</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_hit_stats" class="en">cpg15x_hit_stats</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_languages" class="en">cpg15x_languages</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_pictures" class="en">cpg15x_pictures</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_plugins" class="en">cpg15x_plugins</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_sessions" class="en">cpg15x_sessions</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_temp_messages" class="en">cpg15x_temp_messages</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_usergroups" class="en">cpg15x_usergroups</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_users" class="en">cpg15x_users</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_votes" class="en">cpg15x_votes</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_vote_stats" class="en">cpg15x_vote_stats</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_documentation.htm" class="en">Editing the documentation</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_edit_existing" class="en">Edit existing documents</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_add" class="en">Add new documents</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_move" class="en">Moving content from one document to the other</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_hidden_feature" class="en">Hidden features</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_database_structure" class="en">Database structure</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_header_block" class="en">Header &amp; footer blocks</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_i18n" class="en">Documentation internationalization</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_detail" class="en">Expandable/collapsible "detail"-blocks</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_help" class="en">Help</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_help_start_end" class="en">Start and end anchors needed</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_heading_anchors" class="en">Adding anchors to headings</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_code" class="en">Code</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_css_code" class="en">CSS class &quot;code&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_html_pre" class="en">HTML-tag &quot;pre&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_css_cpg_code" class="en">CSS class &quot;cpg_code&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_css_smallcode" class="en">CSS class &quot;smallcode&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_html_textarea" class="en">HTML-tag &quot;textarea&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_combining" class="en">Combining HTML tags and CSS classes</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_syntaxhighlighting" class="en">No syntax highlighting</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_javascript.htm" class="en">Javascript in Coppermine</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_files_location" class="en">Javascript files location and organization</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_files_location_todo" class="en">TODO</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_include_files" class="en">How to include javascript files</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_javascript.htm#dev_javascript_include_files_plugin" class="en">How to include JavaScript files in plugins</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_php_vars" class="en">How to pass PHP variables to included javascript</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_autostart" class="en">Autostart JavaScript</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_package.htm#packaging" class="en">Packaging a new release</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_package.htm#packaging_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_package.htm#packaging_subversion" class="en">Subversion repository</a></li>\n';
doc_toc += '          <li><a href="dev_package.htm#packaging_steps" class="en">Steps</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_checkout" class="en">Check out</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_loop_through_files" class="en"></a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#" class="en">Replace version number in all files</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_loop_through_files_linux" class="en">Linux</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_loop_through_files_windows" class="en">Windows</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_bom" class="en">Remove Byte Order Marks</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#" class="en">Prepare an announcement thread</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_write_announcement_thread" class="en"></a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_docs_upgrade" class="en">Edit the upgrade section of the docs</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_changelog" class="en">Edit the changelog</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_version_number" class="en">Edit the version number</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_svn_commit" class="en">Commit your changes</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_versioncheck" class="en">Update the versioncheck data</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_versioncheck_complete" class="en">Completeness</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_versioncheck_update" class="en">Update revision numbers and hashes</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_xml_webspace" class="en">Update cpg15x.files.xml on the Coppermine home page</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_svn_export" class="en">Export from subversion</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_rapidsvn" class="en">RapidSVN</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_tortoisesvn" class="en">Tortoise SVN</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_create_zip" class="en">Create the archive</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_upload_zip" class="en">Upload the archive</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_move_announcement" class="en">Publish announcement thread</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_news" class="en">Create news items</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_sf" class="en">News item on sf.net</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_forum" class="en">News item on forum</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_homepage" class="en">News item on home page</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_embedded" class="en">News embedded into existing galleries</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_demo" class="en">Update the demo</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_plugins.htm" class="en">Plugin Writing for Coppermine</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing" class="en">Quick Start Guide</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_target_audience" class="en">Intended Audience</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_target_audience_yes" class="en">People who should read this documentation</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_target_audience_no" class="en">People who do not need to read this documentation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_why_write" class="en">Why write plugins?</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_preparation" class="en">Preparations</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_name" class="en">Choose a name</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_translation" class="en">Consider translations</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_config" class="en">Consider a config screen</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_db" class="en">Database changes</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_support" class="en">Support issues</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_versions" class="en">Plugin versions</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_core_files" class="en">Core files</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_naming_conventions" class="en">Naming conventions</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_folders" class="en">Folders</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_files" class="en">Files</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_archives" class="en">Archives</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_coding" class="en">Coding</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_globals" class="en">Use of Superglobals</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_database" class="en">Database access</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_direct_queries" class="en">Direct queries</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_tables_access" class="en">Accessing database tables</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_tables_create" class="en">Creating database tables</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_tables_delete" class="en">Deleting database tables</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_config" class="en">Storing your plugin\'s config values</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_types" class="en">Plugin Types</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_includes" class="en">Using includes</a></li>\n';
doc_toc += '          <li><a href="dev_plugin_api.htm" class="en">Plugin Writing: Tutorial, API</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_overview_who" class="en">Intended Audience</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_overview_skills" class="en">Required Skills &amp; Knowledge</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_overview_tools" class="en">Recommended Software &amp; Support Forums</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_tutorial" class="en">"Hello, world" Plugin Tutorial</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_first" class="en">My First Plugin</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_installconfig" class="en">Installation, Configuration, and Clean-Up</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_installsimple" class="en">Installation with Simple Configuration</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_install" class="en">Installation with Configuration Parameters</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_config" class="en">Adding a config section to your plugin</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_cleanup" class="en">Uninstallation &amp; Clean-Up</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>  \n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_linking" class="en">Linking to Custom Plugin Scripts</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_button" class="en">Adding a Button to Coppermine</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_button_admin_menu" class="en">Adding a Button to the admin menu</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_button_overall_menu" class="en">Adding a Button to the overall menu</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_js" class="en">Adding JavaScript to plugins</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_lang" class="en">Multi-language Support</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_distrib" class="en">Distributing Your Plugin</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_hooks" class="en">Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_plugin_class" class="en">Plugin Class Properties &amp; Methods</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_globals" class="en">Global Variables &amp; Constants</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugin_steps.htm" class="en">Creating plugins: step by step</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugin_steps.htm#steps_template_plugin" class="en">Getting started with the plugin template</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_extract_template" class="en">1. Extract the plugin template</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_pick_name" class="en">2. Choose a name</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_rename_folder" class="en">3. Rename the folder</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_rename_file_content" class="en">4. Rename the placeholders inside the files</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_copy_to_target" class="en">5. Copy the new plugin folder to the target</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_steps.htm#steps_config" class="en">Creating a config record for your plugin</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_option_type" class="en">1. Decide for an option type</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_name" class="en">2. Choose a record name</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_install" class="en">3. Create the record during plugin install</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_uninstall" class="en">4. Create the uninstall query</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_defaults" class="en">5. Specify the scope of your config record</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_form_options" class="en">6. Populate form options</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_rows" class="en">7. Output the form elements (rows)</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_checkbox" class="en">a. Checkbox</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_radio" class="en">b. Radio button</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_dropdown" class="en">c. Dropdown (select/option list)</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_textinput" class="en">d. Text input field (one line), both for numerical input (integers) as well as any other textual input</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_textarea" class="en">e. Text input field (multiple lines, aka textarea)</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_language" class="en">8. Create the needed translation strings</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugin_hooks.htm" class="en">Reference list of plugin hooks </a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_choosing" class="en">Choosing Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_finding" class="en">Finding Plugin Hooks</a></li>\n';
//doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_using" class="en">Using Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_filename" class="en">Plugin Hooks by File Name</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_php" class="en">Script: index.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_anyc" class="en">Filter: \'anycontent\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_ucp" class="en">Filter: \'user_caption_params\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_pb" class="en">Filter: \'plugin_block\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_php" class="en">Script: displayimage.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_fi" class="en">Filter: \'file_info\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_pbc" class="en">Filter: \'post_breadcrumb\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_thumb_php" class="en">Script: thumbnails.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_thumb_pbc" class="en">Filter: \'post_breadcrumb\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_php" class="en">Script: functions.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_ghgf" class="en">Filters: \'gallery_header\' and \'gallery_footer\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_td" class="en">Filter: \'thumb_data\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_th" class="en">Filter: \'template_html\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_pm" class="en">Filter: \'page_meta\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_tc" class="en">Filters: \'thumb_caption\' and all derivatives</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_th_php" class="en">Script: themes.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_th_fd" class="en">Filter: \'file_data\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_php" class="en">Script: usermgr.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_umh" class="en">Filter: \'usermgr_header\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_umf" class="en">Filter: \'usermgr_footer\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_php" class="en">Script: pluginmgr.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_pcon" class="en">Filter: \'plugin_configure\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_pcl" class="en">Filter: \'plugin_cleanup\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_php" class="en">Script: plugin_api.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_ph" class="en">Filter: \'page_html\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pe" class="en">Filter: \'page_end\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pi" class="en">Filter: \'plugin_install\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pu" class="en">Filter: \'plugin_uninstall\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pw" class="en">Filter: \'plugin_wakeup\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_ps" class="en">Filter: \'plugin_sleep\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_init_php" class="en">Script: init.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_init_ps" class="en">Filter: \'page_start\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_picm_php" class="en">Script: picmgmt.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_picm_afd" class="en">Filter: \'add_file_data\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_alphabetically" class="en">Plugin Hooks Alphabetically</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_hooktype" class="en">Plugin Hooks by Hook Type</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hook_examples" class="en">Plugin Hook Examples</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                    <li><a href="dev_plugin_hooks.htm#plugin_hook_example_upload_method" class="en">Adding an upload method</a></li>\n';
doc_toc += '                    <li><a href="dev_plugin_hooks.htm#plugin_hook_example_theme_display_thumbnails" class="en">Add tags for thumbnails display</a></li>\n';
doc_toc += '                </ul></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_superglobals.htm" class="en">Sanitization of Superglobals using Inspekt</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_whats_new" class="en">What\'s new?</a></li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_reason" class="en">Reason</a></li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_about_inspekt" class="en">What Inspekt does</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_inspekt_accessor_methods" class="en">Inspekt accessor methods</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_howto" class="en">How to use Inspekt with Coppermine Photo Gallery</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_using" class="en">Using Inspekt</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_inspekt_in_coppermine" class="en">Inspekt in Coppermine</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_consider_methods" class="en">Consider the methods to use</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_examples" class="en">Examples</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_regex" class="en">Regular Expressions</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_links" class="en">Links</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_subversion.htm" class="en">Subversion</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_caveat" class="en">Caveats</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_definition" class="en">What is subversion?</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_hosting" class="en">Where is the subversion repository hosted?</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_software" class="en">Recommended software</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_websvn" class="en">Alternative access using Web SVN</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_repository_structure" class="en">Repository structure</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_repository_structure_trunk" class="en">Coppermine core files</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_repository_structure_plugins" class="en">Plugins</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_checking_out" class="en">Checking out</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_entire" class="en">Checking out the entire repository</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_particular_package" class="en">Checking out a particular Package</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_particular_file" class="en">Checking out a particular file</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_refering" class="en">Refering to files downloaded from the subversion repository</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_download" class="en">Is there no single package that I could download instead?</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_download_tarball" class="en">Download Tarball archives</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_dev-only" class="en">Developers-only</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checkout_checkin" class="en">Check out before checking in</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_commit" class="en">Committing your code</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_changelog" class="en">Changelog</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_write_access" class="en">Obtaining write access</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_step-by-step" class="en">Step by step</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_client-download" class="en">Download the client application</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_initial_checkout" class="en">Initial checkout</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_revision" class="en">Revisions</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_fileheaders" class="en">Subversion file headers</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_tools.htm" class="en">Tools recommended by the devs</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_database" class="en">Database manipulation</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_ftp_client" class="en">FTP clients</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_web_development" class="en">Web development</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_editor" class="en">Text editors</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_picture_editors" class="en">Picture Editors</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_update.htm" class="en">Updating</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_update.htm#dev_update_target_audience" class="en">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_update.htm#dev_update_hidden_feature" class="en">Hidden feature</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_vars.htm#vars_constants" class="en">Variables &amp; Constants</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_vars.htm#vars_constants_system" class="en">System Global Variables</a></li>\n';
doc_toc += '          <li><a href="dev_vars.htm#vars_constants_constants" class="en">Coppermine Constants</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_versioncheck.htm" class="en">Versioncheck</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_versioncheck.htm#dev_versioncheck_hidden_features" class="en">Hidden features</a></li>\n';
doc_toc += '          <li><a href="dev_versioncheck.htm#dev_versioncheck_xml" class="en">XML structure</a></li>\n';
doc_toc += '          <li><a href="dev_versioncheck.htm#dev_versioncheck_todo" class="en">To do list</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '</ul>\n';
doc_toc += '</div>\n';
$('#toc').replaceWith('<div id="toc" class="en" class="en">' + doc_toc + '</div>');
}



function cpgDocHeader() {
    // Only display the header if the docs are not included
    if (getUrlParameters('hide_nav') == 1) {
        return;
    }
    $('#docheader').text('Coppermine Photo Gallery v1.5.48: Documentación');
    $('#docheader').after('<br clear="all" />\n<a name="top" class="en" class="en"></a>');
    $('#docheader').before('<img src="../images/coppermine-logo.png" alt="Coppermine Photo Gallery - Your Online Photo Gallery" align="left" />\n');
}

function cpgDocSearch() {
    // Only display the header if the docs are not included
    if (getUrlParameters('hide_nav') == 1) {
        return;
    }
    var doc_search = '';
    doc_search += '  <div id="doc_search" style="display:none;" class="en" class="en">\n';
    doc_search += '    <form action="http://www.google.com/cse" id="cse-search-box" class="en" class="en">\n';
    doc_search += '      <input type="hidden" name="cx" value="009353514429642786404:8ndxnr03bcg" />\n';
    doc_search += '      <input type="text" name="q" size="25" />\n';
    doc_search += '      <input type="submit" name="sa" value="Buscar" style="font-size:9px;" />\n';
    doc_search += '    </form>\n';
    doc_search += '    <script type="text/javascript" src="http://www.google.com/coop/cse/brand?form=cse-search-box&lang=es" class="en" class="en"></script>\n';
    doc_search += '  </div>\n';
    $('#toc').append(doc_search);
}

function cpgDocFooter() {
  var overall_doc_footer = '';
  overall_doc_footer += '</div>';
  overall_doc_footer += '<div align="right" class="en" class="en">';
  overall_doc_footer += '<a href="#top" class="en" class="en">Back to Top</a>';
  overall_doc_footer += '</div>';
  $('#doc_footer').append(overall_doc_footer);
}



function dateRevision() {
  // strip the unneeded data from last_changed and revision fields
  var lastChangeDate = $('#doc_last_changed').text();
  var lastChangeDate = lastChangeDate.replace('$', '');
  var lastChangeDate = lastChangeDate.replace('$', '');
  var lastChangeDate = lastChangeDate.replace('LastChangedDate: ', '');
  var lastChangeDate = lastChangeDate.replace(/Date: /g, '');
  $('#doc_last_changed').text('About this document: ' + 'last changed on ' + lastChangeDate);

  var revisionNumber = $('#doc_revision').text();
  var revisionNumber = revisionNumber.replace('$', '');
  var revisionNumber = revisionNumber.replace('$', '');
  var revisionNumber = revisionNumber.replace(/Revision: /g, '');
  $('#doc_revision').text(', SVN revision ' + revisionNumber);
}

function getUrlParameters(name)
{
  // Taken from http://www.netlobo.com/url_query_string_javascript.html
  name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  var regexS = "[\\?&]"+name+"=([^&#]*)";
  var regex = new RegExp(regexS);
  var results = regex.exec(window.location.href);
  if(results == null) {
    return '';
  } else {
    return results[1];
  }
}

function cpgDocTranslationWarning() {
  $('#doc_en_only').replaceWith('<div class="cpg_message_validation" class="en" class="en"><h1>Pendiente de traducir</h1><p>No se ha traducido aún y por tanto se muestra en inglés.</p><p>Se necesitan traductores: si crees que podrías traducir esta página ¿por qué no te ofreces como voluntario en el sitio oficial de Coppermine?. Esperamos agradecidos tu contribución.</div>');
  $('#doc_en_partial').replaceWith('<div class="cpg_message_warning" class="en" class="en"><h1>Traducido parcialmente</h1><p>No se ha traducido del todo y por tanto se muestra parte en castallano y parte en inglés.</p><p>Se necesitan traductores: si crees que podrías traducir esta página ¿por qué no te ofreces como voluntario en el sitio oficial de Coppermine?. Esperamos agradecidos tu contribución.</div>');
}

$(document).ready(function()
{
    var $_GET = {};
    document.location.search.replace(/\??(?:([^=]+)=([^&]*)&?)/g, function () {
        function decode(s) {
            return decodeURIComponent(s).replace(/\+/g, " ");
        }
        $_GET[decode(arguments[1])] = decode(arguments[2]);
    });
    //hide all elements with class detail_body
    $(".detail_body").hide();
    if ($_GET["expand_all"] == 1) { // Show all details and get rid of the details toggle if the GET parameter expand_all is set
        $('.detail_body').show();
        $('.detail_head_collapsed').replaceWith('');
    }
    //toggle the component with class detail_body
    $(".detail_head_collapsed").click(function()
    {
        $(this).toggleClass("detail_head_expanded").next(".detail_body").slideToggle(600);
    });
    $(".detail_expand_all").click(function()
    {
        $(".detail_body").slideDown(1200);
        $(".detail_head_collapsed").toggleClass("detail_head_expanded");
        $(".detail_expand_all").hide();
        $(".detail_collapse_all").show();

    });
    $(".detail_collapse_all").click(function()
    {
        $(".detail_body").slideUp(1200);
        $(".detail_head_collapsed").toggleClass("detail_head_expanded");
        $(".detail_expand_all").show();
        $(".detail_collapse_all").hide();

    });
    $(".detail_toggle_all").click(function()
    {
        $(".detail_body").slideToggle(600);
        $(".detail_head_collapsed").toggleClass("detail_head_expanded");
    });
    cpgDocHeader();
    cpgDocTranslationWarning();
    cpgDocToc();
    $("#tree").treeview({
        collapsed: true,
        unique: true,
        animated: "slow",
        persist: "location"
    });
    cpgDocSearch();
    cpgDocFooter();
    dateRevision();
    $("a.nolink").click(function(){
      return false;
    });
    // Fade the toc in if it is needed
    $("#toc").bind("mouseenter",function(){
        $("#toc_collapsed").hide();
        $("#toc_expanded").fadeIn('slow');
        $("#doc_search").show();
    });
    // Fade the toc out if it isn't used
    $("#toc").bind("mouseleave",function(){
        $("#toc_expanded").fadeOut('slow');
        $("#toc_collapsed").show();
        $("#doc_search").hide();
    });
    
});
