/*
 * Decompiled with CFR 0.152.
 */
package venue;

import database.DBConn;
import database.DBUtil;
import util.RecordList;
import util.RecordListSet;

public class VenueRequestEquipment {
    private int g_Venue_request_seq = -1;
    private RecordList g_Items = null;
    public static String VENUE_REQUEST_EQUIPMENT_SEQ = "venue_request_equipment_seq";
    public static String VENUE_REQUEST_SEQ = "venue_request_seq";
    public static String VENUE_EQUIPMENT_SEQ = "venue_equipment_seq";
    public static String QTY = "qty";

    public VenueRequestEquipment(int venue_request_seq) {
        this.g_Venue_request_seq = venue_request_seq;
        DBConn conn = new DBConn();
        this.g_Items = VenueRequestEquipment.load(this.g_Venue_request_seq, conn);
        conn.commit();
    }

    public RecordList getItems() {
        return this.g_Items;
    }

    private static RecordList load(int venue_request_seq, DBConn conn) {
        String sql = "select vnre.*,vne.venue_seq,vne.name,vne.unit from venue_request_equipment vnre,venue_equipment vne where vne.venue_equipment_seq=vnre.venue_equipment_seq and vnre.venue_request_seq=? order by vne.venue_seq desc,vnre.venue_request_equipment_seq";
        return DBUtil.run(sql, venue_request_seq, conn);
    }

    public static void update(int venue_request_seq, RecordList items, DBConn conn) {
        RecordList old_items = VenueRequestEquipment.load(venue_request_seq, conn);
        RecordListSet set = new RecordListSet(old_items, items, new String[]{VENUE_REQUEST_EQUIPMENT_SEQ});
        RecordList r = set.getLeftOnly();
        int i = 0;
        while (i < r.size()) {
            int seq = r.getI(VENUE_REQUEST_EQUIPMENT_SEQ, i);
            VenueRequestEquipment.delete(seq, conn);
            ++i;
        }
        r = set.getIntersectOfRight();
        i = 0;
        while (i < r.size()) {
            VenueRequestEquipment.update(r, i, conn);
            ++i;
        }
        r = set.getRightOnly();
        i = 0;
        while (i < r.size()) {
            VenueRequestEquipment.insert(r, venue_request_seq, i, conn);
            ++i;
        }
    }

    private static void insert(RecordList items, int venue_request_seq, int i, DBConn conn) {
        String sql = "insert into venue_request_equipment( venue_request_equipment_seq,venue_request_seq,venue_equipment_seq,qty)values(?,?,?,?)";
        items.setCurrentRow(i);
        Object[] pvs = new Object[]{DBUtil.getNextValueFor(VENUE_REQUEST_EQUIPMENT_SEQ, conn), new Integer(venue_request_seq), items.getI(VENUE_EQUIPMENT_SEQ), items.getBigDecimal(QTY)};
        DBUtil.run(sql, pvs, conn);
    }

    private static void update(RecordList items, int i, DBConn conn) {
        String sql = "update venue_request_equipment set venue_equipment_seq=?,qty=? where venue_request_equipment_seq=?";
        items.setCurrentRow(i);
        Object[] pvs = new Object[]{items.getInteger(VENUE_EQUIPMENT_SEQ), items.getBigDecimal(QTY), items.getInteger(VENUE_REQUEST_EQUIPMENT_SEQ)};
        DBUtil.run(sql, pvs, conn);
    }

    private static void delete(int seq, DBConn conn) {
        String sql = "delete from venue_request_equipment where venue_request_equipment_seq=?";
        DBUtil.run(sql, seq, conn);
    }
}

