/*
 * Decompiled with CFR 0.152.
 */
package util;

import database.DBUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import system.MsgOut;
import util.RecordList;
import util.TimeUtil;

public class Tools {
    public static void writeException(String err_msg) {
        Exception e = new Exception(err_msg);
        MsgOut.write(e);
    }

    public static void writeError(String err_msg) {
        MsgOut.write(err_msg);
    }

    public static void writeError(Exception e) {
        MsgOut.write(e);
    }

    public static String pad(String input) {
        if (input.equals("") || input == null) {
            return "";
        }
        return "%" + input + "%";
    }

    public static void copyFile(String in_path, String out_path) {
        try {
            FileChannel srcChannel = new FileInputStream(in_path).getChannel();
            FileChannel destChannel = new FileOutputStream(out_path).getChannel();
            srcChannel.transferTo(0L, srcChannel.size(), destChannel);
            srcChannel.close();
            destChannel.close();
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
    }

    public static boolean validateIdFormat(String formatStr) {
        int idx1 = formatStr.indexOf("[");
        if (idx1 == -1) {
            return true;
        }
        int idx2 = -1;
        while (idx1 != -1) {
            idx2 = formatStr.indexOf("]", idx1);
            if (idx2 == -1) {
                return false;
            }
            String format = formatStr.substring(idx1 + 1, idx2);
            if (format.equals("")) {
                return false;
            }
            if (format.substring(0, 1).equals("#")) {
                try {
                    Integer.parseInt(format.substring(1, format.length()));
                }
                catch (NumberFormatException e) {
                    return false;
                }
            } else if (!(format.equals("yyyy") || format.equals("yy") || format.equals("MM"))) {
                return false;
            }
            idx1 = formatStr.indexOf("[", idx2);
        }
        return true;
    }

    public static boolean validateMemberIdFormat(String formatStr) {
        if (!Tools.validateIdFormat(formatStr)) {
            return false;
        }
        String chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        int len = 0;
        int idx1 = -1;
        int idx2 = -1;
        String format = "";
        int i = 0;
        while (i < formatStr.length()) {
            char c = formatStr.charAt(i);
            if (c == '[') {
                idx1 = i;
                idx2 = formatStr.indexOf("]", idx1);
                format = formatStr.substring(idx1 + 1, idx2);
                len = format.substring(0, 1).equals("#") ? (len += Integer.parseInt(format.substring(1, format.length()))) : (len += format.length());
                i = idx2;
            } else {
                if (chars.indexOf(c) == -1) {
                    return false;
                }
                ++len;
            }
            ++i;
        }
        return len <= 10;
    }

    public static boolean validateMemberIdForCheckDigit(String s) {
        String chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        int len = 0;
        int idx1 = -1;
        int idx2 = -1;
        String format = "";
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (chars.indexOf(c) == -1) {
                return false;
            }
            ++len;
            ++i;
        }
        return len <= 10;
    }

    public static boolean validateDisplayNameFormat(String formatStr) {
        int idx1 = formatStr.indexOf("[");
        if (idx1 == -1) {
            return false;
        }
        int idx2 = -1;
        while (idx1 != -1) {
            idx2 = formatStr.indexOf("]", idx1);
            if (idx2 == -1) {
                return false;
            }
            String format = formatStr.substring(idx1 + 1, idx2);
            if (format.equals("")) {
                return false;
            }
            if (!format.equals("n1") && !format.equals("n2")) {
                return false;
            }
            idx1 = formatStr.indexOf("[", idx2);
        }
        return true;
    }

    public static String getNextID(String formatStr, String table, String column) {
        return Tools.formatID(formatStr, table, column, 1);
    }

    public static String formatID(String formatStr, String table, String column, int inc) {
        String outputstr = "";
        Timestamp today = TimeUtil.getCurrentDate();
        int idx1 = formatStr.indexOf("[");
        if (idx1 == -1) {
            return formatStr;
        }
        outputstr = formatStr.substring(0, idx1);
        int idx2 = -1;
        while (idx1 != -1) {
            idx2 = formatStr.indexOf("]", idx1);
            if (idx2 == -1) break;
            String format = formatStr.substring(idx1 + 1, idx2);
            String converted = "";
            if (format.equals("yyyy") || format.equals("yy") || format.equals("MM")) {
                SimpleDateFormat df = new SimpleDateFormat(format);
                converted = df.format((Date)today, new StringBuffer(), new FieldPosition(2)).toString();
            } else if (format.substring(0, 1).equals("#")) {
                int num = 0;
                int num_length = Integer.parseInt(format.substring(1, format.length()));
                if (table.equals("member_id_seq")) {
                    num = DBUtil.getNextValueFor("member_id_seq", null);
                    inc = 0;
                } else {
                    String sql = "select max(" + column + ") as nx from " + table + " where " + column + " like ?";
                    RecordList r = DBUtil.run(sql, new Object[]{Tools.pad(outputstr)});
                    String nx = r.getS("nx", 0);
                    if (!nx.equals("")) {
                        int num_start_pos = nx.indexOf(outputstr) + outputstr.length();
                        num = Integer.parseInt(nx.substring(num_start_pos, num_start_pos + num_length));
                    }
                }
                converted = Tools.genIDs("", num_length, num + inc);
            }
            outputstr = String.valueOf(outputstr) + converted;
            idx1 = formatStr.indexOf("[", idx2);
            outputstr = String.valueOf(outputstr) + formatStr.substring(idx2 + 1, idx1 != -1 ? idx1 : formatStr.length());
        }
        return outputstr;
    }

    public static String genCheckDigit(String s) {
        if (s.length() > 10) {
            return "";
        }
        int sum = 0;
        int mul = s.length() + 1;
        int i = 0;
        while (i < s.length()) {
            sum += (mul - i) * Character.getNumericValue(s.charAt(i));
            ++i;
        }
        int cd = 11 - sum % 11;
        if (cd == 10) {
            return "0";
        }
        if (cd == 11) {
            return "A";
        }
        return String.valueOf(cd);
    }

    public static String genIDs(String prefix, int digit_length, int seq) {
        String seq_str = String.valueOf(seq);
        String zero = "";
        int i = 0;
        while (i < digit_length - seq_str.length()) {
            zero = String.valueOf(zero) + "0";
            ++i;
        }
        String id = String.valueOf(prefix) + zero + seq_str;
        return id;
    }

    public static String getStatusName(Object[] map, String code) {
        int i = 0;
        while (i < map.length) {
            if (((String[])map[i])[0].equals(code)) {
                return ((String[])map[i])[1];
            }
            ++i;
        }
        return "";
    }

    public static String[] getStatusItem(Object[] map, String code) {
        int i = 0;
        while (i < map.length) {
            if (((String[])map[i])[0].equals(code)) {
                return (String[])map[i];
            }
            ++i;
        }
        return new String[0];
    }

    public static String md5(String s) {
        StringBuffer hexString = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes());
            byte[] b = md.digest();
            int i = 0;
            while (i < b.length) {
                String tmp = Integer.toHexString(0xFF & b[i]);
                if (tmp.length() < 2) {
                    tmp = "0" + tmp;
                }
                hexString.append(tmp);
                ++i;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return hexString.toString();
    }

    public static ImageIcon getScaledImage(String image_path, int width, int height) {
        ImageIcon icon = new ImageIcon(image_path);
        return new ImageIcon(icon.getImage().getScaledInstance(width, height, 1));
    }

    public static void openFileByCmd(String filePath) {
        char[] filePathArray = filePath.toCharArray();
        StringBuffer path = new StringBuffer();
        int i = 0;
        while (i < filePathArray.length) {
            path.append("^");
            path.append(filePathArray[i]);
            ++i;
        }
        try {
            Runtime.getRuntime().exec("cmd.exe /c \"" + path.toString() + "\"");
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
    }
}

