/*
 * Decompiled with CFR 0.152.
 */
package system;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import mainapp.MainFrame;
import util.Tools;

public class Constants {
    public static String VERSION = "1.2.2";
    public static String VERSION_DESC = "";
    public static final String ERR_MSG_OUT = Constants.load("err_msg_out", false);
    public static final String DB_TYPE = Constants.load("db_type", true);
    public static final String DB_PATH = Constants.load("db_path", true);
    public static final String FONT_PATH = Constants.loadPath("font_path", false);
    public static final String FONT_INDEX = Constants.load("font_index", false);
    public static final String IMG_PATH = "image/";
    public static final String MEMBER_PHOTO_PATH = "image/member_photo/";
    public static final String DEFAULT_FONT_PATH = "webtool/font/";
    public static final String MEMBER_CARD_CONFIG = "config/member_card_config.txt";
    public static final String MEMBER_LABEL_CONFIG = "config/member_label_config.txt";
    public static final String PASSWORD_FILE = "config/password.txt";
    public static final String LIST_LIMIT = " limit 1000";
    public static final int LIST_LIMIT_SIZE = 1000;
    public static final int NULLNUM = -1;
    public static final int MEMBER_ID_LENGTH = 5;
    public static final String MEMBER_PHOTO_EXTENSION = ".jpg";
    public static final String LOGIN_ID = Constants.load("login_id", false);
    public static final String PASSWORD = Constants.load("password", false);

    private static String load(String name, boolean isRequired) {
        Properties config = new Properties();
        try {
            config.load(new FileInputStream(MainFrame.CONFIG));
            String value = config.getProperty(name);
            boolean showErr = false;
            if (value == null) {
                if (isRequired) {
                    showErr = true;
                }
            } else if (value.equals("") && isRequired) {
                showErr = true;
            }
            if (showErr) {
                Tools.writeError("Constants.load(): " + name + " is required.");
            }
            return value == null ? "" : value;
        }
        catch (IOException e) {
            Tools.writeError("Constants.load(): " + name + " " + e.getMessage());
            return "";
        }
    }

    private static int loadInt(String name, boolean isRequired) {
        Properties config = new Properties();
        try {
            config.load(new FileInputStream(MainFrame.CONFIG));
            String value = config.getProperty(name);
            boolean showErr = false;
            if (value == null) {
                if (isRequired) {
                    showErr = true;
                }
            } else if (value.equals("") && isRequired) {
                showErr = true;
            }
            if (showErr) {
                Tools.writeError("Constants.loadInt(): " + name + " is required.");
            }
            return value == null ? -1 : Integer.parseInt(value);
        }
        catch (Exception e) {
            Tools.writeError("Constants.loadInt(): " + name + " " + e.getMessage());
            return -1;
        }
    }

    private static String loadPath(String name, boolean isRequired) {
        Properties config = new Properties();
        try {
            config.load(new FileInputStream(MainFrame.CONFIG));
            String value = config.getProperty(name);
            boolean showErr = false;
            if (value == null) {
                if (isRequired) {
                    showErr = true;
                }
            } else if (value.equals("")) {
                if (isRequired) {
                    showErr = true;
                }
            } else if (!new File(value).isFile()) {
                Tools.writeError("Constants.loadPath(): " + name + "=" + value + " doesn't exist.");
            }
            if (showErr) {
                Tools.writeError("Constants.loadPath(): " + name + " is required.");
            }
            return value == null ? "" : value;
        }
        catch (IOException e) {
            Tools.writeError("Constants.loadPath(): " + name + " " + e.getMessage());
            return "";
        }
    }
}

