/*
 * Decompiled with CFR 0.152.
 */
package attendance;

import attendance.Activity;
import database.DBUtil;
import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import member.Member;
import member.MemberGroup;
import printout.xls.ExcelCellFormat;
import printout.xls.ExcelFormat;
import printout.xls.ExcelPrintout;
import system.Lang;
import system.MasterCode;
import util.RecordList;
import util.TimeUtil;

public class AttendanceReport {
    public ExcelCellFormat FORMAT_LATE_TIME = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.FCR);
    public ExcelCellFormat FORMAT_WFAR = new ExcelCellFormat(ExcelCellFormat.STRING, String.valueOf(ExcelFormat.WF) + ExcelFormat.AR);
    public ExcelCellFormat FORMAT_BT = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.BT);
    public ExcelCellFormat FORMAT_BD = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.BD);
    private String ATD__PRESENT = "O";
    private String ATD__LATE = "L";
    private String ATD__EXEMPT_PRESENT = "E";
    private String ATD__EXEMPT_LATE = "LE";
    private String ATD__ABSENT = "A";

    public AttendanceReport(String activity_type, Timestamp start_date, Timestamp end_date, RecordList member_groups, boolean show_time, boolean show_multi_time_range, boolean show_multi_time_sum, boolean show_remark, boolean show_only_group_incl) {
        if (show_multi_time_range) {
            show_time = true;
        }
        RecordList members = AttendanceReport.getMembers(member_groups, start_date, end_date);
        RecordList atvs_n_gps = AttendanceReport.getActivitiesAndGroups(activity_type, start_date, end_date);
        RecordList attendances = AttendanceReport.getAttendances(activity_type, start_date, end_date);
        int atv_col = 0;
        atv_col = show_only_group_incl ? this.getMaxActivityCol(activity_type, start_date, end_date) : atvs_n_gps.uniq(new String[]{"activity_seq"}).size();
        int prefix_col = 7;
        int[] widths = new int[prefix_col + atv_col];
        widths[0] = 30;
        widths[1] = 50;
        widths[2] = 12;
        widths[3] = 12;
        widths[4] = 12;
        widths[5] = 12;
        widths[6] = 14;
        int i = 0;
        while (i < atv_col) {
            widths[prefix_col + i] = !show_multi_time_range ? 16 : 24;
            ++i;
        }
        ExcelPrintout p = new ExcelPrintout(ExcelFormat.PA4R, widths);
        p.addHeader(Lang.set("\u51fa\u5e2d\u8a18\u9304\u5831\u8868"), new String[]{String.valueOf(Lang.set("\u805a\u6703\u985e\u5225: ")) + MasterCode.getName(activity_type), String.valueOf(Lang.set("\u805a\u6703\u65e5\u671f: ")) + TimeUtil.getStringByDate(start_date) + Lang.set(" \u81f3 ") + TimeUtil.getStringByDate(end_date), String.valueOf(Lang.set("\u6703\u773e\u7fa4\u7d44: ")) + MemberGroup.getOneNameStringOfGroups(member_groups), show_time ? "" : Lang.set("\u8a3b\u89e3: O:\u51fa\u5e2d,L:\u9072\u5230,E:\u8c41\u514d\u51fa\u5e2d,LE:\u8c41\u514d\u9072\u5230,\u7a7a\u683c:\u7f3a\u5e2d")});
        int row = p.getRowNumAfterHeader();
        int i2 = 0;
        while (i2 < member_groups.size()) {
            member_groups.setCurrentRow(i2);
            int mg_seq = member_groups.getI("member_group_seq");
            MemberGroup mg = new MemberGroup(mg_seq);
            RecordList mg_members = members.getGroupItems("member_group_seq", mg_seq);
            RecordList hcs = atvs_n_gps.getGroupItems("member_group_seq", mg_seq);
            RecordList atvs = show_only_group_incl ? atvs_n_gps.getGroupItems("member_group_seq", mg_seq) : atvs_n_gps.uniq(new String[]{"activity_seq"});
            p.addCell(0, row += 2, mg.getName());
            p.addCell(0, ++row, Lang.set("\u6703\u773e\u7de8\u865f"), p.TL);
            p.addCell(1, row, Lang.set("\u59d3\u540d"), p.TL);
            p.addCell(2, row, Lang.set("\u51fa\u5e2d"), p.TL);
            p.addCell(3, row, Lang.set("\u51fa(\u8c41)"), p.TL);
            p.addCell(4, row, Lang.set("\u7f3a\u5e2d"), p.TL);
            p.addCell(5, row, Lang.set("\u9072\u5230"), p.TL);
            p.addCell(6, row, Lang.set("\u51fa\u5e2d\u7387"), p.TL);
            int j = 0;
            while (j < atvs.size()) {
                Timestamp date = atvs.getT("date", j);
                SimpleDateFormat df = new SimpleDateFormat("d MMM", Locale.ENGLISH);
                String d = df.format((Date)date, new StringBuffer(), new FieldPosition(2)).toString();
                p.addCell(prefix_col + j, row, d, p.TL);
                ++j;
            }
            int[] mg_activity_present = new int[atvs.size()];
            int[] mg_activity_late = new int[atvs.size()];
            int q = 0;
            while (q < atvs.size()) {
                mg_activity_present[q] = 0;
                mg_activity_late[q] = 0;
                ++q;
            }
            int j2 = 0;
            while (j2 < mg_members.size()) {
                mg_members.setCurrentRow(j2);
                int member_seq = mg_members.getI("member_seq");
                String member_id = mg_members.getS("member_id");
                String display_name = mg_members.getS("display_name");
                RecordList mg_member_atds = attendances.getGroupItems("member_seq", member_seq);
                p.addCell(0, ++row, member_id);
                p.addCell(1, row, display_name);
                int present = 0;
                int exempt_present = 0;
                int late = 0;
                String atd_type = "";
                int q2 = 0;
                while (q2 < atvs.size()) {
                    int activity_seq = atvs.getI("activity_seq", q2);
                    RecordList mb_atds = mg_member_atds.getGroupItems(new String[]{"activity_seq", "member_seq"}, new Integer[]{activity_seq, member_seq});
                    if (!mb_atds.isEmpty()) {
                        Timestamp in_time = mb_atds.getT("in_time", 0);
                        String exempt = mb_atds.getS("exempt", 0);
                        String remark = mb_atds.getS("remark", 0);
                        if (exempt.equals("Y") && in_time == null) {
                            ++exempt_present;
                            atd_type = this.ATD__EXEMPT_PRESENT;
                        } else if (in_time != null) {
                            ++present;
                            int n = q2;
                            mg_activity_present[n] = mg_activity_present[n] + 1;
                            Timestamp late_time = atvs.getT("late_time", q2);
                            if (in_time.after(late_time)) {
                                if (exempt.equals("Y")) {
                                    atd_type = this.ATD__EXEMPT_LATE;
                                } else {
                                    ++late;
                                    int n2 = q2;
                                    mg_activity_late[n2] = mg_activity_late[n2] + 1;
                                    atd_type = this.ATD__LATE;
                                }
                            } else {
                                atd_type = this.ATD__PRESENT;
                            }
                        } else {
                            atd_type = this.ATD__ABSENT;
                        }
                        ExcelCellFormat cf = p.FORMAT_STRING;
                        if (show_time && atd_type.equals(this.ATD__LATE)) {
                            cf = this.FORMAT_LATE_TIME;
                        }
                        String cell = "";
                        if (show_remark && !remark.equals("")) {
                            if (show_multi_time_range) {
                                int t = 0;
                                while (t < mb_atds.size()) {
                                    remark = mg_member_atds.getS("remark", t);
                                    cell = String.valueOf(cell) + remark;
                                    if (t != mb_atds.size() - 1) {
                                        cell = String.valueOf(cell) + "\n";
                                    }
                                    ++t;
                                }
                            } else {
                                cell = remark;
                            }
                        } else if (show_time) {
                            if (show_multi_time_range) {
                                int t = 0;
                                while (t < mb_atds.size()) {
                                    in_time = mg_member_atds.getT("in_time", t);
                                    cell = String.valueOf(cell) + TimeUtil.getStringByTime(in_time);
                                    if (t % 2 == 0) {
                                        cell = String.valueOf(cell) + "-";
                                    } else if (t % 2 == 1 && t != mb_atds.size() - 1) {
                                        cell = String.valueOf(cell) + "\n";
                                    }
                                    ++t;
                                }
                            } else {
                                cell = TimeUtil.getStringByTime(in_time);
                            }
                        } else if (show_multi_time_sum) {
                            long time_sum = 0L;
                            int t = 0;
                            while (t < mb_atds.size()) {
                                if (t % 2 == 1) {
                                    long time_a = mg_member_atds.getT("in_time", t - 1).getTime();
                                    long time_b = mg_member_atds.getT("in_time", t).getTime();
                                    long diff = (time_b - time_a) / 60000L;
                                    time_sum += diff;
                                }
                                ++t;
                            }
                            cell = String.valueOf(time_sum);
                        } else if (!atd_type.equals(this.ATD__ABSENT)) {
                            cell = atd_type;
                        }
                        p.addCell(prefix_col + q2, row, cell, cf);
                    }
                    ++q2;
                }
                p.addCell(2, row, String.valueOf(present));
                p.addCell(3, row, String.valueOf(exempt_present));
                p.addCell(4, row, String.valueOf(atvs.size() - present - exempt_present));
                p.addCell(5, row, String.valueOf(late));
                p.addCell(6, row, String.valueOf(atvs.size() == 0 ? 0 : present * 100 / atvs.size()) + "%");
                ++j2;
            }
            p.addCell(0, ++row, Lang.set("\u7e3d\u4eba\u6578:"), this.FORMAT_WFAR);
            p.addCell(1, row, String.valueOf(mg_members.size()));
            p.addCell(6, row, String.valueOf(mg.getName()) + Lang.set("\u9ede\u5230\u6703\u773e:"), this.FORMAT_WFAR);
            q = 0;
            while (q < atvs.size()) {
                p.addCell(prefix_col + q, row, mg_activity_present[q], this.FORMAT_BT);
                ++q;
            }
            p.addCell(0, ++row, Lang.set("\u805a\u6703\u7e3d\u6578:"), this.FORMAT_WFAR);
            p.addCell(1, row, String.valueOf(atvs.size()));
            p.addCell(6, row, String.valueOf(mg.getName()) + Lang.set("\u51fa\u5e2d\u7e3d\u6578:"), this.FORMAT_WFAR);
            q = 0;
            while (q < atvs.size()) {
                int s = hcs.indexOf("activity_seq", atvs.getI("activity_seq", q));
                int hc = s == -1 ? 0 : hcs.getI("headcount", s);
                p.addCell(prefix_col + q, row, mg_activity_present[q] + hc, this.FORMAT_BD);
                ++q;
            }
            p.addCell(6, ++row, Lang.set("\u9072\u5230\u6703\u773e:"), this.FORMAT_WFAR);
            q = 0;
            while (q < atvs.size()) {
                p.addCell(prefix_col + q, row, mg_activity_late[q]);
                ++q;
            }
            ++i2;
        }
        p.genPrintout();
    }

    private static RecordList getMembers(RecordList member_groups, Timestamp start_date, Timestamp end_date) {
        String sql = "select distinct mgm.member_group_seq,mb.member_seq,mb.member_id,mb.name1,mb.name2" + Member.getSelectDisplayNameSQL() + " from " + " member mb" + ",member_group_member mgm" + " where" + " mb.member_seq=mgm.member_seq" + " and mgm.member_group_seq in" + DBUtil.getSQLInValues(member_groups.getCol("member_group_seq")) + " and mgm.start_date<=?" + " and mgm.end_date>=?" + Member.getOrderByDisplayNameSQL();
        Object[] pvs = new Object[]{end_date, start_date};
        return DBUtil.run(sql, pvs);
    }

    private static RecordList getActivitiesAndGroups(String activity_type, Timestamp start_date, Timestamp end_date) {
        String sql = "select atv.activity_seq,atv.date,atv.late_time,amg.member_group_seq,amg.headcount from activity atv,activity_member_group amg where atv.activity_seq=amg.activity_seq and atv.type=? and atv.status=? and atv.date>=? and atv.date<=?";
        Object[] pvs = new Object[]{activity_type, Activity.STATUS__CP, start_date, end_date};
        return DBUtil.run("select atv.activity_seq,atv.date,atv.late_time,amg.member_group_seq,amg.headcount from activity atv,activity_member_group amg where atv.activity_seq=amg.activity_seq and atv.type=? and atv.status=? and atv.date>=? and atv.date<=?", pvs);
    }

    private int getMaxActivityCol(String activity_type, Timestamp start_date, Timestamp end_date) {
        String sql = "select amg.member_group_seq,count(atv.activity_seq) as ttl_atv from activity atv,activity_member_group amg where atv.activity_seq=amg.activity_seq and atv.type=? and atv.status=? and atv.date>=? and atv.date<=? group by amg.member_group_seq order by ttl_atv desc";
        Object[] pvs = new Object[]{activity_type, Activity.STATUS__CP, start_date, end_date};
        RecordList r = DBUtil.run("select amg.member_group_seq,count(atv.activity_seq) as ttl_atv from activity atv,activity_member_group amg where atv.activity_seq=amg.activity_seq and atv.type=? and atv.status=? and atv.date>=? and atv.date<=? group by amg.member_group_seq order by ttl_atv desc", pvs);
        return r.isEmpty() ? 0 : r.getI("ttl_atv", 0);
    }

    private static RecordList getAttendances(String activity_type, Timestamp start_date, Timestamp end_date) {
        String sql = "select atv.activity_seq,atd.member_seq,atd.in_time,atd.exempt,atd.remark from activity atv,attendance atd where atv.activity_seq=atd.activity_seq and atv.type=? and atv.status=? and atv.date>=? and atv.date<=? order by atv.activity_seq,atd.member_seq,atd.in_time";
        Object[] pvs = new Object[]{activity_type, Activity.STATUS__CP, start_date, end_date};
        return DBUtil.run("select atv.activity_seq,atd.member_seq,atd.in_time,atd.exempt,atd.remark from activity atv,attendance atd where atv.activity_seq=atd.activity_seq and atv.type=? and atv.status=? and atv.date>=? and atv.date<=? order by atv.activity_seq,atd.member_seq,atd.in_time", pvs);
    }
}

