/*
 * Decompiled with CFR 0.152.
 */
package account;

import database.DBUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.StringTokenizer;
import printout.xls.ExcelCellFormat;
import printout.xls.ExcelFormat;
import printout.xls.ExcelFormula;
import printout.xls.ExcelPrintout;
import system.Config;
import system.Lang;
import system.SystemCode;
import util.Arith;
import util.ArrayUtil;
import util.TimeUtil;

public class AccountActivityReport {
    public ExcelCellFormat WF = new ExcelCellFormat(ExcelCellFormat.STRING, ExcelFormat.WF);
    private ArrayList g_Accounts;
    private ArrayList g_Items;

    public AccountActivityReport(String start_ac_id, String end_ac_id, String ac_ids, Timestamp start_date, Timestamp end_date, boolean posted, boolean show_no_trans) {
        this.getData(start_ac_id, end_ac_id, ac_ids, start_date, end_date, posted);
        ExcelPrintout p = new ExcelPrintout(ExcelFormat.PA4, new int[]{22, 25, 83, 25, 25});
        p.addHeader(Config.getS(Config.companyName), Lang.set("\u5206\u985e\u5e33\u5217\u8868"), new String[]{String.valueOf(Lang.set("\u5e33\u6236\u7de8\u865f: ")) + (ac_ids.equals("") ? "\u5168\u90e8" : ac_ids), String.valueOf(Lang.set("\u5e33\u6236\u7e3d\u6578: ")) + this.g_Accounts.size(), String.valueOf(Lang.set("\u65e5\u671f: ")) + TimeUtil.getStringByDate(start_date) + Lang.set(" \u81f3 ") + TimeUtil.getStringByDate(end_date), String.valueOf(Lang.set("\u8cc7\u6599\u4f86\u6e90: ")) + (posted ? Lang.set("\u904e\u5e33\u5f8c\u8cc7\u6599") : Lang.set("\u539f\u59cb\u8cc7\u6599"))});
        int row = p.getRowNumAfterHeader();
        p.addCell(0, row, Lang.set("\u65e5\u671f"), p.TL);
        p.addCell(1, row, Lang.set("\u6587\u4ef6\u7de8\u865f"), p.TL);
        p.addCell(2, row, Lang.set("\u6458\u8981"), p.TL);
        p.addCell(3, row, String.valueOf(Lang.set("\u501f\u65b9(")) + Config.getS(Config.currencyCode) + ")", p.TR);
        p.addCell(4, row, String.valueOf(Lang.set("\u8cb8\u65b9(")) + Config.getS(Config.currencyCode) + ")", p.TR);
        int i = 0;
        while (i < this.g_Accounts.size()) {
            int ac_seq = ArrayUtil.getInt("AC_SEQ", i, this.g_Accounts);
            String ac_id = ArrayUtil.getString("ID", i, this.g_Accounts);
            String name = ArrayUtil.getString("NAME", i, this.g_Accounts);
            String status = ArrayUtil.getString("STATUS", i, this.g_Accounts);
            double bf_debit = ArrayUtil.getDouble("BF_DEBIT", i, this.g_Accounts);
            double bf_credit = ArrayUtil.getDouble("BF_CREDIT", i, this.g_Accounts);
            ArrayList items = ArrayUtil.getGroupItems(this.g_Items, "AC_SEQ", new Integer(ac_seq));
            if (!(items.isEmpty() && !show_no_trans || items.isEmpty() && status.equals(SystemCode.STATUS__D))) {
                p.addCell(0, ++row, Lang.set("\u5e33\u6236\u7de8\u865f:"));
                p.addCell(1, row, String.valueOf(ac_id) + " " + name, this.WF);
                int j = 0;
                while (j < items.size()) {
                    String doc_id = ArrayUtil.getString("ID", j, items);
                    Timestamp date = ArrayUtil.getTimestamp("DATE", j, items);
                    String remark = ArrayUtil.getString("REMARK", j, items);
                    String cheque_no = ArrayUtil.getString("CHEQUE_NO", j, items);
                    double debit = ArrayUtil.getDouble("DEBIT", j, items);
                    double credit = ArrayUtil.getDouble("CREDIT", j, items);
                    p.addCell(0, ++row, date);
                    p.addCell(1, row, doc_id);
                    p.addCell(2, row, String.valueOf(remark) + (!cheque_no.equals("") ? String.valueOf(Lang.set(" \u652f\u7968/\u53c3\u8003#:")) + cheque_no : ""));
                    if (debit != 0.0) {
                        p.addCell(3, row, debit);
                    }
                    if (credit != 0.0) {
                        p.addCell(4, row, credit);
                    }
                    ++j;
                }
                int first_item_row = items.isEmpty() ? row : row - items.size() + 1;
                int last_item_row = row++;
                int item_total_row = row;
                p.addCell(2, row, Lang.set("\u7e3d\u984d:"), p.AR);
                p.addCell(3, row, ExcelFormula.sum(3, first_item_row, 3, last_item_row), p.BTBD);
                p.addCell(4, row, ExcelFormula.sum(4, first_item_row, 4, last_item_row), p.BTBD);
                p.addCell(1, ++row, String.valueOf(ac_id) + " " + name, this.WF);
                int bf_row = ++row;
                p.addCell(0, row, Lang.set("\u627f\u4e0a\u7d50\u9918:"), p.AR);
                p.addCell(1, row, Arith.sub(bf_debit, bf_credit), p.FORMAT_DOUBLE);
                int item_bal_row = ++row;
                p.addCell(0, row, Lang.set("\u9805\u76ee\u7d50\u9918:"), p.AR);
                p.addCell(1, row, ExcelFormula.sub(3, item_total_row, 4, item_total_row), p.FORMAT_DOUBLE);
                p.addCell(2, row, Lang.set("\u9805\u76ee\u7e3d\u9805:"), p.AR);
                p.addCell(3, row, String.valueOf(items.size()));
                p.addCell(0, ++row, Lang.set("\u7d2f\u7a4d\u7d50\u9918:"), p.AR);
                p.addCell(1, row, ExcelFormula.add(1, bf_row, 1, item_bal_row), p.BTBD);
                row += 2;
            }
            ++i;
        }
        p.genPrintout();
    }

    private void getData(String start_ac_id, String end_ac_id, String ac_ids, Timestamp start_date, Timestamp end_date, boolean posted) {
        this.g_Accounts = AccountActivityReport.getAccounts(start_ac_id, end_ac_id, ac_ids);
        ArrayList ac_seqs = ArrayUtil.getCol(this.g_Accounts, "AC_SEQ");
        this.g_Items = AccountActivityReport.getItems(ac_seqs, start_date, end_date, posted);
        if (posted) {
            ArrayList b4_month_balances = AccountActivityReport.getBalanceBeforeStartMonth(ac_seqs, start_date);
            ArrayList b4_start_date_balances = AccountActivityReport.getSumOfStartMonthToStartDate(ac_seqs, start_date);
            int i = 0;
            while (i < this.g_Accounts.size()) {
                int ac_seq = ArrayUtil.getInt("AC_SEQ", i, this.g_Accounts);
                double bf_debit = 0.0;
                double bf_credit = 0.0;
                int k = ArrayUtil.indexOf("AC_SEQ", new Integer(ac_seq), b4_month_balances);
                if (k != -1) {
                    bf_debit = Arith.add(bf_debit, ArrayUtil.getDouble("DEBIT", k, b4_month_balances));
                    bf_credit = Arith.add(bf_credit, ArrayUtil.getDouble("CREDIT", k, b4_month_balances));
                }
                if ((k = ArrayUtil.indexOf("AC_SEQ", new Integer(ac_seq), b4_start_date_balances)) != -1) {
                    bf_debit = Arith.add(bf_debit, ArrayUtil.getDouble("DEBIT", k, b4_start_date_balances));
                    bf_credit = Arith.add(bf_credit, ArrayUtil.getDouble("CREDIT", k, b4_start_date_balances));
                }
                ArrayUtil.setDouble("BF_DEBIT", bf_debit, i, this.g_Accounts);
                ArrayUtil.setDouble("BF_CREDIT", bf_credit, i, this.g_Accounts);
                ++i;
            }
        } else {
            ArrayList bring_forwards = AccountActivityReport.getBringForwards(ac_seqs, start_date);
            int i = 0;
            while (i < this.g_Accounts.size()) {
                int ac_seq = ArrayUtil.getInt("AC_SEQ", i, this.g_Accounts);
                double bf_debit = 0.0;
                double bf_credit = 0.0;
                int k = ArrayUtil.indexOf("AC_SEQ", new Integer(ac_seq), bring_forwards);
                if (k != -1) {
                    bf_debit = Arith.add(bf_debit, ArrayUtil.getDouble("DEBIT", k, bring_forwards));
                    bf_credit = Arith.add(bf_credit, ArrayUtil.getDouble("CREDIT", k, bring_forwards));
                }
                ArrayUtil.setDouble("BF_DEBIT", bf_debit, i, this.g_Accounts);
                ArrayUtil.setDouble("BF_CREDIT", bf_credit, i, this.g_Accounts);
                ++i;
            }
        }
    }

    private static ArrayList getAccounts(String start_ac_id, String end_ac_id, String ac_ids) {
        ArrayList<String> separate_ac_ids = new ArrayList<String>();
        if (!ac_ids.equals("")) {
            if (ac_ids.indexOf(",") >= 0) {
                StringTokenizer st = new StringTokenizer(ac_ids, ",");
                while (st.hasMoreTokens()) {
                    separate_ac_ids.add(st.nextToken());
                }
            } else {
                start_ac_id = ac_ids;
                end_ac_id = ac_ids;
            }
        }
        String sql = "select ac_seq,id,name,status from ac_master where is_parent='N'" + (!start_ac_id.equals("") ? " and id>='" + start_ac_id + "'" : "") + (!end_ac_id.equals("") ? " and id<='" + end_ac_id + "'" : "") + (!separate_ac_ids.isEmpty() ? " and id in" + DBUtil.getSQLInValues(separate_ac_ids) : "") + " order by id";
        return DBUtil.run(sql);
    }

    private static ArrayList getItems(ArrayList ac_seqs, Timestamp start_date, Timestamp end_date, boolean posted) {
        String sql = "select ac_seq,date,id,debit,credit,cheque_no,remark from" + (posted ? " ac_ledger" : " ac_ledger_vw") + " where" + " date>=?" + " and date<?" + " and ac_seq in" + DBUtil.getSQLInValues(ac_seqs) + " order by ac_seq,date,id";
        return DBUtil.run(sql, new Object[]{start_date, TimeUtil.adjustDate(end_date, 1)});
    }

    private static ArrayList getBalanceBeforeStartMonth(ArrayList ac_seqs, Timestamp start_date) {
        String sql = "select acb.ac_seq as ac_seq,sum(acb.debit+acb.adj_debit) as debit,sum(acb.credit+acb.adj_credit) as credit from ac_balance acb,ac_month acm where acb.ac_month_seq=acm.ac_month_seq and acm.end_date<? and acb.ac_seq in" + DBUtil.getSQLInValues(ac_seqs) + " group by acb.ac_seq";
        return DBUtil.run(sql, start_date);
    }

    private static ArrayList getSumOfStartMonthToStartDate(ArrayList ac_seqs, Timestamp start_date) {
        String sql = "select ac_seq,sum(debit) as debit,sum(credit) as credit from ac_ledger where date>=? and date<? and ac_seq in" + DBUtil.getSQLInValues(ac_seqs) + " group by ac_seq";
        return DBUtil.run(sql, new Object[]{TimeUtil.getMonthStartDay(start_date), start_date});
    }

    private static ArrayList getBringForwards(ArrayList ac_seqs, Timestamp start_date) {
        String sql = "select ac_seq,sum(debit) as debit,sum(credit) as credit from ac_ledger_vw where date<? and ac_seq in" + DBUtil.getSQLInValues(ac_seqs) + " group by ac_seq";
        return DBUtil.run(sql, start_date);
    }
}

