/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Image;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class PdfImage
extends PdfStream {
    static final int TRANSFERSIZE = 4096;
    protected PdfName name;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PdfImage(Image image, String name, PdfIndirectReference maskRef) throws BadPdfFormatException {
        block48: {
            block47: {
                block46: {
                    super();
                    this.name = null;
                    this.name = new PdfName(name);
                    this.put(PdfName.TYPE, PdfName.XOBJECT);
                    this.put(PdfName.SUBTYPE, PdfName.IMAGE);
                    this.put(PdfName.WIDTH, new PdfNumber(image.width()));
                    this.put(PdfName.HEIGHT, new PdfNumber(image.height()));
                    if (image.isMask() && (image.bpc() == 1 || image.bpc() > 255)) {
                        this.put(PdfName.IMAGEMASK, PdfBoolean.PDFTRUE);
                    }
                    if (maskRef != null) {
                        if (image.isSmask()) {
                            this.put(PdfName.SMASK, maskRef);
                        } else {
                            this.put(PdfName.MASK, maskRef);
                        }
                    }
                    if (image.isMask() && image.isInvertMask()) {
                        this.put(PdfName.DECODE, new PdfLiteral("[1 0]"));
                    }
                    if (image.isInterpolation()) {
                        this.put(PdfName.INTERPOLATE, PdfBoolean.PDFTRUE);
                    }
                    is = null;
                    try {
                        try {
                            if (image.isImgRaw()) {
                                colorspace = image.colorspace();
                                transparency = image.getTransparency();
                                if (transparency != null && !image.isMask() && maskRef == null) {
                                    s = "[";
                                    for (k = 0; k < transparency.length; ++k) {
                                        s = s + transparency[k] + " ";
                                    }
                                    s = s + "]";
                                    this.put(PdfName.MASK, new PdfLiteral(s));
                                }
                                this.bytes = image.rawData();
                                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                                bpc = image.bpc();
                                if (bpc > 255) {
                                    if (!image.isMask()) {
                                        this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                    }
                                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(1));
                                    this.put(PdfName.FILTER, PdfName.CCITTFAXDECODE);
                                    k = bpc - 257;
                                    decodeparms = new PdfDictionary();
                                    if (k != 0) {
                                        decodeparms.put(PdfName.K, new PdfNumber(k));
                                    }
                                    if ((colorspace & 1) != 0) {
                                        decodeparms.put(PdfName.BLACKIS1, PdfBoolean.PDFTRUE);
                                    }
                                    if ((colorspace & 2) != 0) {
                                        decodeparms.put(PdfName.ENCODEDBYTEALIGN, PdfBoolean.PDFTRUE);
                                    }
                                    if ((colorspace & 4) != 0) {
                                        decodeparms.put(PdfName.ENDOFLINE, PdfBoolean.PDFTRUE);
                                    }
                                    if ((colorspace & 8) != 0) {
                                        decodeparms.put(PdfName.ENDOFBLOCK, PdfBoolean.PDFFALSE);
                                    }
                                    decodeparms.put(PdfName.COLUMNS, new PdfNumber(image.width()));
                                    decodeparms.put(PdfName.ROWS, new PdfNumber(image.height()));
                                    this.put(PdfName.DECODEPARMS, decodeparms);
                                } else {
                                    switch (colorspace) {
                                        case 1: {
                                            this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                            if (!image.isInverted()) break;
                                            this.put(PdfName.DECODE, new PdfLiteral("[1 0]"));
                                            break;
                                        }
                                        case 3: {
                                            this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                            if (!image.isInverted()) break;
                                            this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0]"));
                                            break;
                                        }
                                        default: {
                                            this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                                            if (!image.isInverted()) break;
                                            this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0 1 0]"));
                                        }
                                    }
                                    if ((additional = image.getAdditional()) != null) {
                                        this.putAll(additional);
                                    }
                                    if (image.isMask() && (image.bpc() == 1 || image.bpc() > 8)) {
                                        this.remove(PdfName.COLORSPACE);
                                    }
                                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(image.bpc()));
                                    if (image.isDeflated()) {
                                        this.put(PdfName.FILTER, PdfName.FLATEDECODE);
                                    } else {
                                        this.flateCompress();
                                    }
                                }
                                var11_15 = null;
                                if (is == null) return;
                                break block46;
                            }
                            if (image.rawData() == null) {
                                is = image.url().openStream();
                                errorID = image.url().toString();
                            } else {
                                is = new ByteArrayInputStream(image.rawData());
                                errorID = "Byte array";
                            }
                            i = false;
                            switch (image.type()) {
                                case 32: {
                                    this.put(PdfName.FILTER, PdfName.DCTDECODE);
                                    switch (image.colorspace()) {
                                        case 1: {
                                            this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                            break;
                                        }
                                        case 3: {
                                            this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                            break;
                                        }
                                        default: {
                                            this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                                            if (!image.isInverted()) break;
                                            this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0 1 0]"));
                                        }
                                    }
                                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(8));
                                    if (image.rawData() != null) {
                                        this.bytes = image.rawData();
                                        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                                        break block47;
                                    } else {
                                        this.streamBytes = new ByteArrayOutputStream();
                                        PdfImage.transferBytes(is, this.streamBytes, -1);
                                        break;
                                    }
                                }
                                default: {
                                    throw new BadPdfFormatException(errorID + " is an unknown Image format.");
                                }
                            }
                            this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
                            break block48;
                        }
                        catch (IOException ioe) {
                            throw new BadPdfFormatException(ioe.getMessage());
                        }
                    }
                    catch (Throwable var10_23) {
                        var11_18 = null;
                        if (is == null) throw var10_23;
                        try {
                            is.close();
                            throw var10_23;
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                        throw var10_23;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [7 : 1165->1173)] { 
lbl171:
                // 1 sources

                is.close();
                return;
lbl173:
                // 1 sources

                catch (Exception ee) {
                    // empty catch block
                }
                return;
            }
            var11_16 = null;
            if (is == null) return;
            ** try [egrp 2[TRYBLOCK] [7 : 1165->1173)] { 
lbl180:
            // 1 sources

            is.close();
            return;
lbl182:
            // 1 sources

            catch (Exception ee) {
                // empty catch block
            }
            return;
        }
        var11_17 = null;
        if (is == null) return;
        try {}
        catch (Exception ee) {}
        is.close();
        return;
    }

    public PdfName name() {
        return this.name;
    }

    static void transferBytes(InputStream in, OutputStream out, int len) throws IOException {
        byte[] buffer = new byte[4096];
        if (len < 0) {
            len = 0x7FFFFFF;
        }
        while (len != 0) {
            int size = in.read(buffer, 0, Math.min(len, 4096));
            if (size < 0) {
                return;
            }
            out.write(buffer, 0, size);
            len -= size;
        }
    }

    protected void importAll(PdfImage dup) {
        this.name = dup.name;
        this.compressed = dup.compressed;
        this.streamBytes = dup.streamBytes;
        this.bytes = dup.bytes;
        this.hashMap = dup.hashMap;
    }
}

