/*
 * Decompiled with CFR 0.152.
 */
package venue;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import member.Member;
import system.User;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.DateTextField;
import ui.ListDialog;
import ui.ScrollList2;
import ui.TableLayout;
import util.ArrayUtil;
import util.RecordList;
import util.Tools;
import venue.Venue;
import venue.VenueRequest;
import venue.VenueRequestInfoDialog;

public class VenueRequestListDialog
extends ListDialog {
    private JButton searchB;
    private JButton modifyB;
    private JButton addB;
    private JButton copyB;
    private ComboBoxNV venueNameNV;
    private ComboBoxCN requestStatusCN;
    private DateTextField start_dateDT;
    private DateTextField end_dateDT;
    private ScrollList2 listSL;
    private RecordList g_List = VenueRequest.search(-1, "", null, null);

    public VenueRequestListDialog(JFrame frame) {
        super(frame, "Venue Reservation List", false);
        this.setLayout();
        this.setEventHandler();
        this.showDialog();
    }

    private void setLayout() {
        this.venueNameNV = new ComboBoxNV((ArrayList)Venue.getVenueNames(), "name", "venue_seq", -1);
        this.requestStatusCN = this.getStatus();
        this.start_dateDT = new DateTextField();
        this.end_dateDT = new DateTextField();
        this.searchB = new JButton("Search");
        this.modifyB = new JButton("Edit/View");
        this.addB = new JButton("Add");
        this.copyB = new JButton("Copy");
        this.addB.setEnabled(User.hasPrivilege("venueRequestModify"));
        this.modifyB.setEnabled(User.hasPrivilege("venueRequestRead"));
        this.copyB.setEnabled(User.hasPrivilege("venueRequestModify"));
        this.listSL = new ScrollList2(680, 415, this.g_List, new int[]{80, 50, 43, 43, 95, 104, 35, 70, 100, 50}, new String[]{"Date", "Week", "Start", "End", "Venue", "Use By", "U#", "Usage", "Apply", "Status"}, new String[]{"date", "week", "start_time", "end_time", "venue_name", "member_group_name", "user_num", "purpose", Member.DISPLAY_NAME, "status"}, new boolean[10]);
        this.listSL.setDateTextFieldColumn("date");
        this.listSL.setWeekTextFieldColumn("week");
        this.addResizeComp(this.listSL, true, true);
        TableLayout t = new TableLayout(this, 720, 575, 5, 10);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 370;
        nArray[2] = 130;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30, 30});
        JLabel jLabel = new JLabel("Date");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.addCell(this.start_dateDT, 1, 0, 20, 0);
        JLabel jLabel2 = new JLabel("to");
        t.getClass();
        t.addCell(jLabel2, 1, 0, 115, 0);
        t.getClass();
        t.addCell(this.end_dateDT, 1, 0, 140, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.searchB, 2, 0, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 3, 0, -1, 0, 115, -1);
        JLabel jLabel3 = new JLabel("Venue");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 1, 1, 0);
        t.getClass();
        t.addCell(this.venueNameNV, 1, 1, 20, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.modifyB, 3, 1, -1, 0, 115, -1);
        JLabel jLabel4 = new JLabel("Status");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, 2, 1, 0);
        t.getClass();
        t.addCell(this.requestStatusCN, 1, 2, 20, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.copyB, 3, 2, -1, 0, 115, -1);
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{425});
        t.getClass();
        t.getClass();
        t.addCell(this.listSL, 0, 0, -1, -1);
    }

    private ComboBoxCN getStatus() {
        String[][] status = new String[][]{Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__WA), Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__AP), Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__CL), Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__RJ)};
        ComboBoxCN c = new ComboBoxCN(ComboBoxCN.buildItemsByArray(status), "");
        c.hasNilItem(true);
        return c;
    }

    private void setEventHandler() {
        this.searchB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestListDialog.this.onSearch(evt);
            }
        });
        this.modifyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestListDialog.this.onModify(evt);
            }
        });
        this.addB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestListDialog.this.onAdd(evt);
            }
        });
        this.copyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestListDialog.this.onCopy(evt);
            }
        });
        this.listSL.getViewport().getView().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    VenueRequestListDialog.this.onModify(null);
                }
            }
        });
        this.listSL.getViewport().getView().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    VenueRequestListDialog.this.onModify(null);
                }
            }
        });
    }

    public void onSearch(ActionEvent evt) {
        int venue_seq = this.venueNameNV.getSelectedIntValue();
        String status = this.requestStatusCN.getSelectedCode();
        RecordList r = VenueRequest.search(venue_seq, status, this.start_dateDT.getDate(), this.end_dateDT.getDate());
        this.listSL.refreshTable(r);
    }

    private void onModify(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int venue_request_seq = ArrayUtil.getInt("VENUE_REQUEST_SEQ", selrow, this.listSL.getTableData());
            VenueRequestInfoDialog venueRequestInfoDialog = new VenueRequestInfoDialog((DataDialog)this, venue_request_seq, true);
        }
    }

    public void onAdd(ActionEvent evt) {
        VenueRequestInfoDialog d = new VenueRequestInfoDialog((DataDialog)this, -1, false);
    }

    public void onCopy(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int venue_request_seq = ArrayUtil.getInt("VENUE_REQUEST_SEQ", selrow, this.listSL.getTableData());
            VenueRequestInfoDialog venueRequestInfoDialog = new VenueRequestInfoDialog((DataDialog)this, venue_request_seq, false);
        }
    }
}

