/*
 * Decompiled with CFR 0.152.
 */
package venue;

import database.DBConn;
import database.DBUtil;
import system.SystemCode;
import util.RecordList;
import venue.VenueEquipment;

public class Venue {
    public static int FREE_EQUIPMENT_SEQ = -2;
    private int g_Venue_seq = -1;
    private String g_Name = "";
    private String g_Desc = "";
    private String g_Status = "";
    private int g_User_capacity = 0;
    private int g_Request_before = 0;
    private int g_Request_upto = 0;
    private String g_Overlap = "";

    public Venue() {
    }

    public Venue(int venue_seq) {
        this.g_Venue_seq = venue_seq;
        this.load(null);
    }

    public int getVenue_seq() {
        return this.g_Venue_seq;
    }

    public String getName() {
        return this.g_Name;
    }

    public String getDesc() {
        return this.g_Desc;
    }

    public String getStatus() {
        return this.g_Status;
    }

    public int getUser_capacity() {
        return this.g_User_capacity;
    }

    public int getRequest_before() {
        return this.g_Request_before;
    }

    public int getRequest_upto() {
        return this.g_Request_upto;
    }

    public String getOverlap() {
        return this.g_Overlap;
    }

    private void load(DBConn conn) {
        String sql = "select * from venue where venue_seq=?";
        RecordList r = DBUtil.run(sql, this.g_Venue_seq, conn);
        if (!r.isEmpty()) {
            r.setCurrentRow(0);
            this.g_Name = r.getS("name");
            this.g_Desc = r.getS("desc");
            this.g_Status = r.getS("status");
            this.g_User_capacity = r.getI("user_capacity");
            this.g_Request_before = r.getI("request_before");
            this.g_Request_upto = r.getI("request_upto");
            this.g_Overlap = r.getS("overlap");
        }
    }

    public static int insert(String name, String desc, String status, int user_capacity, int request_before, int request_upto, String overlap, RecordList equipments) {
        String sql = "insert into venue( venue_seq,name,desc,status,user_capacity,request_before,request_upto,overlap)values(?,?,?,?,?,?,?,?)";
        DBConn conn = new DBConn();
        int venue_seq = DBUtil.getNextValueFor("venue_seq", conn);
        DBUtil.run(sql, new Object[]{new Integer(venue_seq), name, desc, status, new Integer(user_capacity), new Integer(request_before), new Integer(request_upto), overlap}, conn);
        VenueEquipment.update(venue_seq, equipments, conn);
        conn.commit();
        return conn.isSuccessful() ? venue_seq : -1;
    }

    public static int update(int venue_seq, String name, String desc, String status, int user_capacity, int request_before, int request_upto, String overlap, RecordList equipments) {
        String sql = "update venue set name=?,desc=?,status=?,user_capacity=?,request_before=?,request_upto=?,overlap=? where venue_seq=?";
        DBConn conn = new DBConn();
        DBUtil.run(sql, new Object[]{name, desc, status, new Integer(user_capacity), new Integer(request_before), new Integer(request_upto), overlap, new Integer(venue_seq)}, conn);
        VenueEquipment.update(venue_seq, equipments, conn);
        conn.commit();
        return conn.isSuccessful() ? venue_seq : -1;
    }

    public static int updateFreeEquipment(RecordList equipments) {
        DBConn conn = new DBConn();
        VenueEquipment.update(FREE_EQUIPMENT_SEQ, equipments, conn);
        conn.commit();
        return FREE_EQUIPMENT_SEQ;
    }

    public static RecordList search() {
        String sql = "select venue_seq,name,status from venue order by status asc, name";
        RecordList r = DBUtil.run(sql);
        int i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            r.setS("status", SystemCode.getStatus(r.getS("status")));
            ++i;
        }
        return r;
    }

    public static RecordList getVenueNames() {
        String sql = "select venue_seq,name from venue where STATUS='" + SystemCode.STATUS__A + "'" + " order by name";
        return DBUtil.run(sql);
    }
}

