/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import system.Lang;
import ui.DataDialog;
import ui.ProcessingDialog;

public class WinUtil {
    public static void setFixedWindow(Component c, int width, int height) {
        c.setSize(width, height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        c.setLocation(Math.max(0, (screenSize.width - width) / 2), Math.max(0, (screenSize.height - height) / 2));
        if (c instanceof JFrame) {
            JFrame f = (JFrame)c;
            f.setResizable(false);
        } else if (c instanceof DataDialog) {
            DataDialog f = (DataDialog)c;
            f.setResizable(false);
        }
    }

    public static DataDialog getWaitingDialog(DataDialog parent, String message) {
        return WinUtil.getWaitingDialog(parent, message, 0.4);
    }

    public static DataDialog getWaitingDialog(DataDialog parent, String message, double wait_second) {
        ProcessingDialog f = new ProcessingDialog(parent, message, true, wait_second);
        return f;
    }

    public static boolean getConfirm(Component c, String message) {
        int reply = JOptionPane.showConfirmDialog(c, Lang.set(message), Lang.set("Information"), 1);
        return reply == 0;
    }

    public static void showMessage(Component c, String message) {
        JOptionPane.showMessageDialog(c, Lang.set(message), Lang.set("Information"), 1);
    }

    public static boolean getConfirmSave(Component c) {
        return WinUtil.getConfirm(c, "Save?");
    }

    public static boolean getConfirmCancel(Component c) {
        return WinUtil.getConfirm(c, "Cancel the input?");
    }
}

