/*
 * Decompiled with CFR 0.152.
 */
package system;

import database.DBConn;
import database.DBUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import system.Config;
import system.Constants;
import ui.DataDialog;
import ui.TableLayout;
import util.Tools;
import util.WinUtil;

public class SystemUpdate {
    private String gDbVersion = Config.getS(Config.dbVersion);

    public SystemUpdate() {
        String message;
        if (this.gDbVersion.equals("")) {
            this.gDbVersion = "1.0.0";
        }
        if (Constants.VERSION.equals(this.gDbVersion)) {
            if (Config.getS(Config.uid).isEmpty()) {
                String message2 = "You are the first time to use ACTS Church Management Software\nDefault Login:admin  Password:admin\n";
                JOptionPane.showMessageDialog(null, message2);
            }
            return;
        }
        if (SystemUpdate.isUpdate(this.gDbVersion, Constants.VERSION)) {
            JOptionPane.showMessageDialog(null, "This program requires database version: " + Constants.VERSION + " and the current database version: " + this.gDbVersion + " are not matched. Program terminated.");
            System.exit(0);
        }
        if (!WinUtil.getConfirm(null, "Program version:" + Constants.VERSION + " is newer than the current database version:" + this.gDbVersion + ", do the database upgrade now?")) {
            JOptionPane.showMessageDialog(null, "Database must be upgrade before use. Program terminated.");
            System.exit(0);
        }
        if (!WinUtil.getConfirm(null, message = "Please make sure below steps are done:\n(If you are using Webtool, please stop the database first.)\n1. Backup the whole ACTS software(Copy the whole ACTS program folder)\n2. Copy the original acts\\config\\config.txt, acts\\db and acts\\image folders to the new ACTS program folder.")) {
            JOptionPane.showMessageDialog(null, "You can do the update later. Program terminated.");
            System.exit(0);
        }
        AdminPasswordDialog apd = new AdminPasswordDialog(null);
        this.processUpdate();
    }

    public void processUpdate() {
        boolean success = false;
        DBConn conn = new DBConn(false);
        if (this.gDbVersion.equals("1.0.0")) {
            success = this.update100to110(conn);
            this.gDbVersion = "1.1.0";
        }
        if (this.gDbVersion.equals("1.1.0")) {
            success = this.update110to120(conn);
            this.gDbVersion = "1.2.0";
        }
        if (this.gDbVersion.equals("1.2.0")) {
            success = this.update120to121(conn);
            this.gDbVersion = "1.2.1";
        }
        if (this.gDbVersion.equals("1.2.1")) {
            success = this.update121to122(conn);
            this.gDbVersion = "1.2.2";
        }
        conn.commit();
        if (success) {
            JOptionPane.showMessageDialog(null, "Software update successful");
        } else {
            JOptionPane.showMessageDialog(null, "Update failed, please refer to error.txt");
            System.exit(0);
        }
    }

    private boolean update100to110(DBConn conn) {
        String sql = "";
        boolean success = false;
        sql = "alter table member add column receipt_type varchar(6);";
        DBUtil.run(sql, conn);
        sql = "update member set receipt_type='P';";
        DBUtil.run(sql, conn);
        sql = "alter table receipt add column require_receipt varchar(1);";
        DBUtil.run(sql, conn);
        sql = "alter table receipt add column email_status varchar(6);";
        DBUtil.run(sql, conn);
        sql = "alter table receipt add column email_time timestamp(6);";
        DBUtil.run(sql, conn);
        sql = "update receipt set require_receipt='Y',email_status='NA';";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege_base(privilege,name,has_member_group,display_seq) values ('receiptApprove','Receipt Approve','N',1850);";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege(user_privilege_seq,user_seq,member_group_seq,privilege) select next value for user_privilege_seq,user_seq,1,'receiptApprove' from user_privilege where privilege='receiptModify';";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('lang','TC');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('emailHost','');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,i) values ('emailPort',25);";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('emailUser','');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('emailPwd','');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('adminEmail','');";
        DBUtil.run(sql, conn);
        sql = "alter table venue_request drop column approve_user_seq;";
        DBUtil.run(sql, conn);
        sql = "alter table venue_request drop column approve_date;";
        DBUtil.run(sql, conn);
        sql = "alter table venue_request add column member_group_seq int;";
        DBUtil.run(sql, conn);
        sql = "update venue_request set member_group_seq=1;";
        DBUtil.run(sql, conn);
        sql = "alter table venue_request add column email_status varchar(6);";
        DBUtil.run(sql, conn);
        sql = "update venue_request set email_status='NA';";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege_base(privilege,name,has_member_group,display_seq) values ('venueRequestApprove','Venue Reservation Approve','N',1350);";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege(user_privilege_seq,user_seq,member_group_seq,privilege) select next value for user_privilege_seq,user_seq,1,'venueRequestApprove' from user_privilege where privilege='venueRequestModify';";
        DBUtil.run(sql, conn);
        sql = "update user_privilege_base set name='Member Group Read' where privilege='memberGroupRead';";
        DBUtil.run(sql, conn);
        sql = "update user_privilege_base set name='Member Group Modify' where privilege='memberGroupModify';";
        DBUtil.run(sql, conn);
        sql = "delete from config where name='venueRequestApproval';";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,t) values ('venueRequestMaxDate','2099-01-01 21:00:00');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('venueRequestEmail','');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('receiptEmail','');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('enableEmail','N');";
        DBUtil.run(sql, conn);
        sql = "update activity set remark=coalesce(remark,'')||'(Venue: '||coalesce(venue,'N/A')||')';";
        DBUtil.run(sql, conn);
        sql = "alter table activity drop column venue;";
        DBUtil.run(sql, conn);
        sql = "alter table activity add column venue_seq int;";
        DBUtil.run(sql, conn);
        sql = "insert into venue(venue_seq,name,status,user_capacity,request_before,has_floor_plan) values (next value for venue_seq,'Others','A','10000','0','N');";
        DBUtil.run(sql, conn);
        sql = "update activity set venue_seq=(select max(venue_seq) from venue);";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('uid','');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('autoCheckUpdate','N');";
        DBUtil.run(sql, conn);
        sql = "alter table user add column known_version varchar(32);";
        DBUtil.run(sql, conn);
        sql = "update user set known_version='1.1.0';";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege_base(privilege,name,has_member_group,display_seq) values ('memberReport','Member Report','N',950);";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege_base(privilege,name,has_member_group,display_seq) values ('venueRequestReport','Venue Reservation Report','N',1375);";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege_base(privilege,name,has_member_group,display_seq) values ('importData','Import Data','N',575);";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege_base(privilege,name,has_member_group,display_seq) values ('runSQL','Run SQL','N',585);";
        DBUtil.run(sql, conn);
        sql = "alter table master_code alter column name varchar(128);";
        DBUtil.run(sql, conn);
        sql = "alter table master_code alter column code_group varchar(50);";
        DBUtil.run(sql, conn);
        sql = "alter table master_code alter column sub_code varchar(50);";
        DBUtil.run(sql, conn);
        sql = "update config set s='1.1.0',i=null where name='dbVersion';";
        DBUtil.run(sql, conn);
        sql = "update config set t=now() where name='dbUpdateDate';";
        DBUtil.run(sql, conn);
        return conn.isRunnable();
    }

    private boolean update110to120(DBConn conn) {
        String sql = "";
        sql = "alter table member add column official_name varchar(128) before HKID;";
        DBUtil.run(sql, conn);
        sql = "alter table member alter column name_chi rename to name1;";
        DBUtil.run(sql, conn);
        sql = "alter table member alter column name_eng rename to name2;";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('displayNameFormat','[n1] [n2]');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('displayNameShortFormat','[n1]');";
        DBUtil.run(sql, conn);
        sql = "update member set official_name=coalesce(name1,'')||' '||coalesce(name2,'');";
        DBUtil.run(sql, conn);
        sql = "update member set name1=null where name1='';";
        DBUtil.run(sql, conn);
        sql = "update member set name2=null where name2='';";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('venueRequestWalkInPeriod','');";
        DBUtil.run(sql, conn);
        sql = "update venue_request set email_status='NA' where venue_request_seq in( select vr.venue_request_seq from venue_request vr,member mb where vr.member_seq=mb.member_seq and vr.email_status='TBS' and (mb.email is null or mb.email=''));";
        DBUtil.run(sql, conn);
        sql = "alter table venue add column request_upto int;";
        DBUtil.run(sql, conn);
        sql = "alter table venue alter column has_floor_plan rename to overlap;";
        DBUtil.run(sql, conn);
        sql = "update venue set request_upto=0;";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('venueRequestDefaultApproved','N');";
        DBUtil.run(sql, conn);
        sql = "alter table ac_ledger alter column cheque_no varchar(2000);";
        DBUtil.run(sql, conn);
        sql = "alter table ac_master add column remark varchar(2000);";
        DBUtil.run(sql, conn);
        sql = "alter table receipt add column payment_method varchar(6);";
        DBUtil.run(sql, conn);
        sql = "alter table receipt_item add column target_date timestamp;";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('receiptPrintoutStatement','');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('offeringPrintoutStatement','');";
        DBUtil.run(sql, conn);
        sql = "update user_privilege_base set name='Receipt Report' where privilege='receiptPrint';";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('receiptAllowModify','Y');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('voucherAllowModify','Y');";
        DBUtil.run(sql, conn);
        sql = "update user_privilege_base set has_member_group='Y' where privilege='memberModify';";
        DBUtil.run(sql, conn);
        sql = "update user_privilege_base set has_member_group='Y' where privilege='memberReport';";
        DBUtil.run(sql, conn);
        sql = "update user_privilege_base set has_member_group='Y' where privilege='memberGroupRead';";
        DBUtil.run(sql, conn);
        sql = "update user_privilege_base set has_member_group='Y' where privilege='memberGroupModify';";
        DBUtil.run(sql, conn);
        sql = "update user_privilege_base set has_member_group='Y' where privilege='activityRead';";
        DBUtil.run(sql, conn);
        sql = "update user_privilege_base set has_member_group='Y' where privilege='activityModify';";
        DBUtil.run(sql, conn);
        sql = "update user_privilege_base set has_member_group='Y' where privilege='attendanceReport';";
        DBUtil.run(sql, conn);
        sql = "update config set s='1.2.0',i=null where name='dbVersion';";
        DBUtil.run(sql, conn);
        sql = "update config set t=now() where name='dbUpdateDate';";
        DBUtil.run(sql, conn);
        return conn.isRunnable();
    }

    private boolean update120to121(DBConn conn) {
        String sql = "";
        sql = "insert into config(name,s) values ('emailEncryption','NA');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('receiptRequireReceipt','N');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('voucherSignTitle','Operator Signature                                         Approver Signature and Chop');";
        DBUtil.run(sql, conn);
        sql = "update config set s='1.2.1',i=null where name='dbVersion';";
        DBUtil.run(sql, conn);
        sql = "update config set t=now() where name='dbUpdateDate';";
        DBUtil.run(sql, conn);
        sql = "alter table ac_master add column status varchar(6);";
        DBUtil.run(sql, conn);
        sql = "update ac_master set status='A';";
        DBUtil.run(sql, conn);
        return conn.isRunnable();
    }

    private boolean update121to122(DBConn conn) {
        String sql = "";
        sql = "update config set s='1.2.2',i=null where name='dbVersion';";
        DBUtil.run(sql, conn);
        sql = "update config set t=now() where name='dbUpdateDate';";
        DBUtil.run(sql, conn);
        return conn.isRunnable();
    }

    public static boolean isUpdate(String ver1, String ver2) {
        int fix2;
        int fix1;
        block5: {
            int min2;
            int min1;
            block4: {
                try {
                    StringTokenizer v1 = new StringTokenizer(ver1, ".");
                    StringTokenizer v2 = new StringTokenizer(ver2, ".");
                    int maj1 = Integer.parseInt(v1.nextToken());
                    min1 = Integer.parseInt(v1.nextToken());
                    fix1 = Integer.parseInt(v1.nextToken());
                    int maj2 = Integer.parseInt(v2.nextToken());
                    min2 = Integer.parseInt(v2.nextToken());
                    fix2 = Integer.parseInt(v2.nextToken());
                    if (maj1 >= maj2) break block4;
                    return false;
                }
                catch (Exception e) {
                    Tools.writeError(e.toString());
                    return true;
                }
            }
            if (min1 >= min2) break block5;
            return false;
        }
        return fix1 >= fix2;
    }

    private class AdminPasswordDialog
    extends DataDialog {
        private JPasswordField passwordTF;
        private JButton saveB;
        private JButton cancelB;

        public AdminPasswordDialog(JFrame frame) {
            super(frame, "Password", true);
            this.setDefaultCloseOperation(0);
            this.setLayout();
            this.setEventHandler();
            this.setVisible(true);
            this.setModal(true);
        }

        public void setLayout() {
            TableLayout t = new TableLayout(this, 250, 170, 20, 20);
            int[] nArray = new int[2];
            nArray[0] = 60;
            t.addTable(nArray, new int[]{30, 30});
            this.passwordTF = new JPasswordField();
            JLabel jLabel = new JLabel("Please enter admin password to start the update program");
            t.getClass();
            t.getClass();
            t.addCell(jLabel, 0, 0, -1, 0);
            JLabel jLabel2 = new JLabel("Password");
            t.getClass();
            t.getClass();
            t.addCell(jLabel2, 0, 1, 1, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.passwordTF, 1, 1, 20, 0, 120, -1);
            t.addYSpace(10);
            t.addTable(new int[]{100, 20, 80}, new int[]{20});
            this.saveB = new JButton("Save");
            this.cancelB = new JButton("Cancel");
            t.addCell(this.saveB, 0, 0, 1, 10);
            t.addCell(this.cancelB, 2, 0, -1, 10);
        }

        public void setEventHandler() {
            this.saveB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AdminPasswordDialog.this.onSave(evt);
                }
            });
            this.cancelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AdminPasswordDialog.this.onCancel(evt);
                }
            });
        }

        public void onSave(ActionEvent evt) {
            String password = new String(this.passwordTF.getPassword());
            if (!Tools.md5(password).equals(Config.getS(Config.adminPwd))) {
                JOptionPane.showMessageDialog(null, "Password Incorrect.");
                return;
            }
            this.dispose();
        }

        public void onCancel(ActionEvent evt) {
            JOptionPane.showMessageDialog(null, "Database must be updated first. Program Terminated.");
            System.exit(0);
        }
    }
}

