/*
 * Decompiled with CFR 0.152.
 */
package system;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import system.MasterCodeInfoDialog;
import system.MasterGroup;
import system.User;
import ui.ListDialog;
import ui.ScrollList;
import ui.TableLayout;
import util.ArrayListCreator;
import util.ArrayUtil;

public class MasterCodeListDialog
extends ListDialog {
    private JButton modifyB;
    private ScrollList listSL;
    private ArrayList g_List;

    public MasterCodeListDialog(JFrame frame) {
        super(frame, "Custom Code List", false);
        ArrayListCreator creator = new ArrayListCreator(new String[]{"code_group", "group_name"});
        int i = 0;
        while (i < MasterGroup.ALL_GROUPS.length) {
            creator.add(new String[]{MasterGroup.ALL_GROUPS[i], MasterGroup.ALL_GROUP_NAMES[i]});
            ++i;
        }
        this.g_List = creator.getArrayList();
        this.setLayout();
        this.setEventHandler();
        this.showDialog();
    }

    private void setLayout() {
        this.modifyB = new JButton("Edit/View");
        this.modifyB.setEnabled(User.hasPrivilege("masterCodeRead"));
        this.listSL = new ScrollList(560, 470, this.g_List, new int[]{450}, new String[]{"Category"}, new String[]{"GROUP_NAME"}, new boolean[1]);
        this.addResizeComp(this.listSL, true, true);
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        int[] nArray = new int[2];
        nArray[0] = 450;
        t.getClass();
        nArray[1] = 0;
        t.addTable(nArray, new int[]{30});
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.modifyB, 1, 0, -1, 0, 115, -1);
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{425});
        t.getClass();
        t.getClass();
        t.addCell(this.listSL, 0, 0, -1, -1);
    }

    private void setEventHandler() {
        this.modifyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MasterCodeListDialog.this.onModify(evt);
            }
        });
        this.listSL.getViewport().getView().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MasterCodeListDialog.this.onModify(null);
                }
            }
        });
        this.listSL.getViewport().getView().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    MasterCodeListDialog.this.onModify(null);
                }
            }
        });
    }

    private void onModify(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            String code_group = ArrayUtil.getString("CODE_GROUP", selrow, this.listSL.getTableData());
            MasterCodeInfoDialog masterCodeInfoDialog = new MasterCodeInfoDialog(this, code_group);
        }
    }
}

