/*
 * Decompiled with CFR 0.152.
 */
package member;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import member.MemberLabelPrintout;
import member.MemberRemark;
import system.Lang;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.ScrollList2;
import ui.TableLayout;
import util.ArrayListCreator;
import util.RecordList;
import util.Tools;
import util.Validation;
import util.WinUtil;

public class MemberLabelPrintoutDialog
extends DataDialog {
    private JButton printB;
    private JButton cancelB;
    private JRadioButton printHorizontalRB;
    private JRadioButton printVerticalRB;
    private JRadioButton printGroupContRB;
    private JRadioButton printGroupSingleRB;
    private JRadioButton printGroupParaRB;
    private JRadioButton printGroupPageRB;
    private JRadioButton printGroupParaCutRB;
    private JTextField thresholdTF;
    private JTextField emptyCellTF;
    private JCheckBox useBorderCB;
    private Properties g_Config = null;
    private JTextField rowTF;
    private JTextField columnTF;
    private JTextField copyTF;
    private JTextField vPaddingTF;
    private JTextField hPaddingTF;
    private ComboBoxCN sortingCN;
    private ArrayList sortingAL;
    private String[] cbcnCode;
    private String[] cbcnName;
    private ArrayList gMemberSeqs;
    private ScrollList2 gInfoSL;
    private RecordList gInfos;

    public MemberLabelPrintoutDialog(DataDialog f, ArrayList member_seqs) {
        super(f, "Print Member Label", false);
        this.gMemberSeqs = member_seqs;
        this.gInfos = new RecordList(new String[]{"code", "name", "selected", "point", "align", "order"});
        this.gInfos.addItem(new Object[]{MemberLabelPrintout.INFO__NAME1, Lang.set("Name 1"), "N", "8", MemberLabelPrintout.ALIGN__LEFT, "1"});
        this.gInfos.addItem(new Object[]{MemberLabelPrintout.INFO__NAME2, Lang.set("Name 2"), "N", "8", MemberLabelPrintout.ALIGN__LEFT, "2"});
        this.gInfos.addItem(new Object[]{MemberLabelPrintout.INFO__OFFICIAL_NAME, Lang.set("Official Name"), "N", "8", MemberLabelPrintout.ALIGN__LEFT, "3"});
        this.gInfos.addItem(new Object[]{MemberLabelPrintout.INFO__BARCODE, Lang.set("Member ID Barcode"), "N", "18", MemberLabelPrintout.ALIGN__LEFT, "4"});
        this.gInfos.addItem(new Object[]{MemberLabelPrintout.INFO__MEMBER_ID, Lang.set("Member ID"), "N", "8", MemberLabelPrintout.ALIGN__LEFT, "5"});
        this.gInfos.addItem(new Object[]{MemberLabelPrintout.INFO__ADDRESS, Lang.set("Address"), "N", "8", MemberLabelPrintout.ALIGN__LEFT, "6"});
        RecordList remarkCols = MemberRemark.getRemarkCols();
        int i = 0;
        while (i < remarkCols.size()) {
            remarkCols.setCurrentRow(i);
            this.gInfos.addItem(new Object[]{remarkCols.getS("code"), remarkCols.getS("name"), "N", "8", MemberLabelPrintout.ALIGN__LEFT, String.valueOf(this.gInfos.size() + 1)});
            ++i;
        }
        this.setLayout();
        this.getConfigValue();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        TableLayout t = new TableLayout(this, 420, 555, 5, 10);
        boolean[] blArray = new boolean[5];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        this.gInfoSL = new ScrollList2(380, 200, this.gInfos, new int[]{150, 45, 45, 75, 40}, new String[]{"Item", "Select", "Size", "Align", "Order"}, new String[]{"name", "selected", "point", "align", "order"}, blArray);
        this.gInfoSL.setEditing_mode(true);
        this.gInfoSL.setCheckBoxYNColumn("selected", "Y", "N");
        ArrayListCreator alignAC = new ArrayListCreator(new String[]{"align_name", "align_key"});
        alignAC.add(new String[]{Lang.set("Left"), MemberLabelPrintout.ALIGN__LEFT});
        alignAC.add(new String[]{Lang.set("Center"), MemberLabelPrintout.ALIGN__CENTER});
        alignAC.add(new String[]{Lang.set("Right"), MemberLabelPrintout.ALIGN__RIGHT});
        ComboBoxNV alignNV = new ComboBoxNV(alignAC.getArrayList(), "align_name", "align_key", MemberLabelPrintout.ALIGN__LEFT);
        alignNV.hasNilItem(false);
        this.gInfoSL.setComboxNVColumn("align", alignNV);
        int[] nArray = new int[1];
        t.getClass();
        nArray[0] = 0;
        t.addTable(nArray, new int[]{215});
        t.getClass();
        t.getClass();
        t.addCell(this.gInfoSL, 0, 0, -1, -1);
        this.columnTF = new JTextField("");
        this.rowTF = new JTextField("");
        this.vPaddingTF = new JTextField("");
        this.hPaddingTF = new JTextField("");
        this.useBorderCB = new JCheckBox("Print border", false);
        this.sortingAL = new ArrayList();
        this.cbcnCode = new String[]{MemberLabelPrintout.SORT__NAME1, MemberLabelPrintout.SORT__NAME2, MemberLabelPrintout.SORT__OFFICIAL_NAME, MemberLabelPrintout.SORT__MEMBER_ID};
        this.cbcnName = new String[]{"Name 1", "Name 2", "Official Name", "Member ID"};
        int i = 0;
        while (i < this.cbcnName.length) {
            HashMap<String, String> h = new HashMap<String, String>();
            h.put("code", this.cbcnCode[i]);
            h.put("name", this.cbcnName[i]);
            h.put("default_item", "N");
            this.sortingAL.add(h);
            ++i;
        }
        this.sortingCN = new ComboBoxCN(this.sortingAL);
        this.sortingCN.hasNilItem(false);
        this.sortingCN.setSelectedCode(MemberLabelPrintout.SORT__NAME1);
        this.copyTF = new JTextField("");
        this.emptyCellTF = new JTextField("0");
        this.printHorizontalRB = new JRadioButton("Horizontal");
        this.printVerticalRB = new JRadioButton("Portrait");
        this.printHorizontalRB.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.printHorizontalRB);
        group.add(this.printVerticalRB);
        this.printGroupContRB = new JRadioButton("Continued");
        this.printGroupSingleRB = new JRadioButton("Single(Letter mode)");
        this.printGroupParaRB = new JRadioButton("Group to section");
        this.printGroupPageRB = new JRadioButton("Group to page");
        this.printGroupParaCutRB = new JRadioButton("Group to section, over");
        this.printGroupContRB.setSelected(true);
        this.thresholdTF = new JTextField("1");
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.printGroupContRB);
        group2.add(this.printGroupSingleRB);
        group2.add(this.printGroupParaRB);
        group2.add(this.printGroupPageRB);
        group2.add(this.printGroupParaCutRB);
        t.addYSpace(10);
        int[] nArray2 = new int[6];
        nArray2[0] = 40;
        nArray2[1] = 60;
        nArray2[2] = 45;
        nArray2[3] = 40;
        nArray2[4] = 55;
        t.getClass();
        nArray2[5] = 0;
        t.addTable(nArray2, new int[]{30, 30, 30, 30, 30, 30, 30, 30});
        int row = 0;
        JLabel jLabel = new JLabel("Cell");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.columnTF, 1, row, 20, 0, 30, -1);
        JLabel jLabel2 = new JLabel("Col");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 2, row, -1, 0);
        JLabel jLabel3 = new JLabel("Margin");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 3, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.hPaddingTF, 4, row, 10, 0, 30, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.rowTF, 1, ++row, 20, 0, 30, -1);
        JLabel jLabel4 = new JLabel("Row");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 2, row, -1, 0);
        JLabel jLabel5 = new JLabel("Margin");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 3, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.vPaddingTF, 4, row, 10, 0, 30, -1);
        t.getClass();
        t.addCell(this.printHorizontalRB, 1, ++row, 20, 0);
        t.getClass();
        t.addCell(this.printVerticalRB, 3, row, 10, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.useBorderCB, 5, row, -1, 0);
        ++row;
        JLabel jLabel6 = new JLabel("Order");
        t.getClass();
        t.getClass();
        t.addCell(jLabel6, 0, row, 1, 0);
        t.getClass();
        t.addCell(this.sortingCN, 1, row, 20, 0);
        t.getClass();
        t.addCell(this.printGroupContRB, 1, ++row, 20, 0);
        t.getClass();
        t.addCell(this.printGroupSingleRB, 4, row, 10, 0);
        t.getClass();
        t.addCell(this.printGroupParaRB, 1, ++row, 20, 0);
        t.getClass();
        t.addCell(this.printGroupPageRB, 4, row, 10, 0);
        t.addCell(this.printGroupParaCutRB, 1, ++row, 20, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.thresholdTF, 4, row, -1, 0, 30, -1);
        JLabel jLabel7 = new JLabel(" Cell,to page");
        t.getClass();
        t.addCell(jLabel7, 4, row, 40, 0);
        ++row;
        JLabel jLabel8 = new JLabel("Copies");
        t.getClass();
        t.getClass();
        t.addCell(jLabel8, 0, row, -1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.copyTF, 1, row, 20, 0, 30, -1);
        JLabel jLabel9 = new JLabel("Empty cell");
        t.getClass();
        t.getClass();
        t.addCell(jLabel9, 3, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.emptyCellTF, 4, row, 10, 1, 30, -1);
        t.addYSpace(15);
        t.addTable(new int[]{200, 20, 80}, new int[]{20});
        this.printB = new JButton("Export");
        this.cancelB = new JButton("Cancel");
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.printB, 0, 0, 1, 0, 80, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0, 80, -1);
    }

    public void setEventHandler() {
        this.printB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberLabelPrintoutDialog.this.onPrint(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberLabelPrintoutDialog.this.onCancel(evt);
            }
        });
        this.thresholdTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                if (!MemberLabelPrintoutDialog.this.thresholdTF.getText().trim().equals("")) {
                    MemberLabelPrintoutDialog.this.printGroupParaCutRB.setSelected(true);
                }
            }
        });
    }

    public void onPrint(ActionEvent evt) {
        boolean check_input_range = true;
        ArrayList remarkCols = new ArrayList();
        Validation validation = new Validation();
        validation.add(this.columnTF.getText(), "Column", "R,I,GTZ");
        validation.add(this.rowTF.getText(), "Row", "R,I,GTZ");
        validation.add(this.copyTF.getText(), "Copies", "R,I,GTZ");
        validation.add(this.vPaddingTF.getText(), "Row Margin", "R,I,GTZ");
        validation.add(this.hPaddingTF.getText(), "Column Margin", "R,I,GTZ");
        validation.add(this.thresholdTF.getText(), "Grouping count", "R,I,GTZ");
        validation.add(this.emptyCellTF.getText(), "Empty cell", "R,I,GEZ");
        int selnum = 0;
        int i = 0;
        while (i < this.gInfoSL.getTableData().size()) {
            this.gInfos.setCurrentRow(i);
            validation.add(this.gInfos.getS("point"), "Item " + (i + 1) + " font size", "R,I,GTZ");
            validation.add(this.gInfos.getS("order"), "Item " + (i + 1) + " order", "R,I,GTZ");
            if (this.gInfos.getS("selected").equals("Y")) {
                ++selnum;
            }
            ++i;
        }
        validation.add(selnum > 0, "At least select one item", "RT");
        if (!validation.isValid()) {
            return;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Running report...", 0.5);
        String printGroup = this.printGroupContRB.isSelected() ? MemberLabelPrintout.PRINT_GROUP__CONT : (this.printGroupSingleRB.isSelected() ? MemberLabelPrintout.PRINT_GROUP__SINGLE : (this.printGroupPageRB.isSelected() ? MemberLabelPrintout.PRINT_GROUP__PAGE : (this.printGroupParaRB.isSelected() ? MemberLabelPrintout.PRINT_GROUP__PARA : MemberLabelPrintout.PRINT_GROUP__PARACUT)));
        MemberLabelPrintout p = new MemberLabelPrintout(this.gMemberSeqs, this.gInfos, this.columnTF.getText(), this.rowTF.getText(), this.vPaddingTF.getText(), this.hPaddingTF.getText(), this.copyTF.getText(), this.emptyCellTF.getText(), this.thresholdTF.getText(), this.sortingCN.getSelectedCode(), printGroup, this.printHorizontalRB.isSelected(), this.useBorderCB.isSelected());
        p.genFile();
        wait_dialog.dispose();
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
    }

    public void getConfigValue() {
        this.g_Config = new Properties();
        try {
            this.g_Config.load(new FileInputStream("config/member_label_config.txt"));
        }
        catch (IOException e) {
            Tools.writeError(e.getMessage());
        }
        int h_cell_num = this.getIntFromConfig("h_cell_num");
        int v_cell_num = this.getIntFromConfig("v_cell_num");
        int copy = this.getIntFromConfig("copy");
        int v_padding = this.getIntFromConfig("v_padding");
        int h_padding = this.getIntFromConfig("h_padding");
        boolean border = !this.getStringFromConfig("use_border").equals("N");
        this.columnTF.setText(Integer.toString(h_cell_num));
        this.rowTF.setText(Integer.toString(v_cell_num));
        this.copyTF.setText(Integer.toString(copy));
        this.vPaddingTF.setText(Integer.toString(v_padding));
        this.hPaddingTF.setText(Integer.toString(h_padding));
        this.useBorderCB.setSelected(border);
    }

    private int getIntFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return 0;
    }

    private String getStringFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        if (value != null) {
            return value;
        }
        return "";
    }
}

