/*
 * Decompiled with CFR 0.152.
 */
package member;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import member.MemberGroup;
import member.MemberGroupMember;
import member.MemberGroupSelectComboBox;
import system.User;
import ui.DataDialog;
import ui.ScrollList;
import ui.TableLayout;
import util.RecordList;
import util.RecordListSet;
import util.Validation;

public class MemberGroupSelectDialog
extends DataDialog {
    private RecordList gResultGroups;
    private RecordList gSelGroups;
    private RecordList gNonSelGroups;
    private RecordList gAllActiveGroups;
    private ScrollList selListSL;
    private ScrollList nonSelListSL;
    private JButton addB;
    private JButton delB;
    private JButton confirmB;
    private JButton cancelB;
    private MemberGroupSelectComboBox parentCB;

    public MemberGroupSelectDialog(DataDialog dialog, MemberGroupSelectComboBox parent, RecordList groups, String privilege) {
        super(dialog, "Select Member Group", false);
        this.gResultGroups = groups;
        this.gAllActiveGroups = privilege.equals("") ? MemberGroup.getAllActiveGroups() : User.getMGsByPrivilege(privilege, true);
        this.gSelGroups = this.getSelGroups();
        this.gNonSelGroups = this.getNonSelGroups();
        this.parentCB = parent;
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        this.addB = new JButton(">>>");
        this.delB = new JButton("<<<");
        this.confirmB = new JButton("Done");
        this.cancelB = new JButton("Back");
        this.selListSL = new ScrollList(165, 340, this.gSelGroups, new int[]{150}, new String[]{"Selected"}, new String[]{"name"}, new boolean[1]);
        this.nonSelListSL = new ScrollList(165, 340, this.gNonSelGroups, new int[]{150}, new String[]{"Available"}, new String[]{"name"}, new boolean[1]);
        TableLayout t = new TableLayout(this, 480, 395, 5, 10);
        int[] nArray = new int[4];
        nArray[0] = 200;
        nArray[1] = 70;
        nArray[2] = 200;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{90, 30, 30, 150, 30, 30});
        int row = 0;
        t.getClass();
        t.getClass();
        t.addCell(this.nonSelListSL, 0, row, -1, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.selListSL, 2, row, -1, -1);
        ++row;
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 1, row, -1, 0, 60, -1);
        ++row;
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.delB, 1, row, -1, 0, 60, -1);
        ++row;
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.confirmB, 1, row, -1, 1, 60, -1);
        ++row;
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 1, row, -1, 1, 60, -1);
    }

    public void setEventHandler() {
        this.addB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberGroupSelectDialog.this.onAdd(evt);
            }
        });
        this.delB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberGroupSelectDialog.this.onDel(evt);
            }
        });
        this.confirmB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberGroupSelectDialog.this.onConfirm(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberGroupSelectDialog.this.onCancel(evt);
            }
        });
    }

    public void onAdd(ActionEvent evt) {
        int selrow = this.nonSelListSL.getSelectedRow();
        if (selrow >= 0) {
            int mg_seq = this.gNonSelGroups.getI(MemberGroupMember.MEMBER_GROUP_SEQ, selrow);
            this.gNonSelGroups.remove(selrow);
            this.nonSelListSL.refreshTable(this.gNonSelGroups);
            this.gSelGroups.setI(MemberGroupMember.MEMBER_GROUP_SEQ, mg_seq, this.gSelGroups.size());
            this.formatGroups(this.gSelGroups);
            this.selListSL.refreshTable(this.gSelGroups);
        }
    }

    public void onDel(ActionEvent evt) {
        int selrow = this.selListSL.getSelectedRow();
        if (selrow >= 0) {
            int mg_seq = this.gSelGroups.getI(MemberGroupMember.MEMBER_GROUP_SEQ, selrow);
            this.gSelGroups.remove(selrow);
            this.selListSL.refreshTable(this.gSelGroups);
            this.gNonSelGroups.setI(MemberGroupMember.MEMBER_GROUP_SEQ, mg_seq, this.gNonSelGroups.size());
            this.formatGroups(this.gNonSelGroups);
            this.sortGroups(this.gNonSelGroups);
            this.nonSelListSL.refreshTable(this.gNonSelGroups);
        }
    }

    public void onConfirm(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(!this.gSelGroups.isEmpty(), "At least select one group", "RT");
        if (!validation.isValid()) {
            return;
        }
        this.gResultGroups.clear();
        int i = 0;
        while (i < this.gSelGroups.size()) {
            this.gResultGroups.add(this.gSelGroups.get(i));
            ++i;
        }
        this.parentCB.refreshSelection();
        this.dispose();
    }

    private void onCancel(ActionEvent evt) {
        this.dispose();
    }

    private RecordList getSelGroups() {
        RecordListSet s = new RecordListSet(this.gAllActiveGroups, this.gResultGroups, new String[]{MemberGroupMember.MEMBER_GROUP_SEQ});
        RecordList r = s.getIntersectOfLeft();
        this.formatGroups(r);
        this.sortGroups(r);
        return r;
    }

    private RecordList getNonSelGroups() {
        RecordListSet s = new RecordListSet(this.gAllActiveGroups, this.gResultGroups, new String[]{MemberGroupMember.MEMBER_GROUP_SEQ});
        RecordList r = s.getLeftOnly();
        this.formatGroups(r);
        this.sortGroups(r);
        return r;
    }

    private void formatGroups(RecordList r) {
        int i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            r.setS("name", MemberGroup.getName(r.getI(MemberGroupMember.MEMBER_GROUP_SEQ)));
            ++i;
        }
    }

    private void sortGroups(RecordList r) {
    }
}

