/*
 * Decompiled with CFR 0.152.
 */
package member;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import member.MemberGroup;
import member.MemberGroupSelectDialog;
import system.User;
import ui.ComboBoxNV;
import ui.DataDialog;
import util.RecordList;

public class MemberGroupSelectComboBox
extends ComboBoxNV {
    private RecordList gGroups;
    private String gPrivilege;

    public MemberGroupSelectComboBox(String privilege) {
        super((ArrayList)new RecordList(), "name", "code", "");
        this.gPrivilege = privilege;
        RecordList r = new RecordList(new String[]{"member_group_seq"});
        RecordList userMgs = User.getMGsByPrivilege(privilege, true);
        r.addItem(new Integer[]{userMgs.getI("member_group_seq", 0)});
        this.init(r);
    }

    public MemberGroupSelectComboBox(RecordList groups, String privilege) {
        super((ArrayList)new RecordList(), "name", "code", "");
        this.gPrivilege = privilege;
        this.init(groups);
    }

    private void init(RecordList groups) {
        this.hasNilItem(false);
        this.gGroups = groups;
        this.refreshSelection();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberGroupSelectComboBox.this.onSelect(evt);
            }
        });
    }

    public void refreshSelection() {
        RecordList r = new RecordList(new String[]{"name", "code"});
        r.addItem(new String[]{MemberGroup.getOneNameStringOfGroups(this.gGroups), "0"});
        r.addItem(new String[]{"Select Groups...", "1"});
        this.refreshItems(r);
        this.setItemSelected("0");
    }

    public RecordList getSelGroups() {
        return this.gGroups;
    }

    private void onSelect(ActionEvent evt) {
        if (this.getSelectedStringValue().equals("1")) {
            MemberGroupSelectDialog d = new MemberGroupSelectDialog(new DataDialog(), this, this.gGroups, this.gPrivilege);
            d.setVisible(true);
        }
    }
}

