/*
 * Decompiled with CFR 0.152.
 */
package member;

import database.DBUtil;
import member.Member;
import member.MemberGroup;
import printout.xls.ExcelFormat;
import printout.xls.ExcelPrintout;
import system.Lang;
import util.RecordList;
import util.TimeUtil;

public class MemberGroupReport {
    private static int gFixedColNum = 23;
    private int gMemberGroupSeq;
    private boolean gShowExpiredMember;

    public MemberGroupReport(int member_group_seq, boolean show_expired_member) {
        this.gMemberGroupSeq = member_group_seq;
        this.gShowExpiredMember = show_expired_member;
        this.genReport();
    }

    private void genReport() {
        RecordList mgSeqs;
        ExcelPrintout p = new ExcelPrintout(ExcelFormat.PA4, new int[]{33, 30, 30, 23, 23, 15, 25});
        p.addHeader(Lang.set("Member Group Report"), new String[]{String.valueOf(Lang.set("Group: ")) + MemberGroup.getName(this.gMemberGroupSeq), Lang.set("Show inactive members: " + (this.gShowExpiredMember ? "Yes" : "No"))});
        int row = p.getRowNumAfterHeader();
        if (this.gMemberGroupSeq == -1) {
            mgSeqs = this.getMemberGroupSeqs();
        } else {
            mgSeqs = new RecordList(new String[]{"member_group_seq"});
            mgSeqs.addItem(new Object[]{this.gMemberGroupSeq});
        }
        int i = 0;
        while (i < mgSeqs.size()) {
            RecordList members = this.getMembers(mgSeqs.getI("member_group_seq", i));
            MemberGroup mg = new MemberGroup(mgSeqs.getI("member_group_seq", i));
            p.addCell(0, row += 2, 7, 1, String.valueOf(Lang.set("Group: ")) + mg.getName() + Lang.set(" Active On: ") + TimeUtil.getStringByDate(mg.getStart_date()) + Lang.set(" Expire On: ") + TimeUtil.getStringByDate(mg.getEnd_date()) + Lang.set(" Active Members: ") + members.getGroupItems("active", "Y").size(), p.TL);
            p.addCell(0, ++row, Lang.set("Member ID"), p.TL);
            p.addCell(1, row, Lang.set("Name 1"), p.TL);
            p.addCell(2, row, Lang.set("Name 2"), p.TL);
            p.addCell(3, row, Lang.set("Active On"), p.TL);
            p.addCell(4, row, Lang.set("Expire On"), p.TL);
            p.addCell(5, row, Lang.set("Active"), p.TL);
            p.addCell(6, row, Lang.set("Remark"), p.TL);
            int j = 0;
            while (j < members.size()) {
                members.setCurrentRow(j);
                p.addCell(0, ++row, members.getS("member_id"));
                p.addCell(1, row, members.getS("name1"));
                p.addCell(2, row, members.getS("name2"));
                p.addCell(3, row, TimeUtil.getStringByDate(members.getT("start_date")));
                p.addCell(4, row, TimeUtil.getStringByDate(members.getT("end_date")));
                p.addCell(5, row, members.getS("active"));
                p.addCell(6, row, members.getS("remark"));
                ++j;
            }
            ++i;
        }
        p.genPrintout();
    }

    private RecordList getMemberGroupSeqs() {
        String sql = "select member_group_seq from member_group";
        return DBUtil.run("select member_group_seq from member_group");
    }

    private RecordList getMembers(int member_group_seq) {
        String sql = "select mb.member_id,mb.name1,mb.name2" + Member.getSelectDisplayNameSQL() + ",mgm.start_date" + ",mgm.end_date" + ",case when mgm.end_date>=curdate() then 'Y' else 'N' end as active" + ",mgm.remark" + " from" + " member_group_member mgm" + ",member mb" + " where" + " mgm.member_seq=mb.member_seq" + (this.gShowExpiredMember ? "" : " and mgm.end_date>=curdate()") + " and mgm.member_group_seq=?" + Member.getOrderByDisplayNameSQL();
        return DBUtil.run(sql, member_group_seq);
    }
}

