/*
 * Decompiled with CFR 0.152.
 */
package member;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import member.Member;
import member.MemberGroup;
import member.MemberGroupDialog;
import member.MemberGroupMember;
import member.MemberGroupPrivilege;
import system.Lang;
import system.User;
import ui.DataDialog;
import ui.DateTextField;
import ui.ScrollList;
import ui.TableLayout;
import util.ArrayUtil;
import util.ComparableHashMap;
import util.RecordList;
import util.RecordListSet;
import util.TimeUtil;
import util.Validation;
import util.WinUtil;

public class MemberGroupPanels {
    private int gMGSeq;
    private MemberGroupDialog gParentDialog;
    private MGTree gMGTree;
    private MemberGroup gGroup;
    private MGTreePanel gMGTreePanel;
    private MGBasicPanel gMGBasicPanel;
    private MGMemberPanel gMGMemberPanel;
    private MGPrivilegePanel gMGPrivilegePanel;
    private boolean gShowExpiredGroup;
    private boolean gCanModify;

    public MGTreePanel getMGTreePanel() {
        return this.gMGTreePanel;
    }

    public MGBasicPanel getMGBasicPanel() {
        return this.gMGBasicPanel;
    }

    public MGMemberPanel getMGMemberPanel() {
        return this.gMGMemberPanel;
    }

    public MGPrivilegePanel getMGPrivilegePanel() {
        return this.gMGPrivilegePanel;
    }

    public MemberGroupPanels(int mg_seq, MemberGroupDialog parentDialog, boolean showExpiredGroup) {
        this.gMGSeq = mg_seq;
        this.gShowExpiredGroup = showExpiredGroup;
        this.gCanModify = User.hasPrivilegeInGroup("memberGroupModify", this.gMGSeq);
        this.gParentDialog = parentDialog;
        this.gGroup = new MemberGroup(mg_seq);
        this.gMGTreePanel = new MGTreePanel(showExpiredGroup);
        this.gMGTree = this.gMGTreePanel.getTree();
        this.gMGBasicPanel = new MGBasicPanel(mg_seq);
        this.gMGMemberPanel = new MGMemberPanel(mg_seq);
        this.gMGPrivilegePanel = new MGPrivilegePanel(mg_seq);
    }

    public MGAddGroupDialog getMGAddGroupDialog(MemberGroupDialog d) {
        return new MGAddGroupDialog(d);
    }

    public void renewDetailPanels(int mg_seq) {
        this.gMGSeq = mg_seq;
        this.gCanModify = User.hasPrivilegeInGroup("memberGroupModify", this.gMGSeq);
        this.gGroup = new MemberGroup(mg_seq);
        this.gMGBasicPanel = new MGBasicPanel(mg_seq);
        this.gMGMemberPanel = new MGMemberPanel(mg_seq);
        this.gMGPrivilegePanel = new MGPrivilegePanel(mg_seq);
    }

    public class MGAddGroupDialog
    extends DataDialog {
        private MemberGroupDialog parentDialog;
        private JButton addB;
        private JButton cancelB;
        private JTextField nameTF;
        private DateTextField startDateDT;
        private DateTextField endDateDT;

        public MGAddGroupDialog(MemberGroupDialog dialog) {
            super(dialog, "Add Group", false);
            this.parentDialog = dialog;
            this.setLayout();
            this.setEventHandler();
            this.setVisible(true);
        }

        public void setLayout() {
            this.addB = new JButton("Add");
            this.cancelB = new JButton("Cancel");
            this.nameTF = new JTextField();
            this.startDateDT = new DateTextField();
            this.endDateDT = new DateTextField();
            TableLayout t = new TableLayout(this, 320, 170, 10, 10);
            t.addTable(new int[]{65, 150, 40}, new int[]{30, 30, 30, 30});
            JLabel jLabel = new JLabel("Name");
            t.getClass();
            t.getClass();
            t.addCell(jLabel, 0, 0, 1, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.nameTF, 1, 0, 10, 0, 150, -1);
            JLabel jLabel2 = new JLabel("Active On");
            t.getClass();
            t.getClass();
            t.addCell(jLabel2, 0, 1, 1, 0);
            t.getClass();
            t.addCell(this.startDateDT, 1, 1, 10, 0);
            JLabel jLabel3 = new JLabel("Expire On");
            t.getClass();
            t.getClass();
            t.addCell(jLabel3, 0, 2, 1, 0);
            t.getClass();
            t.addCell(this.endDateDT, 1, 2, 10, 0);
            t.getClass();
            t.getClass();
            t.getClass();
            t.addCell(this.addB, 1, 3, -1, 0, 80, -1);
            t.getClass();
            t.getClass();
            t.getClass();
            t.addCell(this.cancelB, 2, 3, 1, 0, 80, -1);
        }

        public void setEventHandler() {
            this.addB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGAddGroupDialog.this.onAdd(evt);
                }
            });
            this.cancelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGAddGroupDialog.this.onCancel(evt);
                }
            });
        }

        public void onAdd(ActionEvent evt) {
            Validation validation = new Validation();
            validation.add(this.nameTF.getText(), "Name", "R");
            validation.add(this.startDateDT.getInput(), "Active On", "R,D");
            validation.add(this.endDateDT.getInput(), "Expire On", "R,D");
            if (!validation.isValid()) {
                return;
            }
            DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
            int newMGSeq = MemberGroup.insert(MemberGroupPanels.this.gMGTree.getCurrentNodeMGSeq(), this.nameTF.getText(), this.startDateDT.getDate(), this.endDateDT.getDate());
            wait_dialog.dispose();
            this.dispose();
            MemberGroupPanels.this.gMGTree.addNewNode(String.valueOf(this.nameTF.getText()) + "(0)", newMGSeq);
            this.parentDialog.onSelectTreeNode(newMGSeq, -1);
        }

        public void onCancel(ActionEvent evt) {
            this.dispose();
        }
    }

    public class MGAddMemberDialog
    extends DataDialog {
        private JButton searchB;
        private JButton addMemberB;
        private JButton cancelB;
        private JCheckBox selectAllCB;
        private JTextField member_idTF;
        private JTextField nameTF;
        private DateTextField startDateDT;
        private DateTextField endDateDT;
        private ScrollList gMemberSL;
        private RecordList gMembers;
        private RecordList gAddedMGMembers;

        public MGAddMemberDialog(DataDialog dialog, RecordList addedMGMembers) {
            super(dialog, "Add", false);
            this.gAddedMGMembers = addedMGMembers;
            this.gMembers = this.getAllowedMembers("", "");
            this.setLayout();
            this.setEventHandler();
            this.setVisible(true);
        }

        private RecordList getAllowedMembers(String name, String member_id) {
            RecordList members;
            if (MemberGroupPanels.this.gMGSeq == MemberGroup.ROOT_GROUP_SEQ) {
                RecordList membersInRoot = MemberGroupMember.getMemberInGroup(MemberGroup.ROOT_GROUP_SEQ, name, member_id);
                MemberGroupMember.setExpiredCol(membersInRoot);
                RecordList nonExpiredMembersInRoot = membersInRoot.getGroupItems("expired", "N");
                membersInRoot.sort(MemberGroupMember.MEMBER_SEQ);
                RecordList uniqueMembersInRootList = membersInRoot.uniq(new String[]{MemberGroupMember.MEMBER_SEQ});
                RecordListSet set = new RecordListSet(uniqueMembersInRootList, nonExpiredMembersInRoot, new String[]{MemberGroupMember.MEMBER_SEQ});
                members = set.getLeftOnly();
            } else {
                MemberGroup mg = new MemberGroup(MemberGroupPanels.this.gMGSeq);
                RecordList membersInParent = MemberGroupMember.getMemberInGroup(mg.getParent_group_seq(), name, member_id);
                MemberGroupMember.setExpiredCol(membersInParent);
                RecordList nonExpiredMembersInParent = membersInParent.getGroupItems("expired", "N");
                RecordList nonExpiredAddedMembers = this.gAddedMGMembers.getGroupItems("expired", "N");
                RecordListSet set = new RecordListSet(nonExpiredMembersInParent, nonExpiredAddedMembers, new String[]{MemberGroupMember.MEMBER_SEQ});
                members = set.getLeftOnly();
            }
            return members;
        }

        public void setLayout() {
            this.member_idTF = new JTextField();
            this.nameTF = new JTextField();
            this.startDateDT = new DateTextField(MemberGroupPanels.this.gGroup.getStart_date());
            this.endDateDT = new DateTextField(MemberGroupPanels.this.gGroup.getEnd_date());
            boolean[] blArray = new boolean[3];
            blArray[2] = true;
            this.gMemberSL = new ScrollList(560, 360, this.gMembers, new int[]{120, 370, 40}, new String[]{"Member ID", "Name", "Sel"}, new String[]{"member_id", Member.DISPLAY_NAME, "selected"}, blArray);
            this.gMemberSL.setCheckBoxYNColumn("selected", "Y", "N");
            this.searchB = new JButton("Search");
            this.selectAllCB = new JCheckBox("Select All", false);
            this.addMemberB = new JButton("Add");
            this.cancelB = new JButton("Cancel");
            this.setDefaultButton(this.searchB);
            TableLayout t = new TableLayout(this, 600, 570, 5, 10);
            int[] nArray = new int[4];
            nArray[0] = 80;
            nArray[1] = 250;
            nArray[2] = 125;
            t.getClass();
            nArray[3] = 0;
            t.addTable(nArray, new int[]{30, 30, 30});
            JLabel jLabel = new JLabel("Member ID");
            t.getClass();
            t.getClass();
            t.addCell(jLabel, 0, 0, 1, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.nameTF, 1, 0, 20, 0, 200, -1);
            t.getClass();
            t.addCell(this.selectAllCB, 2, 0, 20, 0);
            t.getClass();
            t.getClass();
            t.getClass();
            t.addCell(this.searchB, 3, 0, -1, 0, 115, -1);
            JLabel jLabel2 = new JLabel("Name1");
            t.getClass();
            t.getClass();
            t.addCell(jLabel2, 0, 1, 1, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.member_idTF, 1, 1, 20, 0, 200, -1);
            t.addYSpace(15);
            int[] nArray2 = new int[1];
            t.getClass();
            nArray2[0] = 0;
            t.addTable(nArray2, new int[]{365});
            t.getClass();
            t.getClass();
            t.addCell(this.gMemberSL, 0, 0, -1, -1);
            t.addYSpace(15);
            t.addTable(new int[]{100, 100, 100, 100, 90, 80}, new int[]{30});
            JLabel jLabel3 = new JLabel("Active On");
            t.getClass();
            t.getClass();
            t.addCell(jLabel3, 0, 0, 1, 0);
            t.getClass();
            t.addCell(this.startDateDT, 1, 0, 10, 0);
            JLabel jLabel4 = new JLabel("Expire On");
            t.getClass();
            t.getClass();
            t.addCell(jLabel4, 2, 0, 1, 0);
            t.getClass();
            t.addCell(this.endDateDT, 3, 0, 10, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.addMemberB, 4, 0, 1, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.cancelB, 5, 0, 1, 0);
        }

        public void setEventHandler() {
            this.searchB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGAddMemberDialog.this.onSearch(evt);
                }
            });
            this.addMemberB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGAddMemberDialog.this.onAddMember(evt);
                }
            });
            this.cancelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGAddMemberDialog.this.onCancel(evt);
                }
            });
            this.selectAllCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGAddMemberDialog.this.onSelectAll(evt);
                }
            });
            this.gMemberSL.getViewport().getView().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 32) {
                        MGAddMemberDialog.this.onSelect(null);
                    }
                }
            });
        }

        public void onSearch(ActionEvent evt) {
            this.gMembers = this.getAllowedMembers(this.nameTF.getText(), this.member_idTF.getText());
            this.gMemberSL.refreshTable(this.gMembers);
        }

        public void onSelect(ActionEvent evt) {
            ArrayList v;
            int selrow = this.gMemberSL.getSelectedRow();
            String selected = ArrayUtil.getString("SELECTED", selrow, v = this.gMemberSL.getTableData());
            ArrayUtil.setString("SELECTED", selected.equals("Y") ? "N" : "Y", selrow, v);
            this.gMemberSL.refreshTableRow(selrow);
        }

        public void onAddMember(ActionEvent evt) {
            Validation validation = new Validation();
            boolean isSelected = false;
            int i = 0;
            while (i < this.gMembers.size()) {
                if (this.gMembers.getS("selected", i).equals("Y")) {
                    isSelected = true;
                }
                ++i;
            }
            validation.add(isSelected, "At least select one member", "RT");
            validation.add(TimeUtil.getStringByDate(this.startDateDT.getDate()), "Active On", "R,D");
            validation.add(TimeUtil.getStringByDate(this.endDateDT.getDate()), "Expire On", "R,D");
            if (!validation.isValid()) {
                return;
            }
            MemberGroupPanels.this.gMGMemberPanel.onFinishAddMember(this.gMembers.getGroupItems("selected", "Y"), this.startDateDT.getDate(), this.endDateDT.getDate());
            this.dispose();
        }

        public void onSelectAll(ActionEvent evt) {
            ArrayList v = this.gMemberSL.getTableData();
            int i = 0;
            while (i < v.size()) {
                ArrayUtil.setString("selected", this.selectAllCB.isSelected() ? "Y" : "N", i, v);
                ++i;
            }
            this.gMemberSL.refreshTable(v);
        }

        private void onCancel(ActionEvent evt) {
            this.dispose();
        }
    }

    public class MGBasicPanel
    extends TableLayout {
        private String gName;
        private JTextField nameTF;
        private DateTextField startDateDT;
        private DateTextField endDateDT;
        private JTextField displaySeqTF;
        private JButton saveB;
        private JButton cancelB;

        public MGBasicPanel(int mg_seq) {
            super(510, 460, 5, 10);
            this.gName = Lang.set("General");
            this.setLayout();
            this.setEventHandler();
        }

        @Override
        public String getName() {
            return this.gName;
        }

        public void setLayout() {
            this.nameTF = new JTextField(MemberGroupPanels.this.gGroup.getName());
            this.startDateDT = new DateTextField(MemberGroupPanels.this.gGroup.getStart_date());
            this.endDateDT = new DateTextField(MemberGroupPanels.this.gGroup.getEnd_date());
            this.displaySeqTF = new JTextField(String.valueOf(MemberGroupPanels.this.gGroup.getDisplay_seq()));
            this.saveB = new JButton("Save");
            this.cancelB = new JButton("Cancel");
            this.saveB.setEnabled(MemberGroupPanels.this.gCanModify);
            this.addTable(new int[]{60, 0}, new int[]{30, 30, 30, 30});
            this.addCell(new JLabel("Name"), 0, 0, 1, 0);
            this.addCell(this.nameTF, 1, 0, 10, 0, 160, -1);
            this.addCell(new JLabel("Active On"), 0, 1, 1, 0);
            this.addCell(this.startDateDT, 1, 1, 10, 0);
            this.addCell(new JLabel("Expire On"), 0, 2, 1, 0);
            this.addCell(this.endDateDT, 1, 2, 10, 0);
            this.addCell(new JLabel("Ordering"), 0, 3, 1, 0);
            this.addCell(this.displaySeqTF, 1, 3, 10, 0, 80, -1);
            this.addCell(new JLabel("Show smallest first. (Need re-open the list)"), 1, 3, 95, 0);
            this.addYSpace(310);
            this.addTable(new int[]{420, 0}, new int[]{30});
            this.addCell(this.saveB, 0, 0, 1, 0);
            this.addCell(this.cancelB, 1, 0, 1, 0);
        }

        public void setEventHandler() {
            this.saveB.setActionCommand("MGBasicPanel.save");
            this.saveB.addActionListener(MemberGroupPanels.this.gMGTree);
            this.saveB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGBasicPanel.this.onSave();
                }
            });
            this.cancelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGBasicPanel.this.onCancel();
                }
            });
        }

        public void onSave() {
            Validation validation = new Validation();
            validation.add(this.nameTF.getText(), "Name", "R");
            validation.add(this.startDateDT.getInput(), "Active On", "R,D");
            validation.add(this.endDateDT.getInput(), "Expire On", "R,D");
            validation.add(this.displaySeqTF.getText(), "Ordering", "R,I,GEZ");
            if (!validation.isValid()) {
                return;
            }
            DataDialog wait_dialog = WinUtil.getWaitingDialog(MemberGroupPanels.this.gParentDialog, "Data processing...", 0.5);
            MemberGroup.update(MemberGroupPanels.this.gGroup.getMember_group_seq(), this.nameTF.getText(), this.startDateDT.getDate(), this.endDateDT.getDate(), Integer.parseInt(this.displaySeqTF.getText()));
            wait_dialog.dispose();
        }

        public void onCancel() {
            MemberGroupPanels.this.gParentDialog.dispose();
        }
    }

    public class MGMemberPanel
    extends TableLayout {
        private String gName;
        private JButton addMemberB;
        private JButton saveB;
        private JButton cancelB;
        private JButton searchB;
        private JTextField nameTF;
        private RecordList gMemberGroupMembers;
        private ScrollList gMemberGroupMemberSL;

        public MGMemberPanel(int mg_seq) {
            super(510, 460, 5, 10);
            this.gName = Lang.set("Member");
            MemberGroupMember mgm = new MemberGroupMember(mg_seq);
            this.gMemberGroupMembers = mgm.getItems();
            MemberGroupMember.markExpired(this.gMemberGroupMembers);
            this.setLayout();
            this.setEventHandler();
        }

        @Override
        public String getName() {
            return this.gName;
        }

        public void setLayout() {
            this.addMemberB = new JButton("Add");
            this.saveB = new JButton("Save");
            this.cancelB = new JButton("Cancel");
            this.searchB = new JButton("Search");
            this.nameTF = new JTextField("");
            this.addMemberB.setEnabled(MemberGroupPanels.this.gCanModify);
            this.saveB.setEnabled(MemberGroupPanels.this.gCanModify);
            boolean[] blArray = new boolean[4];
            blArray[1] = true;
            blArray[2] = true;
            blArray[3] = true;
            this.gMemberGroupMemberSL = new ScrollList(485, 400, this.gMemberGroupMembers, new int[]{200, 80, 80, 110}, new String[]{"Name", "Active On", "Expire On", "Remark"}, new String[]{Member.DISPLAY_NAME, MemberGroupMember.START_DATE, MemberGroupMember.END_DATE, MemberGroupMember.REMARK}, blArray);
            this.gMemberGroupMemberSL.setEditing_mode(true);
            this.gMemberGroupMemberSL.setDateTextFieldColumn(MemberGroupMember.START_DATE);
            this.gMemberGroupMemberSL.setDateTextFieldColumn(MemberGroupMember.END_DATE);
            this.gMemberGroupMemberSL.setMatchedRowProperties(new String[]{"expired"}, new String[]{"Y"}, Color.lightGray, false);
            this.addTable(new int[]{0}, new int[]{400});
            this.addCell(this.gMemberGroupMemberSL, 0, 0, -1, 0);
            this.addTable(new int[]{100, 170, 100, 50, 0}, new int[]{30, 30});
            this.addCell(new JLabel("Expired item are dimmed"), 0, 0, -1, 0);
            this.addCell(this.addMemberB, 0, 1, -1, 0);
            this.addCell(this.nameTF, 1, 1, 1, 0, 150, -1);
            this.addCell(this.searchB, 2, 1, -1, 0);
            this.addCell(this.saveB, 3, 1, 1, 0);
            this.addCell(this.cancelB, 4, 1, 1, 0);
        }

        public void setEventHandler() {
            this.addMemberB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGMemberPanel.this.onAddMember();
                }
            });
            this.saveB.setActionCommand("MGMemberPanel.save");
            this.saveB.addActionListener(MemberGroupPanels.this.gMGTree);
            this.saveB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGMemberPanel.this.onSave();
                }
            });
            this.cancelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGMemberPanel.this.onCancel();
                }
            });
            this.searchB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGMemberPanel.this.onSearchMember();
                }
            });
        }

        private void onChangeMemberList() {
            MemberGroupMember.markExpired(this.gMemberGroupMembers);
            this.gMemberGroupMemberSL.fireDataChanged();
        }

        private void onAddMember() {
            MGAddMemberDialog d = new MGAddMemberDialog(MemberGroupPanels.this.gParentDialog, this.gMemberGroupMembers);
        }

        private void onSearchMember() {
            int selrow = this.gMemberGroupMemberSL.getSelectedRow();
            selrow = selrow == -1 ? 0 : selrow;
            int newselrow = -1;
            int i = selrow + 1;
            while (i < this.gMemberGroupMembers.size()) {
                String name = this.gMemberGroupMembers.getS(Member.DISPLAY_NAME, i).toLowerCase();
                if (name.indexOf(this.nameTF.getText().toLowerCase()) >= 0) {
                    newselrow = i;
                    break;
                }
                ++i;
            }
            if (newselrow != -1) {
                this.gMemberGroupMemberSL.setSelectedRow(newselrow, 0);
            }
        }

        public void onFinishAddMember(RecordList members, Timestamp startDate, Timestamp endDate) {
            RecordList r = (RecordList)this.gMemberGroupMemberSL.getTableData();
            int i = 0;
            while (i < members.size()) {
                ComparableHashMap h = MemberGroupMember.createMemberHashMap(MemberGroupPanels.this.gMGSeq, members.getInteger("member_seq", i), startDate, endDate);
                h.put(Member.DISPLAY_NAME, members.getS(Member.DISPLAY_NAME, i));
                r.add(h);
                ++i;
            }
            MemberGroupMember.markExpired(r);
            this.gMemberGroupMemberSL.fireDataChanged();
        }

        public void onSave() {
            Validation validation = new Validation();
            int i = 0;
            while (i < this.gMemberGroupMembers.size()) {
                validation.add(TimeUtil.getStringByDate(this.gMemberGroupMembers.getT(MemberGroupMember.START_DATE, i)), "Member record " + (i + 1) + " Active On", "R,D");
                validation.add(TimeUtil.getStringByDate(this.gMemberGroupMembers.getT(MemberGroupMember.END_DATE, i)), "Member record " + (i + 1) + " Expire On", "R,D");
                ++i;
            }
            String duplicatedMemberName = this.getNonExpiredDuplicatedMemberName();
            validation.add(duplicatedMemberName.equals(""), String.valueOf(duplicatedMemberName) + " has more than one active records", "RT");
            if (!validation.isValid()) {
                return;
            }
            MemberGroupMember.markExpired(this.gMemberGroupMembers);
            DataDialog wait_dialog = WinUtil.getWaitingDialog(MemberGroupPanels.this.gParentDialog, "Data processing...", 0.5);
            MemberGroupMember.update(MemberGroupPanels.this.gMGSeq, this.gMemberGroupMembers);
            wait_dialog.dispose();
        }

        private String getNonExpiredDuplicatedMemberName() {
            RecordList nonExpiredMemberIdentities = this.gMemberGroupMembers.getGroupItems("expired", "N");
            nonExpiredMemberIdentities.sort(String.valueOf(MemberGroupMember.MEMBER_SEQ));
            String firstDuplicatedName = "";
            int i = 0;
            while (i < nonExpiredMemberIdentities.size() - 1) {
                int memberSeq2;
                int memberSeq1 = nonExpiredMemberIdentities.getI(MemberGroupMember.MEMBER_SEQ, i);
                if (memberSeq1 == (memberSeq2 = nonExpiredMemberIdentities.getI(MemberGroupMember.MEMBER_SEQ, i + 1))) {
                    return nonExpiredMemberIdentities.getS(Member.DISPLAY_NAME, i);
                }
                ++i;
            }
            return "";
        }

        public void onCancel() {
            MemberGroupPanels.this.gParentDialog.dispose();
        }
    }

    class MGNode
    extends DefaultMutableTreeNode {
        private int gMemberGroupSeq;
        private String gName;

        public int getMemberGroupSeq() {
            return this.gMemberGroupSeq;
        }

        public String getName() {
            return this.gName;
        }

        MGNode(String name, int memberGroupSeq) {
            super(name);
            this.gMemberGroupSeq = -1;
            this.gName = "";
            this.gMemberGroupSeq = memberGroupSeq;
            this.gName = name;
        }
    }

    public class MGPrivilegePanel
    extends TableLayout {
        private String gName;
        private JButton addB;
        private JButton delB;
        private JButton saveB;
        private JButton cancelB;
        private RecordList gMemberGroupPrivileges;
        private ScrollList gPrivilegeSL;

        public MGPrivilegePanel(int mg_seq) {
            super(510, 460, 5, 10);
            this.gName = Lang.set("Permission");
            MemberGroupPrivilege mgp = new MemberGroupPrivilege(mg_seq);
            this.gMemberGroupPrivileges = mgp.getItems();
            MemberGroupPrivilege.markSystemPrivilege(this.gMemberGroupPrivileges);
            this.setLayout();
            this.setEventHandler();
        }

        @Override
        public String getName() {
            return this.gName;
        }

        public void setLayout() {
            this.addB = new JButton("Add");
            this.delB = new JButton("Delete");
            this.saveB = new JButton("Save");
            this.cancelB = new JButton("Cancel");
            this.addB.setEnabled(MemberGroupPanels.this.gCanModify);
            this.delB.setEnabled(MemberGroupPanels.this.gCanModify);
            this.saveB.setEnabled(MemberGroupPanels.this.gCanModify);
            this.gPrivilegeSL = new ScrollList(485, 400, this.gMemberGroupPrivileges, new int[]{300, 130, 40}, new String[]{"Name", "Code", "Active"}, new String[]{MemberGroupPrivilege.NAME, MemberGroupPrivilege.CODE, MemberGroupPrivilege.STATUS}, new boolean[]{true, true, true});
            this.gPrivilegeSL.setEditing_mode(true);
            this.gPrivilegeSL.setCheckBoxYNColumn(MemberGroupPrivilege.STATUS, "A", "D");
            if (MemberGroupPanels.this.gGroup.getParent_group_seq() == -1) {
                this.gPrivilegeSL.setMatchedRowProperties(new String[]{MemberGroupPrivilege.TYPE}, new String[]{MemberGroupPrivilege.TYPE__SYSTEM}, Color.GREEN, true);
            } else {
                this.gPrivilegeSL.setMatchedRowProperties(new String[]{MemberGroupPrivilege.TYPE}, new String[]{MemberGroupPrivilege.TYPE__PARENT}, Color.LIGHT_GRAY, false);
            }
            this.addTable(new int[]{0}, new int[]{400});
            this.addCell(this.gPrivilegeSL, 0, 0, -1, 0);
            this.addTable(new int[]{100, 100, 220, 0}, new int[]{30, 30});
            this.addCell(new JLabel("Dimmed = From parent. Green = System, please do not modify it."), 0, 0, -1, 0);
            this.addCell(this.addB, 0, 1, -1, 0);
            this.addCell(this.delB, 1, 1, -1, 0);
            this.addCell(this.saveB, 2, 1, 1, 0);
            this.addCell(this.cancelB, 3, 1, 1, 0);
        }

        public void setEventHandler() {
            this.addB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGPrivilegePanel.this.onAddPrivilege();
                }
            });
            this.delB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGPrivilegePanel.this.onDelPrivilege();
                }
            });
            this.saveB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGPrivilegePanel.this.onSave();
                }
            });
            this.cancelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MGPrivilegePanel.this.onCancel();
                }
            });
        }

        private void onAddPrivilege() {
            ComparableHashMap h = new ComparableHashMap();
            h.put(MemberGroupPrivilege.MEMBER_GROUP_PRIVILEGE_SEQ, -1);
            h.put(MemberGroupPrivilege.MEMBER_GROUP_SEQ, MemberGroupPanels.this.gMGSeq);
            h.put(MemberGroupPrivilege.TYPE, MemberGroupPrivilege.TYPE__DEFINE);
            h.put(MemberGroupPrivilege.NAME, "");
            h.put(MemberGroupPrivilege.CODE, "");
            h.put(MemberGroupPrivilege.STATUS, "A");
            this.gMemberGroupPrivileges.add(h);
            MemberGroupPrivilege.markSystemPrivilege(this.gMemberGroupPrivileges);
            this.gPrivilegeSL.fireDataChanged();
        }

        private void onDelPrivilege() {
            if (WinUtil.getConfirm(this, "Delete permission will affect the member, are you sure to delete it?")) {
                int sel_row = this.gPrivilegeSL.getSelectedRow();
                if (sel_row == -1) {
                    return;
                }
                ArrayList v = this.gPrivilegeSL.getTableData();
                v.remove(sel_row);
                this.gPrivilegeSL.fireDataChanged();
            }
        }

        public void onSave() {
            int k;
            RecordList definePrivileges = MemberGroupPanels.this.gGroup.getParent_group_seq() == -1 ? this.gMemberGroupPrivileges : this.gMemberGroupPrivileges.getGroupItems(MemberGroupPrivilege.TYPE, MemberGroupPrivilege.TYPE__DEFINE);
            Validation validation = new Validation();
            int i = 0;
            while (i < definePrivileges.size()) {
                validation.add(definePrivileges.getS(MemberGroupPrivilege.NAME, i), "Permission item " + (i + 1) + " Name", "R");
                validation.add(definePrivileges.getS(MemberGroupPrivilege.CODE, i), "Permission item " + (i + 1) + " Code", "R");
                ++i;
            }
            int j = definePrivileges.getColNonUniqueIndex(new String[]{MemberGroupPrivilege.NAME});
            if (j != -1) {
                validation.add(j == -1, "Permission with the same name " + definePrivileges.getS(MemberGroupPrivilege.NAME, j), "RT");
            }
            if ((k = definePrivileges.getColNonUniqueIndex(new String[]{MemberGroupPrivilege.CODE})) != -1) {
                validation.add(k == -1, "Permission with the same code " + definePrivileges.getS(MemberGroupPrivilege.CODE, k), "RT");
            }
            if (!validation.isValid()) {
                return;
            }
            DataDialog wait_dialog = WinUtil.getWaitingDialog(MemberGroupPanels.this.gParentDialog, "Data processing...", 0.5);
            MemberGroupPrivilege.update(MemberGroupPanels.this.gMGSeq, MemberGroupPanels.this.gGroup.getParent_group_seq(), definePrivileges);
            wait_dialog.dispose();
        }

        public void onCancel() {
            MemberGroupPanels.this.gParentDialog.dispose();
        }
    }

    public class MGTree
    extends JTree
    implements ActionListener {
        MGTree(DefaultTreeModel model) {
            super(model);
        }

        public int getCurrentNodeMGSeq() {
            if (this.getSelectionPath() == null) {
                return -1;
            }
            return ((MGNode)this.getSelectionPath().getLastPathComponent()).getMemberGroupSeq();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TreePath path = this.getSelectionPath();
            MGNode selectedNode = (MGNode)path.getLastPathComponent();
            String actionCommand = event.getActionCommand();
            if (actionCommand.equals("MGMemberPanel.save") || actionCommand.equals("MGBasicPanel.save")) {
                MemberGroup group = new MemberGroup(selectedNode.getMemberGroupSeq());
                int activeMemberNum = MemberGroupMember.getGroupMemberNum(selectedNode.getMemberGroupSeq(), true);
                selectedNode.setUserObject(String.valueOf(group.getName()) + "(" + activeMemberNum + ")");
                ((DefaultTreeModel)MemberGroupPanels.this.gMGTree.getModel()).nodeChanged(selectedNode);
                return;
            }
        }

        public void addNewNode(String name, int mg_seq) {
            TreePath path = this.getSelectionPath();
            MGNode node = new MGNode(name, mg_seq);
            MGNode selectedNode = (MGNode)path.getLastPathComponent();
            selectedNode.add(node);
            this.expandPath(path);
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(selectedNode);
            this.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    class MGTreeCellRenderer
    extends DefaultTreeCellRenderer {
        MGTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            String name = (String)node.getUserObject();
            this.setEnabled(true);
            this.setOpenIcon(null);
            this.setClosedIcon(null);
            this.setLeafIcon(null);
            return this;
        }
    }

    class MGTreeModelListener
    implements TreeModelListener {
        MGTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }
    }

    public class MGTreePanel {
        private MGTree gTree;
        private MGNode gRootNode;
        private DefaultTreeModel gTreeModel;
        private RecordList gAllGroups;
        private boolean gShowExpiredGroup;

        public MGTree getTree() {
            return this.gTree;
        }

        public MGTreePanel(boolean showExpiredGroup) {
            this.init(showExpiredGroup);
        }

        public void init(boolean showExpiredGroup) {
            this.gShowExpiredGroup = showExpiredGroup;
            this.gAllGroups = MemberGroup.getAllGroups();
            int rootIdx = this.gAllGroups.indexOf("member_group_seq", new Integer(MemberGroup.ROOT_GROUP_SEQ));
            Timestamp end_date = this.gAllGroups.getT("end_date", rootIdx);
            int activeMemberNum = MemberGroupMember.getGroupMemberNum(MemberGroup.ROOT_GROUP_SEQ, true);
            this.gRootNode = new MGNode(String.valueOf(this.isExpired(end_date) ? "[X]" : "") + this.gAllGroups.getS("name", rootIdx) + "(" + activeMemberNum + ")", MemberGroup.ROOT_GROUP_SEQ);
            this.gTreeModel = new DefaultTreeModel(this.gRootNode);
            this.gTreeModel.addTreeModelListener(new MGTreeModelListener());
            RecordList nextLevelGroups = this.gAllGroups.getGroupItems(new String[]{"parent_group_seq"}, new Integer[]{new Integer(MemberGroup.ROOT_GROUP_SEQ)});
            nextLevelGroups.sort("display_seq,name");
            this.addTreeNodes(this.gRootNode, 1, nextLevelGroups);
            this.gTree = new MGTree(this.gTreeModel);
            this.gTree.setCellRenderer(new MGTreeCellRenderer());
            this.gTree.setEditable(false);
            this.gTree.getSelectionModel().setSelectionMode(1);
            this.gTree.setShowsRootHandles(true);
            this.expandAllNodes(this.gRootNode);
            this.gTree.setSelectionPath(new TreePath(this.gRootNode));
        }

        private void addTreeNodes(MGNode parentNode, int parent_group_seq, RecordList groups) {
            int i = 0;
            while (i < groups.size()) {
                int mg_seq = groups.getI("member_group_seq", i);
                Timestamp end_date = groups.getT("end_date", i);
                if (!this.isExpired(end_date) || this.gShowExpiredGroup) {
                    int activeMemberNum = MemberGroupMember.getGroupMemberNum(mg_seq, true);
                    MGNode node = new MGNode(String.valueOf(this.isExpired(end_date) ? "[X]" : "") + groups.getS("name", i) + "(" + activeMemberNum + ")", mg_seq);
                    this.gTreeModel.insertNodeInto(node, parentNode, parentNode.getChildCount());
                    RecordList nextLevelGroups = this.gAllGroups.getGroupItems(new String[]{"parent_group_seq"}, new Integer[]{new Integer(mg_seq)});
                    nextLevelGroups.sort("display_seq,name");
                    if (!nextLevelGroups.isEmpty()) {
                        this.addTreeNodes(node, mg_seq, nextLevelGroups);
                    }
                }
                ++i;
            }
        }

        private void expandAllNodes(DefaultMutableTreeNode startNode) {
            Enumeration<TreeNode> children = startNode.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
                if (node.isLeaf()) continue;
                TreePath path = new TreePath(node.getPath());
                this.gTree.expandPath(path);
                this.expandAllNodes(node);
            }
        }

        public boolean isExpired(Timestamp s) {
            return s.before(TimeUtil.getCurrentDate());
        }
    }
}

