/*
 * Decompiled with CFR 0.152.
 */
package member;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import member.MemberGroup;
import member.MemberGroupPanels;
import system.Lang;
import system.User;
import ui.DataDialog;
import ui.TableLayout;
import util.WinUtil;

public class MemberGroupDialog
extends DataDialog {
    private boolean gShowExpiredGroup;
    private MemberGroupPanels gMGGroupPanels;
    private JTabbedPane gTreeTP;
    private JTabbedPane gDetailTP;
    private JButton addNewGroupB;
    private JCheckBox showExpiredGroupCB;

    public MemberGroupDialog(JFrame frame, boolean showExpiredGroup) {
        super(frame, "Member Group", false);
        this.gShowExpiredGroup = showExpiredGroup;
        this.gMGGroupPanels = new MemberGroupPanels(MemberGroup.ROOT_GROUP_SEQ, this, this.gShowExpiredGroup);
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        this.addNewGroupB = new JButton("Add Group");
        this.showExpiredGroupCB = new JCheckBox("Expired Group", this.gShowExpiredGroup);
        MemberGroupPanels.MGTreePanel mgTreePanel = this.gMGGroupPanels.getMGTreePanel();
        JScrollPane treeSP = new JScrollPane(mgTreePanel.getTree());
        treeSP.setSize(new Dimension(220, 475));
        this.gTreeTP = new JTabbedPane();
        this.gTreeTP.setSize(new Dimension(220, 475));
        this.gTreeTP.addTab(Lang.set("All Group"), treeSP);
        this.gDetailTP = new JTabbedPane();
        this.gDetailTP.setSize(new Dimension(525, 510));
        this.onSelectTreeNode(MemberGroup.ROOT_GROUP_SEQ, 1);
        TableLayout t = new TableLayout(this, 800, 570, 20, 20);
        int[] nArray = new int[2];
        nArray[0] = 240;
        t.getClass();
        nArray[1] = 0;
        t.addTable(nArray, new int[]{480, 30});
        t.getClass();
        t.getClass();
        t.addCell(this.gTreeTP, 0, 0, -1, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.gDetailTP, 1, 0, -1, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.addNewGroupB, 0, 1, -1, 0);
        t.getClass();
        t.addCell(this.showExpiredGroupCB, 0, 1, 100, 0);
    }

    public void setEventHandler() {
        final MemberGroupPanels.MGTree mgTree = this.gMGGroupPanels.getMGTreePanel().getTree();
        final MemberGroupDialog d = this;
        mgTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = mgTree.getRowForLocation(e.getX(), e.getY());
                if (row == -1) {
                    mgTree.clearSelection();
                    return;
                }
                MemberGroupDialog.this.onSelectTreeNode(mgTree.getCurrentNodeMGSeq(), -1);
            }
        });
        this.showExpiredGroupCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberGroupDialog f = new MemberGroupDialog((JFrame)d.getOwner(), MemberGroupDialog.this.showExpiredGroupCB.isSelected());
                f.setVisible(true);
                d.dispose();
            }
        });
        this.addNewGroupB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberGroupDialog.this.onAddNewGroup();
            }
        });
    }

    public void onSelectTreeNode(int mg_seq, int tabIndex) {
        if (tabIndex < 0) {
            tabIndex = this.gDetailTP.getSelectedIndex();
        }
        boolean canRead = User.hasPrivilegeInGroup("memberGroupRead", mg_seq);
        boolean canModify = User.hasPrivilegeInGroup("memberGroupModify", mg_seq);
        this.addNewGroupB.setEnabled(canModify);
        this.gDetailTP.removeAll();
        this.gMGGroupPanels.renewDetailPanels(mg_seq);
        MemberGroupPanels.MGBasicPanel mgBasicPanel = this.gMGGroupPanels.getMGBasicPanel();
        MemberGroupPanels.MGMemberPanel mgMemberPanel = this.gMGGroupPanels.getMGMemberPanel();
        MemberGroupPanels.MGPrivilegePanel mgPrivilegePanel = this.gMGGroupPanels.getMGPrivilegePanel();
        this.gDetailTP.addTab(mgBasicPanel.getName(), canRead ? mgBasicPanel : null);
        this.gDetailTP.addTab(mgMemberPanel.getName(), canRead ? mgMemberPanel : null);
        this.gDetailTP.addTab(mgPrivilegePanel.getName(), canRead ? mgPrivilegePanel : null);
        this.gDetailTP.setSelectedIndex(tabIndex);
    }

    public void onAddNewGroup() {
        MemberGroupPanels.MGTreePanel p = this.gMGGroupPanels.getMGTreePanel();
        if (p.getTree().getCurrentNodeMGSeq() != -1) {
            MemberGroupPanels.MGAddGroupDialog d = this.gMGGroupPanels.getMGAddGroupDialog(this);
        } else {
            WinUtil.showMessage(this, "Please select the group to add child group");
        }
    }
}

