/*
 * Decompiled with CFR 0.152.
 */
package member;

import database.DBConn;
import database.DBUtil;
import database.SQLWhereClause;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import member.MemberGroup;
import member.MemberGroupMember;
import member.MemberImportTemplate;
import member.MemberRemark;
import printout.xls.ExcelUtil;
import system.Config;
import system.Lang;
import system.SystemCode;
import system.User;
import system.UserSession;
import util.RecordList;
import util.TimeUtil;
import util.Tools;

public class Member {
    private int g_Member_seq = -1;
    private String g_Member_id = "";
    private String g_Name1 = "";
    private String g_Name2 = "";
    private String g_Official_name = "";
    private String g_Hkid = "";
    private String g_Gender = "";
    private Timestamp g_Dob = null;
    private String g_Address = "";
    private String g_Tel1 = "";
    private String g_Tel2 = "";
    private String g_Email = "";
    private String g_Career = "";
    private String g_Education = "";
    private String g_Hobby = "";
    private String g_Marital_status = "";
    private Timestamp g_Baptist_date = null;
    private Timestamp g_Church_join_date = null;
    private String g_Login_id = "";
    private String g_Password = "";
    private String g_Receipt_type = "";
    public static String RECEIPT_TYPE__PRINT = "P";
    public static String RECEIPT_TYPE__EMAIL = "E";
    public static Object[] RECEIPT_TYPE_MAP = new Object[]{new String[]{RECEIPT_TYPE__PRINT, Lang.set("Print")}, new String[]{RECEIPT_TYPE__EMAIL, Lang.set("Email")}};
    public static String DISPLAY_NAME = "display_name";

    public Member() {
    }

    public Member(int member_seq) {
        this(member_seq, null);
    }

    public Member(int member_seq, DBConn conn) {
        this.g_Member_seq = member_seq;
        this.load(conn);
    }

    public int getMember_seq() {
        return this.g_Member_seq;
    }

    public String getMember_id() {
        return this.g_Member_id;
    }

    public String getName1() {
        return this.g_Name1;
    }

    public String getName2() {
        return this.g_Name2;
    }

    public String getOfficial_name() {
        return this.g_Official_name;
    }

    public String getHkid() {
        return this.g_Hkid;
    }

    public String getGender() {
        return this.g_Gender;
    }

    public Timestamp getDob() {
        return this.g_Dob;
    }

    public String getAddress() {
        return this.g_Address;
    }

    public String getTel1() {
        return this.g_Tel1;
    }

    public String getTel2() {
        return this.g_Tel2;
    }

    public String getEmail() {
        return this.g_Email;
    }

    public String getCareer() {
        return this.g_Career;
    }

    public String getEducation() {
        return this.g_Education;
    }

    public String getHobby() {
        return this.g_Hobby;
    }

    public String getMarital_status() {
        return this.g_Marital_status;
    }

    public Timestamp getBaptist_date() {
        return this.g_Baptist_date;
    }

    public Timestamp getChurch_join_date() {
        return this.g_Church_join_date;
    }

    public String getLogin_id() {
        return this.g_Login_id;
    }

    public String getPassword() {
        return this.g_Password;
    }

    public String getReceipt_type() {
        return this.g_Receipt_type;
    }

    private void load(DBConn conn) {
        String sql = "select * from member where member_seq=?";
        RecordList r = DBUtil.run("select * from member where member_seq=?", this.g_Member_seq, conn);
        if (!r.isEmpty()) {
            r.setCurrentRow(0);
            this.g_Member_id = r.getS("member_id");
            this.g_Name1 = r.getS("name1");
            this.g_Name2 = r.getS("name2");
            this.g_Official_name = r.getS("official_name");
            this.g_Hkid = r.getS("hkid");
            this.g_Gender = r.getS("gender");
            this.g_Dob = r.getT("dob");
            this.g_Address = r.getS("address");
            this.g_Tel1 = r.getS("tel1");
            this.g_Tel2 = r.getS("tel2");
            this.g_Email = r.getS("email");
            this.g_Career = r.getS("career");
            this.g_Education = r.getS("education");
            this.g_Hobby = r.getS("hobby");
            this.g_Marital_status = r.getS("marital_status");
            this.g_Baptist_date = r.getT("baptist_date");
            this.g_Church_join_date = r.getT("church_join_date");
            this.g_Login_id = r.getS("login_id");
            this.g_Password = r.getS("password");
            this.g_Receipt_type = r.getS("receipt_type");
        }
    }

    public static int insert(String member_id, String name1, String name2, String official_name, String hkid, String gender, Timestamp dob, String address, String tel1, String tel2, String email, String career, String education, String hobby, String marital_status, Timestamp baptist_date, Timestamp church_join_date, String new_photo_path, String login_id, String password, String receipt_type, Timestamp start_date, Timestamp end_date, RecordList remarks) {
        String sql = "insert into member( member_seq,member_id,name1,name2,official_name,hkid,gender,dob,address,tel1,tel2,email,career,education,hobby,marital_status,baptist_date,church_join_date,login_id,receipt_type)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        DBConn conn = new DBConn();
        int member_seq = -1;
        member_seq = DBUtil.getNextValueFor("member_seq", conn);
        if (!new_photo_path.equals("")) {
            String photo_location = "image/member_photo/" + member_seq + ".jpg";
            Tools.copyFile(new_photo_path, photo_location);
        }
        DBUtil.run("insert into member( member_seq,member_id,name1,name2,official_name,hkid,gender,dob,address,tel1,tel2,email,career,education,hobby,marital_status,baptist_date,church_join_date,login_id,receipt_type)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{new Integer(member_seq), member_id, name1, name2, official_name, hkid, gender, dob, address, tel1, tel2, email, career, education, hobby, marital_status, baptist_date, church_join_date, login_id, receipt_type}, conn);
        Member.updatePassword(member_seq, password, conn);
        MemberRemark.update(member_seq, remarks, conn);
        if (start_date == null) {
            start_date = TimeUtil.getCurrentDate();
        }
        if (end_date == null) {
            MemberGroup mg = new MemberGroup(MemberGroup.ROOT_GROUP_SEQ, conn);
            end_date = mg.getEnd_date();
        }
        RecordList r = new RecordList();
        r.add(MemberGroupMember.createMemberHashMap(MemberGroup.ROOT_GROUP_SEQ, member_seq, start_date, end_date));
        MemberGroupMember.insert(r, 0, conn);
        conn.commit();
        return conn.isSuccessful() ? member_seq : -1;
    }

    public static int update(int member_seq, String member_id, String name1, String name2, String official_name, String hkid, String gender, Timestamp dob, String address, String tel1, String tel2, String email, String career, String education, String hobby, String marital_status, Timestamp baptist_date, Timestamp church_join_date, String new_photo_path, String login_id, String password, String receipt_type, RecordList remarks) {
        String sql = "update member set member_id=?,name1=?,name2=?,official_name=?,hkid=?,gender=?,dob=?,address=?,tel1=?,tel2=?,email=?,career=?,education=?,hobby=?,marital_status=?,baptist_date=?,church_join_date=?,login_id=?,receipt_type=? where member_seq=?";
        DBConn conn = new DBConn();
        if (!new_photo_path.equals("")) {
            String photo_location = "image/member_photo/" + member_seq + ".jpg";
            Tools.copyFile(new_photo_path, photo_location);
        }
        DBUtil.run("update member set member_id=?,name1=?,name2=?,official_name=?,hkid=?,gender=?,dob=?,address=?,tel1=?,tel2=?,email=?,career=?,education=?,hobby=?,marital_status=?,baptist_date=?,church_join_date=?,login_id=?,receipt_type=? where member_seq=?", new Object[]{member_id, name1, name2, official_name, hkid, gender, dob, address, tel1, tel2, email, career, education, hobby, marital_status, baptist_date, church_join_date, login_id, receipt_type, new Integer(member_seq)}, conn);
        Member.updatePassword(member_seq, password, conn);
        MemberRemark.update(member_seq, remarks, conn);
        conn.commit();
        return conn.isSuccessful() ? member_seq : -1;
    }

    public static void updatePassword(int member_seq, String password, DBConn conn) {
        if (password.equals("")) {
            return;
        }
        String sql = "update member set PASSWORD=? where MEMBER_SEQ=?";
        DBUtil.run("update member set PASSWORD=? where MEMBER_SEQ=?", new Object[]{Tools.md5(password), new Integer(member_seq)}, conn);
    }

    public static ArrayList search(String member_id, String display_name, boolean show_incl_inactive, int member_group_seq, String member_remark_code, String member_remark_remark) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"lower(mb.member_id) like lower(?)", "lower(coalesce(mb.name1,'')||'\t'||coalesce(mb.name2,'')||'\t'||coalesce(mb.official_name,'')) like lower(?)", "mgm2.member_group_seq=?", "mbr.code=?", "lower(mbr.remark) like lower(?)"}, new Object[]{Tools.pad(member_id), Tools.pad(display_name), member_group_seq, member_remark_code, Tools.pad(member_remark_remark)});
        String sql = "select distinct mb.member_seq,mb.member_id,mb.name1,mb.name2,coalesce(mb.tel1,'')||coalesce(' / '+mb.tel2,'') as tel,mb.email" + Member.getSelectDisplayNameSQL() + ",'N' as selected" + " from" + " member mb" + "  left join member_remark mbr" + "  on mb.member_seq=mbr.member_seq" + ",member_group_member mgm" + ",member_group_member mgm2" + ",user_privilege_vw upv" + " where" + " mgm.member_group_seq=upv.member_group_seq" + " and mgm.member_seq=mb.member_seq" + " and upv.privilege='" + "memberRead" + "'" + " and upv.user_seq=" + UserSession.getLoginUserSeq() + " and mgm.member_seq=mgm2.member_seq" + (show_incl_inactive ? "" : " and mgm2.end_date>=curdate()") + clause.getConds() + Member.getOrderByDisplayNameSQL();
        return DBUtil.run(sql, clause.getPrepValues());
    }

    public static RecordList getMemberCardInfo(ArrayList member_seqs, String sorting) {
        SQLWhereClause clause = new SQLWhereClause("where", new String[]{"1=? and member_seq in" + DBUtil.getSQLInValues(member_seqs)}, new Object[]{!member_seqs.isEmpty() ? new Integer(1) : new Integer(-1)});
        String sql = "select member_seq,member_id,name1,name2,official_name,address from member" + clause.getConds() + (sorting.equals("") ? "" : " order by " + sorting);
        return DBUtil.run(sql, clause.getPrepValues());
    }

    public static int getMemberSeq(String member_id) {
        String sql = "select member_seq from member where lower(member_id)=lower(?)";
        RecordList r = DBUtil.run("select member_seq from member where lower(member_id)=lower(?)", member_id);
        return !r.isEmpty() ? r.getI("member_seq", 0) : -1;
    }

    public static RecordList getAllMemberIdLoginIds(int member_seq) {
        String sql = "select lower(member_id) as member_id,lower(login_id) as login_id from member where member_seq<>?";
        return DBUtil.run("select lower(member_id) as member_id,lower(login_id) as login_id from member where member_seq<>?", member_seq);
    }

    public static boolean isIdAllowed(RecordList members, String newId) {
        if (newId.equals(User.ADMIN_NAME2)) {
            return false;
        }
        if (members.indexOf("member_id", newId) != -1) {
            return false;
        }
        return members.indexOf("login_id", newId) == -1;
    }

    public static String checkImport(File file) {
        String WARN__FILE_READ_ERROR = "File read error\n";
        String WARN__NOT_XLS_FILE = "File is not a valid Excel file\n";
        String WARN__COL_NUM_NOT_EQ = "Column number doesn't match to the template\n";
        String WARN__MEMBER_ID_MISSED = "Member ID is missed\n";
        String WARN__MEMBER_ID_NOT_ALLOW = "Member ID is already used\n";
        String WARN__LOGIN_ID_NOT_ALLOW = "Login ID is already used\n";
        String WARN__RECEIPT_TYPE = "No Receipt Type is entered or incorrect format\n";
        String WARN__DOB_DATE_FORMAT = "Incorrect Date of Birth format\n";
        String WARN__BAPTIST_DATE_FORMAT = "Incorrect Baptist Data format\n";
        String WARN__CHURCH_JOIN_DATE_FORMAT = "Incorrect Join Church Date format\n";
        String WARN__START_DATE_FORMAT = "Incorrect Start Date format\n";
        String WARN__END_DATE_FORMAT = "Incorrect End Date format\n";
        String WARN__GENDER_CODE = "No Gender is entered or incorrect code\n";
        String WARN__MARTIAL_CODE = "No Martial Status is entered or incorrect code\n";
        String WARN__RECEIPT_TYPE_CODE = "No Receipt Type is entered or incorrect code\n";
        String WARN__EMAIL_FORMAT = "Email address format incorrect\n";
        String warningMsg = "";
        RecordList mids = Member.getAllMemberIdLoginIds(-1);
        int midsSize = mids.size();
        String content = "";
        String email_format = "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        try {
            Workbook workbook = Workbook.getWorkbook((File)file);
            Sheet sheet = workbook.getSheet(0);
            RecordList remarkCols = MemberRemark.getRemarkCols();
            int ttlCol = sheet.getColumns();
            if (ttlCol != MemberImportTemplate.gFixedColNum + remarkCols.size()) {
                warningMsg = String.valueOf(warningMsg) + WARN__COL_NUM_NOT_EQ;
            }
            int i = 1;
            while (i < sheet.getRows()) {
                String login_id;
                String colDesc = "Row " + (i + 1) + ": ";
                String member_id = sheet.getCell(0, i).getContents();
                if (member_id.isEmpty()) {
                    warningMsg = String.valueOf(warningMsg) + colDesc + WARN__MEMBER_ID_MISSED;
                } else if (!Member.isIdAllowed(mids, member_id.toLowerCase())) {
                    warningMsg = String.valueOf(warningMsg) + colDesc + WARN__MEMBER_ID_NOT_ALLOW;
                }
                content = sheet.getCell(5, i).getContents();
                if (!content.isEmpty() && SystemCode.getGender(content).isEmpty()) {
                    warningMsg = String.valueOf(warningMsg) + colDesc + WARN__GENDER_CODE;
                }
                if (!sheet.getCell(6, i).getContents().isEmpty() && ExcelUtil.getCellDate(sheet.getCell(6, i)) == null) {
                    warningMsg = String.valueOf(warningMsg) + colDesc + WARN__DOB_DATE_FORMAT;
                }
                if (!sheet.getCell(10, i).getContents().isEmpty() && !sheet.getCell(10, i).getContents().matches(email_format)) {
                    warningMsg = String.valueOf(warningMsg) + colDesc + WARN__EMAIL_FORMAT;
                }
                if (!(content = sheet.getCell(14, i).getContents()).isEmpty() && SystemCode.getMartial_status(content).isEmpty()) {
                    warningMsg = String.valueOf(warningMsg) + colDesc + WARN__MARTIAL_CODE;
                }
                if (!sheet.getCell(15, i).getContents().isEmpty() && ExcelUtil.getCellDate(sheet.getCell(15, i)) == null) {
                    warningMsg = String.valueOf(warningMsg) + colDesc + WARN__BAPTIST_DATE_FORMAT;
                }
                if (!sheet.getCell(16, i).getContents().isEmpty() && ExcelUtil.getCellDate(sheet.getCell(16, i)) == null) {
                    warningMsg = String.valueOf(warningMsg) + colDesc + WARN__CHURCH_JOIN_DATE_FORMAT;
                }
                if (!(login_id = sheet.getCell(17, i).getContents()).isEmpty() && !Member.isIdAllowed(mids, login_id.toLowerCase())) {
                    warningMsg = String.valueOf(warningMsg) + colDesc + WARN__LOGIN_ID_NOT_ALLOW;
                }
                mids.setS("member_id", member_id, midsSize + i - 1);
                mids.setS("login_id", login_id, midsSize + i - 1);
                content = sheet.getCell(19, i).getContents();
                if (!(content.isEmpty() || content.equals(RECEIPT_TYPE__PRINT) || content.equals(RECEIPT_TYPE__EMAIL))) {
                    warningMsg = String.valueOf(warningMsg) + colDesc + WARN__RECEIPT_TYPE_CODE;
                }
                if (!sheet.getCell(20, i).getContents().isEmpty() && ExcelUtil.getCellDate(sheet.getCell(20, i)) == null) {
                    warningMsg = String.valueOf(warningMsg) + colDesc + WARN__START_DATE_FORMAT;
                }
                if (!sheet.getCell(21, i).getContents().isEmpty() && ExcelUtil.getCellDate(sheet.getCell(21, i)) == null) {
                    warningMsg = String.valueOf(warningMsg) + colDesc + WARN__END_DATE_FORMAT;
                }
                ++i;
            }
        }
        catch (BiffException ex) {
            warningMsg = WARN__NOT_XLS_FILE;
        }
        catch (IOException e1) {
            warningMsg = WARN__FILE_READ_ERROR;
        }
        return warningMsg;
    }

    public static void insertImport(File file) {
        try {
            Workbook workbook = Workbook.getWorkbook((File)file);
            Sheet sheet = workbook.getSheet(0);
            RecordList remarkCols = MemberRemark.getRemarkCols();
            int i = 1;
            while (i < sheet.getRows()) {
                RecordList remarks = new RecordList(new String[]{MemberRemark.CODE, MemberRemark.REMARK});
                int j = 0;
                while (j < remarkCols.size()) {
                    String remark = sheet.getCell(22 + j, i).getContents();
                    if (!remark.equals("")) {
                        remarks.addItem(new String[]{remarkCols.getS(MemberRemark.CODE, j), remark});
                    }
                    remarkCols.setS(MemberRemark.REMARK, sheet.getCell(MemberImportTemplate.gFixedColNum + j, i).getContents(), j);
                    ++j;
                }
                String receipt_type = sheet.getCell(19, i).getContents();
                Member.insert(sheet.getCell(0, i).getContents(), sheet.getCell(1, i).getContents(), sheet.getCell(2, i).getContents(), sheet.getCell(3, i).getContents(), sheet.getCell(4, i).getContents(), sheet.getCell(5, i).getContents(), ExcelUtil.getCellDate(sheet.getCell(6, i)), sheet.getCell(7, i).getContents(), sheet.getCell(8, i).getContents(), sheet.getCell(9, i).getContents(), sheet.getCell(10, i).getContents(), sheet.getCell(11, i).getContents(), sheet.getCell(12, i).getContents(), sheet.getCell(13, i).getContents(), sheet.getCell(14, i).getContents(), ExcelUtil.getCellDate(sheet.getCell(15, i)), ExcelUtil.getCellDate(sheet.getCell(16, i)), "", sheet.getCell(17, i).getContents(), sheet.getCell(18, i).getContents(), !receipt_type.equals("") ? receipt_type : RECEIPT_TYPE__PRINT, ExcelUtil.getCellDate(sheet.getCell(20, i)), ExcelUtil.getCellDate(sheet.getCell(21, i)), remarks);
                ++i;
            }
        }
        catch (BiffException ex) {
            Tools.writeError(ex.toString());
        }
        catch (IOException e1) {
            Tools.writeError(e1.toString());
        }
    }

    public String getDisplayName() {
        return Member.getDisplayName(this.getName1(), this.getName2());
    }

    public static String getDisplayName(String name1, String name2) {
        String display_name_str = Config.getS(Config.displayNameFormat);
        display_name_str = display_name_str.replace("[n1]", name1);
        return display_name_str.replace("[n2]", name2);
    }

    public static String getSelectDisplayNameSQL() {
        String display_name_str = Config.getS(Config.displayNameFormat);
        return ",replace(replace('" + display_name_str + "','[n1]',coalesce(mb.name1,'')),'[n2]',coalesce(mb.name2,'')) as display_name";
    }

    public static String getSelectDisplayNameShortSQL() {
        String display_name_str = Config.getS(Config.displayNameShortFormat);
        return ",replace(replace('" + display_name_str + "','[n1]',coalesce(mb.name1,'')),'[n2]',coalesce(mb.name2,'')) as display_name";
    }

    public static String getOrderByDisplayNameSQL() {
        return " order by case when mb.name1 is null and mb.name2 is null then 1 else 0 end,display_name,mb.member_id";
    }
}

