/*
 * Decompiled with CFR 0.152.
 */
package mainapp;

import database.DBUtil;
import de.javasoft.plaf.synthetica.SyntheticaBlackMoonLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import mainapp.AboutAction;
import mainapp.AccountActivityReportAction;
import mainapp.AccountListAction;
import mainapp.AccountPeriodListAction;
import mainapp.AccountReportAction;
import mainapp.ActivityListAction;
import mainapp.AttendanceReportAction;
import mainapp.CheckVersionAction;
import mainapp.ConfigInfoAction;
import mainapp.ImportMemberAction;
import mainapp.MasterCodeListAction;
import mainapp.MemberGroupAction;
import mainapp.MemberGroupReportAction;
import mainapp.MemberListAction;
import mainapp.MemberReportAction;
import mainapp.OfferingPrintAction;
import mainapp.PasswordInfoAction;
import mainapp.ReceiptListAction;
import mainapp.ReceiptMonthlyReportAction;
import mainapp.ReceiptPrintAction;
import mainapp.RunSQLAction;
import mainapp.SystemCloseAction;
import mainapp.UserListAction;
import mainapp.UserManualAction;
import mainapp.VenueListAction;
import mainapp.VenueRequestAction;
import mainapp.VenueRequestReportAction;
import mainapp.VouTemplateListAction;
import mainapp.VoucherListAction;
import mainapp.VoucherReportAction;
import mainapp.WindowCloseListener;
import system.CheckUpdateThread;
import system.Config;
import system.Constants;
import system.Lang;
import system.LoginDialog;
import system.MsgOut;
import system.SystemCode;
import system.SystemUpdate;
import system.User;
import ui.TableLayout;
import util.WinUtil;

public class MainFrame
extends JFrame {
    public static String CONFIG;
    private JTextArea gMsgArea;

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new MsgOut());
        try {
            UIManager.setLookAndFeel((LookAndFeel)new SyntheticaBlackMoonLookAndFeel());
            SyntheticaLookAndFeel.setFont((String)"DialogInput", (int)12);
            String[] li = new String[]{"Licensee=Barry Leung", "LicenseRegistrationNumber=NCBL100310", "Product=Synthetica", "LicenseType=Non Commercial", "ExpireDate=--.--.----", "MaxVersion=2.999.999"};
            UIManager.put("Synthetica.license.info", li);
            UIManager.put("Synthetica.license.key", "C26ABB21-8E6909E2-8FA16620-4A49FFA9-5EEF7E0C");
        }
        catch (Exception li) {
            // empty catch block
        }
        if (args.length != 0) {
            String config = "config/" + args[0];
            File f = new File(config);
            if (!f.exists()) {
                WinUtil.showMessage(null, "Config file " + f.getAbsoluteFile() + " doesn't exist");
                System.exit(0);
            } else {
                CONFIG = config;
            }
        } else {
            CONFIG = "config/config.txt";
        }
        if (!DBUtil.isDBConnectable()) {
            JOptionPane.showMessageDialog(null, "Database connection failure on \"" + Constants.DB_TYPE + "\",\"" + Constants.DB_PATH + "\"", "Error", 1);
            System.exit(1);
        }
        SystemUpdate systemUpdate = new SystemUpdate();
        LoginDialog d = new LoginDialog(null);
    }

    public static void initMainFrame() {
        MainFrame mainFrame = new MainFrame();
        mainFrame.setIconImage(Toolkit.getDefaultToolkit().getImage("image/icon.png"));
        mainFrame.setVisible(true);
        CheckUpdateThread checkUpdate = new CheckUpdateThread(mainFrame);
        checkUpdate.start();
        WinUtil.setFixedWindow(mainFrame, 400, 303);
        mainFrame.setVisible(true);
        WinUtil.getWaitingDialog(null, "...", 0.0);
        JDialog d = new JDialog(mainFrame);
        d.setVisible(true);
        d.dispose();
    }

    public MainFrame() {
        try {
            JMenuBar mainMenuBar = new JMenuBar();
            this.setJMenuBar(mainMenuBar);
            this.setTitle("ACTS");
            this.addWindowListener(new WindowCloseListener(this));
            JMenu systemMainMenu = new JMenu(Lang.set(" System "));
            if (User.hasPrivilege("masterCodeRead")) {
                JMenuItem masterCodeListItem = new JMenuItem(Lang.set("Custom Code"));
                masterCodeListItem.addActionListener(new MasterCodeListAction(this));
                systemMainMenu.add(masterCodeListItem);
            }
            if (User.hasPrivilege("userRead")) {
                JMenuItem userListItem = new JMenuItem(Lang.set("User"));
                userListItem.addActionListener(new UserListAction(this));
                systemMainMenu.add(userListItem);
            }
            if (User.hasPrivilege("configRead")) {
                JMenuItem configInfoItem = new JMenuItem(Lang.set("Setting"));
                configInfoItem.addActionListener(new ConfigInfoAction(this));
                systemMainMenu.add(configInfoItem);
            }
            if (User.hasPrivilege("importData")) {
                JMenu importData = new JMenu(Lang.set("Import"));
                JMenuItem importMemberItem = new JMenuItem(Lang.set("Import Member"));
                importMemberItem.addActionListener(new ImportMemberAction(this));
                importData.add(importMemberItem);
                systemMainMenu.add(importData);
            }
            if (User.hasPrivilege("runSQL")) {
                JMenuItem runSQLItem = new JMenuItem(Lang.set("Run SQL"));
                runSQLItem.addActionListener(new RunSQLAction(this));
                systemMainMenu.add(runSQLItem);
            }
            JMenuItem passwordInfoItem = new JMenuItem(Lang.set("Change Password"));
            passwordInfoItem.addActionListener(new PasswordInfoAction(this));
            systemMainMenu.add(passwordInfoItem);
            JMenuItem closeItem = new JMenuItem(Lang.set("Exit"));
            closeItem.addActionListener(new SystemCloseAction(this));
            systemMainMenu.add(closeItem);
            mainMenuBar.add(systemMainMenu);
            JMenu memberMainMenu = new JMenu(Lang.set(" Member "));
            JMenu memberMenu = new JMenu(Lang.set("Member"));
            if (User.hasPrivilege("memberRead")) {
                JMenuItem memberList = new JMenuItem(Lang.set("Member"));
                memberList.addActionListener(new MemberListAction(this));
                memberMenu.add(memberList);
            }
            if (User.hasPrivilege("memberReport")) {
                JMenuItem memberReport = new JMenuItem(Lang.set("Member Report"));
                memberReport.addActionListener(new MemberReportAction(this));
                memberMenu.add(memberReport);
            }
            if (memberMenu.getItemCount() != 0) {
                memberMainMenu.add(memberMenu);
            }
            JMenu memberGroupMenu = new JMenu(Lang.set("Member Group"));
            if (User.hasPrivilege("memberGroupRead")) {
                JMenuItem memberGroupList = new JMenuItem(Lang.set("Member Group"));
                memberGroupList.addActionListener(new MemberGroupAction(this));
                memberGroupMenu.add(memberGroupList);
                JMenuItem memberGroupReportList = new JMenuItem(Lang.set("Member Group Report"));
                memberGroupReportList.addActionListener(new MemberGroupReportAction(this));
                memberGroupMenu.add(memberGroupReportList);
            }
            if (memberGroupMenu.getItemCount() != 0) {
                memberMainMenu.add(memberGroupMenu);
            }
            if (memberMainMenu.getItemCount() != 0) {
                mainMenuBar.add(memberMainMenu);
            }
            JMenu activityMainMenu = new JMenu(Lang.set(" Activity "));
            JMenu activityMenu = new JMenu(Lang.set("Activity"));
            if (User.hasPrivilege("activityRead")) {
                JMenuItem activityList = new JMenuItem(Lang.set("Activity"));
                activityList.addActionListener(new ActivityListAction(this));
                activityMenu.add(activityList);
            }
            if (User.hasPrivilege("attendanceReport")) {
                JMenuItem attendanceReport = new JMenuItem(Lang.set("Attendance Report"));
                attendanceReport.addActionListener(new AttendanceReportAction(this));
                activityMenu.add(attendanceReport);
            }
            if (activityMenu.getItemCount() != 0) {
                activityMainMenu.add(activityMenu);
            }
            JMenu venueMenu = new JMenu(Lang.set("Venue"));
            if (User.hasPrivilege("venueRequestRead")) {
                JMenuItem venueRequest = new JMenuItem(Lang.set("Venue Reservation"));
                venueRequest.addActionListener(new VenueRequestAction(this));
                venueMenu.add(venueRequest);
            }
            if (User.hasPrivilege("venueRequestReport")) {
                JMenuItem venueRequestReport = new JMenuItem(Lang.set("Venue Reservation Report"));
                venueRequestReport.addActionListener(new VenueRequestReportAction(this));
                venueMenu.add(venueRequestReport);
            }
            if (User.hasPrivilege("venueRead")) {
                JMenuItem venueList = new JMenuItem(Lang.set("Venue"));
                venueList.addActionListener(new VenueListAction(this));
                venueMenu.add(venueList);
            }
            if (venueMenu.getItemCount() != 0) {
                activityMainMenu.add(venueMenu);
            }
            if (activityMainMenu.getItemCount() != 0) {
                mainMenuBar.add(activityMainMenu);
            }
            JMenu accountMainMenu = new JMenu(Lang.set(" Account "));
            JMenu receiptMenu = new JMenu(Lang.set("Donation & Receipt"));
            if (User.hasPrivilege("receiptRead")) {
                JMenuItem receiptList = new JMenuItem(Lang.set("Receipt"));
                receiptList.addActionListener(new ReceiptListAction(this));
                receiptMenu.add(receiptList);
            }
            if (User.hasPrivilege("receiptPrint")) {
                JMenuItem receiptPrintM = new JMenuItem(Lang.set("Print Receipt"));
                receiptPrintM.addActionListener(new ReceiptPrintAction(this));
                receiptMenu.add(receiptPrintM);
                JMenuItem receiptMonthlyReportM = new JMenuItem(Lang.set("Receipt Monthly Report"));
                receiptMonthlyReportM.addActionListener(new ReceiptMonthlyReportAction(this));
                receiptMenu.add(receiptMonthlyReportM);
                JMenuItem offeringPrintM = new JMenuItem(Lang.set("Print Donation Certificate"));
                offeringPrintM.addActionListener(new OfferingPrintAction(this));
                receiptMenu.add(offeringPrintM);
            }
            if (receiptMenu.getItemCount() != 0) {
                accountMainMenu.add(receiptMenu);
            }
            JMenu voucherMenu = new JMenu(Lang.set("Voucher"));
            if (User.hasPrivilege("voucherRead")) {
                JMenuItem voucherList = new JMenuItem(Lang.set("Voucher"));
                voucherList.addActionListener(new VoucherListAction(this));
                voucherMenu.add(voucherList);
                JMenuItem voucherReportList = new JMenuItem(Lang.set("Voucher Report"));
                voucherReportList.addActionListener(new VoucherReportAction(this));
                voucherMenu.add(voucherReportList);
            }
            if (User.hasPrivilege("vouTemplateRead")) {
                JMenuItem vouTemplateList = new JMenuItem(Lang.set("Voucher Template"));
                vouTemplateList.addActionListener(new VouTemplateListAction(this));
                voucherMenu.add(vouTemplateList);
            }
            if (voucherMenu.getItemCount() != 0) {
                accountMainMenu.add(voucherMenu);
            }
            JMenu ledgerMenu = new JMenu(Lang.set("General Ledger"));
            if (User.hasPrivilege("voucherRead")) {
                JMenuItem accountPeriodList = new JMenuItem(Lang.set("Posting"));
                accountPeriodList.addActionListener(new AccountPeriodListAction(this));
                ledgerMenu.add(accountPeriodList);
            }
            if (User.hasPrivilege("accountActivityReport")) {
                JMenuItem accountActivityReport = new JMenuItem(Lang.set("Account Activity Report"));
                accountActivityReport.addActionListener(new AccountActivityReportAction(this));
                ledgerMenu.add(accountActivityReport);
            }
            if (User.hasPrivilege("accountRead")) {
                JMenuItem accountList = new JMenuItem(Lang.set("Account"));
                accountList.addActionListener(new AccountListAction(this));
                ledgerMenu.add(accountList);
            }
            if (User.hasPrivilege("accountRead")) {
                JMenuItem accountReport = new JMenuItem(Lang.set("Chart of Account"));
                accountReport.addActionListener(new AccountReportAction(this));
                ledgerMenu.add(accountReport);
            }
            if (ledgerMenu.getItemCount() != 0) {
                accountMainMenu.add(ledgerMenu);
            }
            if (accountMainMenu.getItemCount() != 0) {
                mainMenuBar.add(accountMainMenu);
            }
            JMenu helpMainMenu = new JMenu(Lang.set(" Help "));
            JMenuItem userManual = new JMenuItem(Lang.set("User Manual"));
            userManual.addActionListener(new UserManualAction(this));
            helpMainMenu.add(userManual);
            if (Config.getS(Config.autoCheckUpdate).equals(SystemCode.YN__Y)) {
                JMenuItem checkVersion = new JMenuItem(Lang.set("Check for Updates"));
                checkVersion.addActionListener(new CheckVersionAction(this));
                helpMainMenu.add(checkVersion);
            }
            JMenuItem about = new JMenuItem(Lang.set("About ACTS"));
            about.addActionListener(new AboutAction(this));
            helpMainMenu.add(about);
            mainMenuBar.add(helpMainMenu);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.gMsgArea = new JTextArea(String.valueOf(Lang.set("Message:")) + "\n");
        this.gMsgArea.setEditable(false);
        JScrollPane msgAreaSP = new JScrollPane(this.gMsgArea);
        JButton logoutB = new JButton(Lang.set("Logout"));
        logoutB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        TableLayout t = new TableLayout(390, 245, 2, 2);
        t.addTable(new int[]{388}, new int[]{213, 30});
        t.getClass();
        t.getClass();
        t.addCell(msgAreaSP, 0, 0, 0, 0, 388, 211);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(logoutB, 0, 1, 0, 0, 390, -1);
        this.add(t);
    }
}

