/*
 * Decompiled with CFR 0.152.
 */
package attendance;

import attendance.AttendanceReport;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import member.MemberGroupSelectComboBox;
import system.MasterCodeComboBoxCN;
import ui.ComboBoxCN;
import ui.DataDialog;
import ui.DateTextField;
import ui.TableLayout;
import util.Validation;
import util.WinUtil;

public class AttendanceReportDialog
extends DataDialog {
    ComboBoxCN typeCN;
    MemberGroupSelectComboBox member_groupCB;
    DateTextField start_dateDT;
    DateTextField end_dateDT;
    JButton exportB;
    JButton cancelB;
    JCheckBox show_timeCB;
    JCheckBox show_remarkCB;
    JCheckBox show_multi_time_rangeCB;
    JCheckBox show_multi_time_sumCB;
    JCheckBox show_only_incl_groupCB;

    public AttendanceReportDialog(JFrame f) {
        super(f, "Attendance Report", false);
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    void setEditLayout() {
        this.typeCN = new MasterCodeComboBoxCN("ACTIVITY", "");
        this.member_groupCB = new MemberGroupSelectComboBox("attendanceReport");
        this.start_dateDT = new DateTextField();
        this.end_dateDT = new DateTextField();
        this.exportB = new JButton("Run");
        this.cancelB = new JButton("Cancel");
        this.show_timeCB = new JCheckBox("Show in time", false);
        this.show_remarkCB = new JCheckBox("Show remark", false);
        this.show_multi_time_rangeCB = new JCheckBox("Show multiple taken period", false);
        this.show_multi_time_sumCB = new JCheckBox("Show multiple taken minutes", false);
        this.show_only_incl_groupCB = new JCheckBox("Show activities for allowed groups", false);
        TableLayout t = new TableLayout(this, 425, 325, 5, 10);
        int[] nArray = new int[2];
        nArray[0] = 80;
        t.getClass();
        nArray[1] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30, 30, 30, 30, 30});
        JLabel jLabel = new JLabel("Category");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.addCell(this.typeCN, 1, 0, 20, 0);
        JLabel jLabel2 = new JLabel("Date");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 0, 1, 1, 0);
        t.getClass();
        t.addCell(this.start_dateDT, 1, 1, 20, 0);
        JLabel jLabel3 = new JLabel("to");
        t.getClass();
        t.addCell(jLabel3, 1, 1, 110, 0);
        t.getClass();
        t.addCell(this.end_dateDT, 1, 1, 130, 0);
        JLabel jLabel4 = new JLabel("Group");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, 2, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.member_groupCB, 1, 2, 20, 0, 300, -1);
        t.getClass();
        t.addCell(this.show_timeCB, 1, 3, 20, 0);
        t.getClass();
        t.addCell(this.show_multi_time_rangeCB, 1, 4, 20, 0);
        t.getClass();
        t.addCell(this.show_multi_time_sumCB, 1, 5, 20, 0);
        t.getClass();
        t.addCell(this.show_remarkCB, 1, 6, 20, 0);
        t.getClass();
        t.addCell(this.show_only_incl_groupCB, 1, 7, 20, 0);
        int[] nArray2 = new int[4];
        t.getClass();
        nArray2[0] = 0;
        nArray2[1] = 15;
        nArray2[2] = 80;
        nArray2[3] = 10;
        t.addTable(nArray2, new int[]{30});
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.exportB, 0, 0, 1, 0, 80, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0, 80, -1);
    }

    public void setEventHandler() {
        this.exportB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceReportDialog.this.onExport(evt);
            }
        });
        this.show_multi_time_rangeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceReportDialog.this.onSelectShowMultiTimeRange(evt);
            }
        });
        this.show_multi_time_sumCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceReportDialog.this.onSelectShowMultiTimeSum(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceReportDialog.this.onCancel(evt);
            }
        });
    }

    public void onSelectShowMultiTimeRange(ActionEvent evt) {
        this.show_multi_time_sumCB.setSelected(false);
    }

    public void onSelectShowMultiTimeSum(ActionEvent evt) {
        this.show_multi_time_rangeCB.setSelected(false);
    }

    public void onExport(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(this.typeCN.getSelectedCode(), "Category", "R");
        validation.add(this.start_dateDT.getInput(), "Date(Start)", "R,D");
        validation.add(this.end_dateDT.getInput(), "Date(End)", "R,D");
        if (!validation.isValid()) {
            return;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Running report...");
        AttendanceReport p = new AttendanceReport(this.typeCN.getSelectedCode(), this.start_dateDT.getDate(), this.end_dateDT.getDate(), this.member_groupCB.getSelGroups(), this.show_timeCB.isSelected(), this.show_multi_time_rangeCB.isSelected(), this.show_multi_time_sumCB.isSelected(), this.show_remarkCB.isSelected(), this.show_only_incl_groupCB.isSelected());
        wait_dialog.dispose();
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

