/*
 * Decompiled with CFR 0.152.
 */
package attendance;

import attendance.Activity;
import attendance.ActivityMemberGroup;
import database.DBConn;
import database.DBUtil;
import database.SQLWhereClause;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import member.Member;
import util.ArrayUtil;
import util.RecordList;
import util.TimeUtil;

public class Attendance {
    public static String MEMBER_SEQ = "member_seq";
    public static String IN_TIME = "in_time";
    public static String EXEMPT = "exempt";
    public static String REMARK = "remark";
    public static int MIN_TAKE_INTERVAL = 15;
    private int g_Activity_seq = -1;
    private ArrayList g_Items = null;

    public Attendance() {
    }

    public Attendance(int activity_seq) {
        this.g_Activity_seq = activity_seq;
        DBConn conn = new DBConn();
        this.g_Items = Attendance.load(this.g_Activity_seq, conn);
        conn.commit();
    }

    public ArrayList getItems() {
        return this.g_Items;
    }

    private static ArrayList load(int activity_seq, DBConn conn) {
        String sql = "select * from attendance where activity_seq=?";
        return DBUtil.run(sql, activity_seq);
    }

    private static void insert(int activity_seq, int member_seq, Timestamp in_time, String exempt, String remark, DBConn conn) {
        String sql = "insert into attendance( attendance_seq,activity_seq,member_seq,in_time,exempt,remark)values(?,?,?,?,?,?)";
        int attendance_seq = DBUtil.getNextValueFor("attendance_seq", conn);
        Object[] pvs = new Object[]{new Integer(attendance_seq), new Integer(activity_seq), new Integer(member_seq), in_time, exempt, remark};
        DBUtil.run("insert into attendance( attendance_seq,activity_seq,member_seq,in_time,exempt,remark)values(?,?,?,?,?,?)", pvs, conn);
    }

    private static void update(int attendance_seq, int activity_seq, int member_seq, String exempt, Timestamp in_time, String remark, DBConn conn) {
        String sql = "update attendance set activity_seq=?,member_seq=?,in_time=?,exempt=?,remark=? where attendance_seq=?";
        Object[] pvs = new Object[]{new Integer(activity_seq), new Integer(member_seq), in_time, exempt, remark, new Integer(attendance_seq)};
        DBUtil.run("update attendance set activity_seq=?,member_seq=?,in_time=?,exempt=?,remark=? where attendance_seq=?", pvs, conn);
    }

    public static void update(int activity_seq, RecordList attendances, RecordList amgs) {
        DBConn conn = new DBConn();
        Attendance.delete(activity_seq, conn);
        int i = 0;
        while (i < attendances.size()) {
            attendances.setCurrentRow(i);
            Timestamp in_time = attendances.getT("in_time");
            String exempt = attendances.getS("exempt");
            String remark = attendances.getS("remark");
            if (in_time != null || exempt.equals("Y") || !remark.equals("")) {
                Attendance.insert(activity_seq, attendances.getI("member_seq"), in_time, exempt, remark, conn);
            }
            ++i;
        }
        ActivityMemberGroup.update(activity_seq, amgs, conn);
        conn.commit();
    }

    private static void delete(int activity_seq, DBConn conn) {
        String sql = "delete from attendance where activity_seq=?";
        DBUtil.run("delete from attendance where activity_seq=?", new Object[]{new Integer(activity_seq)}, conn);
    }

    public static boolean exist(int activity_seq, int member_seq) {
        String sql = "select 'x' as TMP from attendance where activity_seq=? and member_seq=?";
        Object[] pvs = new Object[]{new Integer(activity_seq), new Integer(member_seq)};
        RecordList r = DBUtil.run("select 'x' as TMP from attendance where activity_seq=? and member_seq=?", pvs);
        return !r.isEmpty();
    }

    public static RecordList getAttendanceList(int activity_seq) {
        String sql = "select mb.member_seq,mb.member_id" + Member.getSelectDisplayNameSQL() + ",atd.in_time" + ",coalesce(atd.exempt,'N') as exempt" + ",atd.remark" + " from" + " attendance atd" + ",member mb" + " where" + " atd.member_seq=mb.member_seq" + " and atd.activity_seq=?" + " order by display_name,mb.member_seq,in_time";
        return DBUtil.run(sql, activity_seq);
    }

    public static Object[] checkImport(File file, Activity activity) {
        String WARN__FILE_READ_ERROR = " File Read Error\n";
        String WARN__FIELD_NUM_MISMATCH = " Record format is not [Member ID,Date,Time]\n";
        String WARN__WRONG_DATE_FORMAT = " Date field is not \"YYYY-MM-DD\" format\n";
        String WARN__WRONG_TIME_FORMAT = " Time field is not \"hh:mm:ss\" format\n";
        String WARN__BEFORE_START_RECORD_TIME = " Record time is earlier than activity start record time\n";
        String WARN__AFTER_END_RECORD_TIME = " Record time is earlier than activity end record time\n";
        String WARN__REPEAT_IN_DB = " This member attendance record is already recorded in database\n";
        String WARN__WRONG_MEMBER_ID = " Member ID is incorrect\n";
        String WARN__NOT_IN_ALLOWED_GROUP = " Member is not in a activity allowed group\n";
        String warning_msg = "";
        RecordList records = new RecordList(new String[]{"member_seq", "in_time"});
        try {
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
            reader.close();
            RecordList groupMembers = Attendance.getAllowedGroupMembers(activity.getActivity_seq());
            int i = 0;
            while (i < lines.size()) {
                block16: {
                    int member_seq;
                    Timestamp in_time;
                    String record;
                    block22: {
                        block21: {
                            String member_id;
                            block20: {
                                block19: {
                                    SimpleDateFormat df;
                                    String time;
                                    String date;
                                    block18: {
                                        int count;
                                        block17: {
                                            StringTokenizer token;
                                            block15: {
                                                record = (String)lines.get(i);
                                                token = new StringTokenizer(record, ",");
                                                count = token.countTokens();
                                                if (count == 3 || count == 1) break block15;
                                                warning_msg = String.valueOf(warning_msg) + record + WARN__FIELD_NUM_MISMATCH;
                                                break block16;
                                            }
                                            member_id = token.nextToken();
                                            date = "";
                                            time = "";
                                            if (count == 3) {
                                                date = token.nextToken();
                                                time = token.nextToken();
                                            }
                                            df = new SimpleDateFormat("yyyy-MM-dd");
                                            if (count == 1) {
                                                date = df.format((Date)activity.getDate(), new StringBuffer(), new FieldPosition(0)).toString();
                                            }
                                            df.setLenient(false);
                                            if (df.parse(date, new ParsePosition(0)) != null) break block17;
                                            warning_msg = String.valueOf(warning_msg) + record + WARN__WRONG_DATE_FORMAT;
                                            break block16;
                                        }
                                        df = new SimpleDateFormat("HH:mm:ss");
                                        if (count == 1) {
                                            time = df.format((Date)activity.getStart_time(), new StringBuffer(), new FieldPosition(0)).toString();
                                        }
                                        df.setLenient(false);
                                        if (df.parse(time, new ParsePosition(0)) != null) break block18;
                                        warning_msg = String.valueOf(warning_msg) + record + WARN__WRONG_TIME_FORMAT;
                                        break block16;
                                    }
                                    df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                    df.setLenient(false);
                                    in_time = new Timestamp(df.parse(String.valueOf(date) + " " + time, new ParsePosition(0)).getTime());
                                    if (!in_time.before(activity.getStart_record_time())) break block19;
                                    warning_msg = String.valueOf(warning_msg) + record + WARN__BEFORE_START_RECORD_TIME;
                                    break block16;
                                }
                                if (!in_time.after(activity.getEnd_record_time())) break block20;
                                warning_msg = String.valueOf(warning_msg) + record + WARN__AFTER_END_RECORD_TIME;
                                break block16;
                            }
                            member_seq = Member.getMemberSeq(member_id);
                            if (member_seq != -1) break block21;
                            warning_msg = String.valueOf(warning_msg) + record + WARN__WRONG_MEMBER_ID;
                            break block16;
                        }
                        RecordList mbRecords = records.getGroupItems("member_seq", member_seq);
                        if (mbRecords.isEmpty()) break block22;
                        Timestamp last_in_time = mbRecords.getT("in_time", mbRecords.size() - 1);
                        long diff = Math.abs((in_time.getTime() - last_in_time.getTime()) / 1000L);
                        if (diff < (long)MIN_TAKE_INTERVAL) break block16;
                    }
                    if (Attendance.exist(activity.getActivity_seq(), member_seq)) {
                        warning_msg = String.valueOf(warning_msg) + record + WARN__REPEAT_IN_DB;
                    } else if (groupMembers.indexOf("member_seq", new Integer(member_seq)) == -1) {
                        warning_msg = String.valueOf(warning_msg) + record + WARN__NOT_IN_ALLOWED_GROUP;
                    } else {
                        records.addItem(new Object[]{new Integer(member_seq), in_time});
                    }
                }
                ++i;
            }
        }
        catch (FileNotFoundException e1) {
            warning_msg = WARN__FILE_READ_ERROR;
        }
        catch (IOException e1) {
            warning_msg = WARN__FILE_READ_ERROR;
        }
        return new Object[]{warning_msg, records};
    }

    public static void insertImport(Activity activity, RecordList valid_records) {
        int activity_seq = activity.getActivity_seq();
        DBConn conn = new DBConn();
        int i = 0;
        while (i < valid_records.size()) {
            valid_records.setCurrentRow(i);
            Attendance.insert(activity_seq, valid_records.getI("member_seq"), valid_records.getT("in_time"), "N", "", conn);
            ++i;
        }
        conn.commit();
    }

    public static boolean existActivityAttendance(int activity_seq) {
        String sql = "select 'x' as TMP from attendance where activity_seq=?";
        RecordList r = DBUtil.run("select 'x' as TMP from attendance where activity_seq=?", activity_seq);
        String sql2 = "select 'x' as TMP from activity_member_group where activity_seq=? and headcount>0";
        RecordList r2 = DBUtil.run("select 'x' as TMP from activity_member_group where activity_seq=? and headcount>0", activity_seq);
        return !r.isEmpty() || !r2.isEmpty();
    }

    public static ArrayList getMemberAttendance(int member_seq, String type, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"atv.TYPE=?", "atv.DATE>=?", "atv.DATE<?"}, new Object[]{type, start_date, TimeUtil.adjustDate(end_date, 1)});
        String sql = "select mc.name as type,atv.name,atv.date,atv.date as week,atv.start_time,coalesce(atd.in_time,null) as in_time from activity atv left join (select activity_seq,in_time from attendance where member_seq=" + member_seq + " ) atd on atv.activity_seq=atd.activity_seq" + ",master_code mc" + " where" + " atv.type=mc.code" + clause.getConds() + " order by atv.date desc,atv.start_time";
        RecordList r = DBUtil.run(sql, clause.getPrepValues());
        int i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            ArrayUtil.setString("START_TIME", TimeUtil.getStringByTime(r.getT("start_time")), i, r);
            ArrayUtil.setString("IN_TIME", TimeUtil.getStringByTime(r.getT("in_time")), i, r);
            ++i;
        }
        return r;
    }

    private static RecordList getAllowedGroupMembers(int activity_seq) {
        String sql = "select distinct mgm.member_seq from activity atv,activity_member_group amg,member_group_member mgm where atv.activity_seq=amg.activity_seq and amg.member_group_seq=mgm.member_group_seq and atv.activity_seq=? and atv.date>=mgm.start_date and atv.date<=mgm.end_date";
        return DBUtil.run("select distinct mgm.member_seq from activity atv,activity_member_group amg,member_group_member mgm where atv.activity_seq=amg.activity_seq and amg.member_group_seq=mgm.member_group_seq and atv.activity_seq=? and atv.date>=mgm.start_date and atv.date<=mgm.end_date", activity_seq);
    }
}

