/*
 * Decompiled with CFR 0.152.
 */
package attendance;

import attendance.Activity;
import attendance.ActivityListDialog;
import attendance.ActivityMemberGroup;
import attendance.Attendance;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import member.MemberGroup;
import member.MemberGroupSelectComboBox;
import system.MasterCode;
import system.MasterCodeComboBoxCN;
import system.User;
import system.UserSession;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.DatePicker;
import ui.TableLayout;
import ui.TimeTextField;
import util.RecordList;
import util.RecordListSet;
import util.TimeUtil;
import util.Tools;
import util.Validation;
import util.WinUtil;
import venue.Venue;
import venue.VenueRequestInfoDialog;

public class ActivityInfoDialog
extends DataDialog {
    JTextField nameTF;
    JTextField lecturerTF;
    JTextField remarkTF;
    ComboBoxCN typeCN;
    ComboBoxCN statusCN;
    ComboBoxNV venueNV;
    MemberGroupSelectComboBox mgCB;
    DatePicker dateDP;
    TimeTextField start_timeTT;
    TimeTextField end_timeTT;
    TimeTextField late_timeTT;
    TimeTextField start_record_timeTT;
    TimeTextField end_record_timeTT;
    JCheckBox requestVenueCB;
    private RecordList g_Member_groups = null;
    JButton saveB;
    JButton cancelB;
    private Activity g_Activity = null;
    private boolean g_IsUpdate = false;
    private boolean g_CanModify = false;

    public ActivityInfoDialog(DataDialog f) {
        super(f, "Add Activity", false);
        this.g_Activity = new Activity();
        this.g_Member_groups = MemberGroup.getRootGroup();
        this.g_IsUpdate = false;
        this.initDialog();
    }

    public ActivityInfoDialog(DataDialog f, int activity_seq, boolean isUpdate) {
        super(f, "Add Activity", false);
        this.g_IsUpdate = isUpdate;
        if (isUpdate) {
            this.setTitle("Edit Acitivity");
        }
        this.g_Activity = new Activity(activity_seq);
        ActivityMemberGroup amg = new ActivityMemberGroup(activity_seq);
        this.g_Member_groups = amg.getItems();
        if (!this.g_IsUpdate) {
            this.g_Activity.resetActivit_seq();
            this.g_Activity.resetDate();
            amg.resetHeadcount();
        }
        this.initDialog();
    }

    private void initDialog() {
        if (this.g_Activity.getActivity_seq() == -1) {
            this.g_CanModify = true;
        } else {
            RecordList userMgs = User.getMGsByPrivilege("activityModify", false);
            RecordListSet set = new RecordListSet(userMgs, this.g_Member_groups, new String[]{"member_group_seq"});
            this.g_CanModify = !set.getIntersectOfLeft().isEmpty();
        }
        this.setEditLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    void setEditLayout() {
        this.nameTF = new JTextField(this.g_Activity.getName());
        this.lecturerTF = new JTextField(this.g_Activity.getLecturer());
        this.remarkTF = new JTextField(this.g_Activity.getRemark());
        this.typeCN = new MasterCodeComboBoxCN("ACTIVITY", this.g_Activity.getType());
        this.statusCN = this.getStatusSel();
        this.venueNV = new ComboBoxNV((ArrayList)Venue.getVenueNames(), "name", "venue_seq", this.g_Activity.getVenue_seq());
        this.mgCB = new MemberGroupSelectComboBox(this.g_Member_groups, "");
        this.dateDP = new DatePicker(this, this.g_Activity.getDate(), !this.g_IsUpdate);
        this.start_timeTT = new TimeTextField(this.g_Activity.getStart_time());
        this.end_timeTT = new TimeTextField(this.g_Activity.getEnd_time());
        this.late_timeTT = new TimeTextField(this.g_Activity.getLate_time());
        this.start_record_timeTT = new TimeTextField(this.g_Activity.getStart_record_time());
        this.end_record_timeTT = new TimeTextField(this.g_Activity.getEnd_record_time());
        this.requestVenueCB = new JCheckBox("Apply venue after save", false);
        this.requestVenueCB.setEnabled(User.hasPrivilege("venueRequestModify"));
        if (Attendance.existActivityAttendance(this.g_Activity.getActivity_seq())) {
            this.mgCB.setEnabled(false);
            this.dateDP.setEnabled(false);
            this.start_timeTT.setEnabled(false);
            this.end_timeTT.setEnabled(false);
            this.late_timeTT.setEnabled(false);
            this.start_record_timeTT.setEnabled(false);
            this.end_record_timeTT.setEnabled(false);
        }
        this.saveB = new JButton("Save");
        this.cancelB = new JButton("Cancel");
        this.saveB.setEnabled(this.g_CanModify);
        TableLayout t = new TableLayout(this, 500, 315, 12, 5);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 120;
        nArray[2] = 100;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30, 30});
        JLabel jLabel = new JLabel("Category");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.addCell(this.typeCN, 1, 0, 20, 0);
        JLabel jLabel2 = new JLabel("Status");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 2, 0, 1, 0);
        t.getClass();
        t.addCell(this.statusCN, 3, 0, 20, 0);
        JLabel jLabel3 = new JLabel("Name");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.nameTF, 1, 1, 20, 0, 140, -1);
        JLabel jLabel4 = new JLabel("Venue");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 2, 1, 1, 0);
        t.getClass();
        t.addCell(this.venueNV, 3, 1, 20, 0);
        JLabel jLabel5 = new JLabel("Date");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 0, 2, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.dateDP, 1, 2, 20, 0, 100, -1);
        JLabel jLabel6 = new JLabel("Speaker");
        t.getClass();
        t.getClass();
        t.addCell(jLabel6, 2, 2, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.lecturerTF, 3, 2, 20, 0, 140, -1);
        int[] nArray2 = new int[6];
        nArray2[0] = 80;
        nArray2[1] = 50;
        nArray2[2] = 100;
        nArray2[3] = 50;
        nArray2[4] = 100;
        t.getClass();
        nArray2[5] = 0;
        t.addTable(nArray2, new int[]{30, 30});
        JLabel jLabel7 = new JLabel("Start Time");
        t.getClass();
        t.getClass();
        t.addCell(jLabel7, 0, 0, 1, 0);
        t.getClass();
        t.addCell(this.start_timeTT, 1, 0, 20, 0);
        JLabel jLabel8 = new JLabel("End Time");
        t.getClass();
        t.getClass();
        t.addCell(jLabel8, 2, 0, 1, 0);
        t.getClass();
        t.addCell(this.end_timeTT, 3, 0, 20, 0);
        JLabel jLabel9 = new JLabel("Late Time");
        t.getClass();
        t.getClass();
        t.addCell(jLabel9, 4, 0, 1, 0);
        t.getClass();
        t.addCell(this.late_timeTT, 5, 0, 20, 0);
        JLabel jLabel10 = new JLabel("Record Start");
        t.getClass();
        t.getClass();
        t.addCell(jLabel10, 0, 1, 1, 0);
        t.getClass();
        t.addCell(this.start_record_timeTT, 1, 1, 20, 0);
        JLabel jLabel11 = new JLabel("Record End");
        t.getClass();
        t.getClass();
        t.addCell(jLabel11, 2, 1, 1, 0);
        t.getClass();
        t.addCell(this.end_record_timeTT, 3, 1, 20, 0);
        int[] nArray3 = new int[2];
        nArray3[0] = 80;
        t.getClass();
        nArray3[1] = 0;
        t.addTable(nArray3, new int[]{30, 30, 30});
        JLabel jLabel12 = new JLabel("Member Group");
        t.getClass();
        t.getClass();
        t.addCell(jLabel12, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.mgCB, 1, 0, 20, 0, 360, -1);
        JLabel jLabel13 = new JLabel("Remark");
        t.getClass();
        t.getClass();
        t.addCell(jLabel13, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.remarkTF, 1, 1, 20, 0, 360, -1);
        t.getClass();
        t.addCell(this.requestVenueCB, 1, 2, 20, 0);
        t.addTable(new int[]{400, 10, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    public ComboBoxCN getStatusSel() {
        String[][] status;
        String cur_status = this.g_Activity.getStatus();
        if (this.g_Activity.getStatus().equals("")) {
            status = new String[][]{Tools.getStatusItem(Activity.STATUS_MAP, Activity.STATUS__CP)};
            cur_status = Activity.STATUS__CP;
        } else {
            status = new String[][]{Tools.getStatusItem(Activity.STATUS_MAP, Activity.STATUS__CP), Tools.getStatusItem(Activity.STATUS_MAP, Activity.STATUS__CL)};
        }
        ComboBoxCN c = new ComboBoxCN(ComboBoxCN.buildItemsByArray(status), cur_status);
        c.hasNilItem(false);
        return c;
    }

    public void setEventHandler() {
        this.typeCN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivityInfoDialog.this.onChangeType(evt);
            }
        });
        this.start_timeTT.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent evt) {
                ActivityInfoDialog.this.onChangeStartTime(evt);
            }

            @Override
            public void focusGained(FocusEvent evt) {
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivityInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActivityInfoDialog.this.onCancel(evt);
            }
        });
    }

    private void onChangeType(ActionEvent evt) {
        if (this.nameTF.getText().equals("")) {
            this.nameTF.setText(MasterCode.getName(this.typeCN.getSelectedCode()));
        }
    }

    private void onChangeStartTime(FocusEvent evt) {
        this.late_timeTT.setValue(this.start_timeTT.getCommittedInput());
    }

    public void onSave(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(this.typeCN.getSelectedCode(), "Category", "R");
        validation.add(this.nameTF.getText(), "Name", "R");
        validation.add(this.venueNV.getSelectedIndex(), "Venue", "CBNVIR");
        validation.add(!this.dateDP.getSelectedDates().isEmpty(), "Select at least one date", "RT");
        validation.add(this.start_timeTT.getInput(), "Start Time", "R,T");
        validation.add(this.end_timeTT.getInput(), "End Time", "R,T");
        validation.add(this.late_timeTT.getInput(), "Late Time", "R,T");
        validation.add(this.start_record_timeTT.getInput(), "Record Start", "R,T");
        validation.add(this.end_record_timeTT.getInput(), "Record End", "R,T");
        validation.add(!this.mgCB.getSelGroups().isEmpty(), "Require to select a member group", "RT");
        if (!validation.isValid()) {
            return;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "Data processing...", 0.5);
        RecordList mgs = this.mgCB.getSelGroups();
        int j = 0;
        while (j < mgs.size()) {
            if (!mgs.hasObj(ActivityMemberGroup.HEADCOUNT, j)) {
                mgs.setI(ActivityMemberGroup.HEADCOUNT, 0, j);
            }
            ++j;
        }
        int i = 0;
        while (i < this.dateDP.getSelectedDates().size()) {
            String activity_date = (String)this.dateDP.getSelectedDates().get(i);
            if (this.g_IsUpdate) {
                Activity.update(this.g_Activity.getActivity_seq(), this.typeCN.getSelectedCode(), this.statusCN.getSelectedCode(), this.nameTF.getText(), this.lecturerTF.getText(), TimeUtil.getDateByString(activity_date), this.start_timeTT.getTime(activity_date), this.end_timeTT.getTime(activity_date), this.late_timeTT.getTime(activity_date), this.start_record_timeTT.getTime(activity_date), this.end_record_timeTT.getTime(activity_date), this.venueNV.getSelectedIntValue(), this.remarkTF.getText(), mgs);
            } else {
                Activity.insert(this.typeCN.getSelectedCode(), this.statusCN.getSelectedCode(), this.nameTF.getText(), this.lecturerTF.getText(), TimeUtil.getDateByString(activity_date), this.start_timeTT.getTime(activity_date), this.end_timeTT.getTime(activity_date), this.late_timeTT.getTime(activity_date), this.start_record_timeTT.getTime(activity_date), this.end_record_timeTT.getTime(activity_date), this.venueNV.getSelectedIntValue(), this.remarkTF.getText(), mgs);
            }
            ++i;
        }
        ((ActivityListDialog)this.getParent()).onSearch(null);
        wait_dialog.dispose();
        this.dispose();
        if (this.requestVenueCB.isSelected()) {
            VenueRequestInfoDialog venueRequestInfoDialog = new VenueRequestInfoDialog((DataDialog)this.getOwner(), this.venueNV.getSelectedIntValue(), new User(UserSession.getRealUserSeq()).getMember_seq(), this.dateDP.getSelectedDates(), this.start_record_timeTT.getInput(), this.end_record_timeTT.getInput(), mgs.getI("member_group_seq", 0));
        }
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

