/*
 * Decompiled with CFR 0.152.
 */
package attendance;

import attendance.ActivityMemberGroup;
import database.DBConn;
import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import java.util.ArrayList;
import system.Lang;
import util.RecordList;
import util.TimeUtil;
import util.Tools;

public class Activity {
    private int g_Activity_seq = -1;
    private String g_Type = "";
    private String g_Status = "";
    private String g_Name = "";
    private String g_Lecturer = "";
    private Timestamp g_Date = null;
    private Timestamp g_Start_time = null;
    private Timestamp g_End_time = null;
    private Timestamp g_Late_time = null;
    private Timestamp g_Start_record_time = null;
    private Timestamp g_End_record_time = null;
    private int g_Venue_seq = -1;
    private String g_Remark = "";
    public static String STATUS__CP = "CP";
    public static String STATUS__CL = "CL";
    public static Object[] STATUS_MAP = new Object[]{new String[]{STATUS__CP, Lang.set("Confirm")}, new String[]{STATUS__CL, Lang.set("Cancel")}};

    public Activity() {
    }

    public Activity(int activity_seq) {
        this.g_Activity_seq = activity_seq;
        this.load();
    }

    public int getActivity_seq() {
        return this.g_Activity_seq;
    }

    public String getType() {
        return this.g_Type;
    }

    public String getStatus() {
        return this.g_Status;
    }

    public String getName() {
        return this.g_Name;
    }

    public String getLecturer() {
        return this.g_Lecturer;
    }

    public Timestamp getDate() {
        return this.g_Date;
    }

    public Timestamp getStart_time() {
        return this.g_Start_time;
    }

    public Timestamp getEnd_time() {
        return this.g_End_time;
    }

    public Timestamp getLate_time() {
        return this.g_Late_time;
    }

    public Timestamp getStart_record_time() {
        return this.g_Start_record_time;
    }

    public Timestamp getEnd_record_time() {
        return this.g_End_record_time;
    }

    public int getVenue_seq() {
        return this.g_Venue_seq;
    }

    public String getRemark() {
        return this.g_Remark;
    }

    public void resetActivit_seq() {
        this.g_Activity_seq = -1;
    }

    public void resetDate() {
        this.g_Date = null;
    }

    private void load() {
        String sql = "select * from activity where activity_seq=?";
        RecordList r = DBUtil.run(sql, this.g_Activity_seq);
        if (!r.isEmpty()) {
            r.setCurrentRow(0);
            this.g_Type = r.getS("type");
            this.g_Status = r.getS("status");
            this.g_Name = r.getS("name");
            this.g_Lecturer = r.getS("lecturer");
            this.g_Date = r.getT("date");
            this.g_Start_time = r.getT("start_time");
            this.g_End_time = r.getT("end_time");
            this.g_Late_time = r.getT("late_time");
            this.g_Start_record_time = r.getT("start_record_time");
            this.g_End_record_time = r.getT("end_record_time");
            this.g_Venue_seq = r.getI("venue_seq");
            this.g_Remark = r.getS("remark");
        }
    }

    public static int insert(String type, String status, String name, String lecturer, Timestamp date, Timestamp start_time, Timestamp end_time, Timestamp late_time, Timestamp start_record_time, Timestamp end_record_time, int venue_seq, String remark, RecordList member_groups) {
        String sql = "insert into activity( activity_seq,type,status,name,lecturer,date,start_time,end_time,late_time,start_record_time,end_record_time,venue_seq,remark)values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
        DBConn conn = new DBConn();
        int activity_seq = DBUtil.getNextValueFor("activity_seq", conn);
        String activity_id = Tools.genIDs("A", 4, activity_seq);
        Object[] pvs = new Object[]{new Integer(activity_seq), type, status, name, lecturer, date, start_time, end_time, late_time, start_record_time, end_record_time, venue_seq, remark};
        DBUtil.run("insert into activity( activity_seq,type,status,name,lecturer,date,start_time,end_time,late_time,start_record_time,end_record_time,venue_seq,remark)values(?,?,?,?,?,?,?,?,?,?,?,?,?)", pvs, conn);
        ActivityMemberGroup.update(activity_seq, member_groups, conn);
        conn.commit();
        return conn.isSuccessful() ? activity_seq : -1;
    }

    public static int update(int activity_seq, String type, String status, String name, String lecturer, Timestamp date, Timestamp start_time, Timestamp end_time, Timestamp late_time, Timestamp start_record_time, Timestamp end_record_time, int venue_seq, String remark, RecordList member_groups) {
        String sql = "update activity set type=?,status=?,name=?,lecturer=?,date=?,start_time=?,end_time=?,late_time=?,start_record_time=?,end_record_time=?,venue_seq=?,remark=? where activity_seq=?";
        DBConn conn = new DBConn();
        Object[] pvs = new Object[]{type, status, name, lecturer, date, start_time, end_time, late_time, start_record_time, end_record_time, venue_seq, remark, new Integer(activity_seq)};
        DBUtil.run("update activity set type=?,status=?,name=?,lecturer=?,date=?,start_time=?,end_time=?,late_time=?,start_record_time=?,end_record_time=?,venue_seq=?,remark=? where activity_seq=?", pvs, conn);
        ActivityMemberGroup.update(activity_seq, member_groups, conn);
        conn.commit();
        return conn.isSuccessful() ? activity_seq : -1;
    }

    public static ArrayList search(String name, String type, Timestamp start_date, Timestamp end_date, ArrayList member_group_seqs) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"lower(ac.name) like lower(?)", "ac.type = ?", "ac.date>=?", "ac.date<?"}, new Object[]{Tools.pad(name), type, start_date, TimeUtil.adjustDate(end_date, 1)});
        String sql = "select distinct ac.activity_seq,ac.name,mc.name as type,ac.status,ac.date,ac.date as week,ac.start_time,ac.end_time,vn.name as venue from activity as ac,activity_member_group as amg,master_code as mc,venue vn where ac.activity_seq=amg.activity_seq and ac.type=mc.code and ac.venue_seq=vn.venue_seq and amg.member_group_seq in" + DBUtil.getSQLInValues(member_group_seqs) + clause.getConds() + " order by ac.date desc" + " limit 1000";
        RecordList r = DBUtil.run(sql, clause.getPrepValues());
        r.replaceColValue("status", STATUS__CP, Tools.getStatusName(STATUS_MAP, STATUS__CP));
        r.replaceColValue("status", STATUS__CL, Tools.getStatusName(STATUS_MAP, STATUS__CL));
        return r;
    }
}

